/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DeploymentManager;
import org.netbeans.modules.j2ee.deployment.config.J2eeModuleAccessor;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.InstanceListener;
import org.netbeans.modules.j2ee.deployment.impl.Server;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceCreationException;
import org.netbeans.modules.j2ee.deployment.plugins.spi.OptionalDeploymentManagerFactory;
import org.netbeans.modules.j2ee.deployment.plugins.spi.ServerInitializationException;
import org.netbeans.modules.j2ee.deployment.profiler.spi.Profiler;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class ServerRegistry
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(ServerRegistry.class.getName());
    public static final String DIR_INSTALLED_SERVERS = "/J2EE/InstalledServers";
    public static final String DIR_JSR88_PLUGINS = "/J2EE/DeploymentPlugins";
    public static final String URL_ATTR = "url";
    public static final String USERNAME_ATTR = "username";
    public static final String PASSWORD_ATTR = "password";
    public static final String TARGETNAME_ATTR = "targetName";
    public static final String SERVER_NAME = "serverName";
    private static ServerRegistry instance = null;
    private transient Map<String, Server> servers = null;
    private transient Map instances = null;
    private transient Collection pluginListeners = new HashSet();
    private transient Collection instanceListeners = new ArrayList();
    private transient InstanceListener[] instanceListenersArray;
    private transient PluginInstallListener pluginL;
    private transient InstanceInstallListener instanceL;
    private static HashMap configNamesByType = null;
    private static final J2eeModule.Type[] allTypes = new J2eeModule.Type[]{J2eeModule.Type.EAR, J2eeModule.Type.RAR, J2eeModule.Type.CAR, J2eeModule.Type.EJB, J2eeModule.Type.WAR};

    public static synchronized ServerRegistry getInstance() {
        if (instance == null) {
            instance = new ServerRegistry();
        }
        return instance;
    }

    public static synchronized boolean wasInitialized() {
        return instance != null && ServerRegistry.instance.servers != null && ServerRegistry.instance.instances != null;
    }

    private ServerRegistry() {
    }

    private synchronized void init() {
        LOGGER.log(Level.FINEST, "Entering registry initialization");
        if (this.servers != null && this.instances != null) {
            return;
        }
        this.servers = new HashMap<String, Server>();
        this.instances = new HashMap();
        FileObject dir = FileUtil.getConfigFile((String)DIR_JSR88_PLUGINS);
        if (dir != null) {
            int i;
            LOGGER.log(Level.FINE, "Loading server plugins");
            this.pluginL = new PluginInstallListener(dir);
            dir.addFileChangeListener((FileChangeListener)this.pluginL);
            FileObject[] ch = dir.getChildren();
            for (i = 0; i < ch.length; ++i) {
                this.addPlugin(ch[i]);
            }
            LOGGER.log(Level.FINE, "Loading server instances");
            dir = FileUtil.getConfigFile((String)DIR_INSTALLED_SERVERS);
            this.instanceL = new InstanceInstallListener(dir);
            dir.addFileChangeListener((FileChangeListener)this.instanceL);
            ch = dir.getChildren();
            for (i = 0; i < ch.length; ++i) {
                this.addInstance(ch[i]);
            }
            LOGGER.log(Level.FINE, "Finish initializing plugins");
            LinkedList<String> notInitialized = new LinkedList<String>();
            for (Map.Entry<String, Server> entry : this.serversMap().entrySet()) {
                OptionalDeploymentManagerFactory odmf = entry.getValue().getOptionalFactory();
                if (null == odmf) continue;
                try {
                    odmf.finishServerInitialization();
                }
                catch (ServerInitializationException sie) {
                    LOGGER.log(Level.INFO, "Server plugin not initialized", sie);
                    notInitialized.add(entry.getKey());
                }
                catch (RuntimeException ex) {
                    LOGGER.log(Level.WARNING, "Plugin implementation BUG -- Unexpected Exception from finishServerInitialization", ex);
                    notInitialized.add(entry.getKey());
                }
            }
            this.serversMap().keySet().removeAll(notInitialized);
        } else {
            LOGGER.log(Level.WARNING, "No DIR_JSR88_PLUGINS folder found, no server plugins will be availabe");
        }
    }

    private Map<String, Server> serversMap() {
        this.init();
        return this.servers;
    }

    private synchronized Map instancesMap() {
        this.init();
        return this.instances;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPlugin(FileObject fo) {
        block8: {
            String name = "";
            try {
                if (!fo.isFolder()) break block8;
                if (fo.getFileObject("Descriptor") == null) {
                    LOGGER.log(Level.WARNING, "No server descriptor found in {0}", fo.getPath());
                    return;
                }
                name = fo.getName();
                Server server = null;
                ServerRegistry serverRegistry = this;
                synchronized (serverRegistry) {
                    if (this.serversMap().containsKey(name)) {
                        return;
                    }
                    server = new Server(fo);
                    this.serversMap().put(name, server);
                }
                if (server != null) {
                    this.firePluginListeners(server, true);
                    this.fetchInstances(server);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, null, e);
            }
        }
    }

    private void fetchInstances(Server server) {
        FileObject dir = FileUtil.getConfigFile((String)DIR_INSTALLED_SERVERS);
        FileObject[] ch = dir.getChildren();
        for (int i = 0; i < ch.length; ++i) {
            String url = (String)ch[i].getAttribute(URL_ATTR);
            if (url == null || !server.handlesUri(url)) continue;
            this.addInstance(ch[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePlugin(FileObject fo) {
        Server server = null;
        ServerRegistry serverRegistry = this;
        synchronized (serverRegistry) {
            String name = fo.getName();
            server = this.serversMap().get(name);
            if (server != null) {
                ServerInstance[] tmp = this.getServerInstances();
                for (int i = 0; i < tmp.length; ++i) {
                    ServerInstance si = tmp[i];
                    if (!server.equals(si.getServer())) continue;
                    this.removeServerInstance(si.getUrl());
                }
            }
            this.serversMap().remove(name);
        }
        if (server != null) {
            this.firePluginListeners(server, false);
        }
    }

    public Collection<Server> getServers() {
        return this.serversMap().values();
    }

    public synchronized Collection getInstances() {
        return new ArrayList(this.instancesMap().values());
    }

    public synchronized String[] getInstanceURLs() {
        return this.instancesMap().keySet().toArray(new String[this.instancesMap().size()]);
    }

    public void checkInstanceAlreadyExists(String url) throws InstanceCreationException {
        if (this.getServerInstance(url) != null) {
            String msg = NbBundle.getMessage(ServerRegistry.class, (String)"MSG_InstanceAlreadyExists", (Object)url);
            throw new InstanceCreationException(msg);
        }
    }

    public void checkInstanceExists(String url) {
        if (this.getServerInstance(url) == null) {
            String msg = NbBundle.getMessage(ServerRegistry.class, (String)"MSG_InstanceNotExists", (Object)url);
            throw new IllegalArgumentException(msg);
        }
    }

    public Server getServer(String name) {
        return this.serversMap().get(name);
    }

    public void addPluginListener(PluginListener pl) {
        this.pluginListeners.add(pl);
    }

    public synchronized ServerInstance getServerInstance(String url) {
        return (ServerInstance)this.instancesMap().get(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServerInstance(String url) {
        if (url == null) {
            return;
        }
        ServerInstance tmp = null;
        ServerRegistry serverRegistry = this;
        synchronized (serverRegistry) {
            tmp = (ServerInstance)this.instancesMap().remove(url);
        }
        if (tmp != null) {
            this.fireInstanceListeners(url, false);
            this.removeInstanceFromFile(url);
        }
    }

    public synchronized ServerInstance[] getServerInstances() {
        ServerInstance[] ret = new ServerInstance[this.instancesMap().size()];
        this.instancesMap().values().toArray(ret);
        return ret;
    }

    public static FileObject getInstanceFileObject(String url) {
        FileObject installedServersDir = FileUtil.getConfigFile((String)DIR_INSTALLED_SERVERS);
        if (installedServersDir == null) {
            return null;
        }
        FileObject[] installedServers = installedServersDir.getChildren();
        for (int i = 0; i < installedServers.length; ++i) {
            String val = (String)installedServers[i].getAttribute(URL_ATTR);
            if (val == null || !val.equals(url)) continue;
            return installedServers[i];
        }
        return null;
    }

    public void addInstance(String url, String username, String password, String displayName, boolean withoutUI, Map<String, String> initialproperties) throws InstanceCreationException {
        if (url == null || url.equals("")) {
            LOGGER.log(Level.INFO, NbBundle.getMessage(ServerRegistry.class, (String)"MSG_EmptyUrl"));
            return;
        }
        this.checkInstanceAlreadyExists(url);
        try {
            this.addInstanceImpl(url, username, password, displayName, withoutUI, initialproperties, true);
        }
        catch (InstanceCreationException ice) {
            InstanceCreationException e = new InstanceCreationException(NbBundle.getMessage(ServerRegistry.class, (String)"MSG_FailedToCreateInstance", (Object)displayName));
            e.initCause(ice);
            throw e;
        }
    }

    private synchronized void writeInstanceToFile(String url, String username, String password) throws IOException {
        if (url == null) {
            Logger.getLogger("global").log(Level.SEVERE, NbBundle.getMessage(ServerRegistry.class, (String)"MSG_NullUrl"));
            return;
        }
        FileObject dir = FileUtil.getConfigFile((String)DIR_INSTALLED_SERVERS);
        FileObject[] instanceFOs = dir.getChildren();
        FileObject instanceFO = null;
        for (int i = 0; i < instanceFOs.length; ++i) {
            if (!url.equals(instanceFOs[i].getAttribute(URL_ATTR))) continue;
            instanceFO = instanceFOs[i];
        }
        String name = FileUtil.findFreeFileName((FileObject)dir, (String)"instance", null);
        if (instanceFO == null) {
            instanceFO = dir.createData(name);
        }
        instanceFO.setAttribute(URL_ATTR, (Object)url);
        instanceFO.setAttribute(USERNAME_ATTR, (Object)username);
        instanceFO.setAttribute(PASSWORD_ATTR, (Object)password);
    }

    private synchronized void removeInstanceFromFile(String url) {
        FileObject instanceFO = ServerRegistry.getInstanceFileObject(url);
        if (instanceFO == null) {
            return;
        }
        try {
            instanceFO.delete();
        }
        catch (IOException ioe) {
            Logger.getLogger("global").log(Level.INFO, null, ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addInstanceImpl(String url, String username, String password, String displayName, boolean withoutUI, Map<String, String> initialProperties, boolean loadPlugins) throws InstanceCreationException {
        if (url == null) {
            LOGGER.log(Level.FINE, "Tried to add instance with null url");
        }
        ServerRegistry serverRegistry = this;
        synchronized (serverRegistry) {
            if (this.instancesMap().containsKey(url)) {
                throw new InstanceCreationException("already exists");
            }
            LOGGER.log(Level.FINE, "Registering instance {0}", url);
            Map<String, String> properties = this.cleanInitialProperties(initialProperties);
            Collection<Server> serversMap = this.serversMap().values();
            for (Server server : serversMap) {
                try {
                    if (!server.handlesUri(url)) continue;
                    ServerInstance tmp = new ServerInstance(server, url);
                    this.instancesMap().put(url, tmp);
                    this.writeInstanceToFile(url, username, password);
                    tmp.getInstanceProperties().setProperty("registeredWithoutUI", Boolean.toString(withoutUI));
                    if (displayName != null) {
                        tmp.getInstanceProperties().setProperty("displayName", displayName);
                    }
                    for (Map.Entry<String, String> entry : properties.entrySet()) {
                        tmp.getInstanceProperties().setProperty(entry.getKey(), entry.getValue());
                    }
                    DeploymentManager manager = server.getDisconnectedDeploymentManager(url);
                    if (manager != null) {
                        this.fireInstanceListeners(url, true);
                        return;
                    }
                    this.removeInstanceFromFile(url);
                    this.instancesMap().remove(url);
                }
                catch (Exception e) {
                    if (this.instancesMap().containsKey(url)) {
                        this.removeInstanceFromFile(url);
                        this.instancesMap().remove(url);
                    }
                    LOGGER.log(Level.INFO, null, e);
                }
            }
        }
        if (loadPlugins) {
            FileObject dir = FileUtil.getConfigFile((String)DIR_JSR88_PLUGINS);
            if (dir != null) {
                for (FileObject fo : dir.getChildren()) {
                    this.addPlugin(fo);
                }
            }
            this.addInstanceImpl(url, username, password, displayName, withoutUI, initialProperties, false);
            return;
        }
        throw new InstanceCreationException("No handlers for " + url);
    }

    private Map<String, String> cleanInitialProperties(Map<String, String> initialProperties) {
        if (initialProperties == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> properties = new HashMap<String, String>(initialProperties);
        properties.remove(URL_ATTR);
        properties.remove(USERNAME_ATTR);
        properties.remove(PASSWORD_ATTR);
        properties.remove("displayName");
        properties.remove("registeredWithoutUI");
        return properties;
    }

    public void addInstance(FileObject fo) {
        String url = (String)fo.getAttribute(URL_ATTR);
        String username = (String)fo.getAttribute(USERNAME_ATTR);
        String password = (String)fo.getAttribute(PASSWORD_ATTR);
        String displayName = (String)fo.getAttribute("displayName");
        String withoutUI = (String)fo.getAttribute("registeredWithoutUI");
        boolean withoutUIFlag = withoutUI == null ? false : Boolean.valueOf(withoutUI);
        try {
            this.addInstanceImpl(url, username, password, displayName, withoutUIFlag, null, false);
        }
        catch (InstanceCreationException ice) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getInstances(InstanceListener il) {
        if (il != null) {
            Collection collection = this.instanceListeners;
            synchronized (collection) {
                this.instanceListenersArray = null;
                this.instanceListeners.add(il);
            }
        }
        return this.getInstances();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInstanceListener(InstanceListener il) {
        Collection collection = this.instanceListeners;
        synchronized (collection) {
            this.instanceListenersArray = null;
            this.instanceListeners.add(il);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInstanceListener(InstanceListener il) {
        Collection collection = this.instanceListeners;
        synchronized (collection) {
            this.instanceListenersArray = null;
            this.instanceListeners.remove(il);
        }
    }

    public synchronized void removePluginListener(PluginListener pl) {
        this.pluginListeners.remove(pl);
    }

    private void firePluginListeners(Server server, boolean add) {
        LOGGER.log(Level.FINE, "Firing plugin listener");
        for (PluginListener pl : this.pluginListeners) {
            if (add) {
                pl.serverAdded(server);
                continue;
            }
            pl.serverRemoved(server);
        }
        configNamesByType = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InstanceListener[] getInstanceListeners() {
        InstanceListener[] retValue = null;
        Collection collection = this.instanceListeners;
        synchronized (collection) {
            retValue = this.instanceListenersArray;
            if (retValue == null) {
                retValue = this.instanceListeners.toArray(new InstanceListener[this.instanceListeners.size()]);
                this.instanceListenersArray = retValue;
            }
        }
        return retValue;
    }

    private void fireInstanceListeners(String instance, boolean add) {
        InstanceListener[] instListeners = this.getInstanceListeners();
        for (int i = 0; i < instListeners.length; ++i) {
            if (add) {
                instListeners[i].instanceAdded(instance);
                continue;
            }
            instListeners[i].instanceRemoved(instance);
        }
    }

    private void initConfigNamesByType() {
        if (configNamesByType != null) {
            return;
        }
        configNamesByType = new HashMap();
        for (int i = 0; i < allTypes.length; ++i) {
            HashSet<String> configNames = new HashSet<String>();
            for (Server s : this.servers.values()) {
                String[] paths = s.getDeploymentPlanFiles(allTypes[i]);
                if (paths == null) continue;
                for (int k = 0; k < paths.length; ++k) {
                    File path = new File(paths[k]);
                    configNames.add(path.getName());
                }
            }
            configNamesByType.put(allTypes[i], configNames);
        }
    }

    public boolean isConfigFileName(String name, J2eeModule.Type type) {
        this.initConfigNamesByType();
        ModuleType jsrModuleType = J2eeModuleAccessor.getDefault().getJsrModuleType(type);
        Set configNames = (Set)configNamesByType.get(jsrModuleType);
        return configNames != null && configNames.contains(name);
    }

    public static Profiler getProfiler() {
        return (Profiler)Lookup.getDefault().lookup(Profiler.class);
    }

    public static interface PluginListener
    extends EventListener {
        public void serverAdded(Server var1);

        public void serverRemoved(Server var1);
    }

    class InstanceInstallListener
    extends FileChangeAdapter {
        private final FileObject dir;

        private InstanceInstallListener(FileObject dir) {
            this.dir = dir;
        }

        public void fileDataCreated(FileEvent fe) {
            super.fileDataCreated(fe);
            ServerRegistry.this.addInstance(fe.getFile());
        }
    }

    class PluginInstallListener
    extends FileChangeAdapter {
        private final FileObject dir;

        private PluginInstallListener(FileObject dir) {
            this.dir = dir;
        }

        public void fileFolderCreated(FileEvent fe) {
            super.fileFolderCreated(fe);
            ServerRegistry.this.addPlugin(fe.getFile());
        }

        public void fileDeleted(FileEvent fe) {
            super.fileDeleted(fe);
            ServerRegistry.this.removePlugin(fe.getFile());
        }
    }
}

