/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl.bridge;

import java.awt.Component;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JComponent;
import org.netbeans.api.server.CommonServerUIs;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstanceLookup;
import org.netbeans.modules.j2ee.deployment.impl.ui.actions.CustomizerAction;
import org.netbeans.modules.j2ee.deployment.plugins.spi.StartServer;
import org.netbeans.spi.server.ServerInstanceFactory;
import org.netbeans.spi.server.ServerInstanceImplementation;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.SystemAction;

public class BridgingServerInstance
implements ServerInstanceImplementation,
Node.Cookie {
    private final ServerInstance instance;
    private org.netbeans.api.server.ServerInstance commonInstance;

    private BridgingServerInstance(ServerInstance instance) {
        assert (instance != null) : "ServerInstance must not be null";
        this.instance = instance;
    }

    public static BridgingServerInstance createInstance(ServerInstance instance) {
        BridgingServerInstance created = new BridgingServerInstance(instance);
        created.commonInstance = ServerInstanceFactory.createServerInstance((ServerInstanceImplementation)created);
        return created;
    }

    public String getDisplayName() {
        return this.instance.getDisplayName();
    }

    public String getServerDisplayName() {
        return this.instance.getServer().getDisplayName();
    }

    public Node getFullNode() {
        StartServer startServer = this.instance.getStartServer();
        if (startServer == null) {
            return null;
        }
        Node childNode = startServer.isAlsoTargetServer(null) ? this.instance.getServer().getNodeProvider().createInstanceTargetNode(this.instance) : this.instance.getServer().getNodeProvider().createInstanceNode(this.instance);
        this.instance.refresh();
        return new InstanceNode(childNode, this);
    }

    public Node getBasicNode() {
        Node j2eeNode = this.instance.getServer().getRegistryNodeFactory().getManagerNode(new ServerInstanceLookup(this.instance, this.instance.getServer().getDeploymentFactory(), null));
        return new ManagerNode(j2eeNode, this.instance.getDisplayName());
    }

    public JComponent getCustomizer() {
        Node node = this.getBasicNode();
        if (node == null || !node.hasCustomizer()) {
            return null;
        }
        Component customizer = node.getCustomizer();
        if (!(customizer instanceof JComponent)) {
            return null;
        }
        return (JComponent)customizer;
    }

    public boolean isRemovable() {
        return !this.instance.isRemoveForbidden();
    }

    public void remove() {
        this.instance.remove();
    }

    public org.netbeans.api.server.ServerInstance getCommonInstance() {
        return this.commonInstance;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BridgingServerInstance other = (BridgingServerInstance)obj;
        return this.instance == other.instance || this.instance != null && this.instance.equals(other.instance);
    }

    public int hashCode() {
        int hash = 7;
        return hash;
    }

    private static class BridgingCustomizerAction
    extends NodeAction {
        private BridgingCustomizerAction() {
        }

        public void performAction(Node[] nodes) {
            BridgingServerInstance instance = (BridgingServerInstance)nodes[0].getCookie(BridgingServerInstance.class);
            CommonServerUIs.showCustomizer((org.netbeans.api.server.ServerInstance)instance.getCommonInstance());
        }

        protected boolean enable(Node[] nodes) {
            return true;
        }

        public String getName() {
            return NbBundle.getMessage(BridgingServerInstance.class, (String)"LBL_Properties");
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }

        protected boolean asynchronous() {
            return false;
        }
    }

    private static class InstanceNode
    extends FilterNode {
        private final BridgingServerInstance instance;

        public InstanceNode(Node original, BridgingServerInstance instance) {
            super(original);
            this.instance = instance;
        }

        public Node.Cookie getCookie(Class type) {
            if (BridgingServerInstance.class.isAssignableFrom(type)) {
                return this.instance;
            }
            return super.getCookie(type);
        }

        public Action[] getActions(boolean context) {
            boolean found = false;
            ArrayList<Object> freshActions = new ArrayList<Object>();
            Action[] actions = this.getOriginal().getActions(context);
            for (int i = 0; i < actions.length; ++i) {
                if (actions[i] instanceof CustomizerAction) {
                    freshActions.add(SystemAction.get(BridgingCustomizerAction.class));
                    found = true;
                    continue;
                }
                freshActions.add(actions[i]);
            }
            if (!found) {
                freshActions.add(null);
                freshActions.add(SystemAction.get(BridgingCustomizerAction.class));
            }
            return freshActions.toArray(new Action[freshActions.size()]);
        }
    }

    private static class ManagerNode
    extends FilterNode {
        public ManagerNode(Node node, String displayName) {
            super(node);
            this.disableDelegation(396);
            this.setDisplayName(displayName);
        }
    }
}

