/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.refactoring.rename;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.j2ee.core.api.support.java.JavaIdentifiers;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.web.refactoring.RefactoringUtil;
import org.netbeans.modules.web.refactoring.rename.BaseWebXmlRename;
import org.netbeans.modules.web.refactoring.rename.RenameItem;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class WebXmlPackageRename
extends BaseWebXmlRename {
    private final FileObject pkg;
    private final RenameRefactoring rename;

    public WebXmlPackageRename(FileObject webDD, WebApp webModel, FileObject pkg, RenameRefactoring rename) {
        super(webDD, webModel);
        this.pkg = pkg;
        this.rename = rename;
    }

    @Override
    protected List<RenameItem> getRenameItems() {
        ArrayList<RenameItem> result = new ArrayList<RenameItem>();
        ArrayList<FileObject> fos = new ArrayList<FileObject>();
        RefactoringUtil.collectChildren(this.pkg, fos);
        for (FileObject each : fos) {
            if (RefactoringUtil.isPackageInfo(each)) continue;
            String oldFqn = JavaIdentifiers.getQualifiedName((FileObject)each);
            String fqn = JavaIdentifiers.getQualifiedName((FileObject)each);
            if (JavaIdentifiers.isValidPackageName((String)fqn)) {
                String newFqn = RefactoringUtil.constructNewName(each, this.rename);
                result.add(new RenameItem(newFqn, oldFqn));
                continue;
            }
            result.add(new RenameItem(null, null, new Problem(true, NbBundle.getMessage(WebXmlPackageRename.class, (String)"TXT_ErrInvalidPackageName", (Object)fqn))));
        }
        return result;
    }

    @Override
    protected AbstractRefactoring getRefactoring() {
        return this.rename;
    }
}

