/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.freeform;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.tools.ant.module.api.support.AntScriptUtils;
import org.apache.tools.ant.module.api.support.TargetLister;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.modules.profiler.AbstractProjectTypeProfiler;
import org.netbeans.modules.profiler.freeform.Util;
import org.netbeans.modules.profiler.projectsupport.utilities.SourceUtils;
import org.netbeans.modules.profiler.ui.NBHTMLLabel;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.netbeans.modules.profiler.utils.ProjectUtilities;
import org.openide.DialogDescriptor;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class FreeFormProjectTypeProfiler
extends AbstractProjectTypeProfiler {
    private static final String ERROR_PARSING_BUILDFILE_MSG = NbBundle.getMessage(FreeFormProjectTypeProfiler.class, (String)"FreeFormProjectTypeProfiler_ErrorParsingBuildFileMsg");
    private static final String OK_BUTTON_NAME = NbBundle.getMessage(FreeFormProjectTypeProfiler.class, (String)"FreeFormProjectTypeProfiler_OkButtonName");
    private static final String SELECT_PROFILING_TASK_DIALOG_CAPTION = NbBundle.getMessage(FreeFormProjectTypeProfiler.class, (String)"FreeFormProjectTypeProfiler_SelectProfilingTaskDialogCaption");
    private static final String NO_PROFILER_TASK_MSG = NbBundle.getMessage(FreeFormProjectTypeProfiler.class, (String)"FreeFormProjectTypeProfiler_NoProfilerTaskMsg");
    private static final String SELECT_TARGET_ITEM_STRING = NbBundle.getMessage(FreeFormProjectTypeProfiler.class, (String)"FreeFormProjectTypeProfiler_SelectTargetItemString");
    private static final String SELECT_PROJECT_TASK_LABEL_STRING = NbBundle.getMessage(FreeFormProjectTypeProfiler.class, (String)"FreeFormProjectTypeProfiler_SelectProjectTaskLabelString");
    private static final String SELECT_FILE_TASK_LABEL_STRING = NbBundle.getMessage(FreeFormProjectTypeProfiler.class, (String)"FreeFormProjectTypeProfiler_SelectFileTaskLabelString");
    private static final String CREATE_NEW_TARGET_MSG = NbBundle.getMessage(FreeFormProjectTypeProfiler.class, (String)"FreeFormProjectTypeProfiler_CreateNewTargetMsg");
    private static final String TARGET_BOX_ACCESS_NAME = NbBundle.getMessage(FreeFormProjectTypeProfiler.class, (String)"FreeFormProjectTypeProfiler_TargetBoxAccessName");
    private static final String TARGET_BOX_ACCESS_DESCR = NbBundle.getMessage(FreeFormProjectTypeProfiler.class, (String)"FreeFormProjectTypeProfiler_TargetBoxAccessDescr");
    private static final String PROFILE_TARGET_ATTRIBUTE = "profile-target";
    private static final String PROFILE_SINGLE_TARGET_ATTRIBUTE = "profile-file-target";
    private static final String PROFILE_VERSION_ATTRIBUTE = "version";
    private static final String VERSION_NUMBER = "0.4";

    public String getProfilerTargetName(Project project, FileObject buildScript, int type, FileObject profiledClass) {
        Element e = ProjectUtils.getAuxiliaryConfiguration((Project)project).getConfigurationFragment("data", "http://www.netbeans.org/ns/profiler/1", false);
        String profileTarget = e.getAttribute(PROFILE_TARGET_ATTRIBUTE);
        String profileSingleTarget = e.getAttribute(PROFILE_SINGLE_TARGET_ATTRIBUTE);
        switch (type) {
            case 1: {
                profileTarget = this.selectProfilingTarget(project, buildScript, 1, profileTarget);
                if (profileTarget == null) {
                    return null;
                }
                this.saveProfilerConfig(project, profileTarget, profileSingleTarget);
                return profileTarget;
            }
            case 2: {
                profileSingleTarget = this.selectProfilingTarget(project, buildScript, 2, profileSingleTarget);
                if (profileSingleTarget == null) {
                    return null;
                }
                this.saveProfilerConfig(project, profileTarget, profileSingleTarget);
                return profileSingleTarget;
            }
        }
        return null;
    }

    public boolean isProfilingSupported(Project project) {
        return true;
    }

    public FileObject getProjectBuildScript(Project project) {
        return Util.getProjectBuildScript(project);
    }

    public boolean checkProjectCanBeProfiled(Project project, FileObject profiledClassFile) {
        return true;
    }

    public boolean checkProjectIsModifiedForProfiler(Project project) {
        Element e = ProjectUtils.getAuxiliaryConfiguration((Project)project).getConfigurationFragment("data", "http://www.netbeans.org/ns/profiler/1", false);
        if (e != null) {
            String profileTarget = e.getAttribute(PROFILE_TARGET_ATTRIBUTE);
            String profileSingleTarget = e.getAttribute(PROFILE_SINGLE_TARGET_ATTRIBUTE);
            if (profileTarget != null || profileSingleTarget != null) {
                return true;
            }
        } else {
            this.saveProfilerConfig(project, null, null);
        }
        return true;
    }

    public void configurePropertiesForProfiling(Properties props, Project project, FileObject profiledClassFile) {
        if (profiledClassFile != null) {
            String profiledClass = SourceUtils.getToplevelClassName((FileObject)profiledClassFile);
            props.setProperty("profile.class", profiledClass);
            String clazz = FileUtil.getRelativePath((FileObject)ProjectUtilities.getRootOf((FileObject[])ProjectUtilities.getSourceRoots((Project)project), (FileObject)profiledClassFile), (FileObject)profiledClassFile);
            props.setProperty("javac.includes", clazz);
        }
    }

    private boolean checkTarget(Element element) {
        NodeList nl = element.getElementsByTagName("nbprofiledirect");
        return nl.getLength() > 0;
    }

    private boolean saveProfilerConfig(Project project, String profileTarget, String profileSingleTarget) {
        Element profilerFragment = XMLUtil.createDocument((String)"ignore", null, null, null).createElementNS("http://www.netbeans.org/ns/profiler/1", "data");
        profilerFragment.setAttribute(PROFILE_VERSION_ATTRIBUTE, VERSION_NUMBER);
        if (profileTarget != null) {
            profilerFragment.setAttribute(PROFILE_TARGET_ATTRIBUTE, profileTarget);
        }
        if (profileSingleTarget != null) {
            profilerFragment.setAttribute(PROFILE_SINGLE_TARGET_ATTRIBUTE, profileSingleTarget);
        }
        ProjectUtils.getAuxiliaryConfiguration((Project)project).putConfigurationFragment(profilerFragment, false);
        try {
            ProjectManager.getDefault().saveProject(project);
        }
        catch (IOException e1) {
            Profiler.getDefault().notifyException(8, (Exception)e1);
            ProfilerLogger.log((Exception)e1);
            return false;
        }
        return true;
    }

    private String selectProfilingTarget(Project project, FileObject buildScript, int type, String currentTarget) {
        block6: {
            String targetName;
            List l;
            List targets = Util.getAntScriptTargets(buildScript);
            try {
                l = AntScriptUtils.getCallableTargetNames((FileObject)buildScript);
            }
            catch (IOException x) {
                Profiler.getDefault().displayError(MessageFormat.format(ERROR_PARSING_BUILDFILE_MSG, ProjectUtils.getInformation((Project)project).getName()));
                return null;
            }
            if (!"".equals(currentTarget) && l.contains(currentTarget)) {
                return currentTarget;
            }
            JButton okButton = new JButton(OK_BUTTON_NAME);
            AntTaskSelectPanel atsp = new AntTaskSelectPanel(l, type, okButton);
            block2: while (true) {
                DialogDescriptor dd = new DialogDescriptor((Object)atsp, SELECT_PROFILING_TASK_DIALOG_CAPTION, true, new Object[]{okButton, DialogDescriptor.CANCEL_OPTION}, (Object)okButton, 0, null, null);
                Dialog d = ProfilerDialogs.createDialog((DialogDescriptor)dd);
                d.setVisible(true);
                if (dd.getValue() != okButton) break block6;
                targetName = atsp.getTargetName();
                Iterator it = targets.iterator();
                while (true) {
                    if (!it.hasNext()) continue block2;
                    TargetLister.Target t = (TargetLister.Target)it.next();
                    if (!t.getName().equals(targetName)) continue;
                    if (this.checkTarget(t.getElement())) {
                        return targetName;
                    }
                    if (ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)NO_PROFILER_TASK_MSG, 2, 2)) == NotifyDescriptor.OK_OPTION) break block2;
                }
                break;
            }
            return targetName;
        }
        return null;
    }

    private static final class AntTaskSelectPanel
    extends JPanel
    implements HelpCtx.Provider {
        private static final String HELP_CTX_KEY = "FreeFormProjectTypeProfiler.AntTaskSelectPanel.HelpCtx";
        private static final HelpCtx HELP_CTX = new HelpCtx("FreeFormProjectTypeProfiler.AntTaskSelectPanel.HelpCtx");
        final JComboBox targetBox;
        final JLabel label;
        final NBHTMLLabel descriptionLabel;

        AntTaskSelectPanel(List list, int type, final JButton okButton) {
            list.add(0, SELECT_TARGET_ITEM_STRING);
            this.label = type == 1 ? new JLabel(SELECT_PROJECT_TASK_LABEL_STRING) : new JLabel(SELECT_FILE_TASK_LABEL_STRING);
            this.descriptionLabel = new NBHTMLLabel(CREATE_NEW_TARGET_MSG);
            this.targetBox = new JComboBox<Object>(list.toArray(new Object[list.size()]));
            this.targetBox.setSelectedIndex(0);
            this.targetBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    okButton.setEnabled(AntTaskSelectPanel.this.targetBox.getSelectedIndex() != 0);
                }
            });
            this.setLayout(new GridBagLayout());
            this.label.setLabelFor(this.targetBox);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(12, 12, 12, 12);
            this.add((Component)this.label, gridBagConstraints);
            this.targetBox.getAccessibleContext().setAccessibleName(TARGET_BOX_ACCESS_NAME);
            this.targetBox.getAccessibleContext().setAccessibleDescription(TARGET_BOX_ACCESS_DESCR);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(12, 0, 12, 12);
            this.add((Component)this.targetBox, gridBagConstraints);
            this.descriptionLabel.setFocusable(false);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(12, 12, 12, 12);
            this.add((Component)this.descriptionLabel, gridBagConstraints);
            okButton.setEnabled(false);
        }

        public String getTargetName() {
            if (this.targetBox.getSelectedIndex() == 0) {
                return null;
            }
            return (String)this.targetBox.getSelectedItem();
        }

        public HelpCtx getHelpCtx() {
            return HELP_CTX;
        }
    }
}

