/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.factories.DeploymentFactoryManager;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.tomcat5.TomcatManager;
import org.openide.util.NbBundle;

public final class TomcatFactory
implements DeploymentFactory {
    public static final String SERVER_ID_50 = "Tomcat";
    public static final String SERVER_ID_55 = "Tomcat55";
    public static final String SERVER_ID_60 = "Tomcat60";
    public static final String SERVER_ID_70 = "Tomcat70";
    public static final String TOMCAT_URI_PREFIX_50 = "tomcat:";
    public static final String TOMCAT_URI_PREFIX_55 = "tomcat55:";
    public static final String TOMCAT_URI_PREFIX_60 = "tomcat60:";
    public static final String TOMCAT_URI_PREFIX_70 = "tomcat70:";
    public static final String TOMCAT_URI_HOME_PREFIX = "home=";
    public static final String TOMCAT_URI_BASE_PREFIX = ":base=";
    private static final String DISCONNECTED_URI_50 = "tomcat:jakarta-tomcat-5.0.x";
    private static final String DISCONNECTED_URI_55 = "tomcat55:jakarta-tomcat-5.5.x";
    private static final String DISCONNECTED_URI_60 = "tomcat60:apache-tomcat-6.0.x";
    private static final String DISCONNECTED_URI_70 = "tomcat60:apache-tomcat-7.0.x";
    private static TomcatFactory instance;
    private static TomcatFactory instance55;
    private static TomcatFactory instance60;
    private static TomcatFactory instance70;
    private static final WeakHashMap managerCache;
    private static Logger err;
    private final String tomcatUriPrefix;
    private final String disconnectedUri;
    private final TomcatManager.TomcatVersion version;

    private TomcatFactory(TomcatManager.TomcatVersion version) {
        this.version = version;
        switch (version) {
            case TOMCAT_50: {
                this.tomcatUriPrefix = TOMCAT_URI_PREFIX_50;
                this.disconnectedUri = DISCONNECTED_URI_50;
                break;
            }
            case TOMCAT_55: {
                this.tomcatUriPrefix = TOMCAT_URI_PREFIX_55;
                this.disconnectedUri = DISCONNECTED_URI_55;
                break;
            }
            case TOMCAT_60: {
                this.tomcatUriPrefix = TOMCAT_URI_PREFIX_60;
                this.disconnectedUri = DISCONNECTED_URI_60;
                break;
            }
            default: {
                this.tomcatUriPrefix = TOMCAT_URI_PREFIX_70;
                this.disconnectedUri = DISCONNECTED_URI_70;
            }
        }
    }

    public static synchronized TomcatFactory create50() {
        if (instance == null) {
            if (err.isLoggable(Level.FINE)) {
                err.log(Level.FINE, "Creating TomcatFactory");
            }
            instance = new TomcatFactory(TomcatManager.TomcatVersion.TOMCAT_50);
            DeploymentFactoryManager.getInstance().registerDeploymentFactory((DeploymentFactory)instance);
        }
        return instance;
    }

    public static synchronized TomcatFactory create55() {
        if (instance55 == null) {
            if (err.isLoggable(Level.FINE)) {
                err.log(Level.FINE, "Creating TomcatFactory");
            }
            instance55 = new TomcatFactory(TomcatManager.TomcatVersion.TOMCAT_55);
            DeploymentFactoryManager.getInstance().registerDeploymentFactory((DeploymentFactory)instance55);
        }
        return instance55;
    }

    public static synchronized TomcatFactory create60() {
        if (instance60 == null) {
            if (err.isLoggable(Level.FINE)) {
                err.log(Level.FINE, "Creating TomcatFactory");
            }
            instance60 = new TomcatFactory(TomcatManager.TomcatVersion.TOMCAT_60);
            DeploymentFactoryManager.getInstance().registerDeploymentFactory((DeploymentFactory)instance60);
        }
        return instance60;
    }

    public static synchronized TomcatFactory create70() {
        if (instance70 == null) {
            if (err.isLoggable(Level.FINE)) {
                err.log(Level.FINE, "Creating TomcatFactory");
            }
            instance70 = new TomcatFactory(TomcatManager.TomcatVersion.TOMCAT_70);
            DeploymentFactoryManager.getInstance().registerDeploymentFactory((DeploymentFactory)instance70);
        }
        return instance70;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeploymentManager getDeploymentManager(String uri, String uname, String passwd) throws DeploymentManagerCreationException {
        if (!this.handlesURI(uri)) {
            throw new DeploymentManagerCreationException("Invalid URI:" + uri);
        }
        InstanceProperties ip = InstanceProperties.getInstanceProperties((String)uri);
        if (ip == null && !this.disconnectedUri.equals(uri)) {
            throw new DeploymentManagerCreationException("Tomcat instance: " + uri + " is not registered in the IDE.");
        }
        TomcatFactory tomcatFactory = this;
        synchronized (tomcatFactory) {
            TomcatManager tm = (TomcatManager)managerCache.get(ip);
            if (tm == null) {
                try {
                    tm = new TomcatManager(true, uri.substring(this.tomcatUriPrefix.length()), this.version);
                    managerCache.put(ip, tm);
                }
                catch (IllegalArgumentException iae) {
                    DeploymentManagerCreationException t = new DeploymentManagerCreationException("Cannot create deployment manager for Tomcat instance: " + uri + ".");
                    throw (DeploymentManagerCreationException)t.initCause(iae);
                }
            }
            return tm;
        }
    }

    public DeploymentManager getDisconnectedDeploymentManager(String uri) throws DeploymentManagerCreationException {
        return this.getDeploymentManager(uri, null, null);
    }

    public String getDisplayName() {
        switch (this.version) {
            case TOMCAT_50: {
                return NbBundle.getMessage(TomcatFactory.class, (String)"LBL_TomcatFactory");
            }
            case TOMCAT_55: {
                return NbBundle.getMessage(TomcatFactory.class, (String)"LBL_TomcatFactory55");
            }
            case TOMCAT_60: {
                return NbBundle.getMessage(TomcatFactory.class, (String)"LBL_TomcatFactory60");
            }
        }
        return NbBundle.getMessage(TomcatFactory.class, (String)"LBL_TomcatFactory70");
    }

    public String getProductVersion() {
        return NbBundle.getMessage(TomcatFactory.class, (String)"LBL_TomcatFactoryVersion");
    }

    public boolean handlesURI(String str) {
        return str != null && str.startsWith(this.tomcatUriPrefix);
    }

    public static String getTomcatVersion(File catalinaHome) throws IllegalStateException {
        File catalinaJar = new File(catalinaHome, "lib/catalina.jar");
        if (!catalinaJar.exists()) {
            catalinaJar = new File(catalinaHome, "server/lib/catalina.jar");
        }
        try {
            URLClassLoader loader = new URLClassLoader(new URL[]{catalinaJar.toURL()});
            Class<?> serverInfo = loader.loadClass("org.apache.catalina.util.ServerInfo");
            Method method = serverInfo.getMethod("getServerInfo", new Class[0]);
            String version = (String)method.invoke(serverInfo, new Object[0]);
            int idx = version.indexOf(47);
            if (idx > 0) {
                return version.substring(idx + 1);
            }
            throw new IllegalStateException("Cannot identify the version of the server.");
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    static {
        managerCache = new WeakHashMap();
        err = Logger.getLogger("org.netbeans.modules.tomcat5");
    }
}

