/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdiscovery.provider;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.cnd.discovery.api.ApplicableImpl;
import org.netbeans.modules.cnd.discovery.api.Configuration;
import org.netbeans.modules.cnd.discovery.api.DiscoveryExtensionInterface;
import org.netbeans.modules.cnd.discovery.api.DiscoveryUtils;
import org.netbeans.modules.cnd.discovery.api.Progress;
import org.netbeans.modules.cnd.discovery.api.ProjectImpl;
import org.netbeans.modules.cnd.discovery.api.ProjectProperties;
import org.netbeans.modules.cnd.discovery.api.ProjectProxy;
import org.netbeans.modules.cnd.discovery.api.ProviderProperty;
import org.netbeans.modules.cnd.discovery.api.SourceFileProperties;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.BaseDwarfProvider;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.DwarfSource;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class AnalyzeFolder
extends BaseDwarfProvider {
    private Map<String, ProviderProperty> myProperties = new HashMap<String, ProviderProperty>();
    public static final String FOLDER_KEY = "folder";

    public AnalyzeFolder() {
        this.clean();
    }

    public final void clean() {
        this.myProperties.clear();
        this.myProperties.put(FOLDER_KEY, new ProviderProperty(){
            private String myPath;

            public String getName() {
                return AnalyzeFolder.i18n("Folder_Files_Name");
            }

            public String getDescription() {
                return AnalyzeFolder.i18n("Folder_Files_Description");
            }

            public Object getValue() {
                return this.myPath;
            }

            public void setValue(Object object) {
                if (object instanceof String) {
                    this.myPath = (String)object;
                }
            }

            public ProviderProperty.PropertyKind getKind() {
                return ProviderProperty.PropertyKind.Folder;
            }
        });
        this.myProperties.put("restrict_source_root", new ProviderProperty(){
            private String myPath = "";

            public String getName() {
                return AnalyzeFolder.i18n("RESTRICT_SOURCE_ROOT");
            }

            public String getDescription() {
                return AnalyzeFolder.i18n("RESTRICT_SOURCE_ROOT");
            }

            public Object getValue() {
                return this.myPath;
            }

            public void setValue(Object object) {
                if (object instanceof String) {
                    this.myPath = (String)object;
                }
            }

            public ProviderProperty.PropertyKind getKind() {
                return ProviderProperty.PropertyKind.String;
            }
        });
        this.myProperties.put("restrict_compile_root", new ProviderProperty(){
            private String myPath = "";

            public String getName() {
                return AnalyzeFolder.i18n("RESTRICT_COMPILE_ROOT");
            }

            public String getDescription() {
                return AnalyzeFolder.i18n("RESTRICT_COMPILE_ROOT");
            }

            public Object getValue() {
                return this.myPath;
            }

            public void setValue(Object object) {
                if (object instanceof String) {
                    this.myPath = (String)object;
                }
            }

            public ProviderProperty.PropertyKind getKind() {
                return ProviderProperty.PropertyKind.String;
            }
        });
    }

    public String getID() {
        return "dwarf-folder";
    }

    public String getName() {
        return AnalyzeFolder.i18n("Folder_Provider_Name");
    }

    public String getDescription() {
        return AnalyzeFolder.i18n("Folder_Provider_Description");
    }

    public List<String> getPropertyKeys() {
        return new ArrayList<String>(this.myProperties.keySet());
    }

    public ProviderProperty getProperty(String string) {
        return this.myProperties.get(string);
    }

    public DiscoveryExtensionInterface.Applicable canAnalyze(ProjectProxy projectProxy) {
        String string = (String)this.getProperty(FOLDER_KEY).getValue();
        if (string == null || string.length() == 0) {
            return ApplicableImpl.getNotApplicable(Collections.singletonList(NbBundle.getMessage(AnalyzeFolder.class, (String)"NoBaseFolder")));
        }
        Set<String> set = this.getObjectFiles(string);
        if (set.isEmpty()) {
            return ApplicableImpl.getNotApplicable(Collections.singletonList(NbBundle.getMessage(AnalyzeFolder.class, (String)"NotFoundExecutablesInFolder", (Object)string)));
        }
        int n = 0;
        for (String string2 : set) {
            ++n;
            ApplicableImpl applicableImpl = this.sizeComilationUnit(string2, null);
            if (applicableImpl.isApplicable()) {
                return new ApplicableImpl(true, applicableImpl.getErrors(), applicableImpl.getCompilerName(), 50, applicableImpl.isSunStudio(), null, null, null, null);
            }
            if (n <= 25) continue;
            return ApplicableImpl.getNotApplicable(Collections.singletonList(NbBundle.getMessage(AnalyzeFolder.class, (String)"NotFoundExecutableWithDebugInformation", (Object)string)));
        }
        return ApplicableImpl.getNotApplicable(Collections.singletonList(NbBundle.getMessage(AnalyzeFolder.class, (String)"NotFoundExecutableWithDebugInformation", (Object)string)));
    }

    public List<Configuration> analyze(ProjectProxy projectProxy, final Progress progress) {
        this.isStoped.set(false);
        ArrayList<Configuration> arrayList = new ArrayList<Configuration>();
        this.setCommpilerSettings(projectProxy);
        if (!this.isStoped.get()) {
            Configuration configuration = new Configuration(){
                private List<SourceFileProperties> myFileProperties;
                private List<String> myIncludedFiles;

                public List<ProjectProperties> getProjectConfiguration() {
                    return ProjectImpl.divideByLanguage(this.getSourcesConfiguration());
                }

                public List<String> getDependencies() {
                    return null;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public List<SourceFileProperties> getSourcesConfiguration() {
                    if (this.myFileProperties == null) {
                        if (progress != null) {
                            progress.start();
                        }
                        try {
                            Set set = AnalyzeFolder.this.getObjectFiles((String)AnalyzeFolder.this.getProperty(AnalyzeFolder.FOLDER_KEY).getValue());
                            if (progress != null) {
                                progress.start(set.size());
                            }
                            this.myFileProperties = set.size() > 0 ? AnalyzeFolder.this.getSourceFileProperties(set.toArray(new String[set.size()]), progress, null, null) : new ArrayList<SourceFileProperties>();
                        }
                        finally {
                            if (progress != null) {
                                progress.done();
                            }
                        }
                    }
                    return this.myFileProperties;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public List<String> getIncludedFiles() {
                    if (this.myIncludedFiles == null) {
                        HashSet<String> hashSet = new HashSet<String>();
                        for (SourceFileProperties object : this.getSourcesConfiguration()) {
                            if (AnalyzeFolder.this.isStoped.get()) break;
                            hashSet.addAll(((DwarfSource)object).getIncludedFiles());
                            hashSet.add(object.getItemPath());
                        }
                        if (progress != null) {
                            progress.start(hashSet.size());
                        }
                        HashSet hashSet2 = new HashSet();
                        for (String string : hashSet) {
                            Object object;
                            if (AnalyzeFolder.this.isStoped.get()) break;
                            if (progress != null) {
                                object = progress;
                                synchronized (object) {
                                    progress.increment(string);
                                }
                            }
                            if (!((File)(object = new File(string))).exists()) continue;
                            hashSet2.add(CndFileUtils.normalizeFile((File)object).getAbsolutePath());
                        }
                        if (progress != null) {
                            progress.done();
                        }
                        this.myIncludedFiles = new ArrayList<String>(hashSet2);
                    }
                    return this.myIncludedFiles;
                }
            };
            arrayList.add(configuration);
        }
        return arrayList;
    }

    private Set<String> getObjectFiles(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        this.gatherSubFolders(new File(string), hashSet);
        HashSet<String> hashSet2 = new HashSet<String>();
        Iterator<String> iterator = hashSet.iterator();
        while (iterator.hasNext() && !this.isStoped.get()) {
            File[] fileArray;
            File file = new File(iterator.next());
            if (!file.exists() || !file.isDirectory() || !file.canRead() || (fileArray = file.listFiles()) == null) continue;
            for (int i = 0; i < fileArray.length; ++i) {
                String string2;
                if (!fileArray[i].isFile() || !(string2 = fileArray[i].getName()).endsWith(".o") && !string2.endsWith(".so") && !string2.endsWith(".dylib") && !string2.endsWith(".a") && !this.isExecutable(fileArray[i])) continue;
                String string3 = fileArray[i].getAbsolutePath();
                if (Utilities.isWindows()) {
                    string3 = string3.replace('\\', '/');
                }
                hashSet2.add(string3);
            }
        }
        return hashSet2;
    }

    private boolean isExecutable(File file) {
        String string = file.getName();
        if (Utilities.isWindows()) {
            return string.endsWith(".exe") || string.endsWith(".dll");
        }
        if (Utilities.isUnix()) {
            try {
                return string.indexOf(46) < 0 && file.canExecute();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void gatherSubFolders(File file, HashSet<String> hashSet) {
        if (this.isStoped.get()) {
            return;
        }
        if (!file.exists() || !file.isDirectory() || !file.canRead()) return;
        if (DiscoveryUtils.ignoreFolder((File)file)) {
            return;
        }
        String string = file.getAbsolutePath();
        if (Utilities.isWindows()) {
            string = string.replace('\\', '/');
        }
        if (hashSet.contains(string)) return;
        hashSet.add(string);
        File[] fileArray = file.listFiles();
        if (fileArray == null) return;
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].isDirectory()) continue;
            try {
                String string2 = fileArray[i].getCanonicalPath();
                String string3 = fileArray[i].getAbsolutePath();
                if (!string3.equals(string2) && string3.startsWith(string2)) {
                    continue;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.gatherSubFolders(fileArray[i], hashSet);
        }
    }

    private static String i18n(String string) {
        return NbBundle.getMessage(AnalyzeFolder.class, (String)string);
    }
}

