/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdiscovery.provider;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.api.remote.PathMap;
import org.netbeans.modules.cnd.api.remote.RemoteProject;
import org.netbeans.modules.cnd.discovery.api.DiscoveryUtils;
import org.netbeans.modules.cnd.discovery.api.ItemProperties;
import org.netbeans.modules.cnd.discovery.api.Progress;
import org.netbeans.modules.cnd.discovery.api.ProjectProxy;
import org.netbeans.modules.cnd.discovery.api.SourceFileProperties;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.PathCache;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.spi.configurations.PkgConfigManager;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.MIMESupport;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.util.Utilities;

public class LogReader {
    private static boolean TRACE = Boolean.getBoolean("cnd.dwarfdiscovery.trace.read.log");
    private String workingDir;
    private String guessWorkingDir;
    private String baseWorkingDir;
    private final String root;
    private final String fileName;
    private List<SourceFileProperties> result;
    private final PathMap pathMapper;
    private final ProjectProxy project;
    private final ArrayList<List<String>> makeStack = new ArrayList();
    private static final String CURRENT_DIRECTORY = "Current working directory";
    private static final String ENTERING_DIRECTORY = "Entering directory";
    private static final String LEAVING_DIRECTORY = "Leaving directory";
    private static final String LABEL_CD = "cd ";
    private static final String INVOKE_GNU_C = "gcc ";
    private static final String INVOKE_GNU_C2 = "gcc.exe ";
    private static final String INVOKE_SUN_C = "cc ";
    private static final String INVOKE_GNU_Cpp = "g++ ";
    private static final String INVOKE_GNU_Cpp2 = "g++.exe ";
    private static final String INVOKE_GNU_Cpp3 = "c++ ";
    private static final String INVOKE_GNU_Cpp4 = "c++.exe ";
    private static final String INVOKE_SUN_Cpp = "CC ";
    private static final String INVOKE_MSVC_Cpp = "cl ";
    private static final String INVOKE_GNU_Fortran1 = "gfortran ";
    private static final String INVOKE_GNU_Fortran2 = "gfortran.exe ";
    private static final String INVOKE_GNU_Fortran3 = "g95.exe ";
    private static final String INVOKE_GNU_Fortran4 = "g90.exe ";
    private static final String INVOKE_GNU_Fortran5 = "g77.exe ";
    private static final String INVOKE_GNU_Fortran6 = "g95 ";
    private static final String INVOKE_GNU_Fortran7 = "g90 ";
    private static final String INVOKE_GNU_Fortran8 = "g77 ";
    private static final String INVOKE_SUN_Fortran = "ffortran ";
    private static final String INVOKE_SUN_Fortran1 = "f95 ";
    private static final String INVOKE_SUN_Fortran2 = "f90 ";
    private static final String INVOKE_SUN_Fortran3 = "f77 ";
    private static final String MAKE_DELIMITER = ";";
    private static final String PKG_CONFIG_PATTERN = "pkg-config ";
    private static final String ECHO_PATTERN = "echo ";
    private HashSet<String> subFolders;
    private Map<String, List<String>> findBase;

    public LogReader(String string, String string2, ProjectProxy projectProxy) {
        this.root = string2.length() > 0 ? CndFileUtils.normalizeFile((File)new File(string2)).getAbsolutePath() : string2;
        this.fileName = string;
        this.project = projectProxy;
        this.pathMapper = this.getPathMapper(projectProxy);
        this.setWorkingDir(string2);
    }

    private String convertPath(String string) {
        String string2;
        if (this.pathMapper != null && CndPathUtilitities.isPathAbsolute((CharSequence)string) && (string2 = this.pathMapper.getLocalPath(string)) != null) {
            return string2;
        }
        return string;
    }

    private PathMap getPathMapper(ProjectProxy projectProxy) {
        ExecutionEnvironment executionEnvironment;
        RemoteProject remoteProject;
        Project project = projectProxy.getProject();
        if (project != null && (remoteProject = (RemoteProject)project.getLookup().lookup(RemoteProject.class)) != null && (executionEnvironment = remoteProject.getDevelopmentHost()) != null && executionEnvironment.isRemote()) {
            return HostInfoProvider.getMapper((ExecutionEnvironment)executionEnvironment);
        }
        return null;
    }

    private MakeConfiguration getConfiguration(ProjectProxy projectProxy) {
        MakeConfigurationDescriptor makeConfigurationDescriptor;
        ConfigurationDescriptorProvider configurationDescriptorProvider;
        if (projectProxy != null && projectProxy.getProject() != null && (configurationDescriptorProvider = (ConfigurationDescriptorProvider)projectProxy.getProject().getLookup().lookup(ConfigurationDescriptorProvider.class)) != null && configurationDescriptorProvider.gotDescriptor() && (makeConfigurationDescriptor = configurationDescriptorProvider.getConfigurationDescriptor()) != null) {
            return makeConfigurationDescriptor.getActiveConfiguration();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(Progress progress, AtomicBoolean atomicBoolean) {
        if (TRACE) {
            System.out.println("LogReader is run for " + this.fileName);
        }
        Pattern pattern = Pattern.compile(";|\\|\\||&&");
        this.result = new ArrayList<SourceFileProperties>();
        File file = new File(this.fileName);
        if (file.exists() && file.canRead()) {
            try {
                MakeConfiguration makeConfiguration = this.getConfiguration(this.project);
                PkgConfigManager.PkgConfig pkgConfig = PkgConfigManager.getDefault().getPkgConfig(makeConfiguration);
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                long l = file.length();
                long l2 = 0L;
                int n = 0;
                if (l <= 0L) {
                    progress = null;
                }
                if (progress != null) {
                    progress.start(100);
                }
                int n2 = 0;
                try {
                    while (!atomicBoolean.get()) {
                        String[] stringArray;
                        String string = bufferedReader.readLine();
                        if (string == null) {
                            break;
                        }
                        l2 += (long)(string.length() + 1);
                        string = string.trim();
                        while (string.endsWith("\\") && (stringArray = bufferedReader.readLine()) != null) {
                            string = string.substring(0, string.length() - 1) + " " + stringArray.trim();
                        }
                        string = LogReader.trimBackApostropheCalls(string, pkgConfig);
                        stringArray = pattern.split(string);
                        for (int i = 0; i < stringArray.length; ++i) {
                            if (!this.parseLine(stringArray[i])) continue;
                            ++n2;
                        }
                        if (l2 * 100L / l <= (long)n || n >= 100) continue;
                        ++n;
                        if (progress == null) continue;
                        progress.increment(null);
                    }
                }
                finally {
                    if (progress != null) {
                        progress.done();
                    }
                }
                if (TRACE) {
                    System.out.println("Files found: " + n2);
                    System.out.println("Files included in result: " + this.result.size());
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public List<SourceFileProperties> getResults(Progress progress, AtomicBoolean atomicBoolean) {
        if (this.result == null) {
            this.run(progress, atomicBoolean);
            if (this.subFolders != null) {
                this.subFolders.clear();
                this.subFolders = null;
                this.findBase.clear();
                this.findBase = null;
            }
        }
        return this.result;
    }

    private int getMakeLevel(String string) {
        int n;
        int n2 = string.indexOf(91);
        if (n2 > 0 && (n = string.indexOf(93)) > n2) {
            String string2 = string.substring(n2 + 1, n);
            try {
                int n3 = Integer.parseInt(string2);
                return n3;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    private void enterMakeStack(String string, int n) {
        if (n < 0) {
            return;
        }
        for (int i = this.makeStack.size(); i <= n; ++i) {
            this.makeStack.add(new ArrayList());
        }
        List<String> list = this.makeStack.get(n);
        list.add(string);
    }

    private boolean leaveMakeStack(String string, int n) {
        if (n < 0) {
            return false;
        }
        if (this.makeStack.size() <= n) {
            return false;
        }
        List<String> list = this.makeStack.get(n);
        for (String string2 : list) {
            if (!string2.equals(string)) continue;
            list.remove(string2);
            return true;
        }
        return false;
    }

    private List<String> getMakeTop(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = Math.min(this.makeStack.size(), n - 1); i >= 0; --i) {
            List<String> list = this.makeStack.get(i);
            if (list.size() <= 0) continue;
            if (arrayList.isEmpty()) {
                arrayList.addAll(list);
                continue;
            }
            if (list.size() <= 1) continue;
            arrayList.addAll(list);
        }
        return arrayList;
    }

    private boolean checkDirectoryChange(String string) {
        String string2;
        String string3;
        String string4 = null;
        String string5 = null;
        if (string.startsWith(CURRENT_DIRECTORY)) {
            string4 = this.convertPath(string.substring(CURRENT_DIRECTORY.length() + 1).trim());
            if (TRACE) {
                string5 = "**>> by [Current working directory] ";
            }
        } else if (string.indexOf(ENTERING_DIRECTORY) >= 0) {
            String string6 = string.substring(string.indexOf(ENTERING_DIRECTORY) + ENTERING_DIRECTORY.length() + 1).trim();
            string4 = this.convertPath(string6.replaceAll("`|'|\"", ""));
            if (TRACE) {
                string5 = "**>> by [Entering directory] ";
            }
            this.baseWorkingDir = string4;
            this.enterMakeStack(string4, this.getMakeLevel(string));
        } else if (string.indexOf(LEAVING_DIRECTORY) >= 0) {
            List<String> list;
            int n;
            String string7 = string.substring(string.indexOf(LEAVING_DIRECTORY) + LEAVING_DIRECTORY.length() + 1).trim();
            string4 = this.convertPath(string7.replaceAll("`|'|\"", ""));
            if (TRACE) {
                string5 = "**>> by [Leaving directory] ";
            }
            if (this.leaveMakeStack(string4, n = this.getMakeLevel(string)) && (list = this.getMakeTop(n)).size() == 1) {
                this.baseWorkingDir = list.get(0);
            }
        } else if (string.startsWith(LABEL_CD)) {
            int n = string.indexOf(MAKE_DELIMITER);
            string4 = this.convertPath((n == -1 ? string : string.substring(0, n)).substring(LABEL_CD.length()).trim());
            if (TRACE) {
                string5 = "**>> by [ cd ] ";
            }
            if (string4.startsWith("/")) {
                this.baseWorkingDir = string4;
            }
        } else if (string.startsWith("/") && string.indexOf(" ") < 0) {
            string4 = this.convertPath(string.trim());
            if (TRACE) {
                string5 = "**>> by [just path string] ";
            }
        }
        if (string4 == null || string4.length() == 0) {
            return false;
        }
        if (Utilities.isWindows() && string4.startsWith("/cygdrive/") && string4.length() > 11) {
            string4 = "" + string4.charAt(10) + ":" + string4.substring(11);
        }
        if (string4.charAt(0) == '/' || string4.charAt(0) == '\\' || string4.length() > 1 && string4.charAt(1) == ':') {
            if (new File(string4).exists()) {
                if (TRACE) {
                    System.err.print(string5);
                }
                this.setWorkingDir(string4);
                return true;
            }
            String string8 = this.fixNetHost(string4);
            if (string8 != null) {
                this.setWorkingDir(string8);
            }
        }
        if (new File(string3 = this.workingDir + File.separator + string4).exists()) {
            if (TRACE) {
                System.err.print(string5);
            }
            this.setWorkingDir(string3);
            return true;
        }
        if (Utilities.isWindows() && string4.length() > 3 && string4.charAt(0) == '/' && string4.charAt(2) == '/' && new File(string2 = "" + string4.charAt(1) + ":" + string4.substring(2)).exists()) {
            if (TRACE) {
                System.err.print(string5);
            }
            this.setWorkingDir(string2);
            return true;
        }
        if (this.baseWorkingDir != null && new File(string3 = this.baseWorkingDir + File.separator + string4).exists()) {
            if (TRACE) {
                System.err.print(string5);
            }
            this.setWorkingDir(string3);
            return true;
        }
        return false;
    }

    private String fixNetHost(String string) {
        int n;
        if (this.root.startsWith("/net/") && (n = this.root.indexOf(47, 5)) > 0) {
            String string2;
            String string3 = this.root.substring(n);
            String string4 = this.root.substring(0, n);
            if (string.startsWith(string3) && new File(string2 = string4 + string).exists()) {
                return string2;
            }
        }
        return null;
    }

    private static int[] foundCompiler(String string, String ... stringArray) {
        for (String string2 : stringArray) {
            int n = string.indexOf(string2);
            if (n < 0) continue;
            int n2 = n + string2.length();
            return new int[]{n, n2};
        }
        return null;
    }

    static LineInfo testCompilerInvocation(String string) {
        int[] nArray;
        LineInfo lineInfo = new LineInfo(string);
        int n = 0;
        int n2 = -1;
        if (lineInfo.compilerType == CompilerType.UNKNOWN && (nArray = LogReader.foundCompiler(string, INVOKE_GNU_C, INVOKE_GNU_C2)) != null) {
            n = nArray[0];
            n2 = nArray[1];
            lineInfo.compilerType = CompilerType.C;
            lineInfo.compiler = "gcc";
        }
        if (lineInfo.compilerType == CompilerType.UNKNOWN && (nArray = LogReader.foundCompiler(string, INVOKE_GNU_Cpp, INVOKE_GNU_Cpp2, INVOKE_GNU_Cpp3, INVOKE_GNU_Cpp4)) != null) {
            n = nArray[0];
            n2 = nArray[1];
            lineInfo.compilerType = CompilerType.CPP;
            lineInfo.compiler = "g++";
        }
        if (lineInfo.compilerType == CompilerType.UNKNOWN && (nArray = LogReader.foundCompiler(string, INVOKE_SUN_C)) != null) {
            n = nArray[0];
            n2 = nArray[1];
            lineInfo.compilerType = CompilerType.C;
            lineInfo.compiler = "cc";
        }
        if (lineInfo.compilerType == CompilerType.UNKNOWN && (nArray = LogReader.foundCompiler(string, INVOKE_SUN_Cpp)) != null) {
            n = nArray[0];
            n2 = nArray[1];
            lineInfo.compilerType = CompilerType.CPP;
            lineInfo.compiler = "CC";
        }
        if (lineInfo.compilerType == CompilerType.UNKNOWN && (nArray = LogReader.foundCompiler(string, INVOKE_GNU_Fortran1, INVOKE_GNU_Fortran2, INVOKE_GNU_Fortran3, INVOKE_GNU_Fortran4, INVOKE_GNU_Fortran5, INVOKE_GNU_Fortran6, INVOKE_GNU_Fortran7, INVOKE_GNU_Fortran8)) != null) {
            n = nArray[0];
            n2 = nArray[1];
            lineInfo.compilerType = CompilerType.FORTRAN;
            lineInfo.compiler = "gfortran";
        }
        if (lineInfo.compilerType == CompilerType.UNKNOWN && (nArray = LogReader.foundCompiler(string, INVOKE_SUN_Fortran, INVOKE_SUN_Fortran1, INVOKE_SUN_Fortran2, INVOKE_SUN_Fortran3)) != null) {
            n = nArray[0];
            n2 = nArray[1];
            lineInfo.compilerType = CompilerType.FORTRAN;
            lineInfo.compiler = "ffortran";
        }
        if (lineInfo.compilerType == CompilerType.UNKNOWN && (nArray = LogReader.foundCompiler(string, INVOKE_MSVC_Cpp)) != null) {
            n = nArray[0];
            n2 = nArray[1];
            lineInfo.compilerType = CompilerType.CPP;
            lineInfo.compiler = "cl";
        }
        if (lineInfo.compilerType != CompilerType.UNKNOWN) {
            lineInfo.compileLine = string.substring(n);
            while (n2 < string.length() && (string.charAt(n2) == ' ' || string.charAt(n2) == '\t')) {
                ++n2;
            }
            if (n2 >= string.length() || string.charAt(n2) != '-') {
                lineInfo.compilerType = CompilerType.UNKNOWN;
            }
        }
        return lineInfo;
    }

    private void setWorkingDir(String string) {
        if (TRACE) {
            System.err.println("**>> new working dir: " + string);
        }
        this.workingDir = CndFileUtils.normalizeFile((File)new File(string)).getAbsolutePath();
    }

    private void setGuessWorkingDir(String string) {
        if (TRACE) {
            System.err.println("**>> alternative guess working dir: " + string);
        }
        this.guessWorkingDir = CndFileUtils.normalizeFile((File)new File(string)).getAbsolutePath();
    }

    private boolean parseLine(String string) {
        if (this.checkDirectoryChange(string)) {
            return false;
        }
        if (this.workingDir == null) {
            return false;
        }
        if (!this.workingDir.startsWith(this.root)) {
            return false;
        }
        LineInfo lineInfo = LogReader.testCompilerInvocation(string);
        if (lineInfo.compilerType != CompilerType.UNKNOWN) {
            this.gatherLine(lineInfo);
            return true;
        }
        return false;
    }

    static String trimBackApostropheCalls(String string, PkgConfigManager.PkgConfig pkgConfig) {
        int n;
        int n2 = string.indexOf(96);
        if (string.lastIndexOf(96) == n2) {
            return string;
        }
        if (n2 < 0 || n2 == string.length() - 1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (n2 > 0) {
            stringBuilder.append(string.substring(0, n2));
        }
        if ((n = (string = string.substring(n2 + 1)).indexOf(96)) < 0) {
            return string;
        }
        String string2 = string.substring(0, n);
        if (string2.startsWith(PKG_CONFIG_PATTERN)) {
            String string3;
            string2 = string2.substring(PKG_CONFIG_PATTERN.length());
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            boolean bl = false;
            String string4 = null;
            while (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
                if (string3.equals("--cflags")) {
                    bl = true;
                    continue;
                }
                if (string3.startsWith("-")) {
                    bl = false;
                    continue;
                }
                string4 = string3;
            }
            if (bl && pkgConfig != null && string4 != null && (string3 = pkgConfig.getPkgConfig(string4)) != null) {
                for (String string5 : string3.getIncludePaths()) {
                    stringBuilder.append(" -I").append(string5);
                }
                for (String string5 : string3.getMacros()) {
                    stringBuilder.append(" -D").append(string5);
                }
                stringBuilder.append(" ");
            }
        } else if (string2.startsWith(ECHO_PATTERN)) {
            if ((string2 = string2.substring(ECHO_PATTERN.length())).startsWith("'") && string2.endsWith("'")) {
                stringBuilder.append(string2.substring(1, string2.length() - 1));
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                boolean bl = true;
                if (stringTokenizer.hasMoreTokens()) {
                    if (!bl) {
                        stringBuilder.append(" ");
                    }
                    bl = false;
                    stringBuilder.append(stringTokenizer.nextToken());
                }
            }
        } else if (string2.contains(ECHO_PATTERN)) {
            if ((string2 = string2.substring(string2.indexOf(ECHO_PATTERN) + ECHO_PATTERN.length())).startsWith("'") && string2.endsWith("'")) {
                stringBuilder.append(string2.substring(1, string2.length() - 1));
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                boolean bl = true;
                if (stringTokenizer.hasMoreTokens()) {
                    if (!bl) {
                        stringBuilder.append(" ");
                    }
                    bl = false;
                    stringBuilder.append(stringTokenizer.nextToken());
                }
            }
        }
        stringBuilder.append(string.substring(n + 1));
        return LogReader.trimBackApostropheCalls(stringBuilder.toString(), pkgConfig);
    }

    private boolean gatherLine(LineInfo lineInfo) {
        File file;
        String string = lineInfo.compileLine;
        ArrayList<String> arrayList = new ArrayList<String>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        String string2 = DiscoveryUtils.gatherCompilerLine((String)string, (boolean)true, arrayList, hashMap, null, arrayList2);
        if (string2 == null) {
            return false;
        }
        if (string2.endsWith(".s") || string2.endsWith(".S")) {
            return false;
        }
        String string3 = null;
        string3 = string2.startsWith("/") ? string2 : this.workingDir + "/" + string2;
        ArrayList<String> arrayList3 = new ArrayList<String>(arrayList.size());
        for (String object2 : arrayList) {
            arrayList3.add(PathCache.getString(object2));
        }
        HashMap hashMap2 = new HashMap(hashMap.size());
        for (Map.Entry entry : hashMap.entrySet()) {
            if (entry.getValue() == null) {
                hashMap2.put(PathCache.getString((String)entry.getKey()), null);
                continue;
            }
            hashMap2.put(PathCache.getString((String)entry.getKey()), PathCache.getString((String)entry.getValue()));
        }
        File file2 = new File(string3);
        if (file2.exists() && file2.isFile()) {
            if (TRACE) {
                System.err.println("**** Gotcha: " + string3);
            }
            this.result.add(new CommandLineSource(lineInfo, arrayList2, this.workingDir, string2, arrayList3, hashMap2));
            return true;
        }
        if (this.guessWorkingDir != null && !string2.startsWith("/") && (file = new File(this.guessWorkingDir + "/" + string2)).exists() && file.isFile()) {
            if (TRACE) {
                System.err.println("**** Gotcha guess: " + string3);
            }
            this.result.add(new CommandLineSource(lineInfo, arrayList2, this.guessWorkingDir, string2, arrayList3, hashMap2));
            return true;
        }
        if (TRACE) {
            System.err.println("**** Not found " + string3);
        }
        if (!string2.startsWith("/") && arrayList.size() + hashMap.size() > 0) {
            List<String> list = this.findFiles(string2);
            if (list == null || list.isEmpty()) {
                if (TRACE) {
                    System.err.println("** And there is no such file under root");
                }
            } else {
                if (list.size() == 1) {
                    this.result.add(new CommandLineSource(lineInfo, arrayList2, list.get(0), string2, arrayList, hashMap));
                    if (TRACE) {
                        System.err.println("** Gotcha: " + list.get(0) + File.separator + string2);
                    }
                    this.setGuessWorkingDir(list.get(0));
                    return true;
                }
                if (TRACE) {
                    System.err.println("**There are several candidates and I'm not clever enough yet to find correct one.");
                }
            }
            if (TRACE) {
                System.err.println("" + (string.length() > 120 ? string.substring(0, 117) + ">>>" : string) + " [" + string2 + "]");
            }
            return false;
        }
        return false;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.err.println("Not enough parameters. Format: bla-bla-bla filename root");
            return;
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        TRACE = true;
        LogReader logReader = new LogReader(string, string2, null);
        List<SourceFileProperties> list = logReader.getResults(null, new AtomicBoolean(false));
        System.err.print("\n*** Results: ");
        for (SourceFileProperties sourceFileProperties : list) {
            String string3 = sourceFileProperties.getItemName();
            while (string3.indexOf("../") == 0) {
                string3 = string3.substring(3);
            }
            System.err.print(string3 + " ");
        }
        System.err.println();
    }

    private List<String> getFiles(String string) {
        this.getSubfolders();
        return this.findBase.get(string);
    }

    private List<String> findFiles(String string) {
        List<String> list;
        int n;
        String string2;
        string = string.replace('\\', '/');
        int n2 = string.lastIndexOf(47);
        String string3 = null;
        if (n2 > 0) {
            string2 = string.substring(n2 + 1);
            string3 = string.substring(0, n2);
        } else {
            string2 = string;
        }
        String string4 = null;
        if (string3 != null && (n = string3.lastIndexOf("../")) >= 0) {
            string4 = string.substring(n + 2);
        }
        if ((list = this.getFiles(string2)) != null) {
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            for (String string5 : list) {
                if (string3 == null) {
                    arrayList.add(string5);
                    if (arrayList.size() <= 1) continue;
                    return arrayList;
                }
                if (string4 == null) {
                    Object object = string5;
                    if (!((String)object).endsWith(string3)) continue;
                    object = ((String)object).substring(0, ((String)object).length() - string3.length() - 1);
                    arrayList.add((String)object);
                    if (arrayList.size() <= 1) continue;
                    return arrayList;
                }
                for (String string6 : this.getSubfolders()) {
                    String string7 = this.normalizeFile(string6 + "/" + string);
                    int n3 = string7.lastIndexOf(47);
                    if (n3 <= 0 || !this.subFolders.contains(string7 = string7.substring(0, n3))) continue;
                    arrayList.add(string6);
                    if (arrayList.size() <= 1) continue;
                    return arrayList;
                }
            }
            return arrayList;
        }
        return null;
    }

    private String normalizeFile(String string) {
        int n;
        string = string.replace("/./", "/");
        while ((n = string.indexOf("/../")) >= 0) {
            int n2 = -1;
            for (int i = n - 1; i >= 0; --i) {
                if (string.charAt(i) != '/') continue;
                n2 = i;
                break;
            }
            if (n2 == -1) break;
            string = string.substring(0, n2) + string.substring(n + 3);
        }
        return string;
    }

    private Set<String> getSubfolders() {
        if (this.subFolders == null) {
            this.subFolders = new HashSet();
            File file = new File(this.root);
            this.gatherSubFolders(file);
            this.findBase = new HashMap<String, List<String>>();
            this.initSearchMap();
        }
        return this.subFolders;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void gatherSubFolders(File file) {
        if (!file.exists() || !file.isDirectory() || !file.canRead()) return;
        if (DiscoveryUtils.ignoreFolder((File)file)) {
            return;
        }
        String string = file.getAbsolutePath().replace('\\', '/');
        if (this.subFolders.contains(string)) return;
        this.subFolders.add(string);
        File[] fileArray = file.listFiles();
        if (fileArray == null) return;
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].isDirectory()) continue;
            try {
                String string2 = fileArray[i].getCanonicalPath();
                String string3 = fileArray[i].getAbsolutePath();
                if (!string3.equals(string2) && string3.startsWith(string2)) {
                    continue;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.gatherSubFolders(fileArray[i]);
        }
    }

    private void initSearchMap() {
        for (String string : this.subFolders) {
            File[] fileArray;
            File file = new File(string);
            if (!file.exists() || !file.isDirectory() || !file.canRead() || (fileArray = file.listFiles()) == null) continue;
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].isFile()) continue;
                List<String> list = this.findBase.get(fileArray[i].getName());
                if (list == null) {
                    list = new ArrayList<String>();
                    this.findBase.put(fileArray[i].getName(), list);
                }
                list.add(file.getAbsolutePath().replace('\\', '/'));
            }
        }
    }

    static class CommandLineSource
    implements SourceFileProperties {
        private String compilePath;
        private String sourceName;
        private String fullName;
        private String compiler;
        private ItemProperties.LanguageKind language;
        private List<String> userIncludes;
        private List<String> systemIncludes = Collections.emptyList();
        private Map<String, String> userMacros;
        private Map<String, String> systemMacros = Collections.emptyMap();
        private Set<String> includedFiles = Collections.emptySet();

        CommandLineSource(LineInfo lineInfo, List<String> list, String string, String string2, List<String> list2, Map<String, String> map) {
            Object object;
            this.language = lineInfo.getLanguage();
            if (list.contains("c")) {
                this.language = ItemProperties.LanguageKind.C;
            } else if (list.contains("c++")) {
                this.language = ItemProperties.LanguageKind.CPP;
            } else {
                object = MIMESupport.getKnownMIMETypeByExtension((String)string2);
                if ("text/x-c++".equals(object)) {
                    if (lineInfo.getLanguage() != ItemProperties.LanguageKind.CPP) {
                        this.language = ItemProperties.LanguageKind.CPP;
                    }
                } else if ("text/x-c".equals(object) && lineInfo.getLanguage() != ItemProperties.LanguageKind.C) {
                    this.language = ItemProperties.LanguageKind.C;
                }
            }
            this.compiler = lineInfo.compiler;
            this.compilePath = string;
            this.sourceName = string2;
            if (this.sourceName.startsWith("/")) {
                this.fullName = this.sourceName;
                this.sourceName = DiscoveryUtils.getRelativePath((String)string, (String)this.sourceName);
            } else {
                this.fullName = string + "/" + this.sourceName;
            }
            object = new File(this.fullName);
            this.fullName = CndFileUtils.normalizeFile((File)object).getAbsolutePath();
            this.fullName = PathCache.getString(this.fullName);
            this.userIncludes = list2;
            this.userMacros = map;
        }

        public String getCompilePath() {
            return this.compilePath;
        }

        public String getItemPath() {
            return this.fullName;
        }

        public String getItemName() {
            return this.sourceName;
        }

        public List<String> getUserInludePaths() {
            return this.userIncludes;
        }

        public List<String> getSystemInludePaths() {
            return this.systemIncludes;
        }

        public Set<String> getIncludedFiles() {
            return this.includedFiles;
        }

        public Map<String, String> getUserMacros() {
            return this.userMacros;
        }

        public Map<String, String> getSystemMacros() {
            return this.systemMacros;
        }

        public ItemProperties.LanguageKind getLanguageKind() {
            return this.language;
        }

        public String getCompilerName() {
            return this.compiler;
        }

        public ItemProperties.LanguageStandard getLanguageStandard() {
            return ItemProperties.LanguageStandard.Unknown;
        }
    }

    static class LineInfo {
        public String compileLine;
        public String compiler;
        public CompilerType compilerType = CompilerType.UNKNOWN;

        LineInfo(String string) {
            this.compileLine = string;
        }

        ItemProperties.LanguageKind getLanguage() {
            switch (this.compilerType) {
                case C: {
                    return ItemProperties.LanguageKind.C;
                }
                case CPP: {
                    return ItemProperties.LanguageKind.CPP;
                }
                case FORTRAN: {
                    return ItemProperties.LanguageKind.Fortran;
                }
            }
            return ItemProperties.LanguageKind.Unknown;
        }
    }

    static enum CompilerType {
        CPP,
        C,
        FORTRAN,
        UNKNOWN;

    }
}

