/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.queries.FileBuiltQuery;
import org.netbeans.modules.mobility.project.ProjectConfigurationsHelper;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.queries.FileBuiltQueryImplementation;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class FileBuiltQueryImpl
implements FileBuiltQueryImplementation,
PropertyChangeListener,
Runnable {
    protected final AntProjectHelper helper;
    private static final Object NONE = "NONE";
    private final Map<FileObject, Object> statuses = new WeakHashMap<FileObject, Object>();
    private FileObject srcRoot = null;
    private static RequestProcessor RP = new RequestProcessor(FileBuiltQueryImpl.class);

    public FileBuiltQueryImpl(AntProjectHelper helper, ProjectConfigurationsHelper confs) {
        this.helper = helper;
        confs.addPropertyChangeListener(this);
    }

    protected FileObject getSrcRoot() {
        String dir;
        if (this.srcRoot == null && (dir = this.helper.getStandardPropertyEvaluator().getProperty("src.dir")) != null) {
            this.srcRoot = this.helper.resolveFileObject(dir);
        }
        return this.srcRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileBuiltQuery.Status getStatus(FileObject file) {
        StatusImpl status;
        Object o;
        Map<FileObject, Object> map = this.statuses;
        synchronized (map) {
            o = this.statuses.get(file);
        }
        if (o == NONE) {
            return null;
        }
        Reference r = (Reference)o;
        StatusImpl statusImpl = status = r != null ? (StatusImpl)r.get() : null;
        if (status == null) {
            status = this.createStatus(file);
            Map<FileObject, Object> map2 = this.statuses;
            synchronized (map2) {
                if (status != null) {
                    this.statuses.put(file, new WeakReference<StatusImpl>(status));
                } else {
                    this.statuses.put(file, NONE);
                }
            }
        }
        return status;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        RP.post((Runnable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        FileObject[] files;
        Map<FileObject, Object> map = this.statuses;
        synchronized (map) {
            files = this.statuses.keySet().toArray(new FileObject[this.statuses.size()]);
        }
        for (int i = 0; i < files.length; ++i) {
            StatusImpl status = (StatusImpl)this.getStatus(files[i]);
            if (status == null) continue;
            status.isBuilt();
        }
    }

    private StatusImpl createStatus(FileObject file) {
        FileObject root = this.getSrcRoot();
        if (root != null && file != null && FileUtil.isParentOf((FileObject)root, (FileObject)file) && file.getExt().equals("java")) {
            try {
                return new StatusImpl(file);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    private final class StatusImpl
    implements FileBuiltQuery.Status,
    PropertyChangeListener,
    FileChangeListener,
    Runnable {
        private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
        private Boolean built = null;
        private final DataObject source;
        private FileObject oldTarget = null;
        private FileChangeListener weekListener = null;

        StatusImpl(FileObject source) throws DataObjectNotFoundException {
            this.source = DataObject.find((FileObject)source);
            this.source.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.source));
            source.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this, (Object)source));
        }

        private synchronized File getTarget() {
            FileObject root = FileBuiltQueryImpl.this.getSrcRoot();
            FileObject srcFile = this.source.getPrimaryFile();
            if (root == null || srcFile == null) {
                return null;
            }
            String path = FileUtil.getRelativePath((FileObject)root, (FileObject)srcFile);
            String buildClasses = FileBuiltQueryImpl.this.helper.getStandardPropertyEvaluator().getProperty("build.classes.dir");
            File target = path == null || !path.endsWith(".java") || buildClasses == null ? null : FileBuiltQueryImpl.this.helper.resolveFile(buildClasses + "/" + path.substring(0, path.length() - 4) + "class");
            FileObject newTarget = null;
            for (File f = target; !(newTarget != null && newTarget.isValid() || f == null); f = f.getParentFile()) {
                newTarget = FileUtil.toFileObject(f);
            }
            if (!Utilities.compareObjects((Object)this.oldTarget, (Object)newTarget)) {
                if (this.oldTarget != null && this.weekListener != null) {
                    this.oldTarget.removeFileChangeListener(this.weekListener);
                }
                if (newTarget != null) {
                    this.weekListener = FileUtil.weakFileChangeListener((FileChangeListener)this, (Object)newTarget);
                    newTarget.addFileChangeListener(this.weekListener);
                    newTarget.getChildren();
                }
                this.oldTarget = newTarget;
            }
            return target;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isBuilt() {
            boolean b;
            boolean doFire = false;
            StatusImpl statusImpl = this;
            synchronized (statusImpl) {
                b = this.isReallyBuilt();
                if (this.built != null && this.built != b) {
                    doFire = true;
                }
                this.built = b;
            }
            if (doFire) {
                this.fireChange();
            }
            return b;
        }

        private boolean isReallyBuilt() {
            File target = this.getTarget();
            FileObject srcFile = this.source.getPrimaryFile();
            if (!this.source.isValid() || this.source.isModified() || target == null || srcFile == null) {
                return false;
            }
            return target.lastModified() >= srcFile.lastModified().getTime();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChangeListener(ChangeListener l) {
            List<ChangeListener> list = this.listeners;
            synchronized (list) {
                this.listeners.add(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeChangeListener(ChangeListener l) {
            List<ChangeListener> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireChange() {
            ChangeListener[] _listeners;
            List<ChangeListener> list = this.listeners;
            synchronized (list) {
                if (this.listeners.isEmpty()) {
                    return;
                }
                _listeners = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
            }
            ChangeEvent ev = new ChangeEvent(this);
            for (int i = 0; i < _listeners.length; ++i) {
                _listeners[i].stateChanged(ev);
            }
        }

        private void update() {
            RP.post((Runnable)this);
        }

        @Override
        public void run() {
            this.isBuilt();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            assert (evt.getSource() instanceof DataObject);
            if ("modified".equals(evt.getPropertyName())) {
                this.update();
            }
        }

        public void fileChanged(FileEvent fe) {
            this.update();
        }

        public void fileDeleted(FileEvent fe) {
            this.update();
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.update();
        }

        public void fileDataCreated(FileEvent fe) {
            this.update();
        }

        public void fileFolderCreated(FileEvent fe) {
            this.update();
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        public String toString() {
            return "FBQI.StatusImpl[" + this.source.getPrimaryFile() + " -> " + this.getTarget() + "]";
        }
    }
}

