/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midpnb.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.common.ActiveDocumentSupport;
import org.netbeans.modules.vmd.midp.components.MidpProjectSupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class EditSVGFileAction
extends SystemAction {
    public String getName() {
        return NbBundle.getMessage(EditSVGFileAction.class, (String)"NAME_EditSVGFile");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public void actionPerformed(ActionEvent ev) {
        FileObject svgFileObject = this.getSVGFileObject();
        if (svgFileObject == null) {
            return;
        }
        try {
            OpenCookie oc = (OpenCookie)DataObject.find((FileObject)svgFileObject).getCookie(OpenCookie.class);
            if (oc == null) {
                return;
            }
            oc.open();
        }
        catch (DataObjectNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public boolean isEnabled() {
        FileObject svgFileObject = this.getSVGFileObject();
        return svgFileObject != null;
    }

    private DesignComponent getActiveComponent() {
        Iterator iterator;
        Collection components = ActiveDocumentSupport.getDefault().getActiveComponents();
        if (components.size() == 1 && (iterator = components.iterator()).hasNext()) {
            return (DesignComponent)iterator.next();
        }
        return null;
    }

    private FileObject getSVGFileObject() {
        final DesignComponent animatorComponent = this.getActiveComponent();
        if (animatorComponent == null) {
            return null;
        }
        final FileObject[] svgFileWrapper = new FileObject[1];
        animatorComponent.getDocument().getTransactionManager().readAccess(new Runnable(){

            @Override
            public void run() {
                PropertyValue propertyValue;
                DesignComponent svgImageComponent;
                PropertyValue value = animatorComponent.readProperty("svgImage");
                if (!PropertyValue.Kind.USERCODE.equals((Object)value.getKind()) && (svgImageComponent = value.getComponent()) != null && (propertyValue = svgImageComponent.readProperty("resourcePath")).getKind() == PropertyValue.Kind.VALUE) {
                    FileObject svgFileObject;
                    Map images = MidpProjectSupport.getFileObjectsForRelativeResourcePath((DesignDocument)animatorComponent.getDocument(), (String)MidpTypes.getString((PropertyValue)propertyValue));
                    Iterator iterator = images.keySet().iterator();
                    svgFileWrapper[0] = svgFileObject = iterator.hasNext() ? (FileObject)iterator.next() : null;
                }
            }
        });
        return svgFileWrapper[0];
    }
}

