/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midpnb.components;

import java.awt.datatransfer.Transferable;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.vmd.api.model.ComponentProducer;
import org.netbeans.modules.vmd.api.model.DescriptorRegistry;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.common.AcceptSuggestion;
import org.netbeans.modules.vmd.api.model.common.DesignComponentDataFlavorSupport;
import org.netbeans.modules.vmd.midp.components.MidpAcceptTrensferableKindPresenter;
import org.netbeans.modules.vmd.midp.components.MidpProjectSupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midpnb.components.svg.SVGMenuCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGFormCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGFormSupport;
import org.openide.filesystems.FileObject;

public class SVGImageAcceptTrensferableKindPresenter
extends MidpAcceptTrensferableKindPresenter {
    public ComponentProducer.Result accept(Transferable transferable, AcceptSuggestion suggestion) {
        DesignComponent component = DesignComponentDataFlavorSupport.getTransferableDesignComponent((Transferable)transferable);
        String propertyName = (String)this.typesMap.get(component.getType());
        if (propertyName == null) {
            throw new IllegalStateException();
        }
        DesignComponent svgPlayer = this.getComponent();
        svgPlayer.writeProperty(propertyName, PropertyValue.createComponentReference((DesignComponent)component));
        if (this.isAcceptableForComponent(svgPlayer)) {
            Set<FileObject> images = this.getImagesFO(svgPlayer, component);
            if (this.getComponent().getDocument().getDescriptorRegistry().isInHierarchy(SVGFormCD.TYPEID, this.getComponent().getType())) {
                SVGFormSupport.removeAllSVGFormComponents(this.getComponent());
            }
            for (FileObject img : images) {
                SVGFormSupport.parseSVGImageItems(img, svgPlayer);
            }
        }
        return new ComponentProducer.Result(new DesignComponent[]{component});
    }

    private boolean isAcceptableForComponent(DesignComponent svgComponent) {
        TypeID typeID;
        DescriptorRegistry descrRegistry = svgComponent.getDocument().getDescriptorRegistry();
        return descrRegistry.isInHierarchy(SVGMenuCD.TYPEID, typeID = svgComponent.getType()) ? svgComponent.readProperty("elements").getArray().size() == 0 : descrRegistry.isInHierarchy(SVGFormCD.TYPEID, typeID);
    }

    private Set<FileObject> getImagesFO(DesignComponent parentComponent, DesignComponent transferableComponent) {
        PropertyValue propertyValue = transferableComponent.readProperty("resourcePath");
        if (propertyValue.getKind() == PropertyValue.Kind.VALUE) {
            Map images = MidpProjectSupport.getFileObjectsForRelativeResourcePath((DesignDocument)parentComponent.getDocument(), (String)MidpTypes.getString((PropertyValue)propertyValue));
            return images.keySet();
        }
        return Collections.EMPTY_SET;
    }
}

