/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midpnb.components.svg.form;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DescriptorRegistry;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.presenters.actions.DeleteSupport;
import org.netbeans.modules.vmd.api.model.support.ArraySupport;
import org.netbeans.modules.vmd.midp.components.MidpProjectSupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.sources.EventSourceCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGComponentCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGFormCD;
import org.netbeans.modules.vmd.midpnb.components.svg.parsers.SVGComponentImageParser;
import org.netbeans.modules.vmd.midpnb.components.svg.parsers.SVGFormImageParser;
import org.netbeans.modules.vmd.midpnb.components.svg.parsers.SVGMenuImageParser;
import org.openide.filesystems.FileObject;

public final class SVGFormSupport {
    private SVGFormSupport() {
    }

    public static final void removeAllSVGFormComponents(DesignComponent svgForm) {
        DescriptorRegistry registry = svgForm.getDocument().getDescriptorRegistry();
        if (!registry.isInHierarchy(SVGFormCD.TYPEID, svgForm.getType())) {
            throw new IllegalArgumentException("Design Component is not SVGFormCD type" + svgForm.getType());
        }
        HashSet components = new HashSet(svgForm.getComponents());
        for (DesignComponent svgComponent : components) {
            if (!registry.isInHierarchy(SVGComponentCD.TYPEID, svgComponent.getType())) continue;
            SVGFormSupport.deleteEventSource(svgComponent);
            ArraySupport.remove((DesignComponent)svgForm, (String)"components", (DesignComponent)svgComponent);
        }
        DeleteSupport.invokeDirectUserDeletion((DesignDocument)svgForm.getDocument(), components, (boolean)false);
    }

    public static final Collection<DesignComponent> getSVGFormComponents(DesignComponent svgForm) {
        DescriptorRegistry registry = svgForm.getDocument().getDescriptorRegistry();
        if (!registry.isInHierarchy(SVGFormCD.TYPEID, svgForm.getType())) {
            throw new IllegalArgumentException("Design Component is not SVGFormCD type" + svgForm.getType());
        }
        HashSet<DesignComponent> svgComponents = new HashSet<DesignComponent>();
        for (DesignComponent svgComponent : svgForm.getComponents()) {
            if (!registry.isInHierarchy(SVGComponentCD.TYPEID, svgComponent.getType())) continue;
            svgComponents.add(svgComponent);
        }
        return svgComponents;
    }

    private static void deleteEventSource(DesignComponent svgComponent) {
        DesignComponent parentComponent = svgComponent.getParentComponent();
        HashSet components = new HashSet(parentComponent.getComponents());
        for (DesignComponent child : components) {
            if (!parentComponent.getDocument().getDescriptorRegistry().isInHierarchy(EventSourceCD.TYPEID, child.getType()) || child.readProperty("svgButton").getComponent() != svgComponent) continue;
            parentComponent.getDocument().deleteComponent(child);
        }
    }

    public static synchronized FileObject getSVGFile(DesignComponent svgImageComponent) {
        PropertyValue propertyValue = svgImageComponent.readProperty("resourcePath");
        if (propertyValue.getKind() == PropertyValue.Kind.VALUE) {
            return SVGFormSupport.getSVGFile(svgImageComponent.getDocument(), MidpTypes.getString((PropertyValue)propertyValue));
        }
        return null;
    }

    public static synchronized FileObject getSVGFile(DesignDocument document, String path) {
        Map images = MidpProjectSupport.getFileObjectsForRelativeResourcePath((DesignDocument)document, (String)path);
        Iterator iterator = images.keySet().iterator();
        FileObject svgFileObject = iterator.hasNext() ? (FileObject)iterator.next() : null;
        return svgFileObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void parseSVGImageItems(FileObject imageFO, DesignComponent parentComponent) {
        if (imageFO == null) {
            return;
        }
        SVGComponentImageParser parser = SVGComponentImageParser.getParserByComponent(parentComponent);
        if (parser == null) {
            return;
        }
        InputStream inputStream = null;
        inputStream = imageFO.getInputStream();
        if (inputStream != null) {
            DescriptorRegistry registry = parentComponent.getDocument().getDescriptorRegistry();
            if (registry.isInHierarchy(SVGFormCD.TYPEID, parentComponent.getType())) {
                SVGFormImageParser.parseSVGForm(inputStream, parentComponent);
            } else {
                SVGMenuImageParser.parseSVGMenu(inputStream, parentComponent);
            }
        }
        if (inputStream == null) return;
        try {
            inputStream.close();
            return;
        }
        catch (IOException ioe) {
            Debug.warning((Object[])new Object[]{ioe});
        }
        return;
        catch (FileNotFoundException ex) {
            try {
                Debug.warning((Object[])new Object[]{ex});
                if (inputStream == null) return;
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException ioe) {
                    Debug.warning((Object[])new Object[]{ioe});
                }
                throw throwable;
            }
            try {
                inputStream.close();
                return;
            }
            catch (IOException ioe) {
                Debug.warning((Object[])new Object[]{ioe});
            }
            return;
        }
    }
}

