/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midpnb.components.svg.parsers;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.midp.components.MidpArraySupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGButtonCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGButtonGroupCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGCheckBoxCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGComboBoxCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGComponentCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGLabelCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGListCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGRadioButtonCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGSliderCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGSpinnerCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGTextFieldCD;
import org.netbeans.modules.vmd.midpnb.components.svg.parsers.AbstractElementsContentHandler;
import org.netbeans.modules.vmd.midpnb.components.svg.parsers.SVGComponentImageParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SVGFormImageParser
extends SVGComponentImageParser {
    private static final String DIGITS = "_\\d+";
    private static final String DIGITS_END = "_\\d+$";
    private static final String PREFIX = "^";
    private static final Pattern FORM_COMPONENT_ID_BUTTON = Pattern.compile("^button_\\d+$");
    private static final Pattern FORM_COMPONENT_ID_LABEL = Pattern.compile("^label_\\d+$");
    private static final Pattern FORM_COMPONENT_ID_RADIO = Pattern.compile("^radiobutton_\\d+$");
    private static final Pattern FORM_COMPONENT_ID_CHECKBOX = Pattern.compile("^checkbox_\\d+$");
    private static final Pattern FORM_COMPONENT_ID_COMBOBOX = Pattern.compile("^combobox_\\d+$");
    private static final Pattern FORM_COMPONENT_ID_LIST = Pattern.compile("^list_\\d+$");
    private static final Pattern FORM_COMPONENT_ID_SLIDER = Pattern.compile("^slider_\\d+$");
    private static final Pattern FORM_COMPONENT_ID_SPINNER = Pattern.compile("^spinner_\\d+$");
    private static final Pattern FORM_COMPONENT_ID_TEXTFIELD = Pattern.compile("^textfield_\\d+$");
    private static final Pattern FORM_COMPONENT_ID_RADIOBUTTONFRAME = Pattern.compile("^radiobuttonframe_\\d+$");
    private static final Pattern LABEL_TEXT_PROP = Pattern.compile("^label_\\d+_text$");
    private static final Pattern RADIO_TEXT_PROP = Pattern.compile("^radiobutton_\\d+_text$");

    public static synchronized void parseSVGForm(InputStream svgInputStream, final DesignComponent svgForm) {
        final SVGFormComponent[] srcComponents = SVGFormImageParser.getFormComponents(svgInputStream);
        if (srcComponents != null) {
            svgForm.getDocument().getTransactionManager().writeAccess(new Runnable(){

                @Override
                public void run() {
                    HashMap<SVGFormComponent, DesignComponent> producer2Component = new HashMap<SVGFormComponent, DesignComponent>();
                    for (SVGFormComponent srcComponent : srcComponents) {
                        DesignComponent svgComponent = srcComponent.createComponent(svgForm);
                        svgForm.addComponent(svgComponent);
                        producer2Component.put(srcComponent, svgComponent);
                        MidpArraySupport.append((DesignComponent)svgForm, (String)"components", (DesignComponent)svgComponent);
                    }
                    SVGFormImageParser.initButtonGroup(producer2Component);
                }
            });
        }
    }

    @Override
    public void parse(InputStream svgInputStream, DesignComponent svgComponent) {
        SVGFormImageParser.parseSVGForm(svgInputStream, svgComponent);
    }

    public static void initButtonGroup(Map<SVGFormComponent, DesignComponent> producer2Component) {
        for (Map.Entry<SVGFormComponent, DesignComponent> entry : producer2Component.entrySet()) {
            SVGFormComponent buttonGroup;
            Map<String, Object> map;
            SVGFormComponent component = entry.getKey();
            if (!component.getTypeID().equals((Object)SVGRadioButtonCD.TYPEID) || (map = component.getProperties()) == null || (buttonGroup = (SVGFormComponent)map.get("buttonGroup")) == null) continue;
            entry.getValue().writeProperty("buttonGroup", PropertyValue.createComponentReference((DesignComponent)producer2Component.get(buttonGroup)));
        }
    }

    private static SVGFormComponent[] getFormComponents(InputStream svgInputStream) {
        NamedElementsContentHandler ch = new NamedElementsContentHandler();
        try {
            XMLReader parser = XMLReaderFactory.createXMLReader();
            parser.setContentHandler(ch);
            parser.setEntityResolver(ch);
            parser.parse(new InputSource(svgInputStream));
        }
        catch (IOException ex) {
            Debug.warning((Object[])new Object[]{ex});
        }
        catch (SAXException ex) {
            Debug.warning((Object[])new Object[]{ex});
        }
        return ch.getFoundElements();
    }

    private static Float getPosition(Attributes atts) {
        String transform = atts.getValue("transform");
        Float position = null;
        if (transform != null) {
            if (transform.startsWith("translate")) {
                position = SVGFormImageParser.getPositionFromTranslate(transform);
            } else if (transform.startsWith("matrix")) {
                position = SVGFormImageParser.getPositionFromMatrix(transform);
            }
        }
        return position;
    }

    private static Float getPositionFromTranslate(String transform) {
        Float position = null;
        int begining = transform.indexOf(",");
        int end = transform.indexOf(")");
        try {
            position = new Float(transform.substring(begining + 1, end));
        }
        catch (NumberFormatException nfe) {
            Logger.getLogger(SVGFormImageParser.class.getName()).info(nfe.getMessage());
        }
        return position;
    }

    private static Float getPositionFromMatrix(String transform) {
        Float position = null;
        int begining = transform.lastIndexOf(",");
        int end = transform.indexOf(")");
        try {
            position = new Float(transform.substring(begining + 1, end));
        }
        catch (NumberFormatException nfe) {
            Logger.getLogger(SVGFormImageParser.class.getName()).info(nfe.getMessage());
        }
        return position;
    }

    private static Float getPositionForRadioButton(Attributes atts, Float framePosition) {
        Float position = SVGFormImageParser.getPosition(atts);
        if (position == null || atts == null || framePosition == null) {
            return new Float(0.0f);
        }
        if (position != null) {
            position = Float.valueOf(position.floatValue() + framePosition.floatValue());
        }
        return position;
    }

    public static final Object[][] getComponentsInformation(InputStream svgInputStream) {
        SVGFormComponent[] components = SVGFormImageParser.getFormComponents(svgInputStream);
        Object[][] values = new Object[components.length][3];
        for (int i = 0; i < components.length; ++i) {
            values[i][1] = components[i].getId();
            values[i][0] = MidpTypes.getSimpleClassName((TypeID)components[i].getTypeID());
            values[i][2] = components[i];
        }
        return values;
    }

    private static class NamedElementsContentHandler
    extends AbstractElementsContentHandler {
        private ArrayList<SVGFormComponent> foundElements = new ArrayList();
        private Float radioButtonFramePosition;
        private SVGFormComponent myCurrentComponent;
        private SVGFormComponent myButtonGroup;
        private String myPropName;
        private StringBuilder myText;

        public SVGFormComponent[] getFoundElements() {
            LinkedList<SVGFormComponent> reversedList = new LinkedList<SVGFormComponent>();
            for (SVGFormComponent c : this.foundElements) {
                reversedList.addFirst(c);
            }
            return reversedList.toArray(new SVGFormComponent[reversedList.size()]);
        }

        public final void resetFoundElements() {
            this.foundElements.clear();
        }

        @Override
        public final void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            String id = atts.getValue("id");
            String transform = atts.getValue("transform");
            if (id != null && (LABEL_TEXT_PROP.matcher(id).find() || RADIO_TEXT_PROP.matcher(id).find())) {
                this.myPropName = "text";
                return;
            }
            if (id == null || transform == null) {
                return;
            }
            if (FORM_COMPONENT_ID_RADIOBUTTONFRAME.matcher(id).find()) {
                this.radioButtonFramePosition = SVGFormImageParser.getPosition(atts);
                this.addSVGFormComponent(id, SVGButtonGroupCD.TYPEID, SVGFormImageParser.getPosition(atts), localName);
                this.myButtonGroup = this.myCurrentComponent;
                return;
            }
            if (FORM_COMPONENT_ID_BUTTON.matcher(id).find()) {
                this.addSVGFormComponent(id, SVGButtonCD.TYPEID, SVGFormImageParser.getPosition(atts), localName);
            } else if (FORM_COMPONENT_ID_CHECKBOX.matcher(id).find()) {
                this.addSVGFormComponent(id, SVGCheckBoxCD.TYPEID, SVGFormImageParser.getPosition(atts), localName);
            } else if (FORM_COMPONENT_ID_COMBOBOX.matcher(id).find()) {
                this.addSVGFormComponent(id, SVGComboBoxCD.TYPEID, SVGFormImageParser.getPosition(atts), localName);
            } else if (FORM_COMPONENT_ID_LABEL.matcher(id).find()) {
                this.addSVGFormComponent(id, SVGLabelCD.TYPEID, SVGFormImageParser.getPosition(atts), localName);
            } else if (FORM_COMPONENT_ID_LIST.matcher(id).find()) {
                this.addSVGFormComponent(id, SVGListCD.TYPEID, SVGFormImageParser.getPosition(atts), localName);
            } else if (FORM_COMPONENT_ID_RADIO.matcher(id).find()) {
                this.addSVGFormComponent(id, SVGRadioButtonCD.TYPEID, SVGFormImageParser.getPositionForRadioButton(atts, this.radioButtonFramePosition), localName);
            } else if (FORM_COMPONENT_ID_SLIDER.matcher(id).find()) {
                this.addSVGFormComponent(id, SVGSliderCD.TYPEID, SVGFormImageParser.getPosition(atts), localName);
            } else if (FORM_COMPONENT_ID_SPINNER.matcher(id).find()) {
                this.addSVGFormComponent(id, SVGSpinnerCD.TYPEID, SVGFormImageParser.getPosition(atts), localName);
            } else if (FORM_COMPONENT_ID_TEXTFIELD.matcher(id).find()) {
                this.addSVGFormComponent(id, SVGTextFieldCD.TYPEID, SVGFormImageParser.getPosition(atts), localName);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.myPropName == null) {
                return;
            }
            if (this.myText == null) {
                this.myText = new StringBuilder();
            }
            this.myText.append(ch, start, length);
        }

        private void addSVGFormComponent(String id, TypeID type, Float position, String localName) {
            int index = this.getIndex(position);
            this.myCurrentComponent = SVGFormComponent.createComponent(id, type, SVGComponentCD.getEventType(type), position);
            if (!type.equals((Object)SVGRadioButtonCD.TYPEID)) {
                this.myButtonGroup = null;
            } else if (this.myButtonGroup != null) {
                this.myCurrentComponent.setProperty("buttonGroup", this.myButtonGroup);
            }
            if (index == -1) {
                this.foundElements.add(this.myCurrentComponent);
            } else {
                this.foundElements.add(index, this.myCurrentComponent);
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (this.myPropName == null) {
                return;
            }
            this.myCurrentComponent.setProperty(this.myPropName, this.myText.toString().trim());
            this.myText = null;
            this.myPropName = null;
        }

        private int getIndex(Float position) {
            int index = -1;
            if (position != null) {
                Float highestPosition = new Float(-1.0f);
                for (SVGFormComponent c : this.foundElements) {
                    if (!(position.floatValue() > c.getPositon().floatValue()) || !(highestPosition.floatValue() < c.getPositon().floatValue())) continue;
                    highestPosition = c.getPositon();
                    index = this.foundElements.indexOf(c);
                }
            }
            return index;
        }
    }

    public static abstract class SVGFormComponent {
        private String id;
        private TypeID type;
        private Float position;
        private Map<String, Object> myProperties;

        public static SVGFormComponent createComponent(SVGFormComponent component, Float position) {
            component.setPosition(position);
            return component;
        }

        public static SVGFormComponent createComponent(String id, TypeID type, TypeID eventTypeId, Float position) {
            return new SVGFormComponentImpl(id, type, position, eventTypeId);
        }

        SVGFormComponent(String id, TypeID type, Float position) {
            if (type == null || id == null || position == null) {
                throw new IllegalArgumentException(" id or type argument is null");
            }
            this.type = type;
            this.id = id;
            this.position = position;
        }

        public abstract DesignComponent createComponent(DesignComponent var1);

        String getId() {
            return this.id;
        }

        TypeID getTypeID() {
            return this.type;
        }

        Float getPositon() {
            return this.position;
        }

        void setPosition(Float pos) {
            this.position = pos;
        }

        void setProperty(String name, Object value) {
            if (this.myProperties == null) {
                this.myProperties = new HashMap<String, Object>();
            }
            this.myProperties.put(name, value);
        }

        void setProperties(Map<String, Object> props) {
            this.myProperties = props;
        }

        Map<String, Object> getProperties() {
            return this.myProperties;
        }

        private static class SVGFormComponentImpl
        extends SVGFormComponent {
            private TypeID myEventType;

            SVGFormComponentImpl(String id, TypeID type, Float position, TypeID eventTypeId) {
                super(id, type, position);
                this.myEventType = eventTypeId;
            }

            SVGFormComponentImpl(SVGFormComponent component, Float position) {
                super(component.id, component.type, position);
                this.setProperties(component.getProperties());
            }

            @Override
            public DesignComponent createComponent(DesignComponent parentComponent) {
                DesignComponent dc = parentComponent.getDocument().createComponent(this.getTypeID());
                if (this.myEventType != null) {
                    DesignComponent svgES = parentComponent.getDocument().createComponent(this.myEventType);
                    svgES.writeProperty("svgButton", PropertyValue.createComponentReference((DesignComponent)dc));
                    parentComponent.addComponent(svgES);
                }
                dc.writeProperty("id", MidpTypes.createStringValue((String)this.getId()));
                Map<String, Object> properties = this.getProperties();
                if (properties != null) {
                    for (Map.Entry<String, Object> entry : properties.entrySet()) {
                        if (entry.getKey().equals("buttonGroup")) continue;
                        dc.writeProperty(entry.getKey(), MidpTypes.createStringValue((String)entry.getValue().toString()));
                    }
                }
                return dc;
            }
        }
    }
}

