/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midpnb.propertyeditors;

import java.awt.Component;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.midp.components.MidpDocumentSupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.categories.DisplayablesCategoryCD;
import org.netbeans.modules.vmd.midp.propertyeditors.api.resource.element.PropertyEditorResourceElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.resource.element.PropertyEditorResourceElementEvent;
import org.netbeans.modules.vmd.midp.propertyeditors.api.resource.element.PropertyEditorResourceElementListener;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorMessageAwareness;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorUserCode;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGFormCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGFormSupport;
import org.netbeans.modules.vmd.midpnb.propertyeditors.SVGImageEditorElement;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class PropertyEditorSVGImage
extends PropertyEditorUserCode
implements PropertyEditorElement,
PropertyEditorResourceElementListener {
    private JRadioButton radioButton;
    private SVGImageEditorElement element;
    private String resourcePath = "";

    private PropertyEditorSVGImage() {
        super(NbBundle.getMessage(PropertyEditorSVGImage.class, (String)"LBL_SVGIMAGE_UCLABEL"));
    }

    public static PropertyEditorSVGImage createInstance() {
        return new PropertyEditorSVGImage();
    }

    public void cleanUp(DesignComponent component) {
        super.cleanUp(component);
        if (this.element != null) {
            this.element.clean(component);
            this.element = null;
        }
        this.radioButton = null;
    }

    private void initComponents() {
        this.radioButton = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.radioButton, (String)NbBundle.getMessage(PropertyEditorSVGImage.class, (String)"LBL_SVGIMAGE_STR"));
        this.radioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PropertyEditorSVGImage.class, (String)"ACSN_SVGIMAGE_STR"));
        this.radioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PropertyEditorSVGImage.class, (String)"ACSD_SVGIMAGE_STR"));
        this.element = new SVGImageEditorElement();
        this.element.addPropertyEditorResourceElementListener(this);
        this.element.setPropertyEditorMessageAwareness((PropertyEditorMessageAwareness)this);
    }

    public void customEditorOKButtonPressed() {
        super.customEditorOKButtonPressed();
        if (this.radioButton.isSelected()) {
            this.saveValue(this.resourcePath);
        }
    }

    public void updateState(PropertyValue value) {
        if (value == null) {
            this.element.setDesignComponentWrapper(null);
        } else if (this.component != null && this.component.get() != null) {
            this.element.setDesignComponentWrapper(new PropertyEditorResourceElement.DesignComponentWrapper((DesignComponent)this.component.get()));
        }
        this.element.setAllEnabled(true);
    }

    public void setTextForPropertyValue(String text) {
        this.saveValue(text);
    }

    public String getAsText() {
        String superText = super.getAsText();
        if (superText != null) {
            return superText;
        }
        PropertyValue value = (PropertyValue)super.getValue();
        return MidpTypes.getString((PropertyValue)value);
    }

    public String getTextForPropertyValue() {
        return null;
    }

    public JComponent getCustomEditorComponent() {
        return this.element;
    }

    public Component getCustomEditor() {
        if (this.element == null) {
            this.initComponents();
            this.initElements(Collections.singleton(this));
        }
        return super.getCustomEditor();
    }

    public JRadioButton getRadioButton() {
        return this.radioButton;
    }

    public boolean isInitiallySelected() {
        return true;
    }

    public boolean isVerticallyResizable() {
        return true;
    }

    public void elementChanged(PropertyEditorResourceElementEvent event) {
        PropertyValue propertyValue = event.getPropertyValue();
        this.resourcePath = MidpTypes.getString((PropertyValue)propertyValue);
        if (this.resourcePath == null) {
            this.resourcePath = "";
        }
        this.radioButton.setSelected(true);
    }

    private void saveValue(final String text) {
        if (this.component == null || this.component.get() == null) {
            return;
        }
        final DesignComponent component_ = (DesignComponent)this.component.get();
        final PropertyValue[] oldValue = new PropertyValue[1];
        component_.getDocument().getTransactionManager().readAccess(new Runnable(){

            @Override
            public void run() {
                oldValue[0] = component_.readProperty("resourcePath");
            }
        });
        component_.getDocument().getTransactionManager().writeAccess(new Runnable(){

            @Override
            public void run() {
                DesignComponent category = MidpDocumentSupport.getCategoryComponent((DesignDocument)component_.getDocument(), (TypeID)DisplayablesCategoryCD.TYPEID);
                HashSet<DesignComponent> svgForms = new HashSet<DesignComponent>();
                for (DesignComponent child : category.getComponents()) {
                    if (!component_.getDocument().getDescriptorRegistry().isInHierarchy(SVGFormCD.TYPEID, child.getType()) || child.readProperty("svgImage").getComponent() != component_) continue;
                    svgForms.add(child);
                }
                if (!svgForms.isEmpty() && oldValue[0].getKind() == PropertyValue.Kind.VALUE) {
                    if (oldValue[0].getPrimitiveValue().equals(text)) {
                        return;
                    }
                    for (DesignComponent svgForm : svgForms) {
                        SVGFormSupport.removeAllSVGFormComponents(svgForm);
                        FileObject svgImageFile = SVGFormSupport.getSVGFile(component_.getDocument(), text);
                        if (svgImageFile == null) continue;
                        SVGFormSupport.parseSVGImageItems(svgImageFile, svgForm);
                    }
                    PropertyEditorSVGImage.super.setValue(MidpTypes.createStringValue((String)text));
                } else {
                    PropertyEditorSVGImage.super.setValue(MidpTypes.createStringValue((String)text));
                }
            }
        });
    }
}

