/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midpnb.propertyeditors;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGListElementEventSourceCD;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class SVGListPropertyCustomEditor
extends JPanel {
    private static final String NEW_LINE = "\n";
    private static final String CARET_RET = "\r";
    private JLabel myLabel;
    private JScrollPane myScrollPane;
    private JTextArea myTextArea;

    public SVGListPropertyCustomEditor() {
        this.initComponents();
    }

    private void initComponents() {
        this.myLabel = new JLabel();
        this.myScrollPane = new JScrollPane();
        this.myTextArea = new JTextArea();
        this.myLabel.setLabelFor(this.myTextArea);
        Mnemonics.setLocalizedText((JLabel)this.myLabel, (String)NbBundle.getMessage(SVGListPropertyCustomEditor.class, (String)"LBL_DefaultListDescription"));
        this.myTextArea.setColumns(20);
        this.myTextArea.setRows(5);
        this.myScrollPane.setViewportView(this.myTextArea);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.myLabel, -1, 394, Short.MAX_VALUE).add(2, (Component)this.myScrollPane, -1, 394, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.myLabel, -2, 28, -2).addPreferredGap(0).add((Component)this.myScrollPane, -1, 180, Short.MAX_VALUE).addContainerGap()));
    }

    void cleanUp() {
    }

    void removeElemnts() {
        this.myTextArea.setText(null);
        this.myTextArea.removeAll();
    }

    void setValue(PropertyValue value) {
        this.myTextArea.setText(null);
        this.myTextArea.removeAll();
        List list = value.getArray();
        if (list == null || !list.iterator().hasNext()) {
            return;
        }
        if (((PropertyValue)list.iterator().next()).getType() != SVGListElementEventSourceCD.TYPEID) {
            int i = 0;
            for (PropertyValue propertyValue : list) {
                String item = propertyValue.getPrimitiveValue().toString();
                this.myTextArea.append(item);
                if (++i == list.size()) continue;
                this.myTextArea.append(NEW_LINE);
            }
        } else {
            int i = 0;
            for (PropertyValue propertyValue : list) {
                String item = (String)propertyValue.getComponent().readProperty("name").getPrimitiveValue();
                this.myTextArea.append(item);
                if (++i == list.size()) continue;
                this.myTextArea.append(NEW_LINE);
            }
        }
    }

    List<String> getValue() {
        String text = this.myTextArea.getText();
        StringTokenizer tokenizer = new StringTokenizer(text, "\n\r");
        LinkedList<String> result = new LinkedList<String>();
        while (tokenizer.hasMoreTokens()) {
            result.add(tokenizer.nextToken());
        }
        return result;
    }
}

