/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midpnb.propertyeditors.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.propertyeditors.CleanUp;
import org.netbeans.modules.vmd.midp.propertyeditors.api.resource.element.PropertyEditorResourceElement;
import org.netbeans.modules.vmd.midpnb.components.resources.SimpleTableModelCD;
import org.netbeans.modules.vmd.midpnb.propertyeditors.table.CustomEditorTableModel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class TableModelEditorElement
extends PropertyEditorResourceElement
implements TableModelListener,
CleanUp {
    private boolean doNotFireEvent;
    private long componentID;
    private CustomEditorTableModel tableModel = new CustomEditorTableModel();
    private TableCellRenderer renderer;
    private JButton addColButton;
    private JButton addRowButton;
    private JLabel columnsLabel;
    private JTextField columnsTextField;
    private JCheckBox headerCheckBox;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTextField jTextField1;
    private JButton removeColButton;
    private JButton removeRowButton;
    private JLabel rowsLabel;
    private JTextField rowsTextField;
    private JTable table;
    private JLabel tableLabel;

    public TableModelEditorElement() {
        this.tableModel.addTableModelListener(this);
        this.initComponents();
        this.renderer = new HeaderCellRenderer();
        this.setTableCellRenderer();
    }

    public void clean(DesignComponent component) {
        this.tableModel = null;
        this.renderer = null;
        this.addColButton = null;
        this.addRowButton = null;
        this.columnsLabel = null;
        this.columnsTextField = null;
        this.headerCheckBox = null;
        this.jPanel1 = null;
        this.jScrollPane1 = null;
        this.jTextField1 = null;
        this.removeColButton = null;
        this.removeRowButton = null;
        this.rowsLabel = null;
        this.rowsTextField = null;
        this.table = null;
        this.tableLabel = null;
        this.removeAll();
    }

    public JComponent getJComponent() {
        return this;
    }

    public TypeID getTypeID() {
        return SimpleTableModelCD.TYPEID;
    }

    public List<String> getPropertyValueNames() {
        return Arrays.asList("columnNames", "values");
    }

    public String getResourceNameSuggestion() {
        return "tableModel";
    }

    public void setDesignComponentWrapper(PropertyEditorResourceElement.DesignComponentWrapper wrapper) {
        if (wrapper == null) {
            this.setTableValues(null, null);
            this.setAllEnabled(false);
            return;
        }
        this.componentID = wrapper.getComponentID();
        final PropertyValue[] columns = new PropertyValue[1];
        final PropertyValue[] values = new PropertyValue[1];
        final DesignComponent component = wrapper.getComponent();
        if (component != null) {
            if (!component.getType().equals((Object)this.getTypeID())) {
                throw new IllegalArgumentException("Passed component must have typeID " + this.getTypeID() + " instead passed " + component.getType());
            }
            this.componentID = component.getComponentID();
            component.getDocument().getTransactionManager().readAccess(new Runnable(){

                @Override
                public void run() {
                    PropertyValue propertyValue2;
                    PropertyValue propertyValue = component.readProperty("columnNames");
                    if (!PropertyEditorResourceElement.isPropertyValueAUserCodeType((PropertyValue)propertyValue)) {
                        columns[0] = propertyValue;
                    }
                    if (!PropertyEditorResourceElement.isPropertyValueAUserCodeType((PropertyValue)(propertyValue2 = component.readProperty("values")))) {
                        values[0] = propertyValue2;
                    }
                }
            });
        }
        if (wrapper.hasChanges()) {
            Map changes = wrapper.getChanges();
            for (String propertyName : changes.keySet()) {
                PropertyValue propertyValue = (PropertyValue)changes.get(propertyName);
                if ("values".equals(propertyName)) {
                    values[0] = propertyValue;
                    continue;
                }
                if (!"columnNames".equals(propertyName)) continue;
                columns[0] = propertyValue;
            }
        }
        this.setAllEnabled(true);
        this.setTableValues(columns[0], values[0]);
        this.checkButtons();
    }

    @Override
    public synchronized void tableChanged(TableModelEvent e) {
        this.setTableCellRenderer();
        if (!this.doNotFireEvent) {
            PropertyValue headers;
            Vector<Vector> dataVector = this.tableModel.getDataVector();
            boolean useHeader = this.tableModel.hasHeader();
            this.setTextFields(dataVector.size(), this.tableModel.getColumnCount());
            this.checkButtons();
            ArrayList<PropertyValue> propertyValueColumn = new ArrayList<PropertyValue>(dataVector.size());
            for (int i = 0; i < dataVector.size(); ++i) {
                Vector row = dataVector.elementAt(i);
                ArrayList<PropertyValue> propertyValueRow = new ArrayList<PropertyValue>(row.size());
                for (int j = 0; j < row.size(); ++j) {
                    String str = (String)row.elementAt(j);
                    propertyValueRow.add(MidpTypes.createStringValue((String)(str != null ? str : "")));
                }
                propertyValueColumn.add(PropertyValue.createArray((TypeID)MidpTypes.TYPEID_JAVA_LANG_STRING, propertyValueRow));
            }
            PropertyValue values = PropertyValue.createArray((TypeID)MidpTypes.TYPEID_JAVA_LANG_STRING.getArrayType(), propertyValueColumn);
            this.fireElementChanged(this.componentID, "values", values);
            if (useHeader) {
                Vector<String> header = this.tableModel.getHeader();
                ArrayList<PropertyValue> propertyValueHeader = new ArrayList<PropertyValue>(header.size());
                for (int j = 0; j < header.size(); ++j) {
                    String str = header.elementAt(j);
                    propertyValueHeader.add(MidpTypes.createStringValue((String)(str != null ? str : "")));
                }
                headers = PropertyValue.createArray((TypeID)MidpTypes.TYPEID_JAVA_LANG_STRING, propertyValueHeader);
            } else {
                headers = PropertyValue.createNull();
            }
            this.fireElementChanged(this.componentID, "columnNames", headers);
        }
    }

    private void setTableCellRenderer() {
        TableColumnModel columnModel = this.table.getColumnModel();
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            columnModel.getColumn(i).setCellRenderer(this.renderer);
        }
    }

    private synchronized void setTableValues(PropertyValue columns, PropertyValue values) {
        this.doNotFireEvent = true;
        boolean useHeader = columns != null && columns.getArray() != null;
        Object[] header = null;
        Object[][] arrays = null;
        if (useHeader) {
            List list = columns.getArray();
            header = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                header[i] = MidpTypes.getString((PropertyValue)((PropertyValue)list.get(i)));
            }
        }
        if (values == null) {
            this.tableModel.clear();
            this.setTextFields(0, 0);
        } else {
            List rows = values.getArray();
            if (rows != null && rows.size() > 0) {
                List cols = ((PropertyValue)rows.get(0)).getArray();
                int rowCount = rows.size();
                int columnCount = cols.size();
                arrays = new String[rowCount][columnCount];
                for (int x = 0; x < rowCount; ++x) {
                    cols = ((PropertyValue)rows.get(x)).getArray();
                    for (int y = 0; y < columnCount; ++y) {
                        arrays[x][y] = MidpTypes.getString((PropertyValue)((PropertyValue)cols.get(y)));
                    }
                }
                this.setTextFields(rowCount, columnCount);
            } else {
                this.setTextFields(0, 0);
            }
        }
        this.tableModel.setUseHeader(useHeader);
        this.headerCheckBox.setSelected(useHeader);
        this.tableModel.setDataVector(arrays, header);
        this.doNotFireEvent = false;
    }

    private void checkButtons() {
        this.removeRowButton.setEnabled(this.tableModel.getDataVector().size() > 0);
        this.removeColButton.setEnabled(this.tableModel.getColumnCount() > 0);
        this.addColButton.setEnabled(this.tableModel.hasHeader() || this.tableModel.getRowCount() > 0);
    }

    void setAllEnabled(boolean isEnabled) {
        this.addColButton.setEnabled(isEnabled);
        this.addRowButton.setEnabled(isEnabled);
        this.removeColButton.setEnabled(isEnabled);
        this.removeRowButton.setEnabled(isEnabled);
        this.tableLabel.setEnabled(isEnabled);
        this.table.setEnabled(isEnabled);
        this.headerCheckBox.setEnabled(isEnabled);
        this.rowsLabel.setEnabled(isEnabled);
        this.columnsLabel.setEnabled(isEnabled);
        this.rowsTextField.setEnabled(isEnabled);
        this.columnsTextField.setEnabled(isEnabled);
    }

    private void setTextFields(int row, int col) {
        this.rowsTextField.setText(row > -1 ? String.valueOf(row) : "-");
        this.columnsTextField.setText(col > -1 ? String.valueOf(col) : "-");
    }

    private void initComponents() {
        this.jTextField1 = new JTextField();
        this.tableLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.addColButton = new JButton();
        this.removeColButton = new JButton();
        this.removeRowButton = new JButton();
        this.addRowButton = new JButton();
        this.headerCheckBox = new JCheckBox();
        this.rowsLabel = new JLabel();
        this.rowsTextField = new JTextField();
        this.columnsLabel = new JLabel();
        this.columnsTextField = new JTextField();
        this.jTextField1.setText(NbBundle.getMessage(TableModelEditorElement.class, (String)"TableModelEditorElement.jTextField1.text"));
        this.tableLabel.setLabelFor(this.table);
        Mnemonics.setLocalizedText((JLabel)this.tableLabel, (String)NbBundle.getMessage(TableModelEditorElement.class, (String)"TableModelEditorElement.tableLabel.text"));
        this.tableLabel.setEnabled(false);
        this.table.setModel(this.tableModel);
        this.table.setEnabled(false);
        this.table.setGridColor(new Color(0, 0, 0));
        this.table.setTableHeader(null);
        this.jScrollPane1.setViewportView(this.table);
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jScrollPane1, -1, 409, Short.MAX_VALUE).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 242, Short.MAX_VALUE));
        Mnemonics.setLocalizedText((AbstractButton)this.addColButton, (String)NbBundle.getMessage(TableModelEditorElement.class, (String)"TableModelEditorElement.addColButton.text"));
        this.addColButton.setEnabled(false);
        this.addColButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableModelEditorElement.this.addColButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.removeColButton, (String)NbBundle.getMessage(TableModelEditorElement.class, (String)"TableModelEditorElement.removeColButton.text"));
        this.removeColButton.setEnabled(false);
        this.removeColButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableModelEditorElement.this.removeColButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.removeRowButton, (String)NbBundle.getMessage(TableModelEditorElement.class, (String)"TableModelEditorElement.removeRowButton.text"));
        this.removeRowButton.setEnabled(false);
        this.removeRowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableModelEditorElement.this.removeRowButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.addRowButton, (String)NbBundle.getMessage(TableModelEditorElement.class, (String)"TableModelEditorElement.addRowButton.text"));
        this.addRowButton.setEnabled(false);
        this.addRowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableModelEditorElement.this.addRowButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.headerCheckBox, (String)NbBundle.getMessage(TableModelEditorElement.class, (String)"TableModelEditorElement.headerCheckBox.text"));
        this.headerCheckBox.setEnabled(false);
        this.headerCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.headerCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableModelEditorElement.this.headerCheckBoxActionPerformed(evt);
            }
        });
        this.rowsLabel.setLabelFor(this.rowsTextField);
        this.rowsLabel.setText(NbBundle.getMessage(TableModelEditorElement.class, (String)"TableModelEditorElement.rowsLabel.text"));
        this.rowsLabel.setEnabled(false);
        this.rowsTextField.setEditable(false);
        this.rowsTextField.setEnabled(false);
        this.columnsLabel.setLabelFor(this.columnsTextField);
        this.columnsLabel.setText(NbBundle.getMessage(TableModelEditorElement.class, (String)"TableModelEditorElement.columnsLabel.text"));
        this.columnsLabel.setEnabled(false);
        this.columnsTextField.setEditable(false);
        this.columnsTextField.setEnabled(false);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.tableLabel).addPreferredGap(0, 349, Short.MAX_VALUE))).add(0, 0, 0).add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (Component)this.headerCheckBox).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.columnsLabel).addPreferredGap(0).add((Component)this.columnsTextField, -1, 71, Short.MAX_VALUE)).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.rowsLabel).add(18, 18, 18).add((Component)this.rowsTextField, -1, 71, Short.MAX_VALUE)).add((Component)this.removeColButton, -2, 119, Short.MAX_VALUE).add((Component)this.removeRowButton, -2, 119, Short.MAX_VALUE).add((Component)this.addRowButton, -1, 119, Short.MAX_VALUE).add((Component)this.addColButton, -2, 119, Short.MAX_VALUE))));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.tableLabel).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.headerCheckBox, -2, 15, -2).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.rowsLabel).add((Component)this.rowsTextField, -2, -1, -2)).add(6, 6, 6).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.columnsLabel).add((Component)this.columnsTextField, -2, -1, -2)).addPreferredGap(1).add((Component)this.addRowButton).addPreferredGap(0).add((Component)this.removeRowButton).addPreferredGap(0).add((Component)this.addColButton).addPreferredGap(0).add((Component)this.removeColButton).addContainerGap()).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE))));
        this.tableLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TableModelEditorElement.class, (String)"TableModelEditorElement.tableLabel.accessible.name"));
        this.tableLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TableModelEditorElement.class, (String)"TableModelEditorElement.tableLabel.accessible.description"));
        this.addColButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TableModelEditorElement.class, (String)"TableModelEditorElement.addColButton.accessible.name"));
        this.addColButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TableModelEditorElement.class, (String)"TableModelEditorElement.addColButton.accessible.description"));
        this.removeColButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TableModelEditorElement.class, (String)"TableModelEditorElement.removeColButton.accessible.name"));
        this.removeColButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TableModelEditorElement.class, (String)"TableModelEditorElement.removeColButton.accessible.descriptions"));
        this.removeRowButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TableModelEditorElement.class, (String)"TableModelEditorElement.removeRowButton.accessible.name"));
        this.removeRowButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TableModelEditorElement.class, (String)"TableModelEditorElement.removeRowButton.accessible.description"));
        this.addRowButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TableModelEditorElement.class, (String)"TableModelEditorElement.addRowButton.accessible.name"));
        this.addRowButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TableModelEditorElement.class, (String)"TableModelEditorElement.addRowButton.accessible.description"));
        this.headerCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TableModelEditorElement.class, (String)"TableModelEditorElement.headerCheckBox.accessible.name"));
        this.headerCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TableModelEditorElement.class, (String)"TableModelEditorElement.headerCheckBox.accessible.description"));
        this.rowsLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TableModelEditorElement.class, (String)"TableModelEditorElement.rowsLabel.accessible.name"));
        this.rowsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TableModelEditorElement.class, (String)"TableModelEditorElement.rowsLabel.accessible.description"));
        this.columnsLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TableModelEditorElement.class, (String)"TableModelEditorElement.columnsLabel.accessible.name"));
        this.columnsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TableModelEditorElement.class, (String)"TableModelEditorElement.columnsLabel.accessible.description"));
    }

    private void addColButtonActionPerformed(ActionEvent evt) {
        this.tableModel.addColumn("", false);
    }

    private void removeColButtonActionPerformed(ActionEvent evt) {
        this.tableModel.removeLastColumn();
    }

    private void removeRowButtonActionPerformed(ActionEvent evt) {
        int rowCount = this.tableModel.getDataVector().size();
        if (rowCount > 0) {
            this.tableModel.removeRow(rowCount - 1);
        }
    }

    private void addRowButtonActionPerformed(ActionEvent evt) {
        int columnCount = this.tableModel.getColumnCount();
        if (columnCount == 0) {
            this.tableModel.addColumn("", true);
        } else {
            Object[] row = new String[columnCount];
            for (int i = 0; i < row.length; ++i) {
                row[i] = "";
            }
            this.tableModel.addRow(row);
        }
    }

    private void headerCheckBoxActionPerformed(ActionEvent evt) {
        this.tableModel.setUseHeader(this.headerCheckBox.isSelected());
    }

    private class HeaderCellRenderer
    extends DefaultTableCellRenderer {
        private HeaderCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component renderer = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (TableModelEditorElement.this.tableModel.hasHeader() && row == 0) {
                renderer.setBackground(Color.LIGHT_GRAY);
            } else {
                renderer.setBackground(Color.WHITE);
            }
            renderer.setForeground(Color.BLACK);
            return renderer;
        }
    }
}

