/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midpnb.screen.display;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.microedition.m2g.SVGImage;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.mobility.svgcore.util.Util;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.screen.display.ScreenDeviceInfo;
import org.netbeans.modules.vmd.api.screen.display.ScreenDisplayPresenter;
import org.netbeans.modules.vmd.api.screen.display.ScreenPropertyDescriptor;
import org.netbeans.modules.vmd.api.screen.display.ScreenPropertyEditor;
import org.netbeans.modules.vmd.midp.components.MidpProjectSupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.screen.display.DisplayableDisplayPresenter;
import org.netbeans.modules.vmd.midp.screen.display.ScreenFileObjectListener;
import org.netbeans.modules.vmd.midp.screen.display.property.ResourcePropertyEditor;
import org.netbeans.modules.vmd.midpnb.screen.display.SVGImageComponent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class SVGPlayerDisplayPresenter
extends DisplayableDisplayPresenter {
    private JLabel stringLabel;
    private SVGImageComponent imageView = new SVGImageComponent();
    private ScreenFileObjectListener imageFileListener;
    private FileObject svgFileObject;
    private boolean useFileListener;

    public SVGPlayerDisplayPresenter() {
        JPanel contentPanel = this.getPanel().getContentPanel();
        contentPanel.setLayout(new BorderLayout());
        this.stringLabel = new JLabel();
        this.stringLabel.setHorizontalAlignment(0);
    }

    public SVGPlayerDisplayPresenter(boolean useFilelistener) {
        this();
        this.useFileListener = useFilelistener;
    }

    public void reload(ScreenDeviceInfo deviceInfo) {
        super.reload(deviceInfo);
        JPanel contentPanel = this.getPanel().getContentPanel();
        contentPanel.removeAll();
        DesignComponent animatorComponent = this.getComponent();
        PropertyValue value = animatorComponent.readProperty("svgImage");
        if (!PropertyValue.Kind.USERCODE.equals((Object)value.getKind())) {
            PropertyValue propertyValue;
            DesignComponent svgImageComponent = value.getComponent();
            SVGImage svgImage = null;
            boolean notSVGTiny = false;
            if (svgImageComponent != null && (propertyValue = svgImageComponent.readProperty("resourcePath")).getKind() == PropertyValue.Kind.VALUE) {
                Map images = MidpProjectSupport.getFileObjectsForRelativeResourcePath((DesignDocument)animatorComponent.getDocument(), (String)MidpTypes.getString((PropertyValue)propertyValue));
                Iterator iterator = images.keySet().iterator();
                FileObject fileObject = this.svgFileObject = iterator.hasNext() ? (FileObject)iterator.next() : null;
                if (this.svgFileObject != null) {
                    try {
                        svgImage = Util.createSVGImage((FileObject)this.svgFileObject, (boolean)true);
                        if (this.svgFileObject != null && this.useFileListener) {
                            this.svgFileObject.removeFileChangeListener((FileChangeListener)this.imageFileListener);
                            this.imageFileListener = new ScreenFileObjectListener(this.getRelatedComponent(), svgImageComponent, "resourcePath");
                            this.svgFileObject.addFileChangeListener((FileChangeListener)this.imageFileListener);
                        }
                    }
                    catch (IOException e) {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, null, e);
                        notSVGTiny = true;
                    }
                }
            }
            this.imageView.setImage(svgImage);
            if (svgImage != null) {
                contentPanel.add((Component)this.imageView, "Center");
            } else if (notSVGTiny) {
                this.stringLabel.setText(NbBundle.getMessage(SVGPlayerDisplayPresenter.class, (String)"DISP_svg_image_not_svg_tiny"));
                contentPanel.add((Component)this.stringLabel, "Center");
            } else {
                this.stringLabel.setText(NbBundle.getMessage(SVGPlayerDisplayPresenter.class, (String)"DISP_svg_image_not_specified"));
                contentPanel.add((Component)this.stringLabel, "Center");
            }
        } else {
            this.stringLabel.setText(NbBundle.getMessage(SVGPlayerDisplayPresenter.class, (String)"DISP_svg_image_is_usercode"));
            contentPanel.add((Component)this.stringLabel, "Center");
        }
        for (DesignComponent item : this.getChildren()) {
            ScreenDisplayPresenter presenter = (ScreenDisplayPresenter)item.getPresenter(ScreenDisplayPresenter.class);
            if (presenter == null) continue;
            presenter.reload(deviceInfo);
            contentPanel.add((Component)presenter.getView(), "Last");
        }
    }

    public Collection<ScreenPropertyDescriptor> getPropertyDescriptors() {
        ArrayList<ScreenPropertyDescriptor> descriptors = new ArrayList<ScreenPropertyDescriptor>(super.getPropertyDescriptors());
        ResourcePropertyEditor imagePropertyEditor = new ResourcePropertyEditor("svgImage", this.getComponent());
        if (this.stringLabel.getParent() != null) {
            descriptors.add(new ScreenPropertyDescriptor(this.getComponent(), (JComponent)this.stringLabel, (ScreenPropertyEditor)imagePropertyEditor));
        } else {
            descriptors.add(new ScreenPropertyDescriptor(this.getComponent(), (JComponent)this.imageView, (ScreenPropertyEditor)imagePropertyEditor));
        }
        return descriptors;
    }

    public Collection<DesignComponent> getChildren() {
        return this.getComponent().getComponents();
    }

    protected void notifyDetached(DesignComponent component) {
        if (this.svgFileObject != null && this.imageFileListener != null) {
            this.svgFileObject.removeFileChangeListener((FileChangeListener)this.imageFileListener);
        }
        this.svgFileObject = null;
        this.imageFileListener = null;
    }

    protected float getScaleX() {
        return this.imageView.getScaleX();
    }

    protected float getScaleY() {
        return this.imageView.getScaleY();
    }

    protected int getCorrectionX() {
        return this.imageView.getCorrectionX();
    }

    protected int getCorrectionY() {
        return this.imageView.getCorrectionY();
    }

    protected SVGImage getSVGImage() {
        return this.imageView.getImage();
    }
}

