/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.ide;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.deployment.plugins.api.UISupport;
import org.netbeans.modules.j2ee.deployment.profiler.api.ProfilerServerSettings;
import org.netbeans.modules.j2ee.jboss4.JBDeploymentManager;
import org.netbeans.modules.j2ee.jboss4.ide.JBDeploymentStatus;
import org.netbeans.modules.j2ee.jboss4.ide.JBLogWriter;
import org.netbeans.modules.j2ee.jboss4.ide.JBStartServer;
import org.netbeans.modules.j2ee.jboss4.ide.ui.JBPluginUtils;
import org.netbeans.modules.j2ee.jboss4.util.JBProperties;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.InputOutput;

class JBStartRunnable
implements Runnable {
    private static final String CONF_FILE_NAME = "run.conf.bat";
    private static final String RUN_FILE_NAME = "run.bat";
    private static final String JBOSS_HOME = "JBOSS_HOME";
    private static final String STARTUP_SH = File.separator + "bin" + File.separator + "run.sh";
    private static final String STARTUP_BAT = File.separator + "bin" + File.separator + "run.bat";
    private static final String CONF_BAT = File.separator + "bin" + File.separator + "run.conf.bat";
    private static final String JAVA_OPTS = "JAVA_OPTS";
    private static final Pattern IF_JAVA_OPTS_PATTERN = Pattern.compile(".*if(\\s+not)?\\s+(\"x%JAVA_OPTS%\"\\s+==\\s+\"x\")\\s+.*", 32);
    private static final String NEW_IF_CONDITION_STRING = "\"xx\" == \"x\"";
    private static final SpecificationVersion JDK_14 = new SpecificationVersion("1.4");
    private JBDeploymentManager dm;
    private String instanceName;
    private JBStartServer startServer;
    private ProfilerServerSettings profilerSettings;

    JBStartRunnable(ProfilerServerSettings profilerSettings, JBDeploymentManager dm, JBStartServer startServer) {
        this.dm = dm;
        this.instanceName = dm.getInstanceProperties().getProperty("displayName");
        this.startServer = startServer;
        this.profilerSettings = profilerSettings;
    }

    @Override
    public void run() {
        InstanceProperties ip = this.dm.getInstanceProperties();
        boolean free = this.checkPorts(ip);
        if (!free) {
            return;
        }
        Process serverProcess = this.createProcess(ip);
        if (serverProcess == null) {
            return;
        }
        JBLogWriter logWriter = this.createLogWriter();
        this.waitForServerToStart(logWriter, serverProcess);
    }

    private String[] createEnvironment(InstanceProperties ip) {
        JavaPlatform platform;
        JBProperties properties = this.dm.getProperties();
        String javaOpts = properties.getJavaOpts();
        StringBuilder javaOptsBuilder = new StringBuilder(javaOpts);
        boolean version5 = properties.isVersion(JBPluginUtils.JBOSS_5_0_0);
        if (!version5 && properties.getProxyEnabled()) {
            String[] PROXY_PROPS;
            for (String prop : PROXY_PROPS = new String[]{"http.proxyHost", "http.proxyPort", "http.nonProxyHosts", "https.proxyHost", "https.proxyPort"}) {
                String value;
                if (javaOpts.indexOf(prop) != -1 || (value = System.getProperty(prop)) == null) continue;
                if ("http.nonProxyHosts".equals(prop)) {
                    try {
                        BufferedReader br = new BufferedReader(new StringReader(value));
                        String line = null;
                        StringBuilder noNL = new StringBuilder();
                        while ((line = br.readLine()) != null) {
                            noNL.append(line);
                        }
                        value = noNL.toString();
                        value = "\"" + value + "\"";
                    }
                    catch (IOException ioe) {
                        Exceptions.attachLocalizedMessage((Throwable)ioe, (String)NbBundle.getMessage(JBStartRunnable.class, (String)"ERR_NonProxyHostParsingError"));
                        Logger.getLogger("global").log(Level.WARNING, null, ioe);
                        value = null;
                    }
                }
                if (value == null) continue;
                javaOptsBuilder.append(" -D").append(prop).append("=").append(value);
            }
        }
        JavaPlatform javaPlatform = platform = this.startServer.getMode() != JBStartServer.MODE.PROFILE ? properties.getJavaPlatform() : this.profilerSettings.getJavaPlatform();
        if (this.startServer.getMode() == JBStartServer.MODE.DEBUG && javaOptsBuilder.toString().indexOf("-Xdebug") == -1) {
            if (platform.getSpecification().getVersion().compareTo((Object)JDK_14) <= 0) {
                javaOptsBuilder.append(" -classic");
            }
            javaOptsBuilder.append(" -Xdebug -Xnoagent -Djava.compiler=NONE -Xrunjdwp:transport=dt_socket,address=").append(this.dm.getDebuggingPort()).append(",server=y,suspend=n");
        } else if (this.startServer.getMode() == JBStartServer.MODE.PROFILE) {
            String[] profJvmArgs = this.profilerSettings.getJvmArgs();
            for (int i = 0; i < profJvmArgs.length; ++i) {
                javaOptsBuilder.append(" ").append(profJvmArgs[i]);
            }
        }
        javaOpts = javaOptsBuilder.toString();
        String javaHome = JBStartRunnable.getJavaHome(platform);
        String[] envp = new String[]{"JAVA=" + javaHome + File.separator + "bin" + File.separator + "java", "JAVA_HOME=" + javaHome, "JBOSS_HOME=" + ip.getProperty("root-dir"), "JAVA_OPTS=" + javaOpts};
        return envp;
    }

    private boolean checkPorts(InstanceProperties ip) {
        try {
            String strRMIInvokerPort;
            int RMIInvokerPort;
            String serverName = ip.getProperty("displayName");
            String strHTTPConnectorPort = ip.getProperty("port");
            int httpConnectorPort = Integer.parseInt(strHTTPConnectorPort);
            if (httpConnectorPort <= 0) {
                return true;
            }
            if (!JBPluginUtils.isPortFree(httpConnectorPort)) {
                this.fireStartProgressEvent(StateType.FAILED, this.createProgressMessage("MSG_START_SERVER_FAILED_HTTP_PORT_IN_USE", strHTTPConnectorPort));
                return false;
            }
            String serverDir = ip.getProperty("server-dir");
            String strJNPServicePort = JBPluginUtils.getJnpPort(serverDir);
            int JNPServicePort = Integer.parseInt(strJNPServicePort);
            if (JNPServicePort >= 0 && !JBPluginUtils.isPortFree(JNPServicePort)) {
                this.fireStartProgressEvent(StateType.FAILED, this.createProgressMessage("MSG_START_SERVER_FAILED_JNP_PORT_IN_USE", strJNPServicePort));
                return false;
            }
            String strRMINamingServicePort = JBPluginUtils.getRMINamingServicePort(serverDir);
            int RMINamingServicePort = Integer.parseInt(strRMINamingServicePort);
            if (RMINamingServicePort >= 0 && !JBPluginUtils.isPortFree(RMINamingServicePort)) {
                this.fireStartProgressEvent(StateType.FAILED, this.createProgressMessage("MSG_START_SERVER_FAILED_RMI_PORT_IN_USE", strRMINamingServicePort));
                return false;
            }
            String server = ip.getProperty("server");
            if (!"minimal".equals(server) && (RMIInvokerPort = Integer.parseInt(strRMIInvokerPort = JBPluginUtils.getRMIInvokerPort(serverDir))) >= 0 && !JBPluginUtils.isPortFree(RMIInvokerPort)) {
                this.fireStartProgressEvent(StateType.FAILED, this.createProgressMessage("MSG_START_SERVER_FAILED_INVOKER_PORT_IN_USE", strRMIInvokerPort));
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return true;
    }

    private NbProcessDescriptor createProcessDescriptor(InstanceProperties ip, String[] envp) {
        String serverRunFileName = this.getRunFileName(ip, envp);
        if (!new File(serverRunFileName).exists()) {
            this.fireStartProgressEvent(StateType.FAILED, this.createProgressMessage("MSG_START_SERVER_FAILED_FNF"));
            return null;
        }
        String instanceName = ip.getProperty("server");
        String args = ("all".equals(instanceName) ? "-b 127.0.0.1 " : "") + "-c " + instanceName;
        return new NbProcessDescriptor(serverRunFileName, args);
    }

    private String getRunFileName(InstanceProperties ip, String[] envp) {
        SpacesInPathFix fix = new SpacesInPathFix(ip, envp);
        return fix.getRunFileName();
    }

    private static String getJavaHome(JavaPlatform platform) {
        FileObject fo = (FileObject)platform.getInstallFolders().iterator().next();
        return FileUtil.toFile((FileObject)fo).getAbsolutePath();
    }

    private String createProgressMessage(String resName) {
        return this.createProgressMessage(resName, null);
    }

    private String createProgressMessage(String resName, String param) {
        return NbBundle.getMessage(JBStartRunnable.class, (String)resName, (Object)this.instanceName, (Object)param);
    }

    private Process createProcess(InstanceProperties ip) {
        String[] envp;
        NbProcessDescriptor pd;
        JBLogWriter logWriter;
        if (this.startServer.getMode() == JBStartServer.MODE.PROFILE && (logWriter = JBLogWriter.getInstance(this.instanceName)) != null && logWriter.isRunning()) {
            logWriter.stop();
        }
        if ((pd = this.createProcessDescriptor(ip, envp = this.createEnvironment(ip))) == null) {
            return null;
        }
        try {
            return pd.exec(null, envp, true, null);
        }
        catch (IOException ioe) {
            Logger.getLogger("global").log(Level.INFO, null, ioe);
            String serverLocation = ip.getProperty("root-dir");
            String serverRunFileName = serverLocation + (Utilities.isWindows() ? STARTUP_BAT : STARTUP_SH);
            this.fireStartProgressEvent(StateType.FAILED, this.createProgressMessage("MSG_START_SERVER_FAILED_PD", serverRunFileName));
            return null;
        }
    }

    private InputOutput openConsole() {
        InputOutput io = UISupport.getServerIO((String)this.dm.getUrl());
        if (io == null) {
            return null;
        }
        try {
            io.getOut().reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        io.select();
        return io;
    }

    private void fireStartProgressEvent(StateType stateType, String msg) {
        this.startServer.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.START, stateType, msg));
    }

    private JBLogWriter createLogWriter() {
        InputOutput io = this.openConsole();
        return JBLogWriter.createInstance(io, this.instanceName);
    }

    private void waitForServerToStart(JBLogWriter logWriter, Process serverProcess) {
        this.fireStartProgressEvent(StateType.RUNNING, this.createProgressMessage("MSG_START_SERVER_IN_PROGRESS"));
        JBStartServer.ACTION_STATUS status = logWriter.start(serverProcess, this.startServer);
        this.dm.setNeedsRestart(false);
        if (status == JBStartServer.ACTION_STATUS.SUCCESS) {
            this.fireStartProgressEvent(StateType.COMPLETED, this.createProgressMessage("MSG_SERVER_STARTED"));
        } else if (status == JBStartServer.ACTION_STATUS.FAILURE) {
            this.fireStartProgressEvent(StateType.FAILED, this.createProgressMessage("MSG_START_SERVER_FAILED"));
        } else if (status == JBStartServer.ACTION_STATUS.UNKNOWN) {
            this.fireStartProgressEvent(StateType.FAILED, this.createProgressMessage("MSG_StartServerTimeout"));
        }
    }

    private class SpacesInPathFix {
        private InstanceProperties myProps;
        private boolean needChange;

        SpacesInPathFix(InstanceProperties ip, String[] envp) {
            this.myProps = ip;
            this.needChange = this.runFileNeedChange(envp);
        }

        String getRunFileName() {
            String serverLocation = this.getProperties().getProperty("root-dir");
            String serverRunFileName = serverLocation + (Utilities.isWindows() ? STARTUP_BAT : STARTUP_SH);
            if (this.needChange) {
                String contentRun = this.readFile(serverRunFileName);
                String contentConf = this.readFile(serverLocation + CONF_BAT);
                Matcher matcherRun = IF_JAVA_OPTS_PATTERN.matcher(contentRun);
                Matcher matcherConf = IF_JAVA_OPTS_PATTERN.matcher(contentConf);
                boolean needChangeRun = matcherRun.matches();
                boolean needChangeConf = matcherConf.matches();
                try {
                    if (needChangeRun || needChangeConf) {
                        File startBat = File.createTempFile(JBStartRunnable.RUN_FILE_NAME, ".bat");
                        File confBat = File.createTempFile(JBStartRunnable.CONF_FILE_NAME, ".bat", startBat.getParentFile());
                        startBat.deleteOnExit();
                        confBat.deleteOnExit();
                        boolean start = false;
                        contentRun = this.replaceJavaOpts(contentRun, matcherRun);
                        contentConf = this.replaceJavaOpts(contentConf, matcherConf);
                        contentRun = contentRun.replace(JBStartRunnable.CONF_FILE_NAME, confBat.getName());
                        this.writeFile(startBat, contentRun);
                        this.writeFile(confBat, contentConf);
                        return startBat.getAbsolutePath();
                    }
                }
                catch (IOException e) {
                    Exceptions.attachLocalizedMessage((Throwable)e, (String)NbBundle.getMessage(JBStartRunnable.class, (String)"ERR_WriteError"));
                    Logger.getLogger("global").log(Level.WARNING, null, e);
                }
            }
            return serverRunFileName;
        }

        private String replaceJavaOpts(String content, Matcher matcher) {
            String result = content;
            int start = 0;
            ArrayList<String> replacementString = new ArrayList<String>(1);
            while (matcher.find(start)) {
                if (matcher.groupCount() <= 1) continue;
                start = matcher.end(2);
                replacementString.add(matcher.group(2));
            }
            for (String replace : replacementString) {
                result = result.replace(replace, JBStartRunnable.NEW_IF_CONDITION_STRING);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeFile(File file, String content) {
            BufferedWriter writer = null;
            try {
                writer = new BufferedWriter(new FileWriter(file));
                writer.write(content);
            }
            catch (IOException e) {
                Exceptions.attachLocalizedMessage((Throwable)e, (String)NbBundle.getMessage(JBStartRunnable.class, (String)"ERR_WriteError"));
                Logger.getLogger("global").log(Level.WARNING, null, e);
            }
            finally {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException e) {
                    Logger.getLogger("global").log(Level.WARNING, null, e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String readFile(String file) {
            StringBuilder builder = null;
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(new File(file)));
                builder = new StringBuilder();
                String line = "";
                do {
                    builder.append(line);
                    builder.append("\r\n");
                } while ((line = reader.readLine()) != null);
            }
            catch (IOException e) {
                Exceptions.attachLocalizedMessage((Throwable)e, (String)NbBundle.getMessage(JBStartRunnable.class, (String)"ERR_ReadError"));
                Logger.getLogger("global").log(Level.WARNING, null, e);
                String string = null;
                return string;
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e) {
                    Logger.getLogger("global").log(Level.WARNING, null, e);
                }
            }
            return builder.toString();
        }

        private InstanceProperties getProperties() {
            return this.myProps;
        }

        private boolean runFileNeedChange(String[] envp) {
            JBProperties properties = JBStartRunnable.this.dm.getProperties();
            if (properties.isVersion(JBPluginUtils.JBOSS_5_0_1) && Utilities.isWindows()) {
                for (String env : envp) {
                    if (!env.startsWith("JAVA_OPTS=")) continue;
                    return env.indexOf(34) >= 0;
                }
            }
            return false;
        }
    }
}

