/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.ide;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.jboss4.JBDeploymentManager;
import org.netbeans.modules.j2ee.jboss4.ide.JBDeploymentStatus;
import org.netbeans.modules.j2ee.jboss4.ide.JBLogWriter;
import org.netbeans.modules.j2ee.jboss4.ide.JBStartServer;
import org.netbeans.modules.j2ee.jboss4.util.JBProperties;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

class JBStopRunnable
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(JBStopRunnable.class.getName());
    private static final String SHUTDOWN_SH = "/bin/shutdown.sh";
    private static final String SHUTDOWN_BAT = "/bin/shutdown.bat";
    private static final int TIMEOUT = 300000;
    private final JBDeploymentManager dm;
    private final JBStartServer startServer;

    JBStopRunnable(JBDeploymentManager dm, JBStartServer startServer) {
        this.dm = dm;
        this.startServer = startServer;
    }

    private String[] createEnvironment() {
        JBProperties properties = this.dm.getProperties();
        JavaPlatform platform = properties.getJavaPlatform();
        FileObject fo = (FileObject)platform.getInstallFolders().iterator().next();
        String javaHome = FileUtil.toFile((FileObject)fo).getAbsolutePath();
        ArrayList<String> envp = new ArrayList<String>(3);
        envp.add("JAVA=" + javaHome + "/bin/java");
        envp.add("JAVA_HOME=" + javaHome);
        if (Utilities.isWindows()) {
            envp.add("NOPAUSE=true");
        }
        return envp.toArray(new String[envp.size()]);
    }

    @Override
    public void run() {
        InstanceProperties ip = this.dm.getInstanceProperties();
        String configName = ip.getProperty("server");
        if ("minimal".equals(configName)) {
            this.startServer.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, StateType.FAILED, NbBundle.getMessage(JBStopRunnable.class, (String)"MSG_STOP_SERVER_FAILED_MINIMAL")));
            return;
        }
        String serverName = ip.getProperty("displayName");
        String serverLocation = ip.getProperty("root-dir");
        String serverStopFileName = serverLocation + (Utilities.isWindows() ? SHUTDOWN_BAT : SHUTDOWN_SH);
        File serverStopFile = new File(serverStopFileName);
        if (!serverStopFile.exists()) {
            this.startServer.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, StateType.FAILED, NbBundle.getMessage(JBStopRunnable.class, (String)"MSG_STOP_SERVER_FAILED_FNF", (Object)serverName)));
            return;
        }
        JBProperties properties = this.dm.getProperties();
        StringBuilder credentialsParams = new StringBuilder(32);
        credentialsParams.append(" -u ").append(properties.getUsername()).append(" -p ").append(properties.getPassword());
        NbProcessDescriptor pd = new NbProcessDescriptor(serverStopFileName, "--shutdown " + credentialsParams);
        Process stoppingProcess = null;
        try {
            String[] envp = this.createEnvironment();
            stoppingProcess = pd.exec(null, envp, true, null);
        }
        catch (IOException ioe) {
            LOGGER.log(Level.INFO, null, ioe);
            this.startServer.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, StateType.FAILED, NbBundle.getMessage(JBStopRunnable.class, (String)"MSG_STOP_SERVER_FAILED_PD", (Object)serverName, (Object)serverStopFileName)));
            return;
        }
        this.startServer.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, StateType.RUNNING, NbBundle.getMessage(JBStopRunnable.class, (String)"MSG_STOP_SERVER_IN_PROGRESS", (Object)serverName)));
        LOGGER.log(Level.FINER, "Entering the loop");
        int elapsed = 0;
        while (elapsed < 300000) {
            try {
                int processExitValue = stoppingProcess.exitValue();
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.log(Level.FINER, "The stopping process has terminated with the exit value " + processExitValue);
                }
                if (processExitValue != 0) {
                    String msg = NbBundle.getMessage(JBStopRunnable.class, (String)"MSG_STOP_SERVER_FAILED", (Object)serverName);
                    this.startServer.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, StateType.FAILED, msg));
                    return;
                }
            }
            catch (IllegalThreadStateException e) {
                // empty catch block
            }
            if (this.startServer.isRunning()) {
                this.startServer.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, StateType.RUNNING, NbBundle.getMessage(JBStopRunnable.class, (String)"MSG_STOP_SERVER_IN_PROGRESS", (Object)serverName)));
                LOGGER.log(Level.FINER, "STOPPING message fired");
                try {
                    elapsed += 500;
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {}
                continue;
            }
            LOGGER.log(Level.FINER, "JBoss has been stopped, going to stop the Log Writer thread");
            JBLogWriter logWriter = JBLogWriter.getInstance(ip.getProperty("displayName"));
            if (logWriter != null && logWriter.isRunning()) {
                logWriter.waitForServerProcessFinished(10000L);
                logWriter.stop();
            }
            this.startServer.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, StateType.COMPLETED, NbBundle.getMessage(JBStopRunnable.class, (String)"MSG_SERVER_STOPPED", (Object)serverName)));
            LOGGER.log(Level.FINER, "STOPPED message fired");
            return;
        }
        this.startServer.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, StateType.FAILED, NbBundle.getMessage(JBStopRunnable.class, (String)"MSG_StopServerTimeout")));
        if (stoppingProcess != null) {
            stoppingProcess.destroy();
        }
        LOGGER.log(Level.FINER, "TIMEOUT expired");
    }
}

