/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.jboss4.JBDeploymentManager;
import org.netbeans.modules.j2ee.jboss4.customizer.CustomizerSupport;
import org.netbeans.modules.j2ee.jboss4.ide.ui.JBPluginUtils;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbCollections;

public class JBProperties {
    public static final String PLAT_PROP_ANT_NAME = "platform.ant.name";
    public static final String PROP_PROXY_ENABLED = "proxy_enabled";
    private static final String PROP_JAVA_PLATFORM = "java_platform";
    private static final String PROP_SOURCES = "sources";
    private static final String PROP_JAVADOCS = "javadocs";
    private static final String DEF_VALUE_JAVA_OPTS = "";
    private static final boolean DEF_VALUE_PROXY_ENABLED = true;
    private final InstanceProperties ip;
    private final JBDeploymentManager manager;
    private String username = "admin";
    private String password = "admin";
    private long updateCredentialsTimestamp;
    private static final Logger LOGGER = Logger.getLogger(JBProperties.class.getName());
    private final JBPluginUtils.Version version;

    public JBProperties(JBDeploymentManager manager) {
        this.manager = manager;
        this.ip = manager.getInstanceProperties();
        this.version = JBPluginUtils.getServerVersion(new File(this.ip.getProperty("root-dir")));
    }

    public boolean supportsJavaEE6() {
        return this.version != null && this.version.compareToIgnoreUpdate(JBPluginUtils.JBOSS_6_0_0) >= 0;
    }

    public boolean supportsJavaEE6Web() {
        return this.supportsJavaEE6();
    }

    public boolean supportsJavaEE5ejb3() {
        return new File(this.getServerDir(), "deploy/ejb3.deployer").exists() || new File(this.getServerDir(), "deployers/ejb3.deployer").exists();
    }

    public boolean supportsJavaEE5web() {
        return new File(this.getServerDir(), "deploy/jboss-web.deployer").exists() || new File(this.getServerDir(), "deployers/jbossweb.deployer").exists();
    }

    public boolean supportsJavaEE5ear() {
        return this.supportsJavaEE5ejb3() && this.supportsJavaEE5web() && this.version != null && this.version.compareToIgnoreUpdate(JBPluginUtils.JBOSS_5_0_0) >= 0;
    }

    public JBPluginUtils.Version getServerVersion() {
        return this.version;
    }

    public boolean isVersion(JBPluginUtils.Version targetVersion) {
        return this.version != null && this.version.compareToIgnoreUpdate(targetVersion) >= 0;
    }

    public File getServerDir() {
        return new File(this.ip.getProperty("server-dir"));
    }

    public File getRootDir() {
        return new File(this.ip.getProperty("root-dir"));
    }

    public File getLibsDir() {
        return new File(this.getServerDir(), "lib");
    }

    public boolean getProxyEnabled() {
        String val = this.ip.getProperty(PROP_PROXY_ENABLED);
        return val != null ? Boolean.valueOf(val) : true;
    }

    public void setProxyEnabled(boolean enabled) {
        this.ip.setProperty(PROP_PROXY_ENABLED, Boolean.toString(enabled));
    }

    public JavaPlatform getJavaPlatform() {
        String currentJvm = this.ip.getProperty(PROP_JAVA_PLATFORM);
        JavaPlatformManager jpm = JavaPlatformManager.getDefault();
        JavaPlatform[] installedPlatforms = jpm.getPlatforms(null, new Specification("J2SE", null));
        for (int i = 0; i < installedPlatforms.length; ++i) {
            String platformName = (String)installedPlatforms[i].getProperties().get(PLAT_PROP_ANT_NAME);
            if (platformName == null || !platformName.equals(currentJvm)) continue;
            return installedPlatforms[i];
        }
        return jpm.getDefaultPlatform();
    }

    public void setJavaPlatform(JavaPlatform javaPlatform) {
        this.ip.setProperty(PROP_JAVA_PLATFORM, (String)javaPlatform.getProperties().get(PLAT_PROP_ANT_NAME));
    }

    public String getJavaOpts() {
        String val = this.ip.getProperty("java_opts");
        return val != null ? val : DEF_VALUE_JAVA_OPTS;
    }

    public void setJavaOpts(String javaOpts) {
        this.ip.setProperty("java_opts", javaOpts);
    }

    public List<URL> getClasses() {
        ArrayList<URL> list = new ArrayList<URL>();
        try {
            File jstlImpl;
            File jsfIMPL;
            File jsfAPI;
            File wsClientLib;
            File jaxWsAPILib;
            File rootDir = this.getRootDir();
            File serverDir = this.getServerDir();
            File commonLibDir = new File(rootDir, "common" + File.separator + "lib");
            File javaEE = new File(commonLibDir, "jboss-javaee.jar");
            if (!javaEE.exists()) {
                javaEE = new File(rootDir, "client/jboss-j2ee.jar");
                if (!javaEE.exists()) {
                    javaEE = new File(rootDir, "client/jboss-javaee.jar");
                }
            } else assert (this.version != null && this.version.compareToIgnoreUpdate(JBPluginUtils.JBOSS_5_0_0) >= 0);
            if (javaEE.exists()) {
                list.add(JBProperties.fileToUrl(javaEE));
            }
            if ((jaxWsAPILib = new File(rootDir, "client/jboss-jaxws.jar")).exists()) {
                list.add(JBProperties.fileToUrl(jaxWsAPILib));
            }
            if ((wsClientLib = new File(rootDir, "client/jbossws-client.jar")).exists()) {
                list.add(JBProperties.fileToUrl(wsClientLib));
            }
            this.addFiles(new File(rootDir, "lib"), list);
            this.addFiles(new File(serverDir, "lib"), list);
            HashSet commonLibs = new HashSet();
            if (this.version != null && this.version.compareToIgnoreUpdate(JBPluginUtils.JBOSS_6_0_0) >= 0) {
                Collections.addAll(commonLibs, "jboss-servlet-api_3.0_spec.jar", "jboss-jsp-api_2.2_spec.jar", "jboss-el-api_2.2_spec.jar", "mail.jar", "jboss-jsr77.jar", "jboss-ejb-api_3.1_spec.jar", "hibernate-jpa-2.0-api.jar", "hibernate-entitymanager.jar", "jboss-transaction-api_1.1_spec.jar", "jbossws-common.jar", "jbossws-framework.jar", "jbossws-jboss60.jar", "jbossws-native-core.jar", "jbossws-spi.jar");
            } else {
                Collections.addAll(commonLibs, "servlet-api.jar", "jsp-api.jar", "el-api.jar", "mail.jar", "jboss-jsr77.jar", "ejb3-persistence.jar", "hibernate-entitymanager.jar", "jbossws-native-jaxws.jar", "jbossws-native-jaxws-ext.jar", "jbossws-native-jaxrpc.jar", "jbossws-native-saaj.jar");
            }
            for (String commonLib : commonLibs) {
                File libJar = new File(commonLibDir, commonLib);
                if (!libJar.exists()) continue;
                list.add(JBProperties.fileToUrl(libJar));
            }
            if (this.supportsJavaEE5ejb3()) {
                File ejb3deployer = new File(serverDir, "/deploy/ejb3.deployer/");
                if (ejb3deployer.exists()) {
                    this.addFiles(ejb3deployer, list);
                } else {
                    ejb3deployer = new File(serverDir, "/deployers/ejb3.deployer/");
                    if (ejb3deployer.exists()) {
                        this.addFiles(ejb3deployer, list);
                    }
                }
            }
            if ((jsfAPI = new File(serverDir, "/deployers/jsf.deployer/Mojarra-2.0/jsf-libs/jsf-api-2.0.2-FCS.jar")).exists()) {
                try {
                    list.add(JBProperties.fileToUrl(jsfAPI));
                }
                catch (MalformedURLException e) {
                    LOGGER.log(Level.INFO, null, e);
                }
            } else {
                jsfAPI = new File(serverDir, "/deploy/jbossweb.sar/jsf-libs/jsf-api.jar");
                if (jsfAPI.exists()) {
                    try {
                        list.add(JBProperties.fileToUrl(jsfAPI));
                    }
                    catch (MalformedURLException e) {
                        LOGGER.log(Level.INFO, null, e);
                    }
                } else {
                    jsfAPI = new File(serverDir, "/deploy/jboss-web.deployer/jsf-libs/jsf-api.jar");
                    if (jsfAPI.exists()) {
                        try {
                            list.add(JBProperties.fileToUrl(jsfAPI));
                        }
                        catch (MalformedURLException e) {
                            LOGGER.log(Level.INFO, null, e);
                        }
                    } else {
                        jsfAPI = new File(serverDir, "/deploy/jbossweb-tomcat55.sar/jsf-libs/myfaces-api.jar");
                        if (jsfAPI.exists()) {
                            try {
                                list.add(JBProperties.fileToUrl(jsfAPI));
                            }
                            catch (MalformedURLException e) {
                                LOGGER.log(Level.INFO, null, e);
                            }
                        } else {
                            jsfAPI = new File(serverDir, "/deployers/jbossweb.deployer/jsf-libs/jsf-api.jar");
                            if (jsfAPI.exists()) {
                                try {
                                    list.add(JBProperties.fileToUrl(jsfAPI));
                                }
                                catch (MalformedURLException e) {
                                    LOGGER.log(Level.INFO, null, e);
                                }
                            }
                        }
                    }
                }
            }
            if ((jsfIMPL = new File(serverDir, "/deployers/jsf.deployer/Mojarra-2.0/jsf-libs/jsf-impl-2.0.2-FCS.jar")).exists()) {
                try {
                    list.add(JBProperties.fileToUrl(jsfIMPL));
                }
                catch (MalformedURLException e) {
                    LOGGER.log(Level.INFO, null, e);
                }
            } else {
                jsfIMPL = new File(serverDir, "/deploy/jbossweb.sar/jsf-libs/jsf-impl.jar");
                if (jsfIMPL.exists()) {
                    try {
                        list.add(JBProperties.fileToUrl(jsfIMPL));
                    }
                    catch (MalformedURLException e) {
                        LOGGER.log(Level.INFO, null, e);
                    }
                } else {
                    jsfIMPL = new File(serverDir, "/deploy/jboss-web.deployer/jsf-libs/jsf-impl.jar");
                    if (jsfIMPL.exists()) {
                        try {
                            list.add(JBProperties.fileToUrl(jsfIMPL));
                        }
                        catch (MalformedURLException e) {
                            LOGGER.log(Level.INFO, null, e);
                        }
                    } else {
                        jsfIMPL = new File(serverDir, "/deploy/jbossweb-tomcat55.sar/jsf-libs/myfaces-impl.jar");
                        if (jsfIMPL.exists()) {
                            try {
                                list.add(JBProperties.fileToUrl(jsfIMPL));
                            }
                            catch (MalformedURLException e) {
                                LOGGER.log(Level.INFO, null, e);
                            }
                        } else {
                            jsfIMPL = new File(serverDir, "/deployers/jbossweb.deployer/jsf-libs/jsf-impl.jar");
                            if (jsfIMPL.exists()) {
                                try {
                                    list.add(JBProperties.fileToUrl(jsfIMPL));
                                }
                                catch (MalformedURLException e) {
                                    LOGGER.log(Level.INFO, null, e);
                                }
                            }
                        }
                    }
                }
            }
            if ((jstlImpl = new File(serverDir, "/deploy/jbossweb.sar/jstl.jar")).exists()) {
                try {
                    list.add(JBProperties.fileToUrl(jstlImpl));
                }
                catch (MalformedURLException e) {
                    LOGGER.log(Level.INFO, null, e);
                }
            } else {
                jstlImpl = new File(serverDir, "/deploy/jboss-web.deployer/jstl.jar");
                if (jstlImpl.exists()) {
                    try {
                        list.add(JBProperties.fileToUrl(jstlImpl));
                    }
                    catch (MalformedURLException e) {
                        LOGGER.log(Level.INFO, null, e);
                    }
                } else {
                    jstlImpl = new File(serverDir, "/deploy/jbossweb-tomcat55.sar/jsf-libs/jstl.jar");
                    if (jstlImpl.exists()) {
                        try {
                            list.add(JBProperties.fileToUrl(jstlImpl));
                        }
                        catch (MalformedURLException e) {
                            LOGGER.log(Level.INFO, null, e);
                        }
                    }
                }
            }
        }
        catch (MalformedURLException e) {
            LOGGER.log(Level.INFO, null, e);
        }
        return list;
    }

    private void addFiles(File folder, List l) {
        File[] files = folder.listFiles(new FF());
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.addFiles(files[i], l);
                continue;
            }
            try {
                l.add(JBProperties.fileToUrl(files[i]));
                continue;
            }
            catch (MalformedURLException e) {
                Logger.getLogger("global").log(Level.INFO, null, e);
            }
        }
    }

    public List<URL> getSources() {
        String path = this.ip.getProperty(PROP_SOURCES);
        if (path == null) {
            return new ArrayList<URL>();
        }
        return CustomizerSupport.tokenizePath(path);
    }

    public void setSources(List<URL> path) {
        this.ip.setProperty(PROP_SOURCES, CustomizerSupport.buildPath(path));
        this.manager.getJBPlatform().notifyLibrariesChanged();
    }

    public List<URL> getJavadocs() {
        String path = this.ip.getProperty(PROP_JAVADOCS);
        if (path == null) {
            ArrayList<URL> list = new ArrayList<URL>();
            try {
                File j2eeDoc = InstalledFileLocator.getDefault().locate("docs/javaee6-doc-api.zip", null, false);
                if (j2eeDoc != null) {
                    list.add(JBProperties.fileToUrl(j2eeDoc));
                }
            }
            catch (MalformedURLException e) {
                Logger.getLogger("global").log(Level.INFO, null, e);
            }
            return list;
        }
        return CustomizerSupport.tokenizePath(path);
    }

    public void setJavadocs(List<URL> path) {
        this.ip.setProperty(PROP_JAVADOCS, CustomizerSupport.buildPath(path));
        this.manager.getJBPlatform().notifyLibrariesChanged();
    }

    public synchronized String getUsername() {
        this.updateCredentials();
        return this.username;
    }

    public synchronized String getPassword() {
        this.updateCredentials();
        return this.password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateCredentials() {
        File usersPropFile = new File(this.getServerDir(), "/conf/props/jmx-console-users.properties");
        long lastModified = usersPropFile.lastModified();
        if (lastModified == this.updateCredentialsTimestamp) {
            LOGGER.log(Level.FINER, "Credentials are up-to-date.");
            return;
        }
        Properties usersProps = new Properties();
        try {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(usersPropFile));
            try {
                usersProps.load(is);
            }
            finally {
                ((InputStream)is).close();
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.log(Level.WARNING, usersPropFile + " not found.", e);
            return;
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Error while reading " + usersPropFile, e);
            return;
        }
        Enumeration names = NbCollections.checkedEnumerationByFilter(usersProps.propertyNames(), String.class, (boolean)false);
        if (names.hasMoreElements()) {
            this.username = (String)names.nextElement();
            this.password = usersProps.getProperty(this.username);
        }
        this.updateCredentialsTimestamp = lastModified;
    }

    private static URL fileToUrl(File file) throws MalformedURLException {
        URL url = file.toURI().toURL();
        if (FileUtil.isArchiveFile((URL)url)) {
            url = FileUtil.getArchiveRoot((URL)url);
        }
        return url;
    }

    private static class FF
    implements FilenameFilter {
        private FF() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".jar") || new File(dir, name).isDirectory();
        }
    }
}

