/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.componentssupport.ui.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.vmd.componentssupport.ui.UIUtils;
import org.netbeans.modules.vmd.componentssupport.ui.helpers.BaseHelper;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.BasicModuleConfWizardPanel;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.DocumentAdapter;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class BasicModuleConfVisualPanel
extends JPanel {
    private static final String BASIC_CONF_ERR_PREFIX = "BasicConfVisualPanel_err_";
    private static final String XML = ".xml";
    private static final String LAYER = "layer";
    private static final String PROPS = ".properties";
    private static final String BUNDLE = "bundle";
    private static final String MSG_INVALID_CNB = "MSG_InvalidCNB";
    private static final String MSG_INVALID_NBORG_CNB = "BasicConfVisualPanel_err_wrong_nborg_name";
    private static final String ACS_LAYER_VALUE = "ACS_CTL_LayerValue";
    private static final String ACS_DISPLAY_NAME_VALUE = "ACS_CTL_DisplayNameValue";
    private static final String ACS_CODE_NAME_BASE_VALUE = "ACS_CTL_CodeNameBaseValue";
    private static final String ACS_BUNDLE_VALUE = "ACS_CTL_BundleValue";
    private static final String ACS_DESC = "ACS_BasicConfVisualPanel";
    private static final long serialVersionUID = -7699370587627049750L;
    private JLabel bundle;
    private JTextField bundleValue;
    private JLabel cnbHint;
    private JLabel codeNameBase;
    private JTextField codeNameBaseValue;
    private JPanel confPanel;
    private JLabel displayName;
    private JTextField displayNameValue;
    private JLabel filler;
    private JCheckBox generateLayer;
    private JLabel layer;
    private JTextField layerValue;
    private boolean isBundleUpdated;
    private boolean isLayerUpdated;
    private boolean listenersAttached;
    private final DocumentListener myCodeBaseNameListener;
    private final DocumentListener myLayerListener;
    private final DocumentListener myBundleListener;
    private WizardDescriptor mySettings;
    private BasicModuleConfWizardPanel myPanel;

    public BasicModuleConfVisualPanel(BasicModuleConfWizardPanel panel) {
        this.myPanel = panel;
        this.initComponents();
        this.initAccessibility();
        this.myCodeBaseNameListener = new DocumentAdapter(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                BasicModuleConfVisualPanel.this.updateValuesOnCNBUpdate();
                BasicModuleConfVisualPanel.this.checkValidity();
            }
        };
        this.myLayerListener = new DocumentAdapter(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                BasicModuleConfVisualPanel.this.isLayerUpdated = true;
                BasicModuleConfVisualPanel.this.checkValidity();
            }
        };
        this.myBundleListener = new DocumentAdapter(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                BasicModuleConfVisualPanel.this.isBundleUpdated = true;
                BasicModuleConfVisualPanel.this.checkValidity();
            }
        };
    }

    protected HelpCtx getHelp() {
        return new HelpCtx(BasicModuleConfVisualPanel.class);
    }

    private boolean checkValidity() {
        if (!this.checkCodeNameBase()) {
            return false;
        }
        if (!this.checkLayer()) {
            return false;
        }
        if (!this.checkBundle()) {
            return false;
        }
        this.markValid();
        return true;
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(BasicModuleConfVisualPanel.getMessage(ACS_DESC, new Object[0]));
        this.bundleValue.getAccessibleContext().setAccessibleDescription(BasicModuleConfVisualPanel.getMessage(ACS_BUNDLE_VALUE, new Object[0]));
        this.codeNameBaseValue.getAccessibleContext().setAccessibleDescription(BasicModuleConfVisualPanel.getMessage(ACS_CODE_NAME_BASE_VALUE, new Object[0]));
        this.displayNameValue.getAccessibleContext().setAccessibleDescription(BasicModuleConfVisualPanel.getMessage(ACS_DISPLAY_NAME_VALUE, new Object[0]));
        this.layerValue.getAccessibleContext().setAccessibleDescription(BasicModuleConfVisualPanel.getMessage(ACS_LAYER_VALUE, new Object[0]));
        this.bundleValue.getAccessibleContext().setAccessibleName(BasicModuleConfVisualPanel.getMessage(ACS_BUNDLE_VALUE, new Object[0]));
        this.codeNameBaseValue.getAccessibleContext().setAccessibleName(BasicModuleConfVisualPanel.getMessage(ACS_CODE_NAME_BASE_VALUE, new Object[0]));
        this.displayNameValue.getAccessibleContext().setAccessibleName(BasicModuleConfVisualPanel.getMessage(ACS_DISPLAY_NAME_VALUE, new Object[0]));
        this.layerValue.getAccessibleContext().setAccessibleName(BasicModuleConfVisualPanel.getMessage(ACS_LAYER_VALUE, new Object[0]));
    }

    private boolean checkCodeNameBase() {
        String dotName = this.getCodeNameBaseValue();
        if (!UIUtils.isValidJavaFQN(dotName)) {
            this.setError(BasicModuleConfVisualPanel.getMessage(MSG_INVALID_CNB, new Object[0]));
            return false;
        }
        if (BaseHelper.isNetBeansOrg(this.mySettings)) {
            String cnbShort = BasicModuleConfVisualPanel.abbreviateCNB(dotName);
            String name = (String)this.mySettings.getProperty("projName");
            if (!name.equals(cnbShort)) {
                this.setError(BasicModuleConfVisualPanel.getMessage(MSG_INVALID_NBORG_CNB, cnbShort));
                return false;
            }
        }
        return true;
    }

    private static String abbreviateCNB(String cnb) {
        return cnb.replaceFirst("^org\\.netbeans\\.modules\\.", "").replaceFirst("^org\\.netbeans\\.(libs|lib|api|spi|core)\\.", "$1.").replaceFirst("^org\\.netbeans\\.", "o.n.").replaceFirst("^org\\.openide\\.", "openide.").replaceFirst("^org\\.", "o.").replaceFirst("^com\\.sun\\.", "c.s.").replaceFirst("^com\\.", "c.");
    }

    private void updateValuesOnCNBUpdate() {
        String dotName = this.getCodeNameBaseValue();
        String slashName = dotName.replace('.', '/');
        if (!this.isBundleUpdated) {
            this.bundleValue.setText(slashName + "/" + "Bundle.properties");
            this.isBundleUpdated = false;
        }
        if (!this.isLayerUpdated) {
            this.layerValue.setText(slashName + "/" + "layer.xml");
            this.isLayerUpdated = false;
        }
    }

    private boolean checkBundle() {
        return this.checkEntry(this.getBundleValue(), BUNDLE, PROPS);
    }

    private boolean checkLayer() {
        return this.checkEntry(this.getLayerValue(), LAYER, XML);
    }

    private boolean checkEntry(String path, String resName, String extension) {
        if (path.length() == 0) {
            this.setError(NbBundle.getMessage(BasicModuleConfVisualPanel.class, (String)(BASIC_CONF_ERR_PREFIX + resName + "_empty")));
            return false;
        }
        if (path.indexOf(47) == -1) {
            this.setError(NbBundle.getMessage(BasicModuleConfVisualPanel.class, (String)(BASIC_CONF_ERR_PREFIX + resName + "_def_pkg")));
            return false;
        }
        if (!path.endsWith(extension)) {
            this.setError(NbBundle.getMessage(BasicModuleConfVisualPanel.class, (String)(BASIC_CONF_ERR_PREFIX + resName + "_ext"), (Object)extension));
            return false;
        }
        return true;
    }

    void refreshData(WizardDescriptor settings) {
        this.mySettings = settings;
        String cnb = this.getCodeNameBase();
        this.codeNameBaseValue.setText(cnb);
        if (cnb.startsWith("org.<yourorghere>.")) {
            this.codeNameBaseValue.select(0, "org.<yourorghere>.".length() - 1);
        }
        this.displayNameValue.setText(this.getProjectDisplayName());
        this.updateValuesOnCNBUpdate();
        this.checkValidity();
    }

    private String getProjectDisplayName() {
        String projectName = (String)this.mySettings.getProperty("projName");
        String displayName = (String)this.mySettings.getProperty("displayName");
        if (displayName == null) {
            displayName = projectName;
        }
        return displayName;
    }

    private String getCodeNameBase() {
        String codeBaseName = (String)this.mySettings.getProperty("codeBaseName");
        String projectName = (String)this.mySettings.getProperty("projName");
        if (codeBaseName == null) {
            codeBaseName = BaseHelper.getDefaultCodeNameBase(projectName);
        }
        return codeBaseName;
    }

    void storeData(WizardDescriptor descriptor) {
        descriptor.putProperty("codeBaseName", (Object)this.getCodeNameBaseValue());
        descriptor.putProperty("displayName", (Object)this.displayNameValue.getText());
        descriptor.putProperty(BUNDLE, (Object)this.getBundleValue());
        descriptor.putProperty(LAYER, (Object)this.getLayerValue());
    }

    private String getCodeNameBaseValue() {
        return this.codeNameBaseValue.getText().trim();
    }

    private String getBundleValue() {
        return this.bundleValue.getText().trim();
    }

    private String getLayerValue() {
        return this.layerValue.getText().trim();
    }

    protected final void setError(String message) {
        assert (message != null);
        this.setMessage(message);
        this.setValid(false);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.attachDocumentListeners();
    }

    @Override
    public void removeNotify() {
        this.removeDocumentListeners();
        super.removeNotify();
    }

    private void attachDocumentListeners() {
        if (!this.listenersAttached) {
            this.codeNameBaseValue.getDocument().addDocumentListener(this.myCodeBaseNameListener);
            this.bundleValue.getDocument().addDocumentListener(this.myBundleListener);
            this.layerValue.getDocument().addDocumentListener(this.myLayerListener);
            this.listenersAttached = true;
        }
    }

    private final void setValid(boolean valid) {
        this.myPanel.setValid(valid);
    }

    private void markValid() {
        this.setMessage(null);
        this.setValid(true);
    }

    private final void setMessage(String message) {
        this.mySettings.putProperty("WizardPanel_errorMessage", (Object)message);
    }

    private void removeDocumentListeners() {
        if (this.listenersAttached) {
            this.codeNameBaseValue.getDocument().removeDocumentListener(this.myCodeBaseNameListener);
            this.bundleValue.getDocument().removeDocumentListener(this.myBundleListener);
            this.layerValue.getDocument().removeDocumentListener(this.myLayerListener);
            this.listenersAttached = false;
        }
    }

    private static String getMessage(String key, Object ... params) {
        return NbBundle.getMessage(BasicModuleConfVisualPanel.class, (String)key, (Object[])params);
    }

    private void initComponents() {
        this.confPanel = new JPanel();
        this.codeNameBase = new JLabel();
        this.displayName = new JLabel();
        this.bundle = new JLabel();
        this.layer = new JLabel();
        this.codeNameBaseValue = new JTextField();
        this.displayNameValue = new JTextField();
        this.bundleValue = new JTextField();
        this.layerValue = new JTextField();
        this.filler = new JLabel();
        this.generateLayer = new JCheckBox();
        this.cnbHint = new JLabel();
        this.setLayout(new GridBagLayout());
        this.confPanel.setLayout(new GridBagLayout());
        this.codeNameBase.setLabelFor(this.codeNameBaseValue);
        Mnemonics.setLocalizedText((JLabel)this.codeNameBase, (String)NbBundle.getMessage(BasicModuleConfVisualPanel.class, (String)"LBL_CodeNameBase"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 6, 12);
        this.confPanel.add((Component)this.codeNameBase, gridBagConstraints);
        this.displayName.setLabelFor(this.displayNameValue);
        Mnemonics.setLocalizedText((JLabel)this.displayName, (String)NbBundle.getMessage(BasicModuleConfVisualPanel.class, (String)"LBL_ModuleDisplayName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 12);
        this.confPanel.add((Component)this.displayName, gridBagConstraints);
        this.bundle.setLabelFor(this.bundleValue);
        Mnemonics.setLocalizedText((JLabel)this.bundle, (String)NbBundle.getMessage(BasicModuleConfVisualPanel.class, (String)"LBL_LocalizingBundle"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(18, 5, 0, 12);
        this.confPanel.add((Component)this.bundle, gridBagConstraints);
        this.layer.setLabelFor(this.layerValue);
        Mnemonics.setLocalizedText((JLabel)this.layer, (String)NbBundle.getMessage(BasicModuleConfVisualPanel.class, (String)"LBL_XMLLayer"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 20, 0, 12);
        this.confPanel.add((Component)this.layer, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 5, 0);
        this.confPanel.add((Component)this.codeNameBaseValue, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.confPanel.add((Component)this.displayNameValue, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(18, 0, 0, 0);
        this.confPanel.add((Component)this.bundleValue, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.confPanel.add((Component)this.layerValue, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 1.0;
        this.confPanel.add((Component)this.filler, gridBagConstraints);
        this.generateLayer.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.generateLayer, (String)BasicModuleConfVisualPanel.getMessage("CTL_GenerateLayer", new Object[0]));
        this.generateLayer.setEnabled(false);
        this.generateLayer.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = -2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.confPanel.add((Component)this.generateLayer, gridBagConstraints);
        this.generateLayer.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BasicModuleConfVisualPanel.class, (String)"ACS_CTL_GenerateLayer"));
        this.generateLayer.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicModuleConfVisualPanel.class, (String)"ACS_CTL_GenerateLayer"));
        Mnemonics.setLocalizedText((JLabel)this.cnbHint, (String)BasicModuleConfVisualPanel.getMessage("LBL_CodeNameBaseHint", new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.confPanel.add((Component)this.cnbHint, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.add((Component)this.confPanel, gridBagConstraints);
    }
}

