/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.componentssupport.ui.wizard;

import java.awt.Component;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.vmd.componentssupport.ui.helpers.BaseHelper;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.NameAndLocationWizardPanel;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.SelectLibraryWizardPanel;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

final class NewLibraryDescriptor
implements WizardDescriptor.InstantiatingIterator {
    private static final String WIZARD_TITLE = "LBL_LibraryWizardTitle";
    private static final String LIB_STEPS_COUNT = "LBL_LibWizardStepsCount";
    public static final String LIBRARY_STEP = "LBL_LibSelectLibraryStep";
    public static final String NAME_LOCATION_STEP = "LBL_LibNameAndLocationStep";
    public static final String LIBRARY = "library";
    public static final String DISPLAY_NAME = "displayName";
    public static final String LIB_NAME = "libName";
    public static final String EXISTING_LIBRARIES = "existLibrary";
    public static final String EXISTING_LIB_NAMES = "existLibName";
    public static final String LIBRARY_TYPE_J2SE = "j2se";
    private int myCurrentIndex;
    private WizardDescriptor.Panel[] myPanels;
    private WizardDescriptor myWizard;
    private WizardDescriptor myMainWizard;

    NewLibraryDescriptor(WizardDescriptor mainDesc) {
        this.myMainWizard = mainDesc;
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        this.myWizard = wizardDescriptor;
        this.myCurrentIndex = 0;
        this.myPanels = this.createPanels();
        String[] steps = this.createSteps();
        for (int i = 0; i < this.myPanels.length; ++i) {
            Component c = this.myPanels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
        wizardDescriptor.setTitle(NbBundle.getMessage(NewLibraryDescriptor.class, (String)WIZARD_TITLE));
        wizardDescriptor.putProperty("projName", this.myMainWizard.getProperty("projName"));
        wizardDescriptor.putProperty("codeBaseName", (Object)this.getCodeNameBase());
        wizardDescriptor.putProperty(EXISTING_LIB_NAMES, this.myMainWizard.getProperty("libNames"));
        wizardDescriptor.putProperty(EXISTING_LIBRARIES, this.myMainWizard.getProperty("libraries"));
    }

    public Set<?> instantiate() throws IOException {
        LinkedList<Object> names;
        LinkedList<Object> libNames;
        LinkedList<Object> libs = (LinkedList<Object>)this.myMainWizard.getProperty("libraries");
        if (libs == null) {
            libs = new LinkedList<Object>();
            this.myMainWizard.putProperty("libraries", libs);
        }
        if ((libNames = (LinkedList<Object>)this.myMainWizard.getProperty("libNames")) == null) {
            libNames = new LinkedList<Object>();
            this.myMainWizard.putProperty("libNames", libNames);
        }
        if ((names = (LinkedList<Object>)this.myMainWizard.getProperty("libDisplayNames")) == null) {
            names = new LinkedList<Object>();
            this.myMainWizard.putProperty("libDisplayNames", names);
        }
        libs.add(this.myWizard.getProperty(LIBRARY));
        libNames.add(this.myWizard.getProperty(LIB_NAME));
        names.add(this.myWizard.getProperty(DISPLAY_NAME));
        return Collections.EMPTY_SET;
    }

    public void uninitialize(WizardDescriptor arg0) {
        this.myWizard.putProperty(LIBRARY, null);
        this.myWizard.putProperty(LIB_NAME, null);
        this.myWizard.putProperty(DISPLAY_NAME, null);
        this.myWizard.putProperty("projName", null);
        this.myWizard.putProperty("codeBaseName", null);
        this.myWizard.putProperty(EXISTING_LIB_NAMES, null);
        this.myWizard.putProperty(EXISTING_LIBRARIES, null);
        this.myWizard = null;
        this.myPanels = null;
    }

    public WizardDescriptor.Panel current() {
        return this.myPanels[this.myCurrentIndex];
    }

    public boolean hasNext() {
        return this.myCurrentIndex < this.myPanels.length - 1;
    }

    public boolean hasPrevious() {
        return this.myCurrentIndex > 0;
    }

    public String name() {
        return MessageFormat.format(NbBundle.getBundle(NewLibraryDescriptor.class).getString(LIB_STEPS_COUNT), this.myCurrentIndex + 1, this.myPanels.length);
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.myCurrentIndex;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.myCurrentIndex;
    }

    public void removeChangeListener(ChangeListener arg0) {
    }

    public void addChangeListener(ChangeListener arg0) {
    }

    WizardDescriptor.Panel[] createPanels() {
        return new WizardDescriptor.Panel[]{new SelectLibraryWizardPanel(), new NameAndLocationWizardPanel()};
    }

    private String getCodeNameBase() {
        String codeNameBase = (String)this.myMainWizard.getProperty("codeBaseName");
        String projectName = (String)this.myMainWizard.getProperty("projName");
        if (codeNameBase == null) {
            codeNameBase = BaseHelper.getDefaultCodeNameBase(projectName);
        }
        return codeNameBase;
    }

    private String[] createSteps() {
        return new String[]{NbBundle.getMessage(NewLibraryDescriptor.class, (String)LIBRARY_STEP), NbBundle.getMessage(NewLibraryDescriptor.class, (String)NAME_LOCATION_STEP)};
    }
}

