/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uihandler;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.uihandler.Installer;
import org.openide.awt.Mnemonics;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

final class ButtonsParser {
    private final InputStream is;
    private String title;
    private List<Object> options;
    private List<Object> additionalOptions;
    private boolean containsExitButton = false;
    private List<Node> nodes;
    private String url;

    public ButtonsParser(InputStream is) {
        this.is = new CuttingInputStream(is);
    }

    void parse() throws IOException, ParserConfigurationException, SAXException, InterruptedException, InvocationTargetException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setIgnoringComments(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        PushbackInputStream isWithProlog = new PushbackInputStream(this.is, 255);
        byte[] xmlHeader = new byte[5];
        int len = isWithProlog.read(xmlHeader);
        isWithProlog.unread(xmlHeader, 0, len);
        if (len < 5 || xmlHeader[0] != 60 || xmlHeader[1] != 63 || xmlHeader[2] != 120 || xmlHeader[3] != 109 || xmlHeader[4] != 108) {
            String header = "<?xml version='1.0' encoding='utf-8'?>";
            isWithProlog.unread(header.getBytes("utf-8"));
        }
        this.nodes = new ArrayList<Node>();
        builder.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                if (systemId.equals("http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd")) {
                    ByteArrayInputStream is = new ByteArrayInputStream(new byte[0]);
                    return new InputSource(is);
                }
                return null;
            }
        });
        Document doc = builder.parse(isWithProlog);
        NodeList forms = doc.getElementsByTagName("form");
        for (int i = 0; i < forms.getLength(); ++i) {
            String action = forms.item(i).getAttributes().getNamedItem("action").getNodeValue();
            if (action == null || "".equals(action)) {
                throw new IllegalStateException("Action should not be empty");
            }
            this.url = action;
            NodeList inputs = doc.getElementsByTagName("input");
            for (int j = 0; j < inputs.getLength(); ++j) {
                Node in;
                String type;
                if (!ButtonsParser.isChild(inputs.item(j), forms.item(i)) || !"hidden".equals(type = ButtonsParser.attrValue(in = inputs.item(j), "type"))) continue;
                this.nodes.add(in);
            }
        }
        NodeList titlesList = doc.getElementsByTagName("title");
        for (int i = 0; i < titlesList.getLength(); ++i) {
            String t = titlesList.item(i).getTextContent();
            if (t == null) continue;
            this.title = t;
            break;
        }
    }

    public void createButtons() {
        this.options = new ArrayList<Object>();
        this.additionalOptions = new ArrayList<Object>();
        for (Node node : this.nodes) {
            List<Object> addTo;
            String name = ButtonsParser.attrValue(node, "name");
            String value = ButtonsParser.attrValue(node, "value");
            String align = ButtonsParser.attrValue(node, "align");
            String alt = ButtonsParser.attrValue(node, "alt");
            boolean enabled = true;
            if ("true".equals(ButtonsParser.attrValue(node, "disabled"))) {
                enabled = false;
            } else if ("disabled".equals(ButtonsParser.attrValue(node, "disabled"))) {
                enabled = false;
            }
            List<Object> list = addTo = "left".equals(align) ? this.additionalOptions : this.options;
            if (Installer.Button.isSubmitTrigger(name)) {
                String submitValue = value;
                JButton b = new JButton();
                Mnemonics.setLocalizedText((AbstractButton)b, (String)submitValue);
                b.setActionCommand(name);
                b.putClientProperty("url", this.url);
                b.setDefaultCapable(addTo.isEmpty() && addTo == this.options);
                b.putClientProperty("alt", alt);
                b.putClientProperty("now", submitValue);
                b.setEnabled(enabled);
                addTo.add(b);
                continue;
            }
            JButton b = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)b, (String)value);
            b.setActionCommand(name);
            b.setDefaultCapable(addTo.isEmpty() && addTo == this.options);
            b.putClientProperty("alt", alt);
            b.putClientProperty("now", value);
            b.setEnabled(enabled && Installer.Button.isKnown(name));
            addTo.add(b);
            if (Installer.Button.EXIT.isCommand(name)) {
                this.containsExitButton = true;
            }
            if (!Installer.Button.REDIRECT.isCommand(name)) continue;
            b.putClientProperty("url", this.url);
        }
    }

    List<Object> getOptions() {
        return this.options;
    }

    List<Object> getAditionalOptions() {
        return this.additionalOptions;
    }

    String getTitle() {
        return this.title;
    }

    boolean containsExitButton() {
        return this.containsExitButton;
    }

    private static String attrValue(Node in, String attrName) {
        Node n = in.getAttributes().getNamedItem(attrName);
        return n == null ? null : n.getNodeValue();
    }

    private static boolean isChild(Node child, Node parent) {
        while (child != null) {
            if (child == parent) {
                return true;
            }
            child = child.getParentNode();
        }
        return false;
    }

    private static class CuttingInputStream
    extends InputStream {
        private static int[] TERMINAL_PATTERN = new int[]{60, 47, 104, 116, 109, 108, 62};
        private final InputStream br;
        private int processed = 0;

        public CuttingInputStream(InputStream originalIS) {
            this.br = originalIS;
        }

        @Override
        public int read() throws IOException {
            if (this.processed >= TERMINAL_PATTERN.length) {
                return -1;
            }
            int next = this.br.read();
            this.processed = next == TERMINAL_PATTERN[this.processed] ? ++this.processed : 0;
            return next;
        }
    }
}

