/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.vcs;

import java.util.EnumMap;
import java.util.Map;
import java.util.prefs.Preferences;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class VCSHooksConfig {
    private final HookType type;
    private static Map<HookType, VCSHooksConfig> instances = new EnumMap<HookType, VCSHooksConfig>(HookType.class);
    private static final String HOOK_PREFIX = "vcshook.";
    private static final String HOOK_RESOLVE = "_resolve";
    private static final String HOOK_LINK = "_link";
    private static final String HOOK_AFTER_COMMIT = "_after_commit";
    private static final String HOOK_ISSUE_INFO_TEMPLATE = "_issue_format";
    private static final String HOOK_REVISION_TEMPLATE = "_comment_format";
    private static final String HOOK_PUSH_ = "_push_hook_";
    private static final String DELIMITER = "<=>";

    private VCSHooksConfig(HookType type) {
        this.type = type;
    }

    static VCSHooksConfig getInstance(HookType type) {
        VCSHooksConfig instance = instances.get((Object)type);
        if (instance == null) {
            instance = new VCSHooksConfig(type);
            instances.put(type, instance);
        }
        return instance;
    }

    Preferences getPreferences() {
        return NbPreferences.forModule(VCSHooksConfig.class);
    }

    void setIssueInfoTemplate(Format format) {
        this.getPreferences().put(HOOK_PREFIX + (Object)((Object)this.type) + HOOK_ISSUE_INFO_TEMPLATE, format.toString());
    }

    void setRevisionTemplate(Format format) {
        this.getPreferences().put(HOOK_PREFIX + (Object)((Object)this.type) + HOOK_REVISION_TEMPLATE, format.toString());
    }

    void setResolve(boolean bl) {
        this.getPreferences().putBoolean(HOOK_PREFIX + (Object)((Object)this.type) + HOOK_RESOLVE, bl);
    }

    void setLink(boolean bl) {
        this.getPreferences().putBoolean(HOOK_PREFIX + (Object)((Object)this.type) + HOOK_LINK, bl);
    }

    boolean getResolve() {
        return this.getPreferences().getBoolean(HOOK_PREFIX + (Object)((Object)this.type) + HOOK_RESOLVE, false);
    }

    boolean getLink() {
        return this.getPreferences().getBoolean(HOOK_PREFIX + (Object)((Object)this.type) + HOOK_LINK, true);
    }

    boolean getAfterCommit() {
        return this.getPreferences().getBoolean(HOOK_PREFIX + (Object)((Object)this.type) + HOOK_AFTER_COMMIT, false);
    }

    Format getRevisionTemplate() {
        return this.getFormat(this.getPreferences().get(HOOK_PREFIX + (Object)((Object)this.type) + HOOK_REVISION_TEMPLATE, null), this.type == HookType.SVN ? VCSHooksConfig.getDefaultSvnRevisionTemplate() : VCSHooksConfig.getDefaultHgRevisionTemplate());
    }

    Format getIssueInfoTemplate() {
        return this.getFormat(this.getPreferences().get(HOOK_PREFIX + (Object)((Object)this.type) + HOOK_ISSUE_INFO_TEMPLATE, null), this.getDefaultIssueInfoTemplate());
    }

    void setPushAction(String changeset, PushOperation pushAction) {
        this.getPreferences().put(HOOK_PREFIX + (Object)((Object)this.type) + HOOK_PUSH_ + changeset, pushAction.toString());
    }

    void setAfterCommit(boolean bl) {
        this.getPreferences().putBoolean(HOOK_PREFIX + (Object)((Object)this.type) + HOOK_AFTER_COMMIT, bl);
    }

    PushOperation popPushAction(String changeset) {
        String value = this.getPreferences().get(HOOK_PREFIX + (Object)((Object)this.type) + HOOK_PUSH_ + changeset, null);
        if (value == null) {
            return null;
        }
        String[] values = value.split(DELIMITER);
        this.getPreferences().remove(HOOK_PREFIX + (Object)((Object)this.type) + HOOK_PUSH_ + changeset);
        return new PushOperation(values[0], !values[1].equals("") ? values[1] : null, values[2].equals("1"));
    }

    Format getDefaultRevisionTemplate() {
        if (this.type == HookType.SVN) {
            return VCSHooksConfig.getDefaultSvnRevisionTemplate();
        }
        return VCSHooksConfig.getDefaultHgRevisionTemplate();
    }

    private static Format getDefaultHgRevisionTemplate() {
        return new Format(false, VCSHooksConfig.normalizeFormat(new String[]{NbBundle.getMessage(VCSHooksConfig.class, (String)"LBL_Changeset"), "{changeset}\n", NbBundle.getMessage(VCSHooksConfig.class, (String)"LBL_Author"), "{author}\n", NbBundle.getMessage(VCSHooksConfig.class, (String)"LBL_Date"), "{date}\n", NbBundle.getMessage(VCSHooksConfig.class, (String)"LBL_Message"), "{message}"}));
    }

    Format getDefaultIssueInfoTemplate() {
        return new Format(false, NbBundle.getMessage(VCSHooksConfig.class, (String)"LBL_Issue") + "{id} - {summary}");
    }

    private static Format getDefaultSvnRevisionTemplate() {
        return new Format(false, VCSHooksConfig.normalizeFormat(new String[]{NbBundle.getMessage(VCSHooksConfig.class, (String)"LBL_Revision"), "{revision}\n", NbBundle.getMessage(VCSHooksConfig.class, (String)"LBL_Author"), "{author}\n", NbBundle.getMessage(VCSHooksConfig.class, (String)"LBL_Date"), "{date}\n", NbBundle.getMessage(VCSHooksConfig.class, (String)"LBL_Message"), "{message}"}));
    }

    private Format getFormat(String value, Format defaultFormat) {
        Format format;
        if (value == null) {
            format = defaultFormat;
        } else {
            String[] values = value.split(DELIMITER);
            format = new Format(values[0].equals("1"), values.length > 1 ? values[1] : "");
        }
        return format;
    }

    private static String normalizeFormat(String[] params) {
        int l = 0;
        for (int i = 0; i < params.length; i += 2) {
            if (l >= params[i].length()) continue;
            l = params[i].length();
        }
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < params.length; ++i) {
            ret.append(params[i]);
            StringBuilder s = new StringBuilder();
            for (int j = 0; j < l - params[i].length() + 1; ++j) {
                s.append(" ");
            }
            ret.append(s.toString());
            ret.append(params[++i]);
        }
        return ret.toString();
    }

    static void logHookUsage(String vcs, Repository bugRepository) {
        BugtrackingUtil.logBugtrackingUsage((Repository)bugRepository, (String)"COMMIT_HOOK");
        Utils.logVCSActionEvent((String)("COMMIT_HOOK_" + vcs));
    }

    static class Format {
        private boolean above;
        private String format;

        public Format(boolean above, String format) {
            this.above = above;
            this.format = format;
        }

        public boolean isAbove() {
            return this.above;
        }

        public String getFormat() {
            return this.format;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.above ? "1" : "0");
            sb.append(VCSHooksConfig.DELIMITER);
            sb.append(this.format);
            return sb.toString();
        }
    }

    static class PushOperation {
        private final String issueID;
        private final String msg;
        private final boolean close;

        public PushOperation(String issueID, String msg, boolean close) {
            this.issueID = issueID;
            this.msg = msg;
            this.close = close;
        }

        public String getIssueID() {
            return this.issueID;
        }

        public boolean isClose() {
            return this.close;
        }

        public String getMsg() {
            return this.msg;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            String message = this.getMsg();
            sb.append(this.getIssueID());
            sb.append(VCSHooksConfig.DELIMITER);
            sb.append(message != null ? message.trim() : "");
            sb.append(VCSHooksConfig.DELIMITER);
            sb.append(this.isClose() ? "1" : "0");
            return sb.toString();
        }
    }

    static enum HookType {
        SVN("svn"),
        HG("hg"),
        GIT("git");

        private String type;

        private HookType(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }
}

