/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax.completion;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.jsp.lexer.JspTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.web.core.syntax.JspSyntaxSupport;
import org.netbeans.modules.web.core.syntax.SyntaxElement;
import org.netbeans.modules.web.core.syntax.completion.AttributeValueSupport;
import org.netbeans.modules.web.core.syntax.completion.StandardTagLibraryPrefixes;
import org.netbeans.modules.web.core.syntax.completion.api.JspCompletionItem;
import org.netbeans.modules.web.core.syntax.deprecated.JspTagTokenContext;
import org.netbeans.modules.web.core.syntax.tld.TldLibrary;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.JarFileSystem;
import org.openide.util.Exceptions;

public class JspCompletionQuery {
    private static final String JSP_COMMENT_END_DELIMITER = "--%>";
    private static final List<String> JSP_DELIMITERS = Arrays.asList("<%", "<%=", "<%!", "<%--");
    private static final JspCompletionQuery JSP_COMPLETION_QUERY = new JspCompletionQuery();

    static JspCompletionQuery instance() {
        return JSP_COMPLETION_QUERY;
    }

    void query(CompletionResultSet<? extends CompletionItem> result, JTextComponent component, int offset) {
        BaseDocument doc = (BaseDocument)component.getDocument();
        JspSyntaxSupport sup = JspSyntaxSupport.get((Document)doc);
        try {
            SyntaxElement elem = sup.getElementChain(offset);
            if (elem == null) {
                return;
            }
            TokenHierarchy th = TokenHierarchy.get((Document)doc);
            TokenSequence ts = th.tokenSequence(JspTokenId.language());
            ts.move(offset);
            if ((ts.moveNext() || ts.movePrevious()) && (ts.token().id() == JspTokenId.COMMENT || ts.token().id() == JspTokenId.EOL && ts.movePrevious() && ts.token().id() == JspTokenId.COMMENT)) {
                this.queryJspCommentContent(result, offset, doc);
            }
            switch (elem.getCompletionContext()) {
                case 1: {
                    this.queryJspTag(result, component, offset, sup, (SyntaxElement.Tag)elem);
                    break;
                }
                case 2: {
                    this.queryJspEndTag(result, component, offset, sup);
                    break;
                }
                case 7: {
                    this.queryJspDirectiveInScriptlet(result, offset, sup);
                    this.queryJspDelimitersInScriptlet(result, offset, sup);
                    break;
                }
                case 3: {
                    this.queryJspDirective(result, component, offset, sup, (SyntaxElement.Directive)elem, doc);
                    break;
                }
                case 6: {
                    this.queryJspTagInContent(result, offset, sup, doc);
                    this.queryJspDirectiveInContent(result, component, offset, sup, doc);
                    this.queryJspDelimitersInContent(result, offset, sup);
                }
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private void queryJspTag(CompletionResultSet result, JTextComponent component, int offset, JspSyntaxSupport sup, SyntaxElement.Tag elem) throws BadLocationException {
        TokenItem item = sup.getItemAtOrBefore(offset);
        if (item == null) {
            return;
        }
        TokenID id = item.getTokenID();
        String tokenPart = item.getImage().substring(0, offset - item.getOffset());
        String token = item.getImage().trim();
        int anchor = -1;
        if (id == JspTagTokenContext.SYMBOL) {
            AttributeValueSupport attSup;
            String attrName;
            if (tokenPart.equals("<")) {
                anchor = offset;
                this.addTagPrefixItems(result, anchor, sup, sup.getTagPrefixes(""));
            }
            if (tokenPart.endsWith("\"") && (attrName = this.findAttributeForValue(sup, item)) != null && (attSup = AttributeValueSupport.getSupport(true, elem.getName(), attrName)) != null) {
                attSup.result(result, component, offset, sup, elem, "");
            }
            if (tokenPart.endsWith(">") && !tokenPart.endsWith("/>")) {
                result.addItem(sup.getAutocompletedEndTag(offset));
            }
        }
        if (id == JspTagTokenContext.TAG || id == JspTagTokenContext.WHITESPACE || id == JspTagTokenContext.EOL) {
            if (this.isBlank(tokenPart.charAt(tokenPart.length() - 1)) || tokenPart.equals("\n")) {
                anchor = offset;
                this.addAttributeItems(result, anchor, sup, elem, sup.getTagAttributes(elem.getName(), ""), null);
            } else {
                int colonIndex = tokenPart.indexOf(":");
                anchor = offset - tokenPart.length();
                if (colonIndex == -1) {
                    this.addTagPrefixItems(result, anchor, sup, sup.getTagPrefixes(tokenPart));
                } else {
                    String prefix = tokenPart.substring(0, colonIndex);
                    this.addTagPrefixItems(result, anchor, sup, prefix, sup.getTags(tokenPart), elem);
                }
            }
        }
        if (id == JspTagTokenContext.ATTRIBUTE) {
            if (this.isBlank(tokenPart.charAt(tokenPart.length() - 1))) {
                anchor = offset;
                this.addAttributeItems(result, anchor, sup, elem, sup.getTagAttributes(elem.getName(), ""), null);
            } else {
                anchor = offset - tokenPart.length();
                this.addAttributeItems(result, anchor, sup, elem, sup.getTagAttributes(elem.getName(), tokenPart), token);
            }
        }
        if (id == JspTagTokenContext.ATTR_VALUE) {
            AttributeValueSupport attSup;
            String valuePart = tokenPart.trim();
            if (valuePart.length() == 0) {
                return;
            }
            for (item = item.getPrevious(); item != null && item.getTokenID() == JspTagTokenContext.ATTR_VALUE; item = item.getPrevious()) {
                valuePart = item.getImage() + valuePart;
            }
            valuePart = valuePart.substring(1);
            String attrName = this.findAttributeForValue(sup, item);
            if (attrName != null && (attSup = AttributeValueSupport.getSupport(true, elem.getName(), attrName)) != null) {
                attSup.result(result, component, offset, sup, elem, valuePart);
            }
        }
        if (anchor != -1) {
            result.setAnchorOffset(anchor);
        }
    }

    private void queryJspEndTag(CompletionResultSet result, JTextComponent component, int offset, JspSyntaxSupport sup) throws BadLocationException {
        TokenItem item = sup.getItemAtOrBefore(offset);
        if (item == null) {
            return;
        }
        String tokenPart = item.getImage().substring(0, offset - item.getOffset());
        int anchor = offset - tokenPart.length();
        result.setAnchorOffset(anchor);
        result.addAllItems(sup.getPossibleEndTags(offset, anchor, tokenPart));
    }

    private void queryJspDirectiveInScriptlet(CompletionResultSet result, int offset, JspSyntaxSupport sup) throws BadLocationException {
        TokenItem item = sup.getItemAtOrBefore(offset);
        if (item == null) {
            return;
        }
        TokenID id = item.getTokenID();
        String tokenPart = item.getImage().substring(0, offset - item.getOffset());
        if (id == JspTagTokenContext.SYMBOL2 && tokenPart.equals("<%")) {
            this.addDirectiveItems(result, offset - tokenPart.length(), sup.getDirectives(""));
        }
    }

    private void queryJspDelimitersInScriptlet(CompletionResultSet result, int offset, JspSyntaxSupport sup) throws BadLocationException {
        TokenItem item = sup.getItemAtOrBefore(offset);
        if (item == null) {
            return;
        }
        TokenID id = item.getTokenID();
        String image = item.getImage();
        int tokenPartLen = offset - item.getOffset();
        String tokenPart = item.getImage().substring(0, tokenPartLen <= image.length() ? tokenPartLen : image.length());
        if (id == JspTagTokenContext.SYMBOL2 && tokenPart.startsWith("<%")) {
            this.addDelimiterItems(result, offset - tokenPart.length(), tokenPart);
        }
    }

    private void queryJspDelimitersInContent(CompletionResultSet result, int offset, JspSyntaxSupport sup) throws BadLocationException {
        TokenItem item = sup.getItemAtOrBefore(offset);
        if (item == null) {
            return;
        }
        String image = item.getImage();
        int tokenPartLen = offset - item.getOffset();
        String tokenPart = item.getImage().substring(0, tokenPartLen <= image.length() ? tokenPartLen : image.length());
        if (tokenPart.startsWith("<")) {
            this.addDelimiterItems(result, offset - tokenPart.length(), tokenPart);
        }
    }

    private void queryJspDirective(CompletionResultSet result, JTextComponent component, int offset, JspSyntaxSupport sup, SyntaxElement.Directive elem, BaseDocument doc) throws BadLocationException {
        int removeLength;
        TokenItem item = sup.getItemAtOrBefore(offset);
        if (item == null) {
            return;
        }
        TokenID id = item.getTokenID();
        String tokenPart = item.getImage().substring(0, offset - item.getOffset());
        String token = item.getImage().trim();
        if (id.getNumericID() == 4) {
            AttributeValueSupport attSup;
            String attrName;
            if (tokenPart.startsWith("<")) {
                removeLength = tokenPart.length();
                this.addDirectiveItems(result, offset - removeLength, sup.getDirectives(""));
            }
            if (tokenPart.endsWith("\"") && (attrName = this.findAttributeForValue(sup, item)) != null && (attSup = AttributeValueSupport.getSupport(false, elem.getName(), attrName)) != null) {
                attSup.result(result, component, offset, sup, elem, "");
            }
        }
        if (id.getNumericID() == 3 || id.getNumericID() == 11 || id.getNumericID() == 9) {
            if (this.isBlank(tokenPart.charAt(tokenPart.length() - 1)) || tokenPart.equals("\n")) {
                TokenItem prevItem = item.getPrevious();
                TokenID prevId = prevItem.getTokenID();
                String prevToken = prevItem.getImage().trim();
                if (prevId.getNumericID() == 3 || prevId.getNumericID() == 8 || prevId.getNumericID() == 11 || prevId.getNumericID() == 9) {
                    this.addAttributeItems(result, offset, sup, elem, sup.getDirectiveAttributes(elem.getName(), ""), null);
                } else if (prevId.getNumericID() == 4 && prevToken.equals("<%@")) {
                    int removeLength2 = tokenPart.length() + "<%@".length();
                    this.addDirectiveItems(result, offset - removeLength2, sup.getDirectives(""));
                }
            } else {
                TagInfo directive;
                List list;
                boolean add = true;
                int whitespaceLength = 0;
                TokenItem prevItem = item.getPrevious();
                TokenID prevId = prevItem.getTokenID();
                if (prevId.getNumericID() == 3 && "".equals(prevItem.getImage().trim())) {
                    whitespaceLength = prevItem.getImage().length();
                }
                if ((list = sup.getDirectives(tokenPart)).size() == 1 && (directive = (TagInfo)list.get(0)).getTagName().equalsIgnoreCase(tokenPart)) {
                    add = false;
                }
                if (add) {
                    int removeLength3 = whitespaceLength + tokenPart.length() + "<%@".length();
                    this.addDirectiveItems(result, offset - removeLength3, list);
                }
            }
        }
        if (id.getNumericID() == 7) {
            if (this.isBlank(tokenPart.charAt(tokenPart.length() - 1))) {
                this.addAttributeItems(result, offset, sup, elem, sup.getDirectiveAttributes(elem.getName(), ""), null);
            } else {
                removeLength = tokenPart.length();
                this.addAttributeItems(result, offset - removeLength, sup, elem, sup.getDirectiveAttributes(elem.getName(), tokenPart), token);
            }
        }
        if (id.getNumericID() == 8) {
            AttributeValueSupport attSup;
            String valuePart = tokenPart;
            for (item = item.getPrevious(); item != null && (item.getTokenID().getNumericID() == 8 || item.getTokenID().getNumericID() == 9); item = item.getPrevious()) {
                valuePart = item.getImage() + valuePart;
            }
            valuePart = valuePart.substring(1);
            String attrName = this.findAttributeForValue(sup, item);
            if (attrName != null && (attSup = AttributeValueSupport.getSupport(false, elem.getName(), attrName)) != null) {
                attSup.result(result, component, offset, sup, elem, valuePart);
            }
        }
    }

    private void queryJspTagInContent(CompletionResultSet result, int offset, JspSyntaxSupport sup, BaseDocument doc) throws BadLocationException {
        TokenItem item = sup.getItemAtOrBefore(offset);
        if (item == null) {
            return;
        }
        String tokenPart = item.getImage().substring(0, offset - item.getOffset() >= item.getImage().length() ? item.getImage().length() : offset - item.getOffset());
        int ltIndex = tokenPart.lastIndexOf(60);
        if (ltIndex != -1) {
            tokenPart = tokenPart.substring(ltIndex + 1);
        }
        while (ltIndex == -1) {
            if ((item = item.getPrevious()) == null) {
                return;
            }
            String newImage = item.getImage();
            ltIndex = newImage.lastIndexOf(60);
            tokenPart = ltIndex != -1 ? newImage.substring(ltIndex + 1) + tokenPart : newImage + tokenPart;
            if (tokenPart.length() <= 20) continue;
            return;
        }
        int removeLength = tokenPart.length();
        if (tokenPart.startsWith("/")) {
            tokenPart = tokenPart.substring(1);
            int anchor = offset - removeLength + 1;
            result.setAnchorOffset(anchor);
            result.addAllItems(sup.getPossibleEndTags(offset, anchor, tokenPart, true));
        } else {
            int semiColonPos = tokenPart.indexOf(58);
            if (semiColonPos >= 0) {
                Map tagLibMappings = sup.getTagLibraryMappings();
                if (tagLibMappings != null) {
                    int anchor = offset - tokenPart.length();
                    String prefix = tokenPart.substring(0, semiColonPos);
                    String tagNamePrefix = tokenPart.substring(semiColonPos + 1);
                    String uri = StandardTagLibraryPrefixes.get(prefix);
                    Object v = tagLibMappings.get(uri);
                    if (v instanceof String[]) {
                        String[] vals = (String[])v;
                        String jarPath = vals[0];
                        String tldPath = vals[1];
                        String FILE_PREFIX = "file:/";
                        if (jarPath.startsWith(FILE_PREFIX)) {
                            jarPath = '/' + jarPath.substring(FILE_PREFIX.length());
                        }
                        try {
                            JarFileSystem jfs = new JarFileSystem(FileUtil.normalizeFile((File)new File(jarPath)));
                            FileObject tldFile = jfs.getRoot().getFileObject(tldPath);
                            TldLibrary tldLib = TldLibrary.create(tldFile);
                            for (String tagName : tldLib.getTags().keySet()) {
                                if (!tagName.startsWith(tagNamePrefix)) continue;
                                result.addItem(new JspCompletionItem.UnresolvedPrefixTag(prefix + ":" + tagName, anchor, uri, prefix));
                            }
                        }
                        catch (Exception ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }
            } else {
                int anchor = offset - removeLength;
                result.setAnchorOffset(anchor);
                this.addTagPrefixItems(result, anchor, sup, sup.getTagPrefixes(tokenPart));
            }
        }
    }

    private void queryJspDirectiveInContent(CompletionResultSet result, JTextComponent component, int offset, JspSyntaxSupport sup, BaseDocument doc) throws BadLocationException {
        TokenItem item = sup.getItemAtOrBefore(offset);
        if (item == null) {
            return;
        }
        String tokenPart = item.getImage().substring(0, offset - item.getOffset() >= item.getImage().length() ? item.getImage().length() : offset - item.getOffset());
        if (!tokenPart.equals("<") && !tokenPart.equals("<%")) {
            return;
        }
        this.addDirectiveItems(result, offset - tokenPart.length(), sup.getDirectives(""));
    }

    private void queryJspCommentContent(CompletionResultSet result, int offset, BaseDocument doc) throws BadLocationException {
        boolean boundary;
        TokenHierarchy th = TokenHierarchy.get((Document)doc);
        TokenSequence ts = th.tokenSequence(JspTokenId.language());
        int diff = ts.move(offset);
        boolean bl = boundary = diff == 0 && ts.movePrevious();
        if (boundary || ts.moveNext() || ts.movePrevious()) {
            Token t = ts.token();
            if (boundary) {
                diff = t.length();
            }
            assert (t != null);
            assert (t.id() == JspTokenId.COMMENT || t.id() == JspTokenId.EOL);
            CharSequence pretext = t.text().subSequence(Math.max(0, diff - 3), diff);
            int match = this.postfixMatch(pretext, JSP_COMMENT_END_DELIMITER);
            if (match > 0 && match < JSP_COMMENT_END_DELIMITER.length()) {
                result.addItem(JspCompletionItem.createDelimiter(JSP_COMMENT_END_DELIMITER, offset - match));
            }
        }
    }

    int postfixMatch(CharSequence text, CharSequence postfix) {
        if (text.length() > postfix.length()) {
            text = text.subSequence(text.length() - postfix.length(), text.length());
        }
        int match = 0;
        for (int i = text.length() - 1; i >= 0; --i) {
            CharSequence subpattern;
            CharSequence subtext = text.subSequence(i, text.length());
            if (!CharSequenceUtilities.equals((CharSequence)subtext, (Object)(subpattern = postfix.subSequence(0, subtext.length())))) continue;
            match = subtext.length();
        }
        return match;
    }

    private boolean isBlank(char c) {
        return c == ' ';
    }

    protected String findAttributeForValue(JspSyntaxSupport sup, TokenItem item) {
        while (item != null && item.getTokenID().getNumericID() == 8) {
            item = item.getPrevious();
        }
        String symbols = "";
        while (item != null && item.getTokenID().getNumericID() == 4) {
            symbols = item.getImage() + symbols;
            item = item.getPrevious();
        }
        if (!sup.isValueBeginning(symbols)) {
            return null;
        }
        String attributeName = "";
        while (item != null && item.getImage().trim().length() == 0) {
            item = item.getPrevious();
        }
        while (item != null && item.getTokenID().getNumericID() == 7) {
            attributeName = item.getImage() + attributeName;
            item = item.getPrevious();
        }
        if (attributeName.trim().length() > 0) {
            return attributeName.trim();
        }
        return null;
    }

    private void addTagPrefixItems(CompletionResultSet result, int anchor, JspSyntaxSupport sup, String prefix, List tagStringItems, SyntaxElement.Tag set) {
        for (int i = 0; i < tagStringItems.size(); ++i) {
            Object item = tagStringItems.get(i);
            if (item instanceof TagInfo) {
                result.addItem(JspCompletionItem.createPrefixTag(prefix, anchor, (TagInfo)item, set));
                continue;
            }
            result.addItem(JspCompletionItem.createPrefixTag(prefix + ":" + (String)item, anchor));
        }
    }

    private void addTagPrefixItems(CompletionResultSet result, int anchor, JspSyntaxSupport sup, List<Object> prefixStringItems) {
        for (int i = 0; i < prefixStringItems.size(); ++i) {
            String prefix = (String)prefixStringItems.get(i);
            List tags = sup.getTags(prefix, "");
            for (int j = 0; j < tags.size(); ++j) {
                Object item = tags.get(j);
                if (item instanceof TagInfo) {
                    result.addItem(JspCompletionItem.createPrefixTag(prefix, anchor, (TagInfo)item));
                    continue;
                }
                result.addItem(JspCompletionItem.createPrefixTag(prefix + ":" + (String)item, anchor));
            }
        }
    }

    private void addDirectiveItems(CompletionResultSet result, int anchor, List<TagInfo> directiveStringItems) {
        for (int i = 0; i < directiveStringItems.size(); ++i) {
            TagInfo item = directiveStringItems.get(i);
            result.addItem(JspCompletionItem.createDirective(item.getTagName(), anchor, item));
        }
    }

    private void addDelimiterItems(CompletionResultSet result, int anchor, String prefix) {
        for (String delimiter : JSP_DELIMITERS) {
            if (!delimiter.startsWith(prefix)) continue;
            result.addItem(JspCompletionItem.createDelimiter(delimiter, anchor));
        }
    }

    private void addAttributeItems(CompletionResultSet result, int offset, JspSyntaxSupport sup, SyntaxElement.TagDirective tagDir, List attributeItems, String currentAttr) {
        for (int i = 0; i < attributeItems.size(); ++i) {
            Object item = attributeItems.get(i);
            String attr = item instanceof TagAttributeInfo ? ((TagAttributeInfo)item).getName() : (String)item;
            boolean isThere = tagDir.getAttributes().keySet().contains(attr);
            if (isThere && !attr.equalsIgnoreCase(currentAttr) && (currentAttr == null || !attr.startsWith(currentAttr) || attr.length() <= currentAttr.length() || isThere)) continue;
            if (item instanceof TagAttributeInfo) {
                if ("taglib".equalsIgnoreCase(tagDir.getName())) {
                    if (!attr.equalsIgnoreCase("prefix") && (!attr.equalsIgnoreCase("uri") || tagDir.getAttributes().keySet().contains("tagdir")) && (!attr.equalsIgnoreCase("tagdir") || tagDir.getAttributes().keySet().contains("uri"))) continue;
                    result.addItem(JspCompletionItem.createAttribute(offset, (TagAttributeInfo)item));
                    continue;
                }
                result.addItem(JspCompletionItem.createAttribute(offset, (TagAttributeInfo)item));
                continue;
            }
            result.addItem(JspCompletionItem.createAttribute((String)item, offset));
        }
    }

    public static class CompletionResultSet<T extends CompletionItem> {
        private List<T> items = new ArrayList<T>();
        private int anchor = -1;

        public int getAnchor() {
            return this.anchor;
        }

        public List<? extends CompletionItem> getItems() {
            return this.items;
        }

        public void setAnchorOffset(int anchor) {
            this.anchor = anchor;
        }

        public void addItem(T item) {
            this.items.add(item);
        }

        public void addAllItems(Collection<T> items) {
            this.items.addAll(items);
        }
    }
}

