/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.actions;

import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.Location;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.StepRequest;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.logging.Logger;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.debugger.jpda.SmartSteppingFilter;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointListener;
import org.netbeans.modules.debugger.jpda.ExpressionPool;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.JPDAStepImpl;
import org.netbeans.modules.debugger.jpda.SourcePath;
import org.netbeans.modules.debugger.jpda.actions.CompoundSmartSteppingListener;
import org.netbeans.modules.debugger.jpda.actions.JPDADebuggerActionProvider;
import org.netbeans.modules.debugger.jpda.actions.SmartSteppingFilterImpl;
import org.netbeans.modules.debugger.jpda.actions.StepIntoActionProvider;
import org.netbeans.modules.debugger.jpda.jdi.IllegalThreadStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidRequestStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidStackFrameExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocatableWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocationWrapper;
import org.netbeans.modules.debugger.jpda.jdi.MethodWrapper;
import org.netbeans.modules.debugger.jpda.jdi.MirrorWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.StackFrameWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ThreadReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.TypeComponentWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.EventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.LocatableEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestManagerWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.StepRequestWrapper;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.util.Executor;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.openide.util.Exceptions;

public class StepActionProvider
extends JPDADebuggerActionProvider
implements Executor {
    private StepRequest stepRequest;
    private ContextProvider lookupProvider;
    private JPDAStepImpl.MethodExitBreakpointListener lastMethodExitBreakpointListener;
    private boolean isSyntheticLocation;
    private boolean smartSteppingStepOut;
    private Properties p;
    private static boolean ssverbose = System.getProperty("netbeans.debugger.smartstepping") != null;
    private static Logger logger = Logger.getLogger("org.netbeans.modules.debugger.jpda.jdievents");
    private StepIntoActionProvider stepIntoActionProvider;
    private SmartSteppingFilterImpl smartSteppingFilterImpl;
    private CompoundSmartSteppingListener compoundSmartSteppingListener;

    private static int getJDIAction(Object action) {
        if (action == ActionsManager.ACTION_STEP_OUT) {
            return 3;
        }
        if (action == ActionsManager.ACTION_STEP_OVER) {
            return 2;
        }
        throw new IllegalArgumentException();
    }

    public StepActionProvider(ContextProvider lookupProvider) {
        super((JPDADebuggerImpl)((Object)lookupProvider.lookupFirst(null, JPDADebugger.class)));
        this.lookupProvider = lookupProvider;
        this.setProviderToDisableOnLazyAction(this);
        Map properties = (Map)lookupProvider.lookupFirst(null, Map.class);
        if (properties != null) {
            this.smartSteppingStepOut = properties.containsKey("SS_ACTION_STEPOUT");
        }
        this.p = Properties.getDefault().getProperties("debugger.options.JPDA");
    }

    public Set getActions() {
        return new HashSet<Object>(Arrays.asList(ActionsManager.ACTION_STEP_OUT, ActionsManager.ACTION_STEP_OVER));
    }

    public void doAction(Object action) {
        this.runAction(action);
    }

    public void postAction(final Object action, final Runnable actionPerformedNotifier) {
        this.doLazyAction(action, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    StepActionProvider.this.runAction(action);
                }
                finally {
                    actionPerformedNotifier.run();
                }
            }
        });
    }

    public void runAction(Object action) {
        this.runAction(action, true, null);
    }

    /*
     * Exception decompiling
     */
    private void runAction(Object action, boolean doResume, Lock lock) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void addMethodExitBP(ThreadReference tr, JPDAThread jtr) throws VMDisconnectedExceptionWrapper, InternalExceptionWrapper, InvalidStackFrameExceptionWrapper, ObjectCollectedExceptionWrapper {
        Location loc;
        if (!MirrorWrapper.virtualMachine(tr).canGetMethodReturnValues()) {
            return;
        }
        try {
            loc = StackFrameWrapper.location(ThreadReferenceWrapper.frame(tr, 0));
        }
        catch (IncompatibleThreadStateException ex) {
            logger.fine("Incompatible Thread State: " + ex.getLocalizedMessage());
            return;
        }
        catch (IllegalThreadStateExceptionWrapper ex) {
            return;
        }
        catch (IndexOutOfBoundsException ex) {
            return;
        }
        String classType = ReferenceTypeWrapper.name(LocationWrapper.declaringType(loc));
        String methodName = TypeComponentWrapper.name(LocationWrapper.method(loc));
        MethodBreakpoint mb = MethodBreakpoint.create((String)classType, (String)methodName);
        mb.setBreakpointType(2);
        mb.setHidden(true);
        mb.setSuspend(0);
        mb.setThreadFilters((JPDADebugger)this.getDebuggerImpl(), new JPDAThread[]{jtr});
        this.lastMethodExitBreakpointListener = new JPDAStepImpl.MethodExitBreakpointListener(mb);
        mb.addJPDABreakpointListener((JPDABreakpointListener)this.lastMethodExitBreakpointListener);
        try {
            Method setSessionMethod = JPDABreakpoint.class.getDeclaredMethod("setSession", JPDADebugger.class);
            setSessionMethod.setAccessible(true);
            setSessionMethod.invoke((Object)mb, new Object[]{this.debugger});
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)mb);
    }

    @Override
    protected void checkEnabled(int debuggerState) {
        for (Object e : this.getActions()) {
            this.getDebuggerImpl();
            this.setEnabled(e, debuggerState == 3 && this.getDebuggerImpl().getCurrentThread() != null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean exec(Event ev) {
        try {
            StepRequest sr = (StepRequest)EventWrapper.request(ev);
            JPDAThreadImpl st = this.getDebuggerImpl().getThread(StepRequestWrapper.thread(sr));
            st.setInStep(false, null);
            LocatableEvent event = (LocatableEvent)ev;
            String className = ReferenceTypeWrapper.name(LocationWrapper.declaringType(LocatableWrapper.location(event)));
            ThreadReference tr = LocatableEventWrapper.thread(event);
            this.setLastOperation(tr);
            this.removeStepRequests(tr);
            Lock lock = this.getDebuggerImpl().getSuspend() == 1 ? st.accessLock.writeLock() : this.getDebuggerImpl().accessLock.writeLock();
            lock.lock();
            try {
                boolean useStepFilters;
                boolean stepThrough;
                int suspendPolicy = this.getDebuggerImpl().getSuspend();
                if (this.isSyntheticLocation) {
                    int step = StepRequestWrapper.depth((StepRequest)EventWrapper.request(ev));
                    VirtualMachine vm = this.getDebuggerImpl().getVirtualMachine();
                    if (vm == null) {
                        this.removeBPListener();
                        boolean bl = false;
                        return bl;
                    }
                    this.stepRequest = EventRequestManagerWrapper.createStepRequest(VirtualMachineWrapper.eventRequestManager(vm), tr, -2, step);
                    EventRequestWrapper.addCountFilter(this.stepRequest, 1);
                    this.getDebuggerImpl().getOperator().register(this.stepRequest, this);
                    EventRequestWrapper.setSuspendPolicy(this.stepRequest, suspendPolicy);
                    try {
                        EventRequestWrapper.enable(this.stepRequest);
                    }
                    catch (IllegalThreadStateException itsex) {
                        this.getDebuggerImpl().getOperator().unregister(this.stepRequest);
                        this.stepRequest = null;
                        this.removeBPListener();
                    }
                    catch (InvalidRequestStateExceptionWrapper irse) {
                        Exceptions.printStackTrace((Throwable)irse);
                        this.getDebuggerImpl().getOperator().unregister(this.stepRequest);
                        this.stepRequest = null;
                        this.removeBPListener();
                    }
                    boolean irse = true;
                    return irse;
                }
                boolean fsh = this.getSmartSteppingFilterImpl().stopHere(className);
                if (ssverbose) {
                    System.out.println("SS  SmartSteppingFilter.stopHere (" + className + ") ? " + fsh);
                }
                if (fsh) {
                    JPDAThreadImpl t = this.getDebuggerImpl().getThread(tr);
                    if (this.getCompoundSmartSteppingListener().stopHere(this.lookupProvider, t, this.getSmartSteppingFilterImpl())) {
                        boolean irse = false;
                        return irse;
                    }
                }
                if (ssverbose) {
                    System.out.println("\nSS:  SMART STEPPING START! ********** ");
                }
                boolean bl = stepThrough = (useStepFilters = this.p.getBoolean("UseStepFilters", true)) && this.p.getBoolean("StepThroughFilters", false);
                if (!stepThrough || this.smartSteppingStepOut) {
                    this.getStepIntoActionProvider().runAction(ActionsManager.ACTION_STEP_OUT, false, lock);
                } else {
                    int origDepth = StepRequestWrapper.depth(sr);
                    if (origDepth == 2) {
                        this.runAction(ActionsManager.ACTION_STEP_OVER, false, lock);
                    } else if (origDepth == 3) {
                        this.runAction(ActionsManager.ACTION_STEP_OUT, false, lock);
                    } else {
                        this.getStepIntoActionProvider().runAction("smartStepInto", false, lock);
                    }
                }
                boolean bl2 = true;
                return bl2;
            }
            finally {
                lock.unlock();
            }
        }
        catch (InternalExceptionWrapper e) {
            return false;
        }
        catch (VMDisconnectedExceptionWrapper e) {
            return false;
        }
        catch (ObjectCollectedExceptionWrapper e) {
            return false;
        }
    }

    @Override
    public void removed(EventRequest eventRequest) {
        StepRequest sr = (StepRequest)eventRequest;
        try {
            JPDAThreadImpl st = this.getDebuggerImpl().getThread(StepRequestWrapper.thread(sr));
            st.setInStep(false, null);
        }
        catch (InternalExceptionWrapper ex) {
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            // empty catch block
        }
        if (!this.isSyntheticLocation && this.lastMethodExitBreakpointListener != null) {
            this.lastMethodExitBreakpointListener.destroy();
            this.lastMethodExitBreakpointListener = null;
        }
    }

    private void removeBPListener() {
        this.isSyntheticLocation = false;
        if (this.lastMethodExitBreakpointListener != null) {
            this.lastMethodExitBreakpointListener.destroy();
            this.lastMethodExitBreakpointListener = null;
        }
    }

    private void setLastOperation(ThreadReference tr) throws VMDisconnectedExceptionWrapper {
        Variable returnValue = null;
        if (this.lastMethodExitBreakpointListener != null) {
            returnValue = this.lastMethodExitBreakpointListener.getReturnValue();
        }
        boolean bl = this.isSyntheticLocation = !StepActionProvider.setLastOperation(tr, this.getDebuggerImpl(), returnValue);
        if (!this.isSyntheticLocation && this.lastMethodExitBreakpointListener != null) {
            this.lastMethodExitBreakpointListener.destroy();
            this.lastMethodExitBreakpointListener = null;
        }
    }

    public static boolean setLastOperation(ThreadReference tr, JPDADebuggerImpl debugger, Variable returnValue) throws VMDisconnectedExceptionWrapper {
        byte[] bytecodes;
        int codeIndex;
        String url;
        Location loc;
        try {
            loc = StackFrameWrapper.location(ThreadReferenceWrapper.frame(tr, 0));
        }
        catch (IncompatibleThreadStateException itsex) {
            Exceptions.printStackTrace((Throwable)itsex);
            logger.fine("Incompatible Thread State: " + itsex.getLocalizedMessage());
            return true;
        }
        catch (IllegalThreadStateExceptionWrapper itsex) {
            return true;
        }
        catch (InternalExceptionWrapper iex) {
            return true;
        }
        catch (InvalidStackFrameExceptionWrapper iex) {
            return true;
        }
        catch (ObjectCollectedExceptionWrapper iex) {
            return true;
        }
        try {
            if (TypeComponentWrapper.isSynthetic0(LocationWrapper.method(loc))) {
                return false;
            }
        }
        catch (InternalExceptionWrapper ex) {
            // empty catch block
        }
        Session currentSession = DebuggerManager.getDebuggerManager().getCurrentSession();
        String language = currentSession == null ? null : currentSession.getCurrentLanguage();
        SourcePath sourcePath = debugger.getEngineContext();
        try {
            url = sourcePath.getURL(loc, language);
        }
        catch (InternalExceptionWrapper iex) {
            return true;
        }
        catch (ObjectCollectedExceptionWrapper iex) {
            return true;
        }
        ExpressionPool exprPool = debugger.getExpressionPool();
        ExpressionPool.Expression expr = exprPool.getExpressionAt(loc, url);
        if (expr == null) {
            return true;
        }
        EditorContext.Operation[] ops = expr.getOperations();
        try {
            codeIndex = (int)LocationWrapper.codeIndex(loc);
            bytecodes = MethodWrapper.bytecodes(LocationWrapper.method(loc));
        }
        catch (InternalExceptionWrapper iex) {
            return false;
        }
        codeIndex = codeIndex >= 5 && (bytecodes[codeIndex - 5] & 0xFF) == 185 ? (codeIndex -= 5) : (codeIndex -= 3);
        int opIndex = expr.findNextOperationIndex(codeIndex - 1);
        if (opIndex < 0 || ops[opIndex].getBytecodeIndex() != codeIndex) {
            return true;
        }
        EditorContext.Operation lastOperation = ops[opIndex];
        lastOperation.setReturnValue(returnValue);
        JPDAThreadImpl jtr = debugger.getThread(tr);
        jtr.addLastOperation(lastOperation);
        jtr.setCurrentOperation(lastOperation);
        return true;
    }

    private StepIntoActionProvider getStepIntoActionProvider() {
        if (this.stepIntoActionProvider == null) {
            this.stepIntoActionProvider = StepIntoActionProvider.instanceByContext.get(this.lookupProvider).get();
        }
        return this.stepIntoActionProvider;
    }

    private SmartSteppingFilterImpl getSmartSteppingFilterImpl() {
        if (this.smartSteppingFilterImpl == null) {
            this.smartSteppingFilterImpl = (SmartSteppingFilterImpl)this.lookupProvider.lookupFirst(null, SmartSteppingFilter.class);
        }
        return this.smartSteppingFilterImpl;
    }

    private CompoundSmartSteppingListener getCompoundSmartSteppingListener() {
        if (this.compoundSmartSteppingListener == null) {
            this.compoundSmartSteppingListener = (CompoundSmartSteppingListener)((Object)this.lookupProvider.lookupFirst(null, CompoundSmartSteppingListener.class));
        }
        return this.compoundSmartSteppingListener;
    }
}

