/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.jdi;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.debugger.jpda.JDIExceptionReporter;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;

public final class ArrayReferenceWrapper {
    private ArrayReferenceWrapper() {
    }

    public static Value getValue(ArrayReference a, int b) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ArrayReference", "getValue", "JDI CALL: com.sun.jdi.ArrayReference({0}).getValue({1})", new Object[]{a, b});
        }
        Object retValue = null;
        try {
            Value ret = a.getValue(b);
            retValue = ret;
            Value value = ret;
            return value;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (ObjectCollectedException ex) {
            retValue = ex;
            throw new ObjectCollectedExceptionWrapper(ex);
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ArrayReference", "getValue", retValue);
            }
        }
    }

    public static List<Value> getValues0(ArrayReference a) {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ArrayReference", "getValues", "JDI CALL: com.sun.jdi.ArrayReference({0}).getValues()", new Object[]{a});
        }
        Object retValue = null;
        try {
            List<Value> ret = a.getValues();
            retValue = ret;
            List<Value> list = ret;
            return list;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            List<Value> list = Collections.emptyList();
            return list;
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            List<Value> list = Collections.emptyList();
            return list;
        }
        catch (ObjectCollectedException ex) {
            retValue = ex;
            List<Value> list = Collections.emptyList();
            return list;
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ArrayReference", "getValues", retValue);
            }
        }
    }

    public static List<Value> getValues(ArrayReference a) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ArrayReference", "getValues", "JDI CALL: com.sun.jdi.ArrayReference({0}).getValues()", new Object[]{a});
        }
        Object retValue = null;
        try {
            List<Value> ret = a.getValues();
            retValue = ret;
            List<Value> list = ret;
            return list;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (ObjectCollectedException ex) {
            retValue = ex;
            throw new ObjectCollectedExceptionWrapper(ex);
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ArrayReference", "getValues", retValue);
            }
        }
    }

    public static List<Value> getValues0(ArrayReference a, int b, int c) {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ArrayReference", "getValues", "JDI CALL: com.sun.jdi.ArrayReference({0}).getValues({1}, {2})", new Object[]{a, b, c});
        }
        Object retValue = null;
        try {
            List<Value> ret = a.getValues(b, c);
            retValue = ret;
            List<Value> list = ret;
            return list;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            List<Value> list = Collections.emptyList();
            return list;
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            List<Value> list = Collections.emptyList();
            return list;
        }
        catch (ObjectCollectedException ex) {
            retValue = ex;
            List<Value> list = Collections.emptyList();
            return list;
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ArrayReference", "getValues", retValue);
            }
        }
    }

    public static List<Value> getValues(ArrayReference a, int b, int c) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ArrayReference", "getValues", "JDI CALL: com.sun.jdi.ArrayReference({0}).getValues({1}, {2})", new Object[]{a, b, c});
        }
        Object retValue = null;
        try {
            List<Value> ret = a.getValues(b, c);
            retValue = ret;
            List<Value> list = ret;
            return list;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (ObjectCollectedException ex) {
            retValue = ex;
            throw new ObjectCollectedExceptionWrapper(ex);
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ArrayReference", "getValues", retValue);
            }
        }
    }

    public static int length0(ArrayReference a) {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ArrayReference", "length", "JDI CALL: com.sun.jdi.ArrayReference({0}).length()", new Object[]{a});
        }
        Serializable retValue = null;
        try {
            int ret = a.length();
            retValue = Integer.valueOf(ret);
            int n = ret;
            return n;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            int n = 0;
            return n;
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            int n = 0;
            return n;
        }
        catch (ObjectCollectedException ex) {
            retValue = ex;
            int n = 0;
            return n;
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ArrayReference", "length", retValue);
            }
        }
    }

    public static int length(ArrayReference a) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ArrayReference", "length", "JDI CALL: com.sun.jdi.ArrayReference({0}).length()", new Object[]{a});
        }
        Serializable retValue = null;
        try {
            int ret = a.length();
            retValue = Integer.valueOf(ret);
            int n = ret;
            return n;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (ObjectCollectedException ex) {
            retValue = ex;
            throw new ObjectCollectedExceptionWrapper(ex);
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ArrayReference", "length", retValue);
            }
        }
    }

    public static void setValue(ArrayReference a, int b, Value c) throws InvalidTypeException, ClassNotLoadedException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ArrayReference", "setValue", "JDI CALL: com.sun.jdi.ArrayReference({0}).setValue({1}, {2})", new Object[]{a, b, c});
        }
        try {
            a.setValue(b, c);
        }
        catch (InternalException ex) {
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (ObjectCollectedException ex) {
            throw new ObjectCollectedExceptionWrapper(ex);
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ArrayReference", "setValue", JDIExceptionReporter.RET_VOID);
            }
        }
    }

    public static void setValues(ArrayReference a, int b, List<? extends Value> c, int d, int e) throws InvalidTypeException, ClassNotLoadedException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ArrayReference", "setValues", "JDI CALL: com.sun.jdi.ArrayReference({0}).setValues({1}, {2}, {3}, {4})", new Object[]{a, b, c, d, e});
        }
        try {
            a.setValues(b, c, d, e);
        }
        catch (InternalException ex) {
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (ObjectCollectedException ex) {
            throw new ObjectCollectedExceptionWrapper(ex);
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ArrayReference", "setValues", JDIExceptionReporter.RET_VOID);
            }
        }
    }

    public static void setValues(ArrayReference a, List<? extends Value> b) throws InvalidTypeException, ClassNotLoadedException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ArrayReference", "setValues", "JDI CALL: com.sun.jdi.ArrayReference({0}).setValues({1})", new Object[]{a, b});
        }
        try {
            a.setValues(b);
        }
        catch (InternalException ex) {
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (ObjectCollectedException ex) {
            throw new ObjectCollectedExceptionWrapper(ex);
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ArrayReference", "setValues", JDIExceptionReporter.RET_VOID);
            }
        }
    }
}

