/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.jdi;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.NativeMethodException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.debugger.jpda.JDIExceptionReporter;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidStackFrameExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.NativeMethodExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;

public final class StackFrameWrapper {
    private StackFrameWrapper() {
    }

    public static List<Value> getArgumentValues0(StackFrame a) throws InvalidStackFrameExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.StackFrame", "getArgumentValues", "JDI CALL: com.sun.jdi.StackFrame({0}).getArgumentValues()", new Object[]{a});
        }
        Object retValue = null;
        try {
            List<Value> ret = a.getArgumentValues();
            retValue = ret;
            List<Value> list = ret;
            return list;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            List<Value> list = Collections.emptyList();
            return list;
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            List<Value> list = Collections.emptyList();
            return list;
        }
        catch (InvalidStackFrameException ex) {
            retValue = ex;
            throw new InvalidStackFrameExceptionWrapper(ex);
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.StackFrame", "getArgumentValues", retValue);
            }
        }
    }

    public static List<Value> getArgumentValues(StackFrame a) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, InvalidStackFrameExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.StackFrame", "getArgumentValues", "JDI CALL: com.sun.jdi.StackFrame({0}).getArgumentValues()", new Object[]{a});
        }
        Object retValue = null;
        try {
            List<Value> ret = a.getArgumentValues();
            retValue = ret;
            List<Value> list = ret;
            return list;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (InvalidStackFrameException ex) {
            retValue = ex;
            throw new InvalidStackFrameExceptionWrapper(ex);
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.StackFrame", "getArgumentValues", retValue);
            }
        }
    }

    public static Value getValue(StackFrame a, LocalVariable b) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, InvalidStackFrameExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.StackFrame", "getValue", "JDI CALL: com.sun.jdi.StackFrame({0}).getValue({1})", new Object[]{a, b});
        }
        Object retValue = null;
        try {
            Value ret = a.getValue(b);
            retValue = ret;
            Value value = ret;
            return value;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (InvalidStackFrameException ex) {
            retValue = ex;
            throw new InvalidStackFrameExceptionWrapper(ex);
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.StackFrame", "getValue", retValue);
            }
        }
    }

    public static Map<LocalVariable, Value> getValues0(StackFrame a, List<? extends LocalVariable> b) throws InvalidStackFrameExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.StackFrame", "getValues", "JDI CALL: com.sun.jdi.StackFrame({0}).getValues({1})", new Object[]{a, b});
        }
        Object retValue = null;
        try {
            Map<LocalVariable, Value> ret = a.getValues(b);
            retValue = ret;
            Map<LocalVariable, Value> map = ret;
            return map;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            Map<LocalVariable, Value> map = Collections.emptyMap();
            return map;
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            Map<LocalVariable, Value> map = Collections.emptyMap();
            return map;
        }
        catch (InvalidStackFrameException ex) {
            retValue = ex;
            throw new InvalidStackFrameExceptionWrapper(ex);
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.StackFrame", "getValues", retValue);
            }
        }
    }

    public static Map<LocalVariable, Value> getValues(StackFrame a, List<? extends LocalVariable> b) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, InvalidStackFrameExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.StackFrame", "getValues", "JDI CALL: com.sun.jdi.StackFrame({0}).getValues({1})", new Object[]{a, b});
        }
        Object retValue = null;
        try {
            Map<LocalVariable, Value> ret = a.getValues(b);
            retValue = ret;
            Map<LocalVariable, Value> map = ret;
            return map;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (InvalidStackFrameException ex) {
            retValue = ex;
            throw new InvalidStackFrameExceptionWrapper(ex);
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.StackFrame", "getValues", retValue);
            }
        }
    }

    public static Location location(StackFrame a) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, InvalidStackFrameExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.StackFrame", "location", "JDI CALL: com.sun.jdi.StackFrame({0}).location()", new Object[]{a});
        }
        Object retValue = null;
        try {
            Location ret = a.location();
            retValue = ret;
            Location location = ret;
            return location;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (InvalidStackFrameException ex) {
            retValue = ex;
            throw new InvalidStackFrameExceptionWrapper(ex);
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.StackFrame", "location", retValue);
            }
        }
    }

    public static void setValue(StackFrame a, LocalVariable b, Value c) throws InvalidTypeException, ClassNotLoadedException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, InvalidStackFrameExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.StackFrame", "setValue", "JDI CALL: com.sun.jdi.StackFrame({0}).setValue({1}, {2})", new Object[]{a, b, c});
        }
        try {
            a.setValue(b, c);
        }
        catch (InternalException ex) {
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (InvalidStackFrameException ex) {
            throw new InvalidStackFrameExceptionWrapper(ex);
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.StackFrame", "setValue", JDIExceptionReporter.RET_VOID);
            }
        }
    }

    public static ObjectReference thisObject(StackFrame a) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, InvalidStackFrameExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.StackFrame", "thisObject", "JDI CALL: com.sun.jdi.StackFrame({0}).thisObject()", new Object[]{a});
        }
        Object retValue = null;
        try {
            ObjectReference ret = a.thisObject();
            retValue = ret;
            ObjectReference objectReference = ret;
            return objectReference;
        }
        catch (InternalException iex) {
            if (iex.errorCode() == 35) {
                ObjectReference objectReference = null;
                return objectReference;
            }
            try {
                throw iex;
            }
            catch (InternalException ex) {
                retValue = ex;
                JDIExceptionReporter.report(ex);
                throw new InternalExceptionWrapper(ex);
            }
            catch (VMDisconnectedException ex) {
                retValue = ex;
                throw new VMDisconnectedExceptionWrapper(ex);
            }
            catch (InvalidStackFrameException ex) {
                retValue = ex;
                throw new InvalidStackFrameExceptionWrapper(ex);
            }
            catch (Error err) {
                retValue = err;
                throw err;
            }
            catch (RuntimeException rex) {
                retValue = rex;
                throw rex;
            }
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.StackFrame", "thisObject", retValue);
            }
        }
    }

    public static ThreadReference thread(StackFrame a) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, InvalidStackFrameExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.StackFrame", "thread", "JDI CALL: com.sun.jdi.StackFrame({0}).thread()", new Object[]{a});
        }
        Object retValue = null;
        try {
            ThreadReference ret = a.thread();
            retValue = ret;
            ThreadReference threadReference = ret;
            return threadReference;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (InvalidStackFrameException ex) {
            retValue = ex;
            throw new InvalidStackFrameExceptionWrapper(ex);
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.StackFrame", "thread", retValue);
            }
        }
    }

    public static LocalVariable visibleVariableByName(StackFrame a, String b) throws AbsentInformationException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, InvalidStackFrameExceptionWrapper, NativeMethodExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.StackFrame", "visibleVariableByName", "JDI CALL: com.sun.jdi.StackFrame({0}).visibleVariableByName({1})", new Object[]{a, b});
        }
        Object retValue = null;
        try {
            LocalVariable ret = a.visibleVariableByName(b);
            retValue = ret;
            LocalVariable localVariable = ret;
            return localVariable;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (InvalidStackFrameException ex) {
            retValue = ex;
            throw new InvalidStackFrameExceptionWrapper(ex);
        }
        catch (NativeMethodException ex) {
            retValue = ex;
            throw new NativeMethodExceptionWrapper(ex);
        }
        catch (AbsentInformationException ex) {
            retValue = ex;
            throw ex;
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.StackFrame", "visibleVariableByName", retValue);
            }
        }
    }

    public static List<LocalVariable> visibleVariables0(StackFrame a) throws AbsentInformationException, InvalidStackFrameExceptionWrapper, NativeMethodExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.StackFrame", "visibleVariables", "JDI CALL: com.sun.jdi.StackFrame({0}).visibleVariables()", new Object[]{a});
        }
        Object retValue = null;
        try {
            List<LocalVariable> ret = a.visibleVariables();
            retValue = ret;
            List<LocalVariable> list = ret;
            return list;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            List<LocalVariable> list = Collections.emptyList();
            return list;
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            List<LocalVariable> list = Collections.emptyList();
            return list;
        }
        catch (InvalidStackFrameException ex) {
            retValue = ex;
            throw new InvalidStackFrameExceptionWrapper(ex);
        }
        catch (NativeMethodException ex) {
            retValue = ex;
            throw new NativeMethodExceptionWrapper(ex);
        }
        catch (AbsentInformationException ex) {
            retValue = ex;
            throw ex;
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.StackFrame", "visibleVariables", retValue);
            }
        }
    }

    public static List<LocalVariable> visibleVariables(StackFrame a) throws AbsentInformationException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, InvalidStackFrameExceptionWrapper, NativeMethodExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.StackFrame", "visibleVariables", "JDI CALL: com.sun.jdi.StackFrame({0}).visibleVariables()", new Object[]{a});
        }
        Object retValue = null;
        try {
            List<LocalVariable> ret = a.visibleVariables();
            retValue = ret;
            List<LocalVariable> list = ret;
            return list;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (InvalidStackFrameException ex) {
            retValue = ex;
            throw new InvalidStackFrameExceptionWrapper(ex);
        }
        catch (NativeMethodException ex) {
            retValue = ex;
            throw new NativeMethodExceptionWrapper(ex);
        }
        catch (AbsentInformationException ex) {
            retValue = ex;
            throw ex;
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.StackFrame", "visibleVariables", retValue);
            }
        }
    }
}

