/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.NativeMethodException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.LocalVariable;
import org.netbeans.api.debugger.jpda.MonitorInfo;
import org.netbeans.api.debugger.jpda.This;
import org.netbeans.modules.debugger.jpda.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.jdi.IllegalThreadStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidStackFrameExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocationWrapper;
import org.netbeans.modules.debugger.jpda.jdi.MethodWrapper;
import org.netbeans.modules.debugger.jpda.jdi.NativeMethodExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.StackFrameWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ThreadReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.TypeComponentWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.models.AbstractVariable;
import org.netbeans.modules.debugger.jpda.models.ArgumentObjectVariable;
import org.netbeans.modules.debugger.jpda.models.ArgumentVariable;
import org.netbeans.modules.debugger.jpda.models.JPDAClassTypeImpl;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.models.Local;
import org.netbeans.modules.debugger.jpda.models.ObjectLocalVariable;
import org.netbeans.modules.debugger.jpda.models.ThisVariable;
import org.netbeans.modules.debugger.jpda.util.JPDAUtils;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.openide.util.NbBundle;

public class CallStackFrameImpl
implements CallStackFrame {
    private final JPDAThreadImpl thread;
    private StackFrame sf;
    private Location sfLocation;
    private int depth;
    private JPDADebuggerImpl debugger;
    private EditorContext.Operation currentOperation;
    private EqualsInfo equalsInfo;
    private boolean valid;

    public CallStackFrameImpl(JPDAThreadImpl thread, StackFrame sf, int depth, JPDADebuggerImpl debugger) {
        this.thread = thread;
        this.sf = sf;
        this.depth = depth;
        this.debugger = debugger;
        this.equalsInfo = new EqualsInfo(debugger, sf, depth);
        this.valid = true;
        try {
            this.sfLocation = StackFrameWrapper.location(sf);
        }
        catch (InternalExceptionWrapper ex) {
        }
        catch (InvalidStackFrameExceptionWrapper ex) {
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            // empty catch block
        }
    }

    public synchronized int getLineNumber(String struts) {
        if (!this.valid && this.sfLocation == null) {
            return 0;
        }
        try {
            Location l = this.getStackFrameLocation();
            return LocationWrapper.lineNumber0(l, struts);
        }
        catch (InvalidStackFrameExceptionWrapper isfex) {
            this.valid = false;
            return 0;
        }
        catch (InternalExceptionWrapper ex) {
            return 0;
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return 0;
        }
    }

    public synchronized EditorContext.Operation getCurrentOperation(String struts) {
        return this.currentOperation;
    }

    public synchronized void setCurrentOperation(EditorContext.Operation operation) {
        this.currentOperation = operation;
    }

    public synchronized String getMethodName() {
        if (!this.valid && this.sfLocation == null) {
            return "";
        }
        try {
            Location l = this.getStackFrameLocation();
            return TypeComponentWrapper.name(LocationWrapper.method(l));
        }
        catch (InvalidStackFrameExceptionWrapper ex) {
            this.valid = false;
            return "";
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return "";
        }
        catch (InternalExceptionWrapper ex) {
            return "";
        }
    }

    public synchronized String getClassName() {
        if (!this.valid && this.sfLocation == null) {
            return "";
        }
        assert (!EventQueue.isDispatchThread());
        try {
            Location l = this.getStackFrameLocation();
            return ReferenceTypeWrapper.name(LocationWrapper.declaringType(l));
        }
        catch (InternalExceptionWrapper ex) {
            return "";
        }
        catch (ObjectCollectedExceptionWrapper ex) {
            return "";
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return "";
        }
        catch (InvalidStackFrameExceptionWrapper ex) {
            this.valid = false;
            return "";
        }
    }

    public synchronized JPDAClassType getClassType() {
        if (!this.valid && this.sfLocation == null) {
            return null;
        }
        try {
            Location l = this.getStackFrameLocation();
            return new JPDAClassTypeImpl(this.debugger, LocationWrapper.declaringType(l));
        }
        catch (InternalExceptionWrapper ex) {
            return null;
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return null;
        }
        catch (InvalidStackFrameExceptionWrapper ex) {
            this.valid = false;
            return null;
        }
    }

    public synchronized String getDefaultStratum() {
        if (!this.valid && this.sfLocation == null) {
            return "";
        }
        try {
            Location l = this.getStackFrameLocation();
            return ReferenceTypeWrapper.defaultStratum(LocationWrapper.declaringType(l));
        }
        catch (InvalidStackFrameExceptionWrapper ex) {
            this.valid = false;
            return "";
        }
        catch (ObjectCollectedExceptionWrapper ex) {
            return "";
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return "";
        }
        catch (InternalExceptionWrapper ex) {
            return "";
        }
    }

    public synchronized List<String> getAvailableStrata() {
        if (!this.valid && this.sfLocation == null) {
            return Collections.emptyList();
        }
        try {
            Location l = this.getStackFrameLocation();
            return ReferenceTypeWrapper.availableStrata(LocationWrapper.declaringType(l));
        }
        catch (InvalidStackFrameExceptionWrapper ex) {
            this.valid = false;
            return Collections.emptyList();
        }
        catch (ObjectCollectedExceptionWrapper ex) {
            return Collections.emptyList();
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return Collections.emptyList();
        }
        catch (InternalExceptionWrapper ex) {
            return Collections.emptyList();
        }
    }

    public String getSourceDebugExtension() {
        if (!this.valid && this.sfLocation == null) {
            return null;
        }
        try {
            Location l = this.getStackFrameLocation();
            if (VirtualMachineWrapper.canGetSourceDebugExtension(l.virtualMachine())) {
                return ReferenceTypeWrapper.sourceDebugExtension(LocationWrapper.declaringType(l));
            }
            return null;
        }
        catch (InvalidStackFrameExceptionWrapper ex) {
            this.valid = false;
            return null;
        }
        catch (ObjectCollectedExceptionWrapper ex) {
            return null;
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return null;
        }
        catch (InternalExceptionWrapper ex) {
            return null;
        }
        catch (AbsentInformationException ex) {
            return null;
        }
    }

    public synchronized String getSourceName(String stratum) throws AbsentInformationException {
        if (!this.valid && this.sfLocation == null) {
            return "";
        }
        assert (!EventQueue.isDispatchThread());
        try {
            Location l = this.getStackFrameLocation();
            return LocationWrapper.sourceName(l, stratum);
        }
        catch (InvalidStackFrameExceptionWrapper ex) {
            this.valid = false;
            return "";
        }
        catch (InternalExceptionWrapper ex) {
            return "";
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return "";
        }
    }

    public synchronized String getSourcePath(String stratum) throws AbsentInformationException {
        if (!this.valid && this.sfLocation == null) {
            return "";
        }
        assert (!EventQueue.isDispatchThread());
        try {
            Location l = this.getStackFrameLocation();
            return LocationWrapper.sourcePath(l, stratum);
        }
        catch (InvalidStackFrameExceptionWrapper ex) {
            this.valid = false;
            return "";
        }
        catch (InternalExceptionWrapper ex) {
            return "";
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return "";
        }
    }

    public LocalVariable[] getLocalVariables() throws AbsentInformationException {
        try {
            Location location = this.getStackFrameLocation();
            String className = ReferenceTypeWrapper.name(LocationWrapper.declaringType(location));
            List<com.sun.jdi.LocalVariable> l = StackFrameWrapper.visibleVariables(this.getStackFrame());
            int n = l.size();
            LocalVariable[] locals = new LocalVariable[n];
            for (int i = 0; i < n; ++i) {
                AbstractVariable localImpl;
                Value v;
                com.sun.jdi.LocalVariable lv = l.get(i);
                LocalVariable local = (LocalVariable)this.debugger.getLocalVariable(lv, v = StackFrameWrapper.getValue(this.getStackFrame(), lv));
                if (local instanceof Local) {
                    localImpl = (Local)local;
                    ((Local)localImpl).setFrame(this);
                    ((Local)localImpl).setClassName(className);
                } else {
                    localImpl = (ObjectLocalVariable)local;
                    ((ObjectLocalVariable)localImpl).setFrame(this);
                    ((ObjectLocalVariable)localImpl).setClassName(className);
                }
                locals[i] = local;
            }
            return locals;
        }
        catch (NativeMethodExceptionWrapper ex) {
            throw new AbsentInformationException("native method");
        }
        catch (InvalidStackFrameExceptionWrapper ex) {
            throw new AbsentInformationException("thread is running");
        }
        catch (ObjectCollectedExceptionWrapper ex) {
            throw new AbsentInformationException("frame class is collected");
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return new LocalVariable[0];
        }
        catch (InternalExceptionWrapper ex) {
            throw new AbsentInformationException(ex.getLocalizedMessage());
        }
    }

    LocalVariable getLocalVariable(String name) throws AbsentInformationException {
        try {
            com.sun.jdi.LocalVariable lv;
            Location l = this.getStackFrameLocation();
            String className = ReferenceTypeWrapper.name(LocationWrapper.declaringType(l));
            try {
                lv = StackFrameWrapper.visibleVariableByName(this.getStackFrame(), name);
            }
            catch (NativeMethodExceptionWrapper ex) {
                lv = null;
            }
            if (lv == null) {
                return null;
            }
            Value v = StackFrameWrapper.getValue(this.getStackFrame(), lv);
            LocalVariable local = (LocalVariable)this.debugger.getLocalVariable(lv, v);
            if (local instanceof Local) {
                Local localImpl = (Local)local;
                localImpl.setFrame(this);
                localImpl.setInnerValue(v);
                localImpl.setClassName(className);
            } else {
                ObjectLocalVariable localImpl = (ObjectLocalVariable)local;
                localImpl.setFrame(this);
                localImpl.setInnerValue(v);
                localImpl.setClassName(className);
            }
            return local;
        }
        catch (NativeMethodException ex) {
            throw new AbsentInformationException("native method");
        }
        catch (InvalidStackFrameExceptionWrapper ex) {
            throw new AbsentInformationException("thread is running");
        }
        catch (ObjectCollectedExceptionWrapper ex) {
            throw new AbsentInformationException("frame class is collected");
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return null;
        }
        catch (InternalExceptionWrapper ex) {
            throw new AbsentInformationException(ex.getLocalizedMessage());
        }
    }

    public LocalVariable[] getMethodArguments() {
        try {
            StackFrame sf = this.getStackFrame();
            String url = this.debugger.getEngineContext().getURL(sf, this.getDefaultStratum());
            List<Value> argValues = CallStackFrameImpl.getArgumentValues(sf);
            if (argValues == null) {
                return null;
            }
            Location l = this.getStackFrameLocation();
            EditorContext.MethodArgument[] argumentNames = EditorContextBridge.getContext().getArguments(url, LocationWrapper.lineNumber(l));
            int n = argValues.size();
            argumentNames = CallStackFrameImpl.checkArgumentCount(argumentNames, argValues, n);
            LocalVariable[] arguments = new LocalVariable[n];
            for (int i = 0; i < n; ++i) {
                Value value = argValues.get(i);
                arguments[i] = value instanceof ObjectReference ? new ArgumentObjectVariable(this.debugger, (ObjectReference)value, argumentNames[i].getName(), argumentNames[i].getType()) : new ArgumentVariable(this.debugger, (PrimitiveValue)value, argumentNames[i].getName(), argumentNames[i].getType());
            }
            return arguments;
        }
        catch (InvalidStackFrameExceptionWrapper e) {
            return new LocalVariable[0];
        }
        catch (InternalExceptionWrapper e) {
            return new LocalVariable[0];
        }
        catch (ObjectCollectedExceptionWrapper e) {
            return new LocalVariable[0];
        }
        catch (VMDisconnectedExceptionWrapper e) {
            return new LocalVariable[0];
        }
    }

    static boolean canFindOperationArguments() {
        return JPDAUtils.IS_JDK_160_02;
    }

    /*
     * Exception decompiling
     */
    List<LocalVariable> findOperationArguments(EditorContext.Operation operation) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [52[CATCHBLOCK]], but top level block is 22[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static EditorContext.MethodArgument[] checkArgumentCount(EditorContext.MethodArgument[] argumentNames, List<Value> argValues, int size) {
        if (argumentNames == null || argumentNames.length != size) {
            argumentNames = new EditorContext.MethodArgument[size];
            for (int i = 0; i < argumentNames.length; ++i) {
                Value v = argValues.get(i);
                String type = v != null ? v.type().name() : Object.class.getName();
                argumentNames[i] = new EditorContext.MethodArgument(NbBundle.getMessage(CallStackFrameImpl.class, (String)"CTL_MethodArgument", (Object)(i + 1)), type, null, null);
            }
        }
        return argumentNames;
    }

    private static List<Value> getArgumentValues(StackFrame sf) {
        try {
            Method m = LocationWrapper.method(StackFrameWrapper.location(sf));
            if (MethodWrapper.isNative(m)) {
                throw new NativeMethodException(TypeComponentWrapper.name(m));
            }
            return StackFrameWrapper.getArgumentValues0(sf);
        }
        catch (InvalidStackFrameExceptionWrapper e) {
            return Collections.emptyList();
        }
        catch (InternalExceptionWrapper e) {
            return Collections.emptyList();
        }
        catch (VMDisconnectedExceptionWrapper e) {
            return Collections.emptyList();
        }
    }

    public synchronized This getThisVariable() {
        ObjectReference thisR;
        if (!this.valid) {
            return null;
        }
        try {
            thisR = StackFrameWrapper.thisObject(this.getStackFrame());
        }
        catch (InvalidStackFrameExceptionWrapper ex) {
            this.valid = false;
            return null;
        }
        catch (InternalExceptionWrapper e) {
            return null;
        }
        catch (VMDisconnectedExceptionWrapper e) {
            return null;
        }
        if (thisR == null) {
            return null;
        }
        return new ThisVariable(this.debugger, thisR, "");
    }

    public void makeCurrent() {
        this.debugger.setCurrentCallStackFrame(this);
    }

    public boolean isCurrent() {
        return this.equals(this.debugger.getCurrentCallStackFrame());
    }

    public synchronized boolean isObsolete() {
        try {
            Location l = this.getStackFrameLocation();
            return MethodWrapper.isObsolete0(LocationWrapper.method(l));
        }
        catch (InvalidStackFrameExceptionWrapper ex) {
            throw ex.getCause();
        }
        catch (InternalExceptionWrapper ex) {
            return false;
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return false;
        }
    }

    public boolean canPop() {
        if (!this.debugger.canPopFrames()) {
            return false;
        }
        try {
            ThreadReference t = StackFrameWrapper.thread(this.getStackFrame());
            if (ThreadReferenceWrapper.frameCount(t) <= 1) {
                return false;
            }
            List<StackFrame> topFrames = ThreadReferenceWrapper.frames(t, 0, 2);
            if (MethodWrapper.isNative(LocationWrapper.method(StackFrameWrapper.location(topFrames.get(0)))) || MethodWrapper.isNative(LocationWrapper.method(StackFrameWrapper.location(topFrames.get(1))))) {
                return false;
            }
        }
        catch (IncompatibleThreadStateException itsex) {
            return false;
        }
        catch (IllegalThreadStateExceptionWrapper itsex) {
            return false;
        }
        catch (InvalidStackFrameExceptionWrapper isex) {
            return false;
        }
        catch (InternalExceptionWrapper iex) {
            return false;
        }
        catch (ObjectCollectedExceptionWrapper ocex) {
            return false;
        }
        catch (VMDisconnectedExceptionWrapper dex) {
            return false;
        }
        return true;
    }

    public void popFrame() {
        try {
            StackFrame frame = this.getStackFrame();
            this.debugger.popFrames(StackFrameWrapper.thread(frame), frame);
        }
        catch (InternalExceptionWrapper ex) {
        }
        catch (VMDisconnectedExceptionWrapper ex) {
        }
        catch (InvalidStackFrameExceptionWrapper ex) {
            throw ex.getCause();
        }
    }

    public JPDAThread getThread() {
        return this.thread;
    }

    private synchronized Location getStackFrameLocation() throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, InvalidStackFrameExceptionWrapper {
        if (this.sfLocation == null) {
            this.sfLocation = StackFrameWrapper.location(this.getStackFrame());
        }
        return this.sfLocation;
    }

    public StackFrame getStackFrame() throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, InvalidStackFrameExceptionWrapper {
        block7: {
            try {
                StackFrameWrapper.thread(this.sf);
            }
            catch (InvalidStackFrameExceptionWrapper isfex) {
                try {
                    ThreadReference ref = this.thread.getThreadReference();
                    if (this.depth >= ThreadReferenceWrapper.frameCount(ref)) {
                        throw isfex;
                    }
                    this.sf = ThreadReferenceWrapper.frame(ref, this.depth);
                    this.sfLocation = StackFrameWrapper.location(this.getStackFrame());
                }
                catch (ObjectCollectedExceptionWrapper ex) {
                    throw isfex;
                }
                catch (IncompatibleThreadStateException ex) {
                    throw isfex;
                }
                catch (IllegalThreadStateExceptionWrapper ex) {
                    throw isfex;
                }
                if (this.equalsInfo.equals(new EqualsInfo(this.debugger, this.sf, this.depth))) break block7;
                throw isfex;
            }
        }
        return this.sf;
    }

    public int getFrameDepth() {
        return this.depth;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CallStackFrameImpl)) {
            return false;
        }
        CallStackFrameImpl frame = (CallStackFrameImpl)o;
        return this.equalsInfo.equals(frame.equalsInfo);
    }

    public synchronized int hashCode() {
        return this.equalsInfo.hashCode();
    }

    public String toString() {
        return "CallStackFrameImpl[" + this.thread + ", depth = " + this.depth + "]";
    }

    public List<MonitorInfo> getOwnedMonitors() {
        List<MonitorInfo> threadMonitors;
        try {
            threadMonitors = this.getThread().getOwnedMonitorsAndFrames();
        }
        catch (InvalidStackFrameException itsex) {
            threadMonitors = Collections.emptyList();
        }
        catch (VMDisconnectedException e) {
            threadMonitors = Collections.emptyList();
        }
        if (threadMonitors.size() == 0) {
            return threadMonitors;
        }
        ArrayList<MonitorInfo> frameMonitors = new ArrayList<MonitorInfo>();
        for (MonitorInfo mi : threadMonitors) {
            if (!this.equals(mi.getFrame())) continue;
            frameMonitors.add(mi);
        }
        return Collections.unmodifiableList(frameMonitors);
    }

    private static final class EqualsInfo {
        private JPDAThread thread;
        private int depth;
        private Location location;

        public EqualsInfo(JPDADebuggerImpl debugger, StackFrame sf, int depth) {
            try {
                this.thread = debugger.getThread(StackFrameWrapper.thread(sf));
                this.depth = depth;
                this.location = StackFrameWrapper.location(sf);
            }
            catch (VMDisconnectedExceptionWrapper e) {
                this.thread = null;
            }
            catch (InternalExceptionWrapper e) {
                this.thread = null;
            }
            catch (InvalidStackFrameExceptionWrapper e) {
                this.thread = null;
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof EqualsInfo)) {
                return false;
            }
            EqualsInfo ei = (EqualsInfo)obj;
            return this.thread == ei.thread && this.depth == ei.depth && ((Object)this.location).equals(ei.location);
        }

        public int hashCode() {
            if (this.thread == null) {
                return 0;
            }
            return this.thread.hashCode() << 8 + this.depth + ((Object)this.location).hashCode() << 4;
        }
    }
}

