/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.Value;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.security.auth.RefreshFailedException;
import javax.security.auth.Refreshable;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Watch;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAWatch;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.expr.EvaluatorExpression;
import org.netbeans.modules.debugger.jpda.models.AbstractObjectVariable;
import org.netbeans.modules.debugger.jpda.models.AbstractVariable;
import org.netbeans.modules.debugger.jpda.models.JPDAObjectWatchImpl;
import org.netbeans.modules.debugger.jpda.models.JPDAWatchImpl;
import org.netbeans.modules.debugger.jpda.models.LocalsTreeModel;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class WatchesModel
implements TreeModel {
    private static boolean verbose = System.getProperty("netbeans.debugger.viewrefresh") != null && System.getProperty("netbeans.debugger.viewrefresh").indexOf(119) >= 0;
    private JPDADebuggerImpl debugger;
    private Listener listener;
    private Vector<ModelListener> listeners = new Vector();
    private ContextProvider lookupProvider;
    private final Map<Watch, JPDAWatchEvaluating> watchToValue = new WeakHashMap<Watch, JPDAWatchEvaluating>();
    private final JPDAWatch EMPTY_WATCH;
    private LocalsTreeModel localsTreeModel;

    public WatchesModel(ContextProvider lookupProvider) {
        this.debugger = (JPDADebuggerImpl)((Object)lookupProvider.lookupFirst(null, JPDADebugger.class));
        this.lookupProvider = lookupProvider;
        this.EMPTY_WATCH = new EmptyWatch();
    }

    public Object getRoot() {
        return "Root";
    }

    public Object[] getChildren(Object parent, int from, int to) throws UnknownTypeException {
        if (parent == "Root") {
            Watch[] ws = DebuggerManager.getDebuggerManager().getWatches();
            to = Math.min(ws.length, to);
            from = Math.min(ws.length, from);
            Watch[] fws = new Watch[to - from];
            System.arraycopy(ws, from, fws, 0, to - from);
            int k = fws.length;
            Object[] jws = new JPDAWatch[k + 1];
            for (int i = 0; i < k; ++i) {
                JPDAWatchEvaluating jw = this.watchToValue.get(fws[i]);
                if (jw == null) {
                    jw = new JPDAWatchEvaluating(this, fws[i], this.debugger);
                    this.watchToValue.put(fws[i], jw);
                }
                jws[i] = jw;
            }
            jws[k] = this.EMPTY_WATCH;
            if (this.listener == null) {
                this.listener = new Listener(this, this.debugger);
            }
            return jws;
        }
        if (parent instanceof JPDAWatchImpl) {
            return this.getLocalsTreeModel().getChildren(parent, from, to);
        }
        return this.getLocalsTreeModel().getChildren(parent, from, to);
    }

    public int getChildrenCount(Object node) throws UnknownTypeException {
        if (node == "Root") {
            if (this.listener == null) {
                this.listener = new Listener(this, this.debugger);
            }
            return Integer.MAX_VALUE;
        }
        if (node instanceof JPDAWatchImpl) {
            return this.getLocalsTreeModel().getChildrenCount(node);
        }
        return this.getLocalsTreeModel().getChildrenCount(node);
    }

    public boolean isLeaf(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return false;
        }
        if (node instanceof JPDAWatchEvaluating) {
            JPDAWatchEvaluating jwe = (JPDAWatchEvaluating)node;
            if (!jwe.isCurrent()) {
                return false;
            }
            JPDAWatch jw = jwe.getEvaluatedWatch();
            if (jw instanceof JPDAWatchImpl) {
                return ((JPDAWatchImpl)jw).isPrimitive();
            }
        }
        if (node == this.EMPTY_WATCH) {
            return true;
        }
        return this.getLocalsTreeModel().isLeaf(node);
    }

    public void addModelListener(ModelListener l) {
        this.listeners.add(l);
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTreeChanged() {
        Map<Watch, JPDAWatchEvaluating> map = this.watchToValue;
        synchronized (map) {
            Iterator<JPDAWatchEvaluating> it = this.watchToValue.values().iterator();
            while (it.hasNext()) {
                it.next().setEvaluated(null);
            }
        }
        Vector v = (Vector)this.listeners.clone();
        int k = v.size();
        ModelEvent.TreeChanged event = new ModelEvent.TreeChanged((Object)this);
        for (int i = 0; i < k; ++i) {
            ((ModelListener)v.get(i)).modelChanged((ModelEvent)event);
        }
    }

    private void fireWatchesChanged() {
        Vector v = (Vector)this.listeners.clone();
        int k = v.size();
        ModelEvent.NodeChanged event = new ModelEvent.NodeChanged((Object)this, (Object)"Root", 8);
        for (int i = 0; i < k; ++i) {
            ((ModelListener)v.get(i)).modelChanged((ModelEvent)event);
        }
    }

    void fireTableValueChangedChanged(Object node, String propertyName) {
        ((JPDAWatchEvaluating)node).setEvaluated(null);
        this.fireTableValueChangedComputed(node, propertyName);
    }

    void fireTableValueChangedComputed(Object node, String propertyName) {
        Vector v = (Vector)this.listeners.clone();
        int k = v.size();
        for (int i = 0; i < k; ++i) {
            ((ModelListener)v.get(i)).modelChanged((ModelEvent)new ModelEvent.TableValueChanged((Object)this, node, propertyName));
        }
    }

    private void fireChildrenChanged(Object node) {
        Vector v = (Vector)this.listeners.clone();
        int k = v.size();
        for (int i = 0; i < k; ++i) {
            ((ModelListener)v.get(i)).modelChanged((ModelEvent)new ModelEvent.NodeChanged((Object)this, node, 8));
        }
    }

    JPDADebuggerImpl getDebugger() {
        return this.debugger;
    }

    LocalsTreeModel getLocalsTreeModel() {
        if (this.localsTreeModel == null) {
            this.localsTreeModel = (LocalsTreeModel)this.lookupProvider.lookupFirst("LocalsView", TreeModel.class);
        }
        return this.localsTreeModel;
    }

    private final class EmptyWatch
    implements JPDAWatch {
        private EmptyWatch() {
        }

        public String getExpression() {
            return "";
        }

        public void setExpression(String expr) {
            String infoStr = NbBundle.getBundle(WatchesModel.class).getString("CTL_WatchesModel_Empty_Watch_Hint");
            infoStr = "<" + infoStr + ">";
            if (expr == null || expr.trim().length() == 0 || infoStr.equals(expr)) {
                return;
            }
            DebuggerManager.getDebuggerManager().createWatch(expr);
            Vector v = (Vector)WatchesModel.this.listeners.clone();
            int k = v.size();
            for (int i = 0; i < k; ++i) {
                ((ModelListener)v.get(i)).modelChanged((ModelEvent)new ModelEvent.NodeChanged((Object)WatchesModel.this, (Object)this));
            }
        }

        public void remove() {
        }

        public String getType() {
            return "";
        }

        public String getValue() {
            return "";
        }

        public String getExceptionDescription() {
            return null;
        }

        public void setValue(String value) throws InvalidExpressionException {
        }

        public String getToStringValue() throws InvalidExpressionException {
            return "";
        }
    }

    private static class Listener
    extends DebuggerManagerAdapter
    implements PropertyChangeListener {
        private WeakReference<WatchesModel> model;
        private WeakReference<JPDADebuggerImpl> debugger;
        private RequestProcessor.Task task;

        private Listener(WatchesModel tm, JPDADebuggerImpl debugger) {
            this.model = new WeakReference<WatchesModel>(tm);
            this.debugger = new WeakReference<JPDADebuggerImpl>(debugger);
            DebuggerManager.getDebuggerManager().addDebuggerListener("watches", (DebuggerManagerListener)this);
            debugger.addPropertyChangeListener(this);
            Watch[] ws = DebuggerManager.getDebuggerManager().getWatches();
            int k = ws.length;
            for (int i = 0; i < k; ++i) {
                ws[i].addPropertyChangeListener((PropertyChangeListener)this);
            }
        }

        private WatchesModel getModel() {
            WatchesModel m = (WatchesModel)this.model.get();
            if (m == null) {
                this.destroy();
            }
            return m;
        }

        public void watchAdded(Watch watch) {
            WatchesModel m = this.getModel();
            if (m == null) {
                return;
            }
            watch.addPropertyChangeListener((PropertyChangeListener)this);
            m.fireWatchesChanged();
        }

        public void watchRemoved(Watch watch) {
            WatchesModel m = this.getModel();
            if (m == null) {
                return;
            }
            watch.removePropertyChangeListener((PropertyChangeListener)this);
            m.fireWatchesChanged();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if (!("state".equals(propName) || "expression".equals(propName) || "currentCallStackFrame".equals(propName))) {
                return;
            }
            final WatchesModel m = this.getModel();
            if (m == null) {
                return;
            }
            if ("state".equals(propName) && m.debugger.getState() == 4) {
                this.destroy();
                return;
            }
            if (m.debugger.getState() == 2 || "currentCallStackFrame".equals(propName) && m.debugger.getCurrentCallStackFrame() == null) {
                return;
            }
            if (evt.getSource() instanceof Watch) {
                Object node;
                Map map = m.watchToValue;
                synchronized (map) {
                    node = m.watchToValue.get(evt.getSource());
                }
                if (node != null) {
                    m.fireTableValueChangedChanged(node, null);
                    return;
                }
            }
            if (this.task == null) {
                this.task = m.debugger.getRequestProcessor().create(new Runnable(){

                    @Override
                    public void run() {
                        if (verbose) {
                            System.out.println("WM do task " + Listener.this.task);
                        }
                        m.fireTreeChanged();
                    }
                });
                if (verbose) {
                    System.out.println("WM  create task " + this.task);
                }
            }
            this.task.schedule(100);
        }

        private void destroy() {
            DebuggerManager.getDebuggerManager().removeDebuggerListener("watches", (DebuggerManagerListener)this);
            JPDADebugger d = (JPDADebugger)this.debugger.get();
            if (d != null) {
                d.removePropertyChangeListener((PropertyChangeListener)this);
            }
            Watch[] ws = DebuggerManager.getDebuggerManager().getWatches();
            int k = ws.length;
            for (int i = 0; i < k; ++i) {
                ws[i].removePropertyChangeListener((PropertyChangeListener)this);
            }
            if (this.task != null) {
                this.task.cancel();
                if (verbose) {
                    System.out.println("WM cancel old task " + this.task);
                }
                this.task = null;
            }
        }
    }

    public static class JPDAWatchEvaluating
    extends AbstractObjectVariable
    implements JPDAWatch,
    Variable,
    Refreshable,
    PropertyChangeListener {
        private WatchesModel model;
        private Watch w;
        private JPDADebuggerImpl debugger;
        private JPDAWatch evaluatedWatch;
        private EvaluatorExpression expression;
        private final boolean[] evaluating = new boolean[]{false};
        private int cloneNumber = 1;

        public JPDAWatchEvaluating(WatchesModel model, Watch w, JPDADebuggerImpl debugger) {
            this(model, w, debugger, 0);
        }

        private JPDAWatchEvaluating(WatchesModel model, Watch w, JPDADebuggerImpl debugger, int cloneNumber) {
            super(debugger, null, cloneNumber > 0 ? w + "_clone" + cloneNumber : "" + w);
            this.model = model;
            this.w = w;
            this.debugger = debugger;
            this.parseExpression(w.getExpression());
            if (cloneNumber == 0) {
                debugger.varChangeSupport.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)debugger.varChangeSupport));
            }
        }

        public Watch getWatch() {
            return this.w;
        }

        private void parseExpression(String exprStr) {
            this.expression = new EvaluatorExpression(exprStr);
        }

        EvaluatorExpression getParsedExpression() {
            return this.expression;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setEvaluated(JPDAWatch evaluatedWatch) {
            JPDAWatchEvaluating jPDAWatchEvaluating = this;
            synchronized (jPDAWatchEvaluating) {
                this.evaluatedWatch = evaluatedWatch;
            }
            if (evaluatedWatch != null) {
                if (evaluatedWatch instanceof JPDAWatchImpl) {
                    this.setInnerValue(((JPDAWatchImpl)evaluatedWatch).getInnerValue());
                } else if (evaluatedWatch instanceof JPDAObjectWatchImpl) {
                    this.setInnerValue(((JPDAObjectWatchImpl)evaluatedWatch).getInnerValue());
                }
            } else {
                this.setInnerValue(null);
            }
            try {
                if (this.model.isLeaf(this)) {
                    this.model.fireChildrenChanged(this);
                }
            }
            catch (UnknownTypeException unknownTypeException) {
                // empty catch block
            }
        }

        synchronized JPDAWatch getEvaluatedWatch() {
            return this.evaluatedWatch;
        }

        public void expressionChanged() {
            this.setEvaluated(null);
            this.parseExpression(this.w.getExpression());
        }

        public synchronized String getExceptionDescription() {
            if (this.evaluatedWatch != null) {
                return this.evaluatedWatch.getExceptionDescription();
            }
            return null;
        }

        public synchronized String getExpression() {
            if (this.evaluatedWatch != null) {
                return this.evaluatedWatch.getExpression();
            }
            return this.w.getExpression();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getToStringValue() throws InvalidExpressionException {
            String e;
            JPDAWatch evaluatedWatch;
            JPDAWatchEvaluating jPDAWatchEvaluating = this;
            synchronized (jPDAWatchEvaluating) {
                evaluatedWatch = this.evaluatedWatch;
            }
            if (evaluatedWatch == null) {
                JPDAWatch[] watchRef = new JPDAWatch[]{null};
                this.getValue(watchRef);
                evaluatedWatch = watchRef[0];
            }
            if ((e = evaluatedWatch.getExceptionDescription()) != null) {
                return ">" + e + "<";
            }
            return evaluatedWatch.getToStringValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getType() {
            JPDAWatch evaluatedWatch;
            JPDAWatchEvaluating jPDAWatchEvaluating = this;
            synchronized (jPDAWatchEvaluating) {
                evaluatedWatch = this.evaluatedWatch;
            }
            if (evaluatedWatch == null) {
                JPDAWatch[] watchRef = new JPDAWatch[]{null};
                this.getValue(watchRef);
                evaluatedWatch = watchRef[0];
            }
            return evaluatedWatch.getType();
        }

        @Override
        public String getValue() {
            return this.getValue(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private String getValue(JPDAWatch[] watchRef) {
            boolean[] blArray = this.evaluating;
            synchronized (this.evaluating) {
                Object expr;
                AbstractVariable jw;
                block28: {
                    if (this.evaluating[0]) {
                        try {
                            this.evaluating.wait();
                        }
                        catch (InterruptedException iex) {
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            return null;
                        }
                    }
                    JPDAWatchEvaluating iex = this;
                    synchronized (iex) {
                        if (this.evaluatedWatch != null) {
                            if (watchRef == null) return this.evaluatedWatch.getValue();
                            watchRef[0] = this.evaluatedWatch;
                            // MONITOREXIT @DISABLED, blocks:[0, 2, 8, 9, 26] lbl17 : MonitorExitStatement: MONITOREXIT : iex
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            return this.evaluatedWatch.getValue();
                        }
                    }
                    this.evaluating[0] = true;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    jw = null;
                    try {
                        expr = this.getParsedExpression();
                        Value v = this.debugger.evaluateIn((EvaluatorExpression)expr);
                        if (v instanceof PrimitiveValue) {
                            JPDAWatchImpl jwi = new JPDAWatchImpl(this.debugger, this.w, (PrimitiveValue)v, (Object)this);
                            jwi.addPropertyChangeListener(this);
                            jw = jwi;
                        } else {
                            JPDAObjectWatchImpl jwi = new JPDAObjectWatchImpl(this.debugger, this.w, v);
                            jwi.addPropertyChangeListener(this);
                            jw = jwi;
                        }
                        this.setEvaluated((JPDAWatch)jw);
                        if (watchRef == null) break block28;
                        watchRef[0] = jw;
                    }
                    catch (InvalidExpressionException e) {
                        try {
                            JPDAWatchImpl jwi = new JPDAWatchImpl(this.debugger, this.w, (Exception)((Object)e), (Object)this);
                            jwi.addPropertyChangeListener(this);
                            jw = jwi;
                            this.setEvaluated((JPDAWatch)jw);
                            if (watchRef != null) {
                                watchRef[0] = jw;
                            }
                            boolean[] blArray2 = this.evaluating;
                        }
                        catch (Throwable throwable) {
                            this.setEvaluated((JPDAWatch)jw);
                            if (watchRef != null) {
                                watchRef[0] = jw;
                            }
                            boolean[] blArray3 = this.evaluating;
                            synchronized (this.evaluating) {
                                this.evaluating[0] = false;
                                this.evaluating.notifyAll();
                                // ** MonitorExit[var9_16] (shouldn't be in output)
                                throw throwable;
                            }
                        }
                        synchronized (this.evaluating) {
                            this.evaluating[0] = false;
                            this.evaluating.notifyAll();
                            // ** MonitorExit[var3_6] (shouldn't be in output)
                            return jw.getValue();
                        }
                    }
                }
                expr = this.evaluating;
                synchronized (this.evaluating) {
                    this.evaluating[0] = false;
                    this.evaluating.notifyAll();
                    // ** MonitorExit[expr] (shouldn't be in output)
                    return jw.getValue();
                }
            }
        }

        public synchronized void remove() {
            if (this.evaluatedWatch != null) {
                this.evaluatedWatch.remove();
            } else {
                this.w.remove();
            }
        }

        public void setExpression(String expression) {
            this.w.setExpression(expression);
            this.expressionChanged();
        }

        @Override
        public synchronized void setValue(String value) throws InvalidExpressionException {
            if (this.evaluatedWatch == null) {
                throw new InvalidExpressionException("Can not set value while evaluating.");
            }
            this.evaluatedWatch.setValue(value);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof JPDAWatchEvaluating) {
                return;
            }
            this.model.fireTableValueChangedChanged(this, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void refresh() throws RefreshFailedException {
            boolean[] blArray = this.evaluating;
            synchronized (this.evaluating) {
                if (this.evaluating[0]) {
                    try {
                        this.evaluating.wait();
                    }
                    catch (InterruptedException iex) {
                        throw new RefreshFailedException(iex.getLocalizedMessage());
                    }
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        @Override
        public synchronized boolean isCurrent() {
            return this.evaluatedWatch != null;
        }

        @Override
        public JPDAWatchEvaluating clone() {
            JPDAWatchEvaluating clon = new JPDAWatchEvaluating(this.model, this.w, this.debugger, this.cloneNumber++);
            clon.setEvaluated(this.evaluatedWatch);
            return clon;
        }
    }
}

