/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbjarproject.ui.customizer;

import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.modules.java.api.common.project.ui.ClassPathUiSupport;
import org.openide.util.NbBundle;

public final class ClassPathTableModel
extends AbstractTableModel
implements ListDataListener {
    private static final long serialVersionUID = 61197507L;
    private DefaultListModel model;

    public static ClassPathTableModel createTableModel(Iterator it) {
        return new ClassPathTableModel(ClassPathUiSupport.createListModel((Iterator)it));
    }

    public ClassPathTableModel(DefaultListModel model) {
        this.model = model;
        model.addListDataListener(this);
    }

    public DefaultListModel getDefaultListModel() {
        return this.model;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.model.getSize();
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return NbBundle.getMessage(ClassPathTableModel.class, (String)"LBL_CustomizeLibraries_TableHeader_Library");
        }
        return NbBundle.getMessage(ClassPathTableModel.class, (String)"LBL_CustomizeLibraries_TableHeader_Deploy");
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return ClassPathSupport.Item.class;
        }
        return Boolean.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex != 0 && this.getShowItemAsIncludedInDeployment(this.getItem(rowIndex)) instanceof Boolean;
    }

    @Override
    public Object getValueAt(int row, int column) {
        ClassPathSupport.Item item = this.getItem(row);
        if (column == 0) {
            return item;
        }
        return this.getShowItemAsIncludedInDeployment(item);
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        if (column != 1 || !(value instanceof Boolean)) {
            return;
        }
        this.getItem(row).setAdditionalProperty("includeInDeployment", Boolean.toString(value == Boolean.TRUE));
        this.fireTableCellUpdated(row, column);
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.fireTableRowsUpdated(e.getIndex0(), e.getIndex1());
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        this.fireTableRowsInserted(e.getIndex0(), e.getIndex1());
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        this.fireTableRowsDeleted(e.getIndex0(), e.getIndex1());
    }

    private ClassPathSupport.Item getItem(int index) {
        return (ClassPathSupport.Item)this.model.get(index);
    }

    private void setItem(ClassPathSupport.Item item, int index) {
        this.model.set(index, item);
    }

    private Boolean getShowItemAsIncludedInDeployment(ClassPathSupport.Item item) {
        Boolean result = "true".equals(item.getAdditionalProperty("includeInDeployment"));
        return result;
    }
}

