/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.qnavigator.navigator;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.Timer;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.cnd.api.model.CsmChangeEvent;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmModelListener;
import org.netbeans.modules.cnd.api.model.CsmModelState;
import org.netbeans.modules.cnd.api.model.CsmProgressListener;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.qnavigator.navigator.CppDeclarationNode;
import org.netbeans.modules.cnd.qnavigator.navigator.CsmFileFilter;
import org.netbeans.modules.cnd.qnavigator.navigator.CsmFileModel;
import org.netbeans.modules.cnd.qnavigator.navigator.NavigatorComponent;
import org.netbeans.modules.cnd.qnavigator.navigator.NavigatorPanelUI;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.text.NbDocument;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;

public class NavigatorModel
implements CsmProgressListener,
CsmModelListener {
    private static final int DEFAULT_PARSING_DELAY = 2000;
    private DataObject cdo;
    private NavigatorPanelUI ui;
    private NavigatorComponent busyListener;
    private Action[] actions;
    private AbstractNode root;
    private CsmFileModel fileModel;
    private Timer checkModifiedTimer;
    private long lastModified = 0L;
    private long lastDocVersion = 0L;
    private Timer checkCursorTimer;
    private long lastCursorPos = -1L;
    private long lastCursorPosWhenChecked = 0L;
    private final Object lock = new Lock();

    public NavigatorModel(DataObject cdo, NavigatorPanelUI ui, NavigatorComponent component, String mimeType) {
        this.cdo = cdo;
        this.ui = ui;
        this.actions = new Action[]{new SortByNameAction(), new SortBySourceAction(), new GroupByKindAction(), new ExpandAllAction(), null, new FilterSubmenuAction(mimeType)};
        this.root = new AbstractNode((Children)new Children.Array()){

            public Action[] getActions(boolean context) {
                return NavigatorModel.this.actions;
            }
        };
        this.fileModel = new CsmFileModel(new CsmFileFilter(), this.actions);
        this.update(this.getCsmFile());
        if (this.getParsingDelay() > 0) {
            this.checkModifiedTimer = new Timer(this.getParsingDelay(), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    NavigatorModel.this.checkModified();
                }
            });
            this.checkModifiedTimer.start();
        }
        this.checkCursorTimer = new Timer(250, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NavigatorModel.this.checkCursor();
            }
        });
        this.checkCursorTimer.start();
    }

    private int getParsingDelay() {
        return 2000;
    }

    private CsmFile getCsmFile() {
        CsmFile csmFile = CsmUtilities.getCsmFile((DataObject)this.cdo, (boolean)false, (boolean)false);
        if (csmFile != null && !csmFile.isValid()) {
            csmFile = null;
        }
        return csmFile;
    }

    void removeNotify() {
        this.stopTimers();
    }

    void addNotify() {
        this.update(this.getCsmFile());
    }

    void addBusyListener(NavigatorComponent navigatorComponent) {
        this.busyListener = navigatorComponent;
    }

    void removeBusyListener(NavigatorComponent navigatorComponent) {
        this.busyListener = null;
    }

    public Node getRoot() {
        return this.root;
    }

    private void update(CsmFile csmFile) {
        this.update(csmFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(CsmFile csmFile, boolean force) {
        try {
            if (CsmModelAccessor.getModelState() != CsmModelState.ON) {
                return;
            }
            if (this.busyListener != null) {
                this.busyListener.busyStart();
            }
            CsmFileModel.PreBuildModel buildPreModel = this.fileModel.buildPreModel(csmFile);
            Object object = this.lock;
            synchronized (object) {
                if (this.fileModel.buildModel(buildPreModel, csmFile, force)) {
                    final Children children = this.root.getChildren();
                    if (!Children.MUTEX.isReadAccess()) {
                        Children.MUTEX.writeAccess(new Runnable(){

                            @Override
                            public void run() {
                                children.remove(children.getNodes());
                                children.add(NavigatorModel.this.fileModel.getNodes());
                            }
                        });
                    }
                }
            }
        }
        finally {
            if (this.busyListener != null) {
                this.busyListener.busyEnd();
            }
        }
        this.ui.newContentReady();
    }

    private void checkModified() {
        this.stopTimers();
        this.updateNodesIfModified(this.findCurrentJEditorPane());
        this.restartTimers();
    }

    private boolean isUpdateNeeded(JEditorPane jEditorPane) {
        if (jEditorPane == null || jEditorPane.getDocument() == null) {
            return false;
        }
        if (DocumentUtilities.getDocumentVersion((Document)jEditorPane.getDocument()) <= this.lastDocVersion) {
            return false;
        }
        long timeSinceLastModification = System.currentTimeMillis() - this.lastModified;
        return timeSinceLastModification >= (long)this.getParsingDelay();
    }

    private void updateNodesIfModified(JEditorPane jEditorPane) {
        if (!this.isUpdateNeeded(jEditorPane)) {
            return;
        }
        this.lastDocVersion = DocumentUtilities.getDocumentVersion((Document)jEditorPane.getDocument());
        this.lastModified = System.currentTimeMillis();
        this.lastCursorPos = -1L;
        this.lastCursorPosWhenChecked = 0L;
    }

    private void checkCursor() {
        JEditorPane jEditorPane;
        if (this.checkCursorTimer != null) {
            this.checkCursorTimer.stop();
        }
        if ((jEditorPane = this.findCurrentJEditorPane()) != null) {
            Caret caret = jEditorPane.getCaret();
            if ((long)caret.getDot() != this.lastCursorPos && (long)caret.getDot() == this.lastCursorPosWhenChecked) {
                this.lastCursorPosWhenChecked = this.lastCursorPos = (long)caret.getDot();
                this.setSelection(this.lastCursorPos);
            }
            this.lastCursorPosWhenChecked = caret.getDot();
        }
        if (this.checkCursorTimer != null) {
            this.checkCursorTimer.restart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSelection(long caretLineNo) {
        Object object = this.lock;
        synchronized (object) {
            Node node = this.fileModel.setSelection(caretLineNo);
            if (node != null) {
                this.ui.selectNode(node);
            }
        }
    }

    private JEditorPane findCurrentJEditorPane() {
        JEditorPane currentJEditorPane = null;
        if (this.cdo != null) {
            EditorCookie ec = (EditorCookie)this.cdo.getCookie(EditorCookie.class);
            currentJEditorPane = NbDocument.findRecentEditorPane((EditorCookie)ec);
        }
        return currentJEditorPane;
    }

    private void restartTimers() {
        if (this.checkModifiedTimer != null) {
            this.checkModifiedTimer.restart();
        }
        if (this.checkCursorTimer != null) {
            this.checkCursorTimer.restart();
        }
    }

    private void stopTimers() {
        if (this.checkModifiedTimer != null) {
            this.checkModifiedTimer.stop();
        }
        if (this.checkCursorTimer != null) {
            this.checkCursorTimer.stop();
        }
    }

    public void projectParsingStarted(CsmProject project) {
    }

    public void projectFilesCounted(CsmProject project, int filesCount) {
    }

    public void projectParsingFinished(CsmProject project) {
        this.projectLoaded(project);
    }

    public void projectParsingCancelled(CsmProject project) {
    }

    public void fileInvalidated(CsmFile file) {
    }

    public void fileAddedToParse(CsmFile file) {
    }

    public void fileParsingStarted(CsmFile file) {
    }

    public void projectLoaded(CsmProject project) {
        CsmFileModel.logger.log(Level.FINE, "projectLoaded {0}", project);
        CsmFile file = this.getCsmFile();
        if (file != null && project.equals(file.getProject()) && file.isParsed()) {
            this.fileParsedOrProjectLoaded(file);
        }
    }

    public void fileParsingFinished(CsmFile file) {
        if (file.equals(this.getCsmFile())) {
            this.fileParsedOrProjectLoaded(file);
        }
    }

    private void fileParsedOrProjectLoaded(CsmFile file) {
        CsmFileModel.logger.log(Level.FINE, "File parsed {0}", file);
        this.stopTimers();
        this.update(file);
        this.restartTimers();
    }

    public void parserIdle() {
    }

    public void projectOpened(CsmProject project) {
    }

    public void projectClosed(CsmProject project) {
        CsmFile file = this.getCsmFile();
        if (file == null || file.getProject() == project) {
            this.stopTimers();
            this.update(null);
            this.restartTimers();
        } else {
            this.stopTimers();
            this.update(file);
            this.restartTimers();
        }
    }

    public void modelChanged(CsmChangeEvent e) {
        CsmFile file;
        if (e.getRemovedFiles().size() > 0 && ((file = this.getCsmFile()) == null || e.getRemovedFiles().contains(file))) {
            CsmFileModel.logger.log(Level.FINE, "File removed");
            this.stopTimers();
            this.update(null);
            this.restartTimers();
        }
    }

    private int storeSelection() {
        Node selected;
        Node[] selection;
        if (this.ui != null && (selection = this.ui.getExplorerManager().getSelectedNodes()) != null && selection.length == 1 && (selected = selection[0]) instanceof CppDeclarationNode) {
            return ((CppDeclarationNode)selected).getOffset();
        }
        return -1;
    }

    public CsmFileFilter getFilter() {
        return this.fileModel.getFilter();
    }

    private class FilterSubmenuAction
    extends AbstractAction
    implements Presenter.Popup {
        private String mimeType;

        public FilterSubmenuAction(String mimeType) {
            this.mimeType = mimeType;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
        }

        public final JMenuItem getPopupPresenter() {
            return this.createSubmenu();
        }

        private JMenuItem createSubmenu() {
            JMenu menu = new JMenu(NbBundle.getMessage(NavigatorModel.class, (String)"FilterSubmenu"));
            boolean isC = MIMENames.isHeaderOrCppOrC((String)this.mimeType);
            boolean isCpp = MIMENames.isHeaderOrCpp((String)this.mimeType);
            boolean isCnd = MIMENames.isFortranOrHeaderOrCppOrC((String)this.mimeType);
            if (isC) {
                ((Container)menu).add(new ShowForwardClassDeclarationsAction().getPopupPresenter());
                ((Container)menu).add(new ShowForwardFunctionDeclarationsAction().getPopupPresenter());
                ((Container)menu).add(new ShowMacroAction().getPopupPresenter());
            }
            if (isCnd) {
                ((Container)menu).add(new ShowIncludeAction().getPopupPresenter());
            }
            if (isC) {
                ((Container)menu).add(new ShowTypedefAction().getPopupPresenter());
            }
            if (isCnd) {
                ((Container)menu).add(new ShowVariableAction().getPopupPresenter());
                ((Container)menu).add(new ShowFieldAction().getPopupPresenter());
            }
            if (isCpp) {
                ((Container)menu).add(new ShowUsingAction().getPopupPresenter());
            }
            return menu;
        }
    }

    private class ExpandAllAction
    extends AbstractAction
    implements Presenter.Popup {
        private JCheckBoxMenuItem menuItem;

        public ExpandAllAction() {
            this.putValue("Name", NbBundle.getMessage(NavigatorModel.class, (String)"ExpandAll"));
            this.menuItem = new JCheckBoxMenuItem((String)this.getValue("Name"));
            this.menuItem.setAction(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NavigatorModel.this.fileModel.getFilter().setExpandAll(!NavigatorModel.this.fileModel.getFilter().isExpandAll());
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(NavigatorModel.this.fileModel.getFilter().isExpandAll());
            return this.menuItem;
        }
    }

    private class GroupByKindAction
    extends AbstractAction
    implements Presenter.Popup {
        private JCheckBoxMenuItem menuItem;

        public GroupByKindAction() {
            this.putValue("Name", NbBundle.getMessage(NavigatorModel.class, (String)"GroupByKindText"));
            this.menuItem = new JCheckBoxMenuItem((String)this.getValue("Name"));
            this.menuItem.setAction(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NavigatorModel.this.fileModel.getFilter().setGroupByKind(!NavigatorModel.this.fileModel.getFilter().isGroupByKind());
            int selection = NavigatorModel.this.storeSelection();
            NavigatorModel.this.update(NavigatorModel.this.getCsmFile(), true);
            if (selection >= 0) {
                NavigatorModel.this.setSelection(selection);
            }
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(NavigatorModel.this.fileModel.getFilter().isGroupByKind());
            return this.menuItem;
        }
    }

    private class SortBySourceAction
    extends AbstractAction
    implements Presenter.Popup {
        private JRadioButtonMenuItem menuItem;

        public SortBySourceAction() {
            this.putValue("Name", NbBundle.getMessage(NavigatorModel.class, (String)"SortBySourceText"));
            this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/qnavigator/resources/sortPosition.png", (boolean)false));
            this.menuItem = new JRadioButtonMenuItem((String)this.getValue("Name"));
            this.menuItem.setAction(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (NavigatorModel.this.fileModel.getFilter().getSortMode() != CsmFileFilter.SortMode.Offset) {
                NavigatorModel.this.fileModel.getFilter().setSortMode(CsmFileFilter.SortMode.Offset);
                int selection = NavigatorModel.this.storeSelection();
                NavigatorModel.this.update(NavigatorModel.this.getCsmFile(), true);
                if (selection >= 0) {
                    NavigatorModel.this.setSelection(selection);
                }
            }
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(NavigatorModel.this.fileModel.getFilter().getSortMode() == CsmFileFilter.SortMode.Offset);
            return this.menuItem;
        }
    }

    private class SortByNameAction
    extends AbstractAction
    implements Presenter.Popup {
        private JRadioButtonMenuItem menuItem;

        public SortByNameAction() {
            this.putValue("Name", NbBundle.getMessage(NavigatorModel.class, (String)"SortByNameText"));
            this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/qnavigator/resources/sortAlpha.png", (boolean)false));
            this.menuItem = new JRadioButtonMenuItem((String)this.getValue("Name"));
            this.menuItem.setAction(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (NavigatorModel.this.fileModel.getFilter().getSortMode() != CsmFileFilter.SortMode.Name) {
                NavigatorModel.this.fileModel.getFilter().setSortMode(CsmFileFilter.SortMode.Name);
                int selection = NavigatorModel.this.storeSelection();
                NavigatorModel.this.update(NavigatorModel.this.getCsmFile(), true);
                if (selection >= 0) {
                    NavigatorModel.this.setSelection(selection);
                }
            }
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(NavigatorModel.this.fileModel.getFilter().getSortMode() == CsmFileFilter.SortMode.Name);
            return this.menuItem;
        }
    }

    private class ShowUsingAction
    extends AbstractAction
    implements Presenter.Popup {
        private JCheckBoxMenuItem menuItem;

        public ShowUsingAction() {
            this.putValue("Name", NbBundle.getMessage(NavigatorModel.class, (String)"ShowUsingText"));
            this.menuItem = new JCheckBoxMenuItem((String)this.getValue("Name"));
            this.menuItem.setAction(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NavigatorModel.this.fileModel.getFilter().setShowUsing(!NavigatorModel.this.fileModel.getFilter().isShowUsing());
            int selection = NavigatorModel.this.storeSelection();
            NavigatorModel.this.update(NavigatorModel.this.getCsmFile());
            if (selection >= 0) {
                NavigatorModel.this.setSelection(selection);
            }
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(NavigatorModel.this.fileModel.getFilter().isShowUsing());
            return this.menuItem;
        }
    }

    private class ShowFieldAction
    extends AbstractAction
    implements Presenter.Popup {
        private JCheckBoxMenuItem menuItem;

        public ShowFieldAction() {
            this.putValue("Name", NbBundle.getMessage(NavigatorModel.class, (String)"ShowFieldText"));
            this.menuItem = new JCheckBoxMenuItem((String)this.getValue("Name"));
            this.menuItem.setAction(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NavigatorModel.this.fileModel.getFilter().setShowField(!NavigatorModel.this.fileModel.getFilter().isShowField());
            int selection = NavigatorModel.this.storeSelection();
            NavigatorModel.this.update(NavigatorModel.this.getCsmFile());
            if (selection >= 0) {
                NavigatorModel.this.setSelection(selection);
            }
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(NavigatorModel.this.fileModel.getFilter().isShowField());
            return this.menuItem;
        }
    }

    private class ShowVariableAction
    extends AbstractAction
    implements Presenter.Popup {
        private JCheckBoxMenuItem menuItem;

        public ShowVariableAction() {
            this.putValue("Name", NbBundle.getMessage(NavigatorModel.class, (String)"ShowVariableText"));
            this.menuItem = new JCheckBoxMenuItem((String)this.getValue("Name"));
            this.menuItem.setAction(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NavigatorModel.this.fileModel.getFilter().setShowVariable(!NavigatorModel.this.fileModel.getFilter().isShowVariable());
            int selection = NavigatorModel.this.storeSelection();
            NavigatorModel.this.update(NavigatorModel.this.getCsmFile());
            if (selection >= 0) {
                NavigatorModel.this.setSelection(selection);
            }
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(NavigatorModel.this.fileModel.getFilter().isShowVariable());
            return this.menuItem;
        }
    }

    private class ShowTypedefAction
    extends AbstractAction
    implements Presenter.Popup {
        private JCheckBoxMenuItem menuItem;

        public ShowTypedefAction() {
            this.putValue("Name", NbBundle.getMessage(NavigatorModel.class, (String)"ShowTypedefText"));
            this.menuItem = new JCheckBoxMenuItem((String)this.getValue("Name"));
            this.menuItem.setAction(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NavigatorModel.this.fileModel.getFilter().setShowTypedef(!NavigatorModel.this.fileModel.getFilter().isShowTypedef());
            int selection = NavigatorModel.this.storeSelection();
            NavigatorModel.this.update(NavigatorModel.this.getCsmFile());
            if (selection >= 0) {
                NavigatorModel.this.setSelection(selection);
            }
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(NavigatorModel.this.fileModel.getFilter().isShowTypedef());
            return this.menuItem;
        }
    }

    private class ShowIncludeAction
    extends AbstractAction
    implements Presenter.Popup {
        private JCheckBoxMenuItem menuItem;

        public ShowIncludeAction() {
            this.putValue("Name", NbBundle.getMessage(NavigatorModel.class, (String)"ShowIncludeText"));
            this.menuItem = new JCheckBoxMenuItem((String)this.getValue("Name"));
            this.menuItem.setAction(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NavigatorModel.this.fileModel.getFilter().setShowInclude(!NavigatorModel.this.fileModel.getFilter().isShowInclude());
            int selection = NavigatorModel.this.storeSelection();
            NavigatorModel.this.update(NavigatorModel.this.getCsmFile());
            if (selection >= 0) {
                NavigatorModel.this.setSelection(selection);
            }
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(NavigatorModel.this.fileModel.getFilter().isShowInclude());
            return this.menuItem;
        }
    }

    private class ShowMacroAction
    extends AbstractAction
    implements Presenter.Popup {
        private JCheckBoxMenuItem menuItem;

        public ShowMacroAction() {
            this.putValue("Name", NbBundle.getMessage(NavigatorModel.class, (String)"ShowMacroText"));
            this.menuItem = new JCheckBoxMenuItem((String)this.getValue("Name"));
            this.menuItem.setAction(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NavigatorModel.this.fileModel.getFilter().setShowMacro(!NavigatorModel.this.fileModel.getFilter().isShowMacro());
            int selection = NavigatorModel.this.storeSelection();
            NavigatorModel.this.update(NavigatorModel.this.getCsmFile());
            if (selection >= 0) {
                NavigatorModel.this.setSelection(selection);
            }
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(NavigatorModel.this.fileModel.getFilter().isShowMacro());
            return this.menuItem;
        }
    }

    private class ShowForwardClassDeclarationsAction
    extends AbstractAction
    implements Presenter.Popup {
        private JCheckBoxMenuItem menuItem;

        public ShowForwardClassDeclarationsAction() {
            this.putValue("Name", NbBundle.getMessage(NavigatorModel.class, (String)"ShowForwardClassDeclarationsText"));
            this.menuItem = new JCheckBoxMenuItem((String)this.getValue("Name"));
            this.menuItem.setAction(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NavigatorModel.this.fileModel.getFilter().setShowForwardClassDeclarations(!NavigatorModel.this.fileModel.getFilter().isShowForwardClassDeclarations());
            int selection = NavigatorModel.this.storeSelection();
            NavigatorModel.this.update(NavigatorModel.this.getCsmFile());
            if (selection >= 0) {
                NavigatorModel.this.setSelection(selection);
            }
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(NavigatorModel.this.fileModel.getFilter().isShowForwardClassDeclarations());
            return this.menuItem;
        }
    }

    private class ShowForwardFunctionDeclarationsAction
    extends AbstractAction
    implements Presenter.Popup {
        private JCheckBoxMenuItem menuItem;

        public ShowForwardFunctionDeclarationsAction() {
            this.putValue("Name", NbBundle.getMessage(NavigatorModel.class, (String)"ShowForwardFunctionDeclarationsText"));
            this.menuItem = new JCheckBoxMenuItem((String)this.getValue("Name"));
            this.menuItem.setAction(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NavigatorModel.this.fileModel.getFilter().setShowForwardFunctionDeclarations(!NavigatorModel.this.fileModel.getFilter().isShowForwardFunctionDeclarations());
            int selection = NavigatorModel.this.storeSelection();
            NavigatorModel.this.update(NavigatorModel.this.getCsmFile());
            if (selection >= 0) {
                NavigatorModel.this.setSelection(selection);
            }
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(NavigatorModel.this.fileModel.getFilter().isShowForwardFunctionDeclarations());
            return this.menuItem;
        }
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

