/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.javaee.ide;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.modules.glassfish.javaee.Hk2DeploymentManager;
import org.netbeans.modules.glassfish.spi.ServerUtilities;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;

public class Hk2PluginProperties {
    public static final String PROP_JAVA_PLATFORM = "java_platform";
    public static final String PROP_JAVADOCS = "javadocs";
    public static final String PLAT_PROP_ANT_NAME = "platform.ant.name";
    private InstanceProperties ip;
    private static final int DEBUGPORT = 9009;
    private ServerUtilities su;

    public Hk2PluginProperties(Hk2DeploymentManager dm, ServerUtilities su) {
        this.ip = InstanceProperties.getInstanceProperties((String)dm.getUri());
        this.su = su;
    }

    public String getDomainDir() {
        String path = this.ip.getProperty("domainsfolder");
        return null == path ? path : path + File.separator + this.ip.getProperty("domainname");
    }

    public String getInstallRoot() {
        return this.ip.getProperty("installfolder");
    }

    public String getGlassfishRoot() {
        return this.ip.getProperty("homefolder");
    }

    public JavaPlatform getJavaPlatform() {
        String currentJvm = this.ip.getProperty(PROP_JAVA_PLATFORM);
        JavaPlatformManager jpm = JavaPlatformManager.getDefault();
        JavaPlatform[] installedPlatforms = jpm.getPlatforms(null, new Specification("J2SE", null));
        for (int i = 0; i < installedPlatforms.length; ++i) {
            String platformName = (String)installedPlatforms[i].getProperties().get(PLAT_PROP_ANT_NAME);
            if (platformName == null || !platformName.equals(currentJvm)) continue;
            return installedPlatforms[i];
        }
        return jpm.getDefaultPlatform();
    }

    public InstanceProperties getInstanceProperties() {
        return this.ip;
    }

    public List<URL> getClasses() {
        String gfr = this.getGlassfishRoot();
        if (null == gfr) {
            return Collections.EMPTY_LIST;
        }
        File serverDir = new File(gfr);
        return Hk2PluginProperties.getClasses(serverDir);
    }

    public static List<URL> getClasses(File serverDir) {
        List<String> jars = new ArrayList<String>();
        HashSet<URI> urlSet = new HashSet<URI>();
        try {
            File javaEEJar = ServerUtilities.getJarName((String)serverDir.getAbsolutePath(), (String)"javax.javaee(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
            Logger.getLogger("glassfish-javaee").log(Level.FINER, "JavaEE jar is {0}", javaEEJar != null ? javaEEJar.getAbsolutePath() : "null");
            if (javaEEJar != null && javaEEJar.exists()) {
                jars.add("web/jsf-connector-10.0");
                JarFile jarFile = new JarFile(javaEEJar);
                Manifest manifest = jarFile.getManifest();
                if (manifest != null) {
                    Attributes attrs = manifest.getMainAttributes();
                    String cp = attrs.getValue("Class-Path");
                    Logger.getLogger("glassfish-javaee").log(Level.FINER, "JavaEE jar classpath is \"{0}\"", cp);
                    if (cp != null && cp.length() > 0) {
                        File parent = javaEEJar.getParentFile();
                        for (String jarName : cp.split(" ")) {
                            urlSet.add(Hk2PluginProperties.fileToUrl(new File(parent, jarName)).toURI());
                        }
                    }
                }
                if (urlSet.isEmpty()) {
                    Logger.getLogger("glassfish-javaee").log(Level.FINER, "{0} contains null classpath or subjars not found.  Using directly.", javaEEJar.getAbsolutePath());
                    urlSet.add(Hk2PluginProperties.fileToUrl(javaEEJar).toURI());
                }
            } else {
                File modulesDir = new File(serverDir.getAbsolutePath() + File.separatorChar + "modules");
                FileObject mDFO = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)modulesDir));
                jars = ServerUtilities.filterByManifest(jars, (FileObject)mDFO, (int)0, (boolean)true);
            }
            jars.add("webservices(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
            jars.add("jaxb(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
            jars.add("web/jstl-impl(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
            jars.add("web/jsf-impl(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
            jars.add("jstl-impl(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
            jars.add("jsf-impl(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
            jars.add("jsf-api(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
            jars.add("bean-validator(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
            jars.add("webbeans-osgi-bundle(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
            jars.add("weld-osgi-bundle(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
            jars.add("jackson-asl(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
            jars.add("jackson-core-asl(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
            jars.add("jersey-bundle(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
            jars.add("jersey-gf-bundle(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
            jars.add("jersey-multipart(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
            jars.add("jettison(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
            jars.add("mimepull(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
            jars.add("jsr311-api(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
            jars.add("jackson-jaxrs(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
            jars.add("jackson-mapper-asl(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
            jars.add("jersey-client(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
            jars.add("jersey-core(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
            jars.add("jersey-gf-server(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
            jars.add("jersey-json(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
            for (String jarStr : jars) {
                File jar = ServerUtilities.getJarName((String)serverDir.getAbsolutePath(), (String)jarStr);
                if (jar == null || !jar.exists()) continue;
                urlSet.add(Hk2PluginProperties.fileToUrl(jar).toURI());
            }
            File jar = ServerUtilities.getJarName((String)serverDir.getAbsolutePath(), (String)"endorsed/webservices-api-osgi(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
            if (null != jar) {
                urlSet.add(Hk2PluginProperties.fileToUrl(jar).toURI());
            } else {
                jar = ServerUtilities.getJarName((String)serverDir.getAbsolutePath(), (String)"webservices-osgi(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
                if (null != jar) {
                    urlSet.add(Hk2PluginProperties.fileToUrl(jar).toURI());
                }
            }
            jar = ServerUtilities.getJarName((String)serverDir.getAbsolutePath(), (String)"endorsed/jaxb-api-osgi(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
            if (null != jar) {
                urlSet.add(Hk2PluginProperties.fileToUrl(jar).toURI());
            } else {
                jar = ServerUtilities.getJarName((String)serverDir.getAbsolutePath(), (String)"jaxb-osgi(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
                if (null != jar) {
                    urlSet.add(Hk2PluginProperties.fileToUrl(jar).toURI());
                }
            }
            ArrayList<URL> retVal = new ArrayList<URL>();
            for (URI e : urlSet) {
                retVal.add(e.toURL());
            }
            return retVal;
        }
        catch (URISyntaxException use) {
            ErrorManager.getDefault().notify(1, (Throwable)use);
        }
        catch (MalformedURLException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        return new ArrayList<URL>();
    }

    public List<URL> getJavadocs() {
        String path = this.ip.getProperty(PROP_JAVADOCS);
        if (path == null) {
            ArrayList<URL> list = new ArrayList<URL>();
            for (String possible : this.su.getAssociatedJavaDoc()) {
                try {
                    File j2eeDoc = InstalledFileLocator.getDefault().locate(possible, null, false);
                    if (j2eeDoc == null) continue;
                    list.add(Hk2PluginProperties.fileToUrl(j2eeDoc));
                }
                catch (MalformedURLException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
            }
            return list;
        }
        return Hk2PluginProperties.tokenizePath(path);
    }

    public static List<URL> tokenizePath(String path) {
        try {
            ArrayList<URL> l = new ArrayList<URL>();
            StringTokenizer tok = new StringTokenizer(path, ":;", true);
            char dosHack = '\u0000';
            int lastDelim = 0;
            int delimCount = 0;
            while (tok.hasMoreTokens()) {
                char c;
                String s = tok.nextToken();
                if (s.length() == 0) continue;
                if (s.length() == 1 && ((c = s.charAt(0)) == ':' || c == ';')) {
                    lastDelim = c;
                    ++delimCount;
                    continue;
                }
                if (dosHack != '\u0000') {
                    if (lastDelim == 58 && delimCount == 1 && (s.charAt(0) == '\\' || s.charAt(0) == '/')) {
                        s = "" + dosHack + ':' + s;
                    } else {
                        l.add(Hk2PluginProperties.fileToUrl(new File(Character.toString(dosHack))));
                    }
                    dosHack = '\u0000';
                }
                delimCount = 0;
                if (s.length() == 1 && ((c = s.charAt(0)) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
                    dosHack = c;
                    continue;
                }
                l.add(Hk2PluginProperties.fileToUrl(new File(s)));
            }
            if (dosHack != '\u0000') {
                l.add(Hk2PluginProperties.fileToUrl(new File(Character.toString(dosHack))));
            }
            return l;
        }
        catch (MalformedURLException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return new ArrayList<URL>();
        }
    }

    public static URL fileToUrl(File file) throws MalformedURLException {
        URL url = file.toURI().toURL();
        if (FileUtil.isArchiveFile((URL)url)) {
            url = FileUtil.getArchiveRoot((URL)url);
        }
        return url;
    }

    public static String buildPath(List<URL> path) {
        String PATH_SEPARATOR = System.getProperty("path.separator");
        StringBuilder sb = new StringBuilder(path.size() * 16);
        Iterator<URL> i = path.iterator();
        while (i.hasNext()) {
            sb.append(Hk2PluginProperties.urlToString(i.next()));
            if (!i.hasNext()) continue;
            sb.append(PATH_SEPARATOR);
        }
        return sb.toString();
    }

    private static String urlToString(URL url) {
        if ("jar".equals(url.getProtocol())) {
            URL fileURL = FileUtil.getArchiveFile((URL)url);
            if (FileUtil.getArchiveRoot((URL)fileURL).equals(url)) {
                url = fileURL;
            } else {
                return url.toExternalForm();
            }
        }
        if ("file".equals(url.getProtocol())) {
            File f = new File(URI.create(url.toExternalForm()));
            return f.getAbsolutePath();
        }
        return url.toExternalForm();
    }

    public void setJavadocs(List<URL> path) {
        this.ip.setProperty(PROP_JAVADOCS, Hk2PluginProperties.buildPath(path));
    }

    public int getDebugPort() {
        return 9009;
    }

    private static boolean isRunning(String host, int port) throws IOException {
        if (null == host) {
            return false;
        }
        InetSocketAddress isa = new InetSocketAddress(host, port);
        Socket socket = new Socket();
        socket.connect(isa, 1);
        socket.close();
        return true;
    }

    public static boolean isRunning(String host, String port) {
        try {
            return Hk2PluginProperties.isRunning(host, Integer.parseInt(port));
        }
        catch (NumberFormatException e) {
            Logger.getLogger("glassfish-javaee").log(Level.INFO, host + "  " + port, e);
            return false;
        }
        catch (IOException ioe) {
            Logger.getLogger("glassfish-javaee").log(Level.INFO, host + "  " + port, ioe);
            return false;
        }
    }
}

