/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.windows;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import org.openide.awt.ActionID;
import org.openide.filesystems.annotations.LayerBuilder;
import org.openide.filesystems.annotations.LayerGeneratingProcessor;
import org.openide.filesystems.annotations.LayerGenerationException;
import org.openide.windows.TopComponent;

@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public final class TopComponentProcessor
extends LayerGeneratingProcessor {
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> hash = new HashSet<String>();
        hash.add(TopComponent.Registration.class.getCanonicalName());
        hash.add(TopComponent.OpenActionRegistration.class.getCanonicalName());
        hash.add(TopComponent.Description.class.getCanonicalName());
        return hash;
    }

    protected boolean handleProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) throws LayerGenerationException {
        TopComponent.Description info;
        Annotation reg;
        for (Element element : roundEnv.getElementsAnnotatedWith(TopComponent.Registration.class)) {
            reg = element.getAnnotation(TopComponent.Registration.class);
            assert (reg != null);
            info = this.findInfo(element);
            String id = info.preferredID().replace('.', '-');
            LayerBuilder.File settingsFile = this.layer(new Element[]{element}).file("Windows2/Components/" + id + ".settings").contents(TopComponentProcessor.settingsFile(element));
            settingsFile.write();
            LayerBuilder.File modeFile = this.layer(new Element[]{element}).file("Windows2/Modes/" + reg.mode() + "/" + id + ".wstcref").position(reg.position()).contents(TopComponentProcessor.modeFile(info.preferredID(), reg.openAtStartup()));
            modeFile.write();
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(TopComponent.OpenActionRegistration.class)) {
            reg = element.getAnnotation(TopComponent.OpenActionRegistration.class);
            assert (reg != null);
            info = this.findInfo(element);
            ActionID aid = element.getAnnotation(ActionID.class);
            if (aid == null) continue;
            LayerBuilder.File actionFile = this.layer(new Element[]{element}).file("Actions/" + aid.category() + "/" + aid.id().replace('.', '-') + ".instance").methodvalue("instanceCreate", "org.openide.windows.TopComponent", "openAction");
            actionFile.instanceAttribute("component", TopComponent.class);
            if (reg.preferredID().length() > 0) {
                actionFile.stringvalue("preferredID", reg.preferredID());
            }
            actionFile.bundlevalue("displayName", reg.displayName());
            if (info != null && info.iconBase().length() > 0) {
                actionFile.stringvalue("iconBase", info.iconBase());
            }
            actionFile.write();
        }
        return true;
    }

    private TopComponent.Description findInfo(Element e) throws LayerGenerationException {
        Element type;
        switch (e.asType().getKind()) {
            case DECLARED: {
                type = e;
                break;
            }
            case EXECUTABLE: {
                type = ((DeclaredType)((ExecutableType)e.asType()).getReturnType()).asElement();
                break;
            }
            default: {
                throw new LayerGenerationException("" + (Object)((Object)e.asType().getKind()), e);
            }
        }
        TopComponent.Description info = type.getAnnotation(TopComponent.Description.class);
        return info;
    }

    private static String settingsFile(Element e) throws LayerGenerationException {
        String method;
        String clazz;
        switch (e.getKind()) {
            case CLASS: {
                clazz = e.toString();
                method = null;
                break;
            }
            case METHOD: {
                clazz = e.getEnclosingElement().toString();
                method = e.getSimpleName().toString();
                break;
            }
            default: {
                throw new LayerGenerationException("Cannot work on given element", e);
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<!DOCTYPE settings PUBLIC \"-//NetBeans//DTD Session settings 1.0//EN\" \"http://www.netbeans.org/dtds/sessionsettings-1_0.dtd\">\n");
        sb.append("<settings version=\"1.0\">\n");
        sb.append("  <instance class=\"").append(clazz).append("\"");
        if (method != null) {
            sb.append(" method=\"").append(method).append("\"");
        }
        sb.append("/>\n");
        sb.append("</settings>\n");
        return sb.toString();
    }

    private static String modeFile(String id, boolean openAtStart) throws LayerGenerationException {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<!DOCTYPE tc-ref PUBLIC \"-//NetBeans//DTD Top Component in Mode Properties 2.0//EN\" \"http://www.netbeans.org/dtds/tc-ref2_0.dtd\">\n");
        sb.append("<tc-ref version=\"2.0\">\n");
        sb.append("  <tc-id id=\"").append(id).append("\"/>\n");
        sb.append("  <state opened=\"").append(openAtStart).append("\"/>\n");
        sb.append("</tc-ref>\n");
        return sb.toString();
    }
}

