/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.j2ee.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.form.j2ee.J2EEUtils;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class DetailPanel
implements WizardDescriptor.Panel {
    private boolean valid;
    private EventListenerList listenerList;
    private DatabaseConnection connection;
    private String masterTable;
    private List masterColumns;
    private ImageIcon fieldsIcon;
    private ImageIcon tableIcon;
    private WizardDescriptor wizardDesc;
    private JButton addAllButton;
    private JButton addButton;
    private JLabel availableLabel;
    private JList availableList;
    private JScrollPane availablePane;
    private ButtonGroup buttonGroup;
    private JLabel detailLabel;
    private JButton downButton;
    private JRadioButton fieldsChoice;
    private JLabel includeLabel;
    private JList includeList;
    private JScrollPane includePane;
    private JPanel masterPanel;
    private JLabel previewLabel;
    private JButton removeAllButton;
    private JButton removeButton;
    private JRadioButton tableChoice;
    private JComboBox tableCombo;
    private JButton upButton;
    private boolean defaultPreselect = true;

    private void initGUI() {
        this.initComponents();
        this.initLists();
        this.fieldsIcon = new ImageIcon(this.getClass().getResource("/org/netbeans/modules/form/j2ee/resources/md_fields.gif"));
        this.tableIcon = new ImageIcon(this.getClass().getResource("/org/netbeans/modules/form/j2ee/resources/md_table.gif"));
        this.previewLabel.setIcon(this.fieldsIcon);
    }

    private void initLists() {
        this.availableList.setModel(new DefaultListModel());
        this.includeList.setModel(new DefaultListModel());
        ListDataListener listener = new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                this.contentsChanged(e);
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                this.contentsChanged(e);
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                Object source = e.getSource();
                if (source == DetailPanel.this.availableList.getModel()) {
                    DetailPanel.this.addAllButton.setEnabled(DetailPanel.this.availableList.getModel().getSize() != 0);
                } else if (source == DetailPanel.this.includeList.getModel()) {
                    boolean empty = DetailPanel.this.includeList.getModel().getSize() == 0;
                    DetailPanel.this.removeAllButton.setEnabled(!empty);
                    DetailPanel.this.setValid(!empty);
                }
            }
        };
        this.availableList.getModel().addListDataListener(listener);
        this.includeList.getModel().addListDataListener(listener);
    }

    private void fillTableCombo() {
        boolean empty;
        Connection con = this.connection.getJDBCConnection();
        try {
            DefaultComboBoxModel<ForeignKey> model = new DefaultComboBoxModel<ForeignKey>();
            ResultSet rs = con.getMetaData().getExportedKeys(con.getCatalog(), this.connection.getSchema(), this.masterTable);
            while (rs.next()) {
                String tableName = rs.getString("FKTABLE_NAME");
                boolean hasPK = J2EEUtils.hasPrimaryKey(this.connection, tableName);
                ForeignKey fk = new ForeignKey(rs.getString("PKTABLE_NAME"), rs.getString("PKCOLUMN_NAME"), tableName, rs.getString("FKCOLUMN_NAME"), hasPK);
                model.addElement(fk);
            }
            this.tableCombo.setModel(model);
            rs.close();
        }
        catch (Exception ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, ex.getMessage(), ex);
        }
        boolean bl = empty = this.tableCombo.getModel().getSize() == 0;
        if (empty) {
            this.fieldsChoice.setSelected(true);
            this.tableCombo.setEnabled(false);
            Mnemonics.setLocalizedText((JLabel)this.availableLabel, (String)NbBundle.getMessage(DetailPanel.class, (String)"LBL_DetailAvailableFields"));
            Mnemonics.setLocalizedText((JLabel)this.includeLabel, (String)NbBundle.getMessage(DetailPanel.class, (String)"LBL_DetailFieldsToInclude"));
            this.previewLabel.setIcon(this.fieldsIcon);
        }
        this.tableChoice.setEnabled(!empty);
        this.refreshLists();
    }

    private void refreshLists() {
        if (this.tableChoice.isSelected()) {
            this.tableCombo.setSelectedItem(this.tableCombo.getSelectedItem());
        } else {
            this.fillLists(this.masterTable);
        }
    }

    private void initComponents() {
        this.masterPanel = new JPanel();
        this.availableLabel = new JLabel();
        this.availablePane = new JScrollPane();
        this.availableList = new JList();
        this.addAllButton = new JButton();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.removeAllButton = new JButton();
        this.includePane = new JScrollPane();
        this.includeList = new JList();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.includeLabel = new JLabel();
        this.detailLabel = new JLabel();
        this.fieldsChoice = new JRadioButton();
        this.tableChoice = new JRadioButton();
        this.tableCombo = new JComboBox();
        this.previewLabel = new JLabel();
        this.buttonGroup = new ButtonGroup();
        FormListener formListener = new FormListener();
        this.masterPanel.setName(NbBundle.getMessage(DetailPanel.class, (String)"TITLE_DetailPanel"));
        this.availableLabel.setLabelFor(this.availableList);
        Mnemonics.setLocalizedText((JLabel)this.availableLabel, (String)NbBundle.getMessage(DetailPanel.class, (String)"LBL_DetailAvailableFields"));
        this.availableList.addListSelectionListener(formListener);
        this.availablePane.setViewportView(this.availableList);
        this.availableList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetailPanel.class, (String)"LBL_DetailAvailable_ACSD"));
        Mnemonics.setLocalizedText((AbstractButton)this.addAllButton, (String)NbBundle.getMessage(DetailPanel.class, (String)"LBL_DetailAddAll"));
        this.addAllButton.setEnabled(false);
        this.addAllButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(DetailPanel.class, (String)"LBL_DetailAdd"));
        this.addButton.setEnabled(false);
        this.addButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(DetailPanel.class, (String)"LBL_DetailRemove"));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.removeAllButton, (String)NbBundle.getMessage(DetailPanel.class, (String)"LBL_DetailRemoveAll"));
        this.removeAllButton.setEnabled(false);
        this.removeAllButton.addActionListener(formListener);
        this.includeList.addListSelectionListener(formListener);
        this.includePane.setViewportView(this.includeList);
        this.includeList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetailPanel.class, (String)"LBL_DetailToInclude_ACSD"));
        this.upButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/form/j2ee/resources/up.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.upButton, (String)NbBundle.getMessage(DetailPanel.class, (String)"LBL_DetailUp"));
        this.upButton.setEnabled(false);
        this.upButton.setHorizontalAlignment(10);
        if (!Utilities.isMac()) {
            this.upButton.setMargin(new Insets(2, 6, 2, 6));
        }
        this.upButton.addActionListener(formListener);
        this.downButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/form/j2ee/resources/down.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.downButton, (String)NbBundle.getMessage(DetailPanel.class, (String)"LBL_DetailDown"));
        this.downButton.setEnabled(false);
        this.downButton.setHorizontalAlignment(10);
        if (!Utilities.isMac()) {
            this.downButton.setMargin(new Insets(2, 6, 2, 6));
        }
        this.downButton.addActionListener(formListener);
        this.includeLabel.setLabelFor(this.includeList);
        Mnemonics.setLocalizedText((JLabel)this.includeLabel, (String)NbBundle.getMessage(DetailPanel.class, (String)"LBL_DetailFieldsToInclude"));
        Mnemonics.setLocalizedText((JLabel)this.detailLabel, (String)NbBundle.getMessage(DetailPanel.class, (String)"LBL_DetailType"));
        this.buttonGroup.add(this.fieldsChoice);
        this.fieldsChoice.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.fieldsChoice, (String)NbBundle.getMessage(DetailPanel.class, (String)"LBL_DetailTextfields"));
        this.fieldsChoice.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.fieldsChoice.setMargin(new Insets(0, 0, 0, 0));
        this.fieldsChoice.addActionListener(formListener);
        this.buttonGroup.add(this.tableChoice);
        Mnemonics.setLocalizedText((AbstractButton)this.tableChoice, (String)NbBundle.getMessage(DetailPanel.class, (String)"LBL_DetailTable"));
        this.tableChoice.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.tableChoice.setMargin(new Insets(0, 0, 0, 0));
        this.tableChoice.addActionListener(formListener);
        this.tableCombo.setEnabled(false);
        this.tableCombo.setRenderer(new ForeignKeyRenderer());
        this.tableCombo.addActionListener(formListener);
        GroupLayout masterPanelLayout = new GroupLayout((Container)this.masterPanel);
        this.masterPanel.setLayout((LayoutManager)masterPanelLayout);
        masterPanelLayout.setHorizontalGroup((GroupLayout.Group)masterPanelLayout.createParallelGroup(1).add((GroupLayout.Group)masterPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)masterPanelLayout.createParallelGroup(1).add((GroupLayout.Group)masterPanelLayout.createSequentialGroup().add((GroupLayout.Group)masterPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)masterPanelLayout.createSequentialGroup().add((Component)this.availablePane, -1, 170, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)masterPanelLayout.createParallelGroup(1, false).add((Component)this.addButton, -1, -1, Short.MAX_VALUE).add((Component)this.removeButton, -1, -1, Short.MAX_VALUE).add((Component)this.removeAllButton, -1, -1, Short.MAX_VALUE).add((Component)this.addAllButton, -1, -1, Short.MAX_VALUE))).add((Component)this.availableLabel)).addPreferredGap(0).add((GroupLayout.Group)masterPanelLayout.createParallelGroup(1).add((Component)this.includeLabel).add(2, (GroupLayout.Group)masterPanelLayout.createSequentialGroup().add((Component)this.includePane, -1, 170, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)masterPanelLayout.createParallelGroup(1, false).add((Component)this.upButton, -1, -1, Short.MAX_VALUE).add((Component)this.downButton, -1, -1, Short.MAX_VALUE))))).add((GroupLayout.Group)masterPanelLayout.createSequentialGroup().add((GroupLayout.Group)masterPanelLayout.createParallelGroup(1).add((Component)this.detailLabel).add((GroupLayout.Group)masterPanelLayout.createSequentialGroup().add(10, 10, 10).add((GroupLayout.Group)masterPanelLayout.createParallelGroup(1).add((GroupLayout.Group)masterPanelLayout.createSequentialGroup().add((Component)this.tableChoice).addPreferredGap(0).add((Component)this.tableCombo, 0, 311, Short.MAX_VALUE)).add((Component)this.fieldsChoice)))).add(10, 10, 10).add((Component)this.previewLabel, -2, 80, -2))).addContainerGap()));
        masterPanelLayout.linkSize(new Component[]{this.addAllButton, this.addButton, this.downButton, this.removeAllButton, this.removeButton, this.upButton}, 1);
        masterPanelLayout.setVerticalGroup((GroupLayout.Group)masterPanelLayout.createParallelGroup(1).add((GroupLayout.Group)masterPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)masterPanelLayout.createParallelGroup(1).add((GroupLayout.Group)masterPanelLayout.createSequentialGroup().add((Component)this.detailLabel).addPreferredGap(0).add((Component)this.fieldsChoice).addPreferredGap(0).add((GroupLayout.Group)masterPanelLayout.createParallelGroup(3).add((Component)this.tableChoice).add((Component)this.tableCombo, -2, -1, -2))).add((Component)this.previewLabel, -2, 60, -2)).addPreferredGap(0).add((GroupLayout.Group)masterPanelLayout.createParallelGroup(3).add((Component)this.availableLabel).add((Component)this.includeLabel)).addPreferredGap(0).add((GroupLayout.Group)masterPanelLayout.createParallelGroup(1).add((Component)this.includePane, 0, 0, Short.MAX_VALUE).add((GroupLayout.Group)masterPanelLayout.createSequentialGroup().addPreferredGap(0, 18, Short.MAX_VALUE).add((Component)this.addButton).addPreferredGap(0).add((GroupLayout.Group)masterPanelLayout.createParallelGroup(3).add((Component)this.addAllButton).add((Component)this.upButton)).addPreferredGap(0).add((GroupLayout.Group)masterPanelLayout.createParallelGroup(3).add((Component)this.removeButton).add((Component)this.downButton)).addPreferredGap(0).add((Component)this.removeAllButton).addPreferredGap(0, 19, Short.MAX_VALUE)).add((Component)this.availablePane, -1, 147, Short.MAX_VALUE)).addContainerGap()));
        this.addAllButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetailPanel.class, (String)"LBL_DetailAddAll_ACSD"));
        this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetailPanel.class, (String)"LBL_DetailAdd_ACSD"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetailPanel.class, (String)"LBL_DetailRemove_ACSD"));
        this.removeAllButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetailPanel.class, (String)"LBL_DetailRemoveAll_ACSD"));
        this.upButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetailPanel.class, (String)"LBL_DetailUp_ACSD"));
        this.downButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetailPanel.class, (String)"LBL_DetailDown_ACSD"));
        this.fieldsChoice.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetailPanel.class, (String)"LBL_DetailTextfields_ACSD"));
        this.tableChoice.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetailPanel.class, (String)"LBL_DetailTable_ACSD"));
        this.tableCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DetailPanel.class, (String)"LBL_DetailTable_ACSN"));
        this.tableCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetailPanel.class, (String)"LBL_DetailTable_ACSD"));
        this.masterPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetailPanel.class, (String)"TITLE_DetailPanel"));
    }

    private void tableComboActionPerformed(ActionEvent evt) {
        ForeignKey key = this.getForeignKey();
        this.fillLists(key.isValid() ? this.getForeignKey().getFKTable() : null);
    }

    private void tableChoiceActionPerformed(ActionEvent evt) {
        boolean selected = this.tableChoice.isSelected();
        this.tableCombo.setEnabled(selected);
        if (selected) {
            Mnemonics.setLocalizedText((JLabel)this.availableLabel, (String)NbBundle.getMessage(DetailPanel.class, (String)"LBL_DetailAvailableColumns"));
            Mnemonics.setLocalizedText((JLabel)this.includeLabel, (String)NbBundle.getMessage(DetailPanel.class, (String)"LBL_DetailColumnsToInclude"));
            ForeignKey key = this.getForeignKey();
            this.fillLists(key.isValid() ? this.getForeignKey().getFKTable() : null);
            this.previewLabel.setIcon(this.tableIcon);
        }
    }

    private void fieldsChoiceActionPerformed(ActionEvent evt) {
        if (this.fieldsChoice.isSelected()) {
            this.tableCombo.setEnabled(false);
            Mnemonics.setLocalizedText((JLabel)this.availableLabel, (String)NbBundle.getMessage(DetailPanel.class, (String)"LBL_DetailAvailableFields"));
            Mnemonics.setLocalizedText((JLabel)this.includeLabel, (String)NbBundle.getMessage(DetailPanel.class, (String)"LBL_DetailFieldsToInclude"));
            this.fillLists(this.masterTable);
            this.previewLabel.setIcon(this.fieldsIcon);
        }
    }

    private void downButtonActionPerformed(ActionEvent evt) {
        DefaultListModel model = (DefaultListModel)this.includeList.getModel();
        int index = this.includeList.getSelectedIndex();
        Object item = model.remove(index);
        model.add(index + 1, item);
        this.includeList.setSelectedIndex(index + 1);
        this.includeList.ensureIndexIsVisible(index + 1);
    }

    private void upButtonActionPerformed(ActionEvent evt) {
        DefaultListModel model = (DefaultListModel)this.includeList.getModel();
        int index = this.includeList.getSelectedIndex();
        Object item = model.remove(index);
        model.add(index - 1, item);
        this.includeList.setSelectedIndex(index - 1);
        this.includeList.ensureIndexIsVisible(index - 1);
    }

    private void removeAllButtonActionPerformed(ActionEvent evt) {
        DetailPanel.moveListItems(this.includeList, this.availableList, false);
        this.showMsg("MSG_AtLeastOneColumnIncluded");
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        DetailPanel.moveListItems(this.includeList, this.availableList, true);
        if (this.includeList.getModel().getSize() == 0) {
            this.showMsg("MSG_AtLeastOneColumnIncluded");
        }
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        DetailPanel.moveListItems(this.availableList, this.includeList, true);
        this.hideMsg();
    }

    private void addAllButtonActionPerformed(ActionEvent evt) {
        DetailPanel.moveListItems(this.availableList, this.includeList, false);
        this.hideMsg();
    }

    private void includeListValueChanged(ListSelectionEvent evt) {
        int[] index = this.includeList.getSelectedIndices();
        boolean single = index.length == 1;
        this.upButton.setEnabled(single && index[0] != 0);
        this.downButton.setEnabled(single && index[0] != this.includeList.getModel().getSize() - 1);
        boolean any = index.length > 0;
        this.removeButton.setEnabled(any);
        if (any) {
            this.availableList.clearSelection();
        }
    }

    private void availableListValueChanged(ListSelectionEvent evt) {
        boolean enabled = this.availableList.getSelectedIndex() != -1;
        this.addButton.setEnabled(enabled);
        if (enabled) {
            this.includeList.clearSelection();
        }
    }

    private void fillLists(String tableName) {
        this.hideMsg();
        Connection con = this.connection.getJDBCConnection();
        try {
            DefaultListModel model = (DefaultListModel)this.availableList.getModel();
            model.clear();
            model = (DefaultListModel)this.includeList.getModel();
            model.clear();
            if (tableName != null) {
                ResultSet rs = con.getMetaData().getColumns(con.getCatalog(), this.connection.getSchema(), tableName, "%");
                while (rs.next()) {
                    String columnName = rs.getString("COLUMN_NAME");
                    model.addElement(columnName);
                }
                rs.close();
                if (this.defaultPreselect) {
                    if (this.masterTable.equals(tableName)) {
                        this.preSelectColumns(this.masterColumns);
                    } else {
                        ForeignKey key = this.getForeignKey();
                        if (key != null) {
                            this.includeList.setSelectedValue(key.getFKColumn(), false);
                            DetailPanel.moveListItems(this.includeList, this.availableList, true);
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, ex.getMessage(), ex);
        }
    }

    private void preSelectColumns(List columnNames) {
        DefaultListModel availableModel = (DefaultListModel)this.availableList.getModel();
        DefaultListModel includeModel = (DefaultListModel)this.includeList.getModel();
        for (int i = includeModel.getSize() - 1; i >= 0; --i) {
            String column = (String)includeModel.getElementAt(i);
            if (columnNames.contains(column)) continue;
            includeModel.removeElementAt(i);
            availableModel.add(0, column);
        }
    }

    private ForeignKey getForeignKey() {
        return this.tableChoice.isSelected() ? (ForeignKey)this.tableCombo.getSelectedItem() : null;
    }

    private List getSelectedColumns() {
        DefaultListModel model = (DefaultListModel)this.includeList.getModel();
        return Arrays.asList(model.toArray());
    }

    private static void moveListItems(JList fromList, JList toList, boolean selected) {
        DefaultListModel fromModel = (DefaultListModel)fromList.getModel();
        DefaultListModel toModel = (DefaultListModel)toList.getModel();
        if (selected) {
            int i;
            int[] index = fromList.getSelectedIndices();
            for (i = 0; i < index.length; ++i) {
                Object item = fromModel.getElementAt(index[i]);
                toModel.addElement(item);
            }
            for (i = index.length - 1; i >= 0; --i) {
                fromModel.removeElementAt(index[i]);
            }
        } else {
            Enumeration items = fromModel.elements();
            while (items.hasMoreElements()) {
                toModel.addElement(items.nextElement());
            }
            fromModel.clear();
        }
    }

    public Component getComponent() {
        if (this.masterPanel == null) {
            this.initGUI();
        }
        return this.masterPanel;
    }

    public HelpCtx getHelp() {
        return new HelpCtx("org.netbeans.modules.form.j2ee.wizard.DetailPanel");
    }

    public void readSettings(Object settings) {
        WizardDescriptor wizard;
        this.wizardDesc = wizard = (WizardDescriptor)settings;
        this.connection = (DatabaseConnection)wizard.getProperty("connection");
        this.masterTable = (String)wizard.getProperty("master");
        this.masterColumns = (List)wizard.getProperty("masterColumns");
        ForeignKey key = this.getForeignKey();
        List detailColumns = (List)wizard.getProperty("detailColumns");
        if (key == null) {
            String detailTable = (String)wizard.getProperty("detailTable");
            if (this.masterTable.equals(detailTable) && detailColumns != null) {
                this.defaultPreselect = false;
            }
        } else {
            String pkTable = (String)wizard.getProperty("detailPKTable");
            String pkColumn = (String)wizard.getProperty("detailPKColumn");
            String fkTable = (String)wizard.getProperty("detailFKTable");
            String fkColumn = (String)wizard.getProperty("detailFKColumn");
            if (key.getPKTable().equals(pkTable) && key.getPKColumn().equals(pkColumn) && key.getFKTable().equals(fkTable) && key.getFKColumn().equals(fkColumn)) {
                this.defaultPreselect = false;
            }
        }
        this.fillTableCombo();
        if (!this.defaultPreselect) {
            this.preSelectColumns(detailColumns);
            this.defaultPreselect = true;
        }
        if (this.includeList.getModel().getSize() == 0) {
            this.showMsg("MSG_AtLeastOneColumnIncluded");
        } else {
            this.hideMsg();
        }
    }

    public void storeSettings(Object settings) {
        WizardDescriptor wizard = (WizardDescriptor)settings;
        ForeignKey key = this.getForeignKey();
        wizard.putProperty("detailTable", (Object)(key == null ? this.masterTable : null));
        wizard.putProperty("detailPKTable", (Object)(key == null ? null : key.getPKTable()));
        wizard.putProperty("detailPKColumn", (Object)(key == null ? null : key.getPKColumn()));
        wizard.putProperty("detailFKTable", (Object)(key == null ? null : key.getFKTable()));
        wizard.putProperty("detailFKColumn", (Object)(key == null ? null : key.getFKColumn()));
        wizard.putProperty("detailColumns", (Object)this.getSelectedColumns());
    }

    public boolean isValid() {
        return this.valid;
    }

    void setValid(boolean valid) {
        if (valid == this.valid) {
            return;
        }
        this.valid = valid;
        this.fireStateChanged();
    }

    public void addChangeListener(ChangeListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(ChangeListener.class, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        if (this.listenerList != null) {
            this.listenerList.remove(ChangeListener.class, listener);
        }
    }

    private void fireStateChanged() {
        if (this.listenerList == null) {
            return;
        }
        ChangeEvent e = null;
        ChangeListener[] listeners = (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
        for (int i = listeners.length - 1; i >= 0; --i) {
            if (e == null) {
                e = new ChangeEvent(this);
            }
            listeners[i].stateChanged(e);
        }
    }

    private void hideMsg() {
        this.showMsg(null);
    }

    private void showMsg(String msg) {
        if (this.wizardDesc != null) {
            this.wizardDesc.putProperty("WizardPanel_errorMessage", msg != null ? NbBundle.getMessage(this.getClass(), (String)msg) : null);
        }
    }

    static class ForeignKeyRenderer
    extends DefaultListCellRenderer {
        private final String FORMAT = NbBundle.getMessage(ForeignKeyRenderer.class, (String)"FMT_ForeignKey");
        private final String NO_PK = NbBundle.getMessage(ForeignKeyRenderer.class, (String)"FMT_NoPrimaryKey");

        ForeignKeyRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof ForeignKey) {
                ForeignKey key = (ForeignKey)value;
                String message = key.isValid() ? "" : this.NO_PK;
                String label = MessageFormat.format(this.FORMAT, key.getPKTable(), key.getPKColumn(), key.getFKTable(), key.getFKColumn(), message);
                this.setText(label);
                this.setEnabled(key.isValid());
            }
            return this;
        }
    }

    static class ForeignKey {
        private String pkTable;
        private String pkColumn;
        private String fkTable;
        private String fkColumn;
        private boolean valid;

        ForeignKey(String pkTable, String pkColumn, String fkTable, String fkColumn, boolean valid) {
            this.pkTable = pkTable;
            this.pkColumn = pkColumn;
            this.fkTable = fkTable;
            this.fkColumn = fkColumn;
            this.valid = valid;
        }

        String getPKTable() {
            return this.pkTable;
        }

        String getPKColumn() {
            return this.pkColumn;
        }

        String getFKTable() {
            return this.fkTable;
        }

        String getFKColumn() {
            return this.fkColumn;
        }

        boolean isValid() {
            return this.valid;
        }
    }

    private class FormListener
    implements ActionListener,
    ListSelectionListener {
        FormListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == DetailPanel.this.addAllButton) {
                DetailPanel.this.addAllButtonActionPerformed(evt);
            } else if (evt.getSource() == DetailPanel.this.addButton) {
                DetailPanel.this.addButtonActionPerformed(evt);
            } else if (evt.getSource() == DetailPanel.this.removeButton) {
                DetailPanel.this.removeButtonActionPerformed(evt);
            } else if (evt.getSource() == DetailPanel.this.removeAllButton) {
                DetailPanel.this.removeAllButtonActionPerformed(evt);
            } else if (evt.getSource() == DetailPanel.this.upButton) {
                DetailPanel.this.upButtonActionPerformed(evt);
            } else if (evt.getSource() == DetailPanel.this.downButton) {
                DetailPanel.this.downButtonActionPerformed(evt);
            } else if (evt.getSource() == DetailPanel.this.fieldsChoice) {
                DetailPanel.this.fieldsChoiceActionPerformed(evt);
            } else if (evt.getSource() == DetailPanel.this.tableChoice) {
                DetailPanel.this.tableChoiceActionPerformed(evt);
            } else if (evt.getSource() == DetailPanel.this.tableCombo) {
                DetailPanel.this.tableComboActionPerformed(evt);
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent evt) {
            if (evt.getSource() == DetailPanel.this.availableList) {
                DetailPanel.this.availableListValueChanged(evt);
            } else if (evt.getSource() == DetailPanel.this.includeList) {
                DetailPanel.this.includeListValueChanged(evt);
            }
        }
    }
}

