/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.mozilla.nb.javascript.Node;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.IndexSearcher;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.javascript.editing.AstUtilities;
import org.netbeans.modules.javascript.editing.IndexedElement;
import org.netbeans.modules.javascript.editing.JsIndex;
import org.netbeans.modules.javascript.editing.JsParseResult;
import org.netbeans.modules.javascript.editing.lexer.LexUtilities;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class JsTypeSearcher
implements IndexSearcher {
    private static final Logger LOG = Logger.getLogger(JsTypeSearcher.class.getName());
    private static Pattern camelCasePattern = Pattern.compile("(?:\\p{javaUpperCase}(?:\\p{javaLowerCase}|\\p{Digit}|\\:|\\.|\\$)*){2,}");
    private QuerySupport.Kind cachedKind;
    private String cachedString = "/";

    private static boolean isAllUpper(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isUpperCase(c) || c == ':') continue;
            return false;
        }
        return true;
    }

    private static boolean isCamelCase(String string) {
        return camelCasePattern.matcher(string).matches();
    }

    private QuerySupport.Kind adjustKind(QuerySupport.Kind kind, String string) {
        if (string.equals(this.cachedString)) {
            return this.cachedKind;
        }
        if (kind == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX && (JsTypeSearcher.isAllUpper(string) && string.length() > 1 || JsTypeSearcher.isCamelCase(string))) {
            kind = QuerySupport.Kind.CAMEL_CASE;
        }
        this.cachedString = string;
        this.cachedKind = kind;
        return kind;
    }

    public Set<? extends IndexSearcher.Descriptor> getTypes(Project project, String string, QuerySupport.Kind kind, IndexSearcher.Helper helper) {
        Set<IndexedElement> set;
        JsIndex jsIndex = JsIndex.get(QuerySupport.findRoots((Project)project, null, Collections.emptySet(), Collections.emptySet()));
        if ((kind = this.adjustKind(kind, string)) == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX) {
            string = string.toLowerCase();
        }
        HashSet<JsSymbolDescriptor> hashSet = new HashSet<JsSymbolDescriptor>();
        int n = string.lastIndexOf(46);
        if (n != -1 && (kind == QuerySupport.Kind.PREFIX || kind == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX)) {
            String string2 = string.substring(n + 1);
            String object = string.substring(0, n);
            set = jsIndex.getElements(string2, object, kind, null);
        } else {
            set = jsIndex.getAllNames(string, kind, null);
        }
        for (IndexedElement indexedElement : set) {
            hashSet.add(new JsSymbolDescriptor(indexedElement, helper));
        }
        return hashSet;
    }

    public Set<? extends IndexSearcher.Descriptor> getSymbols(Project project, String string, QuerySupport.Kind kind, IndexSearcher.Helper helper) {
        Set<IndexedElement> set;
        JsIndex jsIndex = JsIndex.get(QuerySupport.findRoots((Project)project, null, Collections.emptySet(), Collections.emptySet()));
        if ((kind = this.adjustKind(kind, string)) == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX) {
            string = string.toLowerCase();
        }
        HashSet<JsSymbolDescriptor> hashSet = new HashSet<JsSymbolDescriptor>();
        int n = string.lastIndexOf(46);
        if (n != -1 && (kind == QuerySupport.Kind.PREFIX || kind == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX)) {
            String string2 = string.substring(n + 1);
            String object = string.substring(0, n);
            set = jsIndex.getElements(string2, object, kind, null);
        } else {
            set = jsIndex.getAllNames(string, kind, null);
        }
        for (IndexedElement indexedElement : set) {
            hashSet.add(new JsSymbolDescriptor(indexedElement, helper));
        }
        return hashSet;
    }

    private class JsSymbolDescriptor
    extends IndexSearcher.Descriptor {
        private final IndexedElement element;
        private String projectName;
        private Icon projectIcon;
        private final IndexSearcher.Helper helper;
        private boolean isLibrary;
        private static final String ICON_PATH = "org/netbeans/modules/javascript/editing/javascript.png";

        public JsSymbolDescriptor(IndexedElement indexedElement, IndexSearcher.Helper helper) {
            this.element = indexedElement;
            this.helper = helper;
        }

        public Icon getIcon() {
            if (this.projectName == null) {
                this.initProjectInfo();
            }
            return this.helper.getIcon((ElementHandle)this.element);
        }

        public String getTypeName() {
            return this.element.getName();
        }

        public String getProjectName() {
            if (this.projectName == null) {
                this.initProjectInfo();
            }
            return this.projectName;
        }

        private void initProjectInfo() {
            FileObject fileObject = this.element.getFileObject();
            if (fileObject != null) {
                File file = FileUtil.toFile((FileObject)fileObject);
                Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
                if (project != null) {
                    ProjectInformation projectInformation = ProjectUtils.getInformation((Project)project);
                    this.projectName = projectInformation.getDisplayName();
                    this.projectIcon = projectInformation.getIcon();
                }
            } else {
                this.isLibrary = true;
                Logger.getLogger(JsTypeSearcher.class.getName()).fine("No fileobject for " + this.element.toString() + " with fileurl=" + this.element.getFilenameUrl());
            }
            if (this.projectName == null) {
                this.projectName = "";
            }
        }

        public Icon getProjectIcon() {
            if (this.projectName == null) {
                this.initProjectInfo();
            }
            if (this.isLibrary) {
                return ImageUtilities.loadImageIcon((String)ICON_PATH, (boolean)false);
            }
            return this.projectIcon;
        }

        public FileObject getFileObject() {
            return this.element.getFileObject();
        }

        public void open() {
            JsParseResult[] jsParseResultArray = new JsParseResult[1];
            Node node = AstUtilities.getForeignNode(this.element, jsParseResultArray);
            if (node != null) {
                int n = AstUtilities.getRange(node).getStart();
                int n2 = LexUtilities.getLexerOffset(jsParseResultArray[0], n);
                if (n2 == -1) {
                    n2 = 0;
                }
                GsfUtilities.open((FileObject)this.element.getFileObject(), (int)n2, (String)this.element.getName());
                return;
            }
            FileObject fileObject = this.element.getFileObject();
            if (fileObject == null) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(JsTypeSearcher.class, (String)"FileDeleted"), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                return;
            }
            this.helper.open(fileObject, (ElementHandle)this.element);
        }

        public String getContextName() {
            String string;
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = string = this.element.getIn() != null ? this.element.getIn() + "." + this.element.getName() : this.element.getName();
            if (this.element.getName().equals(string)) {
                string = null;
                String string3 = this.element.getFilenameUrl();
                if (string3 != null) {
                    return string3.substring(string3.lastIndexOf(47) + 1);
                }
            }
            return string;
        }

        public ElementHandle getElement() {
            return this.element;
        }

        public int getOffset() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getSimpleName() {
            return this.element.getName();
        }

        public String getOuterName() {
            return null;
        }
    }
}

