/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.operators;

import java.awt.Color;
import java.awt.Container;
import java.util.Hashtable;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.plaf.ColorChooserUI;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.ComponentSearcher;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JComponentOperator;
import org.netbeans.jemmy.operators.JTabbedPaneOperator;
import org.netbeans.jemmy.operators.JTextFieldOperator;
import org.netbeans.jemmy.operators.Operator;

public class JColorChooserOperator
extends JComponentOperator
implements Outputable {
    public static final String COLOR_DPROP = "Color";
    public static final String SELECTED_PAGE_DPROP = "Selected page";
    private static final String RGB_TITLE = "RGB";
    private static final long WAIT_LIST_PAINTED_TIMEOUT = 60000L;
    private TestOut output;
    private JTabbedPaneOperator tabbed;
    private JTextFieldOperator red;
    private JTextFieldOperator green;
    private JTextFieldOperator blue;

    public JColorChooserOperator(JColorChooser comp) {
        super(comp);
        this.setTimeouts(JemmyProperties.getProperties().getTimeouts());
        this.setOutput(JemmyProperties.getProperties().getOutput());
        this.tabbed = new JTabbedPaneOperator(this);
    }

    public JColorChooserOperator(ContainerOperator cont, ComponentChooser chooser, int index) {
        this((JColorChooser)cont.waitSubComponent(new JColorChooserFinder(chooser), index));
        this.copyEnvironment(cont);
    }

    public JColorChooserOperator(ContainerOperator cont, ComponentChooser chooser) {
        this(cont, chooser, 0);
    }

    public JColorChooserOperator(ContainerOperator cont, int index) {
        this((JColorChooser)JColorChooserOperator.waitComponent(cont, (ComponentChooser)new JColorChooserFinder(), index));
        this.copyEnvironment(cont);
    }

    public JColorChooserOperator(ContainerOperator cont) {
        this(cont, 0);
    }

    public static JColorChooser findJColorChooser(Container cont, ComponentChooser chooser, int index) {
        return (JColorChooser)JColorChooserOperator.findComponent(cont, new JColorChooserFinder(chooser), index);
    }

    public static JColorChooser findJColorChooser(Container cont, ComponentChooser chooser) {
        return JColorChooserOperator.findJColorChooser(cont, chooser, 0);
    }

    public static JColorChooser findJColorChooser(Container cont, int index) {
        return JColorChooserOperator.findJColorChooser(cont, ComponentSearcher.getTrueChooser(Integer.toString(index) + "'th JColorChooser instance"), index);
    }

    public static JColorChooser findJColorChooser(Container cont) {
        return JColorChooserOperator.findJColorChooser(cont, 0);
    }

    public static JColorChooser waitJColorChooser(Container cont, ComponentChooser chooser, int index) {
        return (JColorChooser)JColorChooserOperator.waitComponent(cont, (ComponentChooser)new JColorChooserFinder(chooser), index);
    }

    public static JColorChooser waitJColorChooser(Container cont, ComponentChooser chooser) {
        return JColorChooserOperator.waitJColorChooser(cont, chooser, 0);
    }

    public static JColorChooser waitJColorChooser(Container cont, int index) {
        return JColorChooserOperator.waitJColorChooser(cont, ComponentSearcher.getTrueChooser(Integer.toString(index) + "'th JColorChooser instance"), index);
    }

    public static JColorChooser waitJColorChooser(Container cont) {
        return JColorChooserOperator.waitJColorChooser(cont, 0);
    }

    public void setOutput(TestOut out) {
        this.output = out;
        super.setOutput(this.output.createErrorOutput());
    }

    public TestOut getOutput() {
        return this.output;
    }

    public void switchToRGB() {
        if (!this.tabbed.getTitleAt(this.tabbed.getSelectedIndex()).equals(RGB_TITLE)) {
            this.tabbed.selectPage(RGB_TITLE);
        }
        this.blue = new JTextFieldOperator((ContainerOperator)this, 2);
        this.green = new JTextFieldOperator((ContainerOperator)this, 1);
        this.red = new JTextFieldOperator((ContainerOperator)this, 0);
    }

    public void enterRed(int value) {
        this.switchToRGB();
        this.red.setText(Integer.toString(value));
    }

    public void enterGreen(int value) {
        this.switchToRGB();
        this.green.setText(Integer.toString(value));
    }

    public void enterBlue(int value) {
        this.switchToRGB();
        this.blue.setText(Integer.toString(value));
    }

    public void enterColor(int red, int green, int blue) {
        this.switchToRGB();
        this.enterRed(red);
        this.enterGreen(green);
        this.enterBlue(blue);
    }

    public void enterColor(Color color) {
        this.enterColor(color.getRed(), color.getGreen(), color.getBlue());
    }

    public void enterColor(int color) {
        this.enterColor(new Color(color));
    }

    public Hashtable getDump() {
        Hashtable result = super.getDump();
        result.put(COLOR_DPROP, ((JColorChooser)this.getSource()).getColor().toString());
        JTabbedPane tb = (JTabbedPane)this.tabbed.getSource();
        result.put(SELECTED_PAGE_DPROP, tb.getTitleAt(tb.getSelectedIndex()));
        return result;
    }

    public void addChooserPanel(final AbstractColorChooserPanel abstractColorChooserPanel) {
        this.runMapping(new Operator.MapVoidAction("addChooserPanel"){

            public void map() {
                ((JColorChooser)JColorChooserOperator.this.getSource()).addChooserPanel(abstractColorChooserPanel);
            }
        });
    }

    public AbstractColorChooserPanel[] getChooserPanels() {
        return (AbstractColorChooserPanel[])this.runMapping(new Operator.MapAction("getChooserPanels"){

            public Object map() {
                return ((JColorChooser)JColorChooserOperator.this.getSource()).getChooserPanels();
            }
        });
    }

    public Color getColor() {
        return (Color)this.runMapping(new Operator.MapAction("getColor"){

            public Object map() {
                return ((JColorChooser)JColorChooserOperator.this.getSource()).getColor();
            }
        });
    }

    public JComponent getPreviewPanel() {
        return (JComponent)this.runMapping(new Operator.MapAction("getPreviewPanel"){

            public Object map() {
                return ((JColorChooser)JColorChooserOperator.this.getSource()).getPreviewPanel();
            }
        });
    }

    public ColorSelectionModel getSelectionModel() {
        return (ColorSelectionModel)this.runMapping(new Operator.MapAction("getSelectionModel"){

            public Object map() {
                return ((JColorChooser)JColorChooserOperator.this.getSource()).getSelectionModel();
            }
        });
    }

    public ColorChooserUI getUI() {
        return (ColorChooserUI)this.runMapping(new Operator.MapAction("getUI"){

            public Object map() {
                return ((JColorChooser)JColorChooserOperator.this.getSource()).getUI();
            }
        });
    }

    public AbstractColorChooserPanel removeChooserPanel(final AbstractColorChooserPanel abstractColorChooserPanel) {
        return (AbstractColorChooserPanel)this.runMapping(new Operator.MapAction("removeChooserPanel"){

            public Object map() {
                return ((JColorChooser)JColorChooserOperator.this.getSource()).removeChooserPanel(abstractColorChooserPanel);
            }
        });
    }

    public void setChooserPanels(final AbstractColorChooserPanel[] abstractColorChooserPanel) {
        this.runMapping(new Operator.MapVoidAction("setChooserPanels"){

            public void map() {
                ((JColorChooser)JColorChooserOperator.this.getSource()).setChooserPanels(abstractColorChooserPanel);
            }
        });
    }

    public void setColor(final int i) {
        this.runMapping(new Operator.MapVoidAction("setColor"){

            public void map() {
                ((JColorChooser)JColorChooserOperator.this.getSource()).setColor(i);
            }
        });
    }

    public void setColor(final int i, final int i1, final int i2) {
        this.runMapping(new Operator.MapVoidAction("setColor"){

            public void map() {
                ((JColorChooser)JColorChooserOperator.this.getSource()).setColor(i, i1, i2);
            }
        });
    }

    public void setColor(final Color color) {
        this.runMapping(new Operator.MapVoidAction("setColor"){

            public void map() {
                ((JColorChooser)JColorChooserOperator.this.getSource()).setColor(color);
            }
        });
    }

    public void setPreviewPanel(final JComponent jComponent) {
        this.runMapping(new Operator.MapVoidAction("setPreviewPanel"){

            public void map() {
                ((JColorChooser)JColorChooserOperator.this.getSource()).setPreviewPanel(jComponent);
            }
        });
    }

    public void setSelectionModel(final ColorSelectionModel colorSelectionModel) {
        this.runMapping(new Operator.MapVoidAction("setSelectionModel"){

            public void map() {
                ((JColorChooser)JColorChooserOperator.this.getSource()).setSelectionModel(colorSelectionModel);
            }
        });
    }

    public void setUI(final ColorChooserUI colorChooserUI) {
        this.runMapping(new Operator.MapVoidAction("setUI"){

            public void map() {
                ((JColorChooser)JColorChooserOperator.this.getSource()).setUI(colorChooserUI);
            }
        });
    }

    public static class JColorChooserFinder
    extends Operator.Finder {
        public JColorChooserFinder(ComponentChooser sf) {
            super(JColorChooser.class, sf);
        }

        public JColorChooserFinder() {
            super(JColorChooser.class);
        }
    }
}

