/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.api;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class HudsonVersion
implements Comparable<HudsonVersion> {
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)\\b.*");
    public static final HudsonVersion SUPPORTED_VERSION = new HudsonVersion("1.291");
    private final int major;
    private final int minor;

    public HudsonVersion(String version) {
        Matcher m = VERSION_PATTERN.matcher(version);
        if (!m.matches()) {
            throw new IllegalArgumentException(version);
        }
        this.major = Integer.parseInt(m.group(1));
        this.minor = Integer.parseInt(m.group(2));
    }

    public int getMajorVersion() {
        return this.major;
    }

    public int getMinorVersion() {
        return this.minor;
    }

    public String toString() {
        return this.major + "." + this.minor;
    }

    public boolean equals(Object o) {
        if (!(o instanceof HudsonVersion)) {
            return false;
        }
        HudsonVersion oV = (HudsonVersion)o;
        return this.major == oV.major && this.minor == oV.minor;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public int compareTo(HudsonVersion o) {
        if (this.equals(o)) {
            return 0;
        }
        return this.major < o.major ? -1 : (this.major > o.major ? 1 : (this.minor < o.minor ? -1 : (this.minor > o.minor ? 1 : 0)));
    }
}

