/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.util;

import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.xml.namespace.QName;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.websvc.jaxwsruntimemodel.JavaWsdlMapper;
import org.netbeans.modules.websvc.wsitconf.spi.WsitProvider;
import org.netbeans.modules.websvc.wsitconf.util.ServerUtils;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingFault;
import org.netbeans.modules.xml.wsdl.model.BindingInput;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.BindingOutput;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.Input;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.Output;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.ReferenceableWSDLComponent;
import org.netbeans.modules.xml.wsdl.model.RequestResponseOperation;
import org.netbeans.modules.xml.wsdl.model.WSDLComponentFactory;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.ModelSource;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.NbBundle;

public class Util {
    public static final String MEX_CLASS_NAME = "com.sun.xml.ws.mex.server.MEXEndpoint";
    public static final String MEX_NAME = "MEXEndpoint";
    private static final Logger logger = Logger.getLogger(Util.class.getName());

    public static void changeLabelInComponent(JComponent component, String oldLabel, String newLabel) {
        JLabel label = Util.findLabel(component, oldLabel);
        if (label != null) {
            label.setText(newLabel);
        }
    }

    public static void hideLabelAndLabelFor(JComponent component, String lab) {
        JLabel label = Util.findLabel(component, lab);
        if (label != null) {
            label.setVisible(false);
            Component c = label.getLabelFor();
            if (c != null) {
                c.setVisible(false);
            }
        }
    }

    public static void getAllComponents(Component[] components, Collection<Component> allComponents) {
        for (int i = 0; i < components.length; ++i) {
            if (components[i] == null) continue;
            allComponents.add(components[i]);
            if (((Container)components[i]).getComponentCount() == 0) continue;
            Util.getAllComponents(((Container)components[i]).getComponents(), allComponents);
        }
    }

    public static JLabel findLabel(JComponent comp, String labelText) {
        ArrayList<Component> allComponents = new ArrayList<Component>();
        Util.getAllComponents(comp.getComponents(), allComponents);
        for (Component c : allComponents) {
            JLabel label;
            if (!(c instanceof JLabel) || !(label = (JLabel)c).getText().equals(labelText)) continue;
            return label;
        }
        return null;
    }

    public static SourceGroup[] getJavaSourceGroups(Project project) {
        SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        Set<SourceGroup> testGroups = Util.getTestSourceGroups(sourceGroups);
        ArrayList<SourceGroup> result = new ArrayList<SourceGroup>();
        for (int i = 0; i < sourceGroups.length; ++i) {
            if (testGroups.contains(sourceGroups[i])) continue;
            result.add(sourceGroups[i]);
        }
        return result.toArray(new SourceGroup[result.size()]);
    }

    private static Set<SourceGroup> getTestSourceGroups(SourceGroup[] sourceGroups) {
        Map foldersToSourceGroupsMap = Util.createFoldersToSourceGroupsMap(sourceGroups);
        HashSet<SourceGroup> testGroups = new HashSet<SourceGroup>();
        for (int i = 0; i < sourceGroups.length; ++i) {
            testGroups.addAll(Util.getTestTargets(sourceGroups[i], foldersToSourceGroupsMap));
        }
        return testGroups;
    }

    private static Map createFoldersToSourceGroupsMap(SourceGroup[] sourceGroups) {
        Map<FileObject, SourceGroup> result;
        if (sourceGroups.length == 0) {
            result = Collections.emptyMap();
        } else {
            result = new HashMap(2 * sourceGroups.length, 0.5f);
            for (int i = 0; i < sourceGroups.length; ++i) {
                SourceGroup sourceGroup = sourceGroups[i];
                result.put(sourceGroup.getRootFolder(), sourceGroup);
            }
        }
        return result;
    }

    private static List<FileObject> getFileObjects(URL[] urls) {
        ArrayList<FileObject> result = new ArrayList<FileObject>();
        for (int i = 0; i < urls.length; ++i) {
            FileObject sourceRoot = URLMapper.findFileObject((URL)urls[i]);
            if (sourceRoot != null) {
                result.add(sourceRoot);
                continue;
            }
            if (!logger.isLoggable(Level.INFO)) continue;
            logger.log(Level.INFO, "No FileObject found for the following URL: " + urls[i]);
        }
        return result;
    }

    private static List<SourceGroup> getTestTargets(SourceGroup sourceGroup, Map foldersToSourceGroupsMap) {
        URL[] rootURLs = UnitTestForSourceQuery.findUnitTests((FileObject)sourceGroup.getRootFolder());
        if (rootURLs.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<SourceGroup> result = new ArrayList<SourceGroup>();
        List<FileObject> sourceRoots = Util.getFileObjects(rootURLs);
        for (int i = 0; i < sourceRoots.size(); ++i) {
            FileObject sourceRoot = sourceRoots.get(i);
            SourceGroup srcGroup = (SourceGroup)foldersToSourceGroupsMap.get(sourceRoot);
            if (srcGroup == null) continue;
            result.add(srcGroup);
        }
        return result;
    }

    public static boolean isPositiveNumber(String s, boolean zeroAllowed, boolean allowEmptyValue) {
        Integer i = null;
        if (s == null || "".equals(s)) {
            return allowEmptyValue;
        }
        try {
            i = Integer.parseInt(s);
            if (i != null) {
                if (zeroAllowed) {
                    return i >= 0;
                }
                return i > 0;
            }
        }
        catch (NumberFormatException nfe) {
            logger.log(Level.FINE, null, nfe);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getAliases(String storePath, char[] password, String type) throws IOException {
        if (storePath == null || type == null) {
            return null;
        }
        FileInputStream iStream = null;
        try {
            File f = new File(storePath);
            if (f == null || !f.exists()) {
                throw new IOException();
            }
            iStream = new FileInputStream(f);
            KeyStore keyStore = KeyStore.getInstance(type);
            keyStore.load(iStream, password);
            Enumeration<String> e = keyStore.aliases();
            ArrayList<String> arr = new ArrayList<String>(keyStore.size());
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                arr.add(key);
            }
            Collections.sort(arr);
            ArrayList<String> arrayList = arr;
            return arrayList;
        }
        catch (FileNotFoundException ex) {
            logger.log(Level.INFO, null, ex);
        }
        catch (KeyStoreException ex) {
            logger.log(Level.INFO, null, ex);
        }
        catch (NoSuchAlgorithmException ex) {
            logger.log(Level.INFO, null, ex);
        }
        catch (CertificateException ex) {
            logger.log(Level.INFO, null, ex);
        }
        finally {
            if (iStream != null) {
                iStream.close();
            }
        }
        return null;
    }

    public static final String getPassword(Project p) {
        J2eeModuleProvider mp = (J2eeModuleProvider)p.getLookup().lookup(J2eeModuleProvider.class);
        if (mp != null) {
            InstanceProperties ip = mp.getInstanceProperties();
            return ip.getProperty("password");
        }
        return "";
    }

    public static boolean isJavaEE5orHigher(Project project) {
        J2eeModule j2eeModule;
        if (project == null) {
            return false;
        }
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider != null && (j2eeModule = j2eeModuleProvider.getJ2eeModule()) != null) {
            J2eeModule.Type type = j2eeModule.getType();
            double version = Double.parseDouble(j2eeModule.getModuleVersion());
            if (J2eeModule.Type.EJB.equals(type) && version > 2.1) {
                return true;
            }
            if (J2eeModule.Type.WAR.equals(type) && version > 2.4) {
                return true;
            }
            if (J2eeModule.Type.CAR.equals(type) && version > 1.4) {
                return true;
            }
        }
        return false;
    }

    public static boolean isEqual(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a != null && b != null) {
            return a.equals(b);
        }
        return false;
    }

    private static boolean isOperationInList(String operName, Collection<BindingOperation> operations) {
        for (BindingOperation bo : operations) {
            if (bo == null || !operName.equals(bo.getName())) continue;
            return true;
        }
        return false;
    }

    public static Collection<BindingOperation> refreshOperations(Binding binding, FileObject jc) {
        if (binding == null) {
            return null;
        }
        Collection operations = binding.getBindingOperations();
        if (jc == null) {
            return operations;
        }
        PortType pt = Util.getPortType(binding);
        List<String> bindingOperationNames = JavaWsdlMapper.getOperationNames(jc);
        for (String name : bindingOperationNames) {
            if (Util.isOperationInList(name, operations)) continue;
            Util.generateOperation(binding, pt, name, jc);
        }
        return binding.getBindingOperations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BindingOperation generateOperation(Binding binding, PortType portType, String operationName, FileObject implClass) {
        WSDLModel model = binding.getModel();
        WSDLComponentFactory wcf = model.getFactory();
        Definitions d = (Definitions)binding.getParent();
        BindingOperation bindingOperation = null;
        boolean isTransaction = model.isIntransaction();
        if (!isTransaction) {
            model.startTransaction();
        }
        try {
            bindingOperation = wcf.createBindingOperation();
            bindingOperation.setName(operationName);
            binding.addBindingOperation(bindingOperation);
            Message inputMsg = wcf.createMessage();
            inputMsg.setName(operationName);
            d.addMessage(inputMsg);
            Message outMsg = wcf.createMessage();
            outMsg.setName(operationName + "Response");
            d.addMessage(outMsg);
            RequestResponseOperation oper = wcf.createRequestResponseOperation();
            oper.setName(operationName);
            portType.addOperation((Operation)oper);
            Input input = wcf.createInput();
            oper.setInput(input);
            input.setMessage(input.createReferenceTo((ReferenceableWSDLComponent)inputMsg, Message.class));
            Output out = wcf.createOutput();
            oper.setOutput(out);
            out.setMessage(out.createReferenceTo((ReferenceableWSDLComponent)outMsg, Message.class));
            BindingOutput bindingOutput = wcf.createBindingOutput();
            bindingOperation.setBindingOutput(bindingOutput);
            BindingInput bindingInput = wcf.createBindingInput();
            bindingOperation.setBindingInput(bindingInput);
            List<String> operationFaults = JavaWsdlMapper.getOperationFaults(implClass, operationName);
            for (String fault : operationFaults) {
                BindingFault bindingFault = wcf.createBindingFault();
                bindingOperation.addBindingFault(bindingFault);
            }
        }
        catch (NullPointerException npe) {
            logger.log(Level.INFO, "Cannot create operation: " + operationName + ", " + portType + npe.getLocalizedMessage());
        }
        finally {
            if (!isTransaction) {
                model.endTransaction();
            }
        }
        return bindingOperation;
    }

    public static PortType getPortType(Binding binding) {
        Definitions d = (Definitions)binding.getParent();
        QName portTypeQName = binding.getType().getQName();
        PortType portType = null;
        Collection portTypes = d.getPortTypes();
        for (PortType pt : portTypes) {
            if (pt == null || !portTypeQName.getLocalPart().equals(pt.getName())) continue;
            portType = pt;
            break;
        }
        return portType;
    }

    public static FileObject getFOForModel(WSDLModel model) {
        if (model == null) {
            return null;
        }
        ModelSource ms = model.getModelSource();
        return Utilities.getFileObject((ModelSource)ms);
    }

    public static FileObject getSunDDFO(Project p) {
        J2eeModuleProvider provider = ServerUtils.getProvider(p);
        if (provider == null) {
            return null;
        }
        FileObject[] fobjs = provider.getConfigurationFiles();
        if (fobjs.length > 0) {
            return fobjs[0];
        }
        return null;
    }

    public static Servlet getServlet(WebApp wa, String className) {
        Servlet[] servlets;
        for (Servlet s : servlets = wa.getServlet()) {
            if (!className.equals(s.getServletClass())) continue;
            return s;
        }
        return null;
    }

    public static void checkMetroLibrary(Project p) {
        Object button;
        if (p == null) {
            return;
        }
        WsitProvider wsitProvider = (WsitProvider)p.getLookup().lookup(WsitProvider.class);
        if (wsitProvider == null) {
            return;
        }
        if (!wsitProvider.isWsitSupported() && NotifyDescriptor.OK_OPTION.equals(button = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(Util.class, (String)"TXT_AddLibraries"), 0)))) {
            wsitProvider.addMetroLibrary();
        }
    }

    public static void checkMetroRtLibrary(Project p, boolean askFirst) {
        if (p == null) {
            return;
        }
        WsitProvider wsitProvider = (WsitProvider)p.getLookup().lookup(WsitProvider.class);
        if (wsitProvider == null) {
            return;
        }
        if (wsitProvider.isWsitSupported() && !wsitProvider.isWsitRtOnClasspath()) {
            if (askFirst) {
                Object button = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(Util.class, (String)"TXT_AddRtLibrary"), 0));
                if (NotifyDescriptor.OK_OPTION.equals(button)) {
                    wsitProvider.addMetroRtLibrary();
                }
            } else {
                wsitProvider.addMetroRtLibrary();
            }
        }
    }
}

