/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.commands;

import java.util.Set;
import java.util.logging.Level;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.netbeans.modules.bugzilla.commands.BugzillaCommand;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;

public class GetMultiTaskDataCommand
extends BugzillaCommand {
    private final BugzillaRepository repository;
    private final Set<String> ids;
    private final TaskDataCollector collector;

    public GetMultiTaskDataCommand(BugzillaRepository repository, Set<String> ids, TaskDataCollector collector) {
        this.repository = repository;
        this.ids = ids;
        this.collector = collector;
    }

    @Override
    public void execute() throws CoreException {
        if (Bugzilla.LOG.isLoggable(Level.FINER)) {
            Bugzilla.LOG.log(Level.FINER, "will retrieve data for issues: {0}", this.print(this.ids));
        }
        Bugzilla.getInstance().getRepositoryConnector().getTaskDataHandler().getMultiTaskData(this.repository.getTaskRepository(), this.ids, this.collector, (IProgressMonitor)new NullProgressMonitor());
    }

    private String print(Set<String> ids) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (String string : ids) {
            sb.append(string);
            if (++i >= ids.size()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("GetMultiTaskDataCommand [repository=");
        sb.append(this.repository.getUrl());
        sb.append(",...]");
        return sb.toString();
    }
}

