/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.issue;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.bugtracking.util.LinkButton;
import org.netbeans.modules.bugtracking.util.UIUtils;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.netbeans.modules.bugzilla.issue.AttachmentPanel;
import org.netbeans.modules.bugzilla.issue.BugzillaIssue;
import org.openide.util.NbBundle;

public class AttachmentsPanel
extends JPanel {
    private static final Color BG_COLOR = new Color(220, 220, 220);
    private boolean hadNoAttachments = true;
    private List<AttachmentPanel> newAttachments;
    private JLabel noneLabel;
    private LinkButton createNewButton;
    private JLabel dummyLabel = new JLabel();
    private Method maxMethod;
    private PropertyChangeListener deletedListener;

    public AttachmentsPanel() {
        this.setBackground(UIManager.getColor("EditorPane.background"));
        ResourceBundle bundle = NbBundle.getBundle(AttachmentsPanel.class);
        this.noneLabel = new JLabel(bundle.getString("AttachmentsPanel.noneLabel.text"));
        this.createNewButton = new LinkButton((Action)new CreateNewAction());
        this.createNewButton.getAccessibleContext().setAccessibleDescription(bundle.getString("AttachmentPanels.createNewButton.AccessibleContext.accessibleDescription"));
        try {
            this.maxMethod = GroupLayout.Group.class.getDeclaredMethod("calculateMaximumSize", Integer.TYPE);
            this.maxMethod.setAccessible(true);
        }
        catch (NoSuchMethodException nsmex) {
            Bugzilla.LOG.log(Level.INFO, nsmex.getMessage(), nsmex);
        }
    }

    void setAttachments(List<BugzillaIssue.Attachment> attachments) {
        this.hadNoAttachments = attachments.isEmpty();
        this.newAttachments = new LinkedList<AttachmentPanel>();
        this.removeAll();
        GroupLayout layout = new GroupLayout((Container)this);
        GroupLayout.ParallelGroup horizontalGroup = layout.createParallelGroup(1);
        GroupLayout.SequentialGroup verticalGroup = layout.createSequentialGroup();
        ResourceBundle bundle = NbBundle.getBundle(AttachmentsPanel.class);
        GroupLayout.SequentialGroup newVerticalGroup = layout.createSequentialGroup();
        boolean noAttachments = this.hadNoAttachments;
        horizontalGroup.add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.noneLabel).addPreferredGap(0).add((Component)(noAttachments ? this.createNewButton : this.dummyLabel)));
        verticalGroup.add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.noneLabel).add((Component)(noAttachments ? this.createNewButton : this.dummyLabel)));
        this.dummyLabel.setVisible(false);
        this.noneLabel.setVisible(noAttachments);
        this.updateCreateNewButton(noAttachments);
        if (noAttachments) {
            verticalGroup.add((GroupLayout.Group)newVerticalGroup);
        } else {
            ArrayList<JPanel> panels = new ArrayList<JPanel>();
            JLabel descriptionLabel = new JLabel(bundle.getString("AttachmentsPanel.table.description"));
            JLabel filenameLabel = new JLabel(bundle.getString("AttachmentsPanel.table.filename"));
            JLabel dateLabel = new JLabel(bundle.getString("AttachmentsPanel.table.date"));
            JLabel authorLabel = new JLabel(bundle.getString("AttachmentsPanel.table.author"));
            this.makeBold(descriptionLabel);
            this.makeBold(filenameLabel);
            this.makeBold(dateLabel);
            this.makeBold(authorLabel);
            GroupLayout.ParallelGroup descriptionGroup = layout.createParallelGroup();
            GroupLayout.ParallelGroup filenameGroup = layout.createParallelGroup();
            GroupLayout.ParallelGroup dateGroup = layout.createParallelGroup();
            GroupLayout.ParallelGroup authorGroup = layout.createParallelGroup();
            int descriptionWidth = Math.max(descriptionLabel.getPreferredSize().width, 150);
            descriptionGroup.add((Component)descriptionLabel, descriptionWidth, descriptionWidth, descriptionWidth);
            filenameGroup.add((Component)filenameLabel);
            dateGroup.add((Component)dateLabel);
            authorGroup.add((Component)authorLabel);
            JPanel panel = this.createHighlightPanel();
            panels.add(panel);
            horizontalGroup.add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)descriptionGroup).addPreferredGap((JComponent)descriptionLabel, (JComponent)filenameLabel, 1).add((GroupLayout.Group)filenameGroup).addPreferredGap((JComponent)filenameLabel, (JComponent)dateLabel, 1).add((GroupLayout.Group)dateGroup).addPreferredGap((JComponent)dateLabel, (JComponent)authorLabel, 1).add((GroupLayout.Group)authorGroup));
            verticalGroup.add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)panel, 0, 0, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)descriptionLabel).add((Component)filenameLabel).add((Component)dateLabel).add((Component)authorLabel)));
            for (BugzillaIssue.Attachment attachment : attachments) {
                boolean isPatch = "1".equals(attachment.getIsPatch());
                String description = attachment.getDesc();
                String filename = attachment.getFilename();
                Date date = attachment.getDate();
                String author = attachment.getAuthor();
                descriptionLabel = new JLabel(description);
                LinkButton filenameButton = new LinkButton();
                LinkButton patchButton = null;
                JLabel lBrace = null;
                JLabel rBrace = null;
                GroupLayout.SequentialGroup hPatchGroup = null;
                if (isPatch) {
                    patchButton = new LinkButton();
                    lBrace = new JLabel("(");
                    rBrace = new JLabel(")");
                    hPatchGroup = layout.createSequentialGroup().add((Component)filenameButton).addPreferredGap((JComponent)filenameButton, (JComponent)lBrace, 0).add((Component)lBrace).add((Component)patchButton).add((Component)rBrace);
                }
                JPopupMenu menu = this.menuFor(attachment, patchButton);
                filenameButton.setAction((Action)new BugzillaIssue.Attachment.DefaultAttachmentAction(attachment));
                filenameButton.setText(filename);
                filenameButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AttachmentsPanel.class, (String)"AttachmentPanels.filenameButton.AccessibleContext.accessibleDescription"));
                dateLabel = new JLabel(date != null ? DateFormat.getDateInstance().format(date) : "");
                authorLabel = new JLabel(author);
                descriptionLabel.setComponentPopupMenu(menu);
                filenameButton.setComponentPopupMenu(menu);
                dateLabel.setComponentPopupMenu(menu);
                authorLabel.setComponentPopupMenu(menu);
                descriptionGroup.add((Component)descriptionLabel, 0, -1, -2);
                if (isPatch) {
                    lBrace.setComponentPopupMenu(menu);
                    patchButton.setComponentPopupMenu(menu);
                    rBrace.setComponentPopupMenu(menu);
                    filenameGroup.add((GroupLayout.Group)hPatchGroup);
                } else {
                    filenameGroup.add((Component)filenameButton);
                }
                dateGroup.add((Component)dateLabel);
                authorGroup.add((Component)authorLabel);
                panel = this.createHighlightPanel();
                panel.addMouseListener(new MouseAdapter(){});
                panel.setComponentPopupMenu(menu);
                panels.add(panel);
                GroupLayout.ParallelGroup pGroup = layout.createParallelGroup(3);
                pGroup.add((Component)descriptionLabel);
                pGroup.add((Component)filenameButton);
                if (isPatch) {
                    pGroup.add((Component)lBrace);
                    pGroup.add((Component)patchButton);
                    pGroup.add((Component)rBrace);
                }
                pGroup.add((Component)dateLabel);
                pGroup.add((Component)authorLabel);
                verticalGroup.addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)panel, 0, 0, Short.MAX_VALUE).add((GroupLayout.Group)pGroup));
            }
            verticalGroup.add((GroupLayout.Group)newVerticalGroup);
            int groupWidth = 0;
            if (this.maxMethod != null) {
                try {
                    groupWidth = (Integer)this.maxMethod.invoke((Object)horizontalGroup, 1);
                }
                catch (Exception ex) {
                    Bugzilla.LOG.log(Level.INFO, ex.getMessage(), ex);
                }
            }
            for (JPanel p : panels) {
                horizontalGroup.add((Component)p, 0, 0, groupWidth);
            }
        }
        horizontalGroup.add((GroupLayout.Group)layout.createSequentialGroup().add((Component)(noAttachments ? this.dummyLabel : this.createNewButton)).add(0, 0, Short.MAX_VALUE));
        verticalGroup.addPreferredGap(0);
        verticalGroup.add((Component)(noAttachments ? this.dummyLabel : this.createNewButton));
        layout.setHorizontalGroup((GroupLayout.Group)horizontalGroup);
        layout.setVerticalGroup((GroupLayout.Group)verticalGroup);
        ((CreateNewAction)this.createNewButton.getAction()).setLayoutGroups(horizontalGroup, newVerticalGroup);
        this.setLayout((LayoutManager)layout);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(0, super.getMinimumSize().height);
    }

    private JPopupMenu menuFor(BugzillaIssue.Attachment attachment, LinkButton patchButton) {
        JPopupMenu menu = new JPopupMenu();
        menu.add(new BugzillaIssue.Attachment.DefaultAttachmentAction(attachment));
        menu.add(new BugzillaIssue.Attachment.SaveAttachmentAction(attachment));
        if ("1".equals(attachment.getIsPatch())) {
            BugzillaIssue.Attachment.ApplyPatchAction action = new BugzillaIssue.Attachment.ApplyPatchAction(attachment);
            menu.add(action);
            patchButton.setAction((Action)action);
            String label = patchButton.getText();
            patchButton.setText(label.substring(0, 1).toLowerCase() + label.substring(1));
            patchButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AttachmentsPanel.class, (String)"AttachmentPanels.patchButton.AccessibleContext.accessibleDescription"));
        }
        return menu;
    }

    private void updateCreateNewButton(boolean noAttachments) {
        String createNewButtonText = NbBundle.getMessage(AttachmentsPanel.class, (String)"AttachmentsPanel.createNewButton.text");
        this.createNewButton.setText(noAttachments ? '(' + createNewButtonText + ')' : createNewButtonText);
    }

    private void makeBold(JLabel label) {
        Font font = label.getFont().deriveFont(1);
        label.setFont(font);
    }

    private JPanel createHighlightPanel() {
        JPanel panel = new JPanel();
        panel.setBackground(BG_COLOR);
        this.add(panel);
        return panel;
    }

    PropertyChangeListener getDeletedListener() {
        if (this.deletedListener == null) {
            this.deletedListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("attachmentDeleted".equals(evt.getPropertyName())) {
                        for (AttachmentPanel panel : AttachmentsPanel.this.newAttachments) {
                            if (panel.isDeleted()) continue;
                            return;
                        }
                        AttachmentsPanel.this.noneLabel.setVisible(true);
                        AttachmentsPanel.this.switchHelper();
                        AttachmentsPanel.this.updateCreateNewButton(true);
                    }
                }
            };
        }
        return this.deletedListener;
    }

    private void switchHelper() {
        JLabel temp = new JLabel();
        GroupLayout layout = (GroupLayout)this.getLayout();
        layout.replace((Component)this.dummyLabel, (Component)temp);
        layout.replace((Component)this.createNewButton, (Component)this.dummyLabel);
        layout.replace((Component)temp, (Component)this.createNewButton);
    }

    List<AttachmentInfo> getNewAttachments() {
        LinkedList<AttachmentInfo> infos = new LinkedList<AttachmentInfo>();
        for (AttachmentPanel attachment : this.newAttachments) {
            if (attachment.isDeleted()) continue;
            AttachmentInfo info = new AttachmentInfo();
            info.file = attachment.getFile();
            info.description = attachment.getDescription();
            info.contentType = attachment.getContentType();
            info.isPatch = attachment.isPatch();
            infos.add(info);
        }
        return infos;
    }

    class CreateNewAction
    extends AbstractAction {
        private GroupLayout.ParallelGroup horizontalGroup;
        private GroupLayout.SequentialGroup verticalGroup;

        CreateNewAction() {
        }

        void setLayoutGroups(GroupLayout.ParallelGroup horizontalGroup, GroupLayout.SequentialGroup verticalGroup) {
            this.horizontalGroup = horizontalGroup;
            this.verticalGroup = verticalGroup;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AttachmentPanel attachment = new AttachmentPanel();
            attachment.setBackground(BG_COLOR);
            this.horizontalGroup.add((Component)attachment, -2, -1, -2);
            this.verticalGroup.addPreferredGap(0);
            this.verticalGroup.add((Component)attachment, -2, -1, -2);
            if (AttachmentsPanel.this.noneLabel.isVisible()) {
                AttachmentsPanel.this.noneLabel.setVisible(false);
                AttachmentsPanel.this.switchHelper();
                AttachmentsPanel.this.updateCreateNewButton(false);
            }
            if (AttachmentsPanel.this.hadNoAttachments) {
                attachment.addPropertyChangeListener(AttachmentsPanel.this.getDeletedListener());
            }
            AttachmentsPanel.this.newAttachments.add(attachment);
            UIUtils.keepFocusedComponentVisible((Component)attachment);
            AttachmentsPanel.this.revalidate();
        }
    }

    class AttachmentInfo {
        File file;
        String description;
        String contentType;
        boolean isPatch;

        AttachmentInfo() {
        }
    }
}

