/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.model.wsdl.impl;

import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.WeakHashMap;
import org.netbeans.modules.websvc.saas.model.wsdl.impl.WsdlModeler;

public class WsdlModelerFactory {
    private static WsdlModelerFactory factory;
    WeakHashMap<URL, WeakReference<WsdlModeler>> modelers = new WeakHashMap(5);

    private WsdlModelerFactory() {
    }

    public static synchronized WsdlModelerFactory getDefault() {
        if (factory == null) {
            factory = new WsdlModelerFactory();
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WsdlModeler getWsdlModeler(URL wsdlUrl) {
        WsdlModeler modeler = null;
        WeakHashMap<URL, WeakReference<WsdlModeler>> weakHashMap = this.modelers;
        synchronized (weakHashMap) {
            modeler = this.getFromCache(wsdlUrl);
            if (modeler != null) {
                return modeler;
            }
            modeler = new WsdlModeler(wsdlUrl);
            this.modelers.put(wsdlUrl, new WeakReference<WsdlModeler>(modeler));
        }
        return modeler;
    }

    private WsdlModeler getFromCache(URL url) {
        if (url == null) {
            return null;
        }
        WeakReference<WsdlModeler> wr = this.modelers.get(url);
        if (wr == null) {
            return null;
        }
        WsdlModeler modeler = (WsdlModeler)wr.get();
        if (modeler == null) {
            this.modelers.remove(url);
        }
        return modeler;
    }

    int mapLength() {
        return this.modelers.size();
    }
}

