/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui;

import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.ui.ButtonPopupSwitcher;
import org.netbeans.modules.debugger.jpda.ui.SwitcherTableItem;
import org.netbeans.modules.debugger.jpda.ui.WatchPanel;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.netbeans.spi.viewmodel.Models;
import org.omg.CORBA.portable.ApplicationException;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class CodeEvaluator
extends TopComponent
implements HelpCtx.Provider,
DocumentListener,
KeyListener,
PropertyChangeListener {
    private static final String ID = "evaluator";
    private static final String PROP_RESULT_CHANGED = "resultChanged";
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private static WeakReference<CodeEvaluator> instanceRef;
    private JEditorPane codePane;
    private volatile String codeText = "";
    private History history;
    private Reference<JPDADebugger> debuggerRef = new WeakReference<Object>(null);
    private DbgManagerListener dbgManagerListener;
    private TopComponent resultView;
    private Set<String> editItemsSet = new HashSet<String>();
    private ArrayList<String> editItemsList = new ArrayList();
    private JButton dropDownButton;
    private Preferences preferences = NbPreferences.forModule(ContextProvider.class).node("variables_view");
    private HistoryRecord lastEvaluationRecord = null;
    private Variable result;
    private static RequestProcessor rp;
    private RequestProcessor.Task evalTask = rp.create((Runnable)new EvaluateTask());
    private RequestProcessor.Task setupContextTask;
    private JScrollPane editorScrollPane;
    private JButton evaluateButton;
    private JPanel rightPanel;
    private JPanel separatorPanel;

    public CodeEvaluator() {
        this.initComponents();
        this.codePane = new JEditorPane();
        this.codePane.setMinimumSize(new Dimension(0, 0));
        this.history = new History();
        this.dropDownButton = this.createDropDownButton();
        GroupLayout rightPanelLayout = new GroupLayout((Container)this.rightPanel);
        this.rightPanel.setLayout((LayoutManager)rightPanelLayout);
        rightPanelLayout.setHorizontalGroup((GroupLayout.Group)rightPanelLayout.createParallelGroup(1).add((GroupLayout.Group)rightPanelLayout.createSequentialGroup().addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.dropDownButton).addPreferredGap(0, 2, 2)).add((GroupLayout.Group)rightPanelLayout.createSequentialGroup().addPreferredGap(0, 2, 2).add((Component)this.evaluateButton).addPreferredGap(0, 2, 2)));
        rightPanelLayout.setVerticalGroup((GroupLayout.Group)rightPanelLayout.createParallelGroup(1).add((GroupLayout.Group)rightPanelLayout.createSequentialGroup().add((Component)this.dropDownButton).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.evaluateButton)));
        this.editorScrollPane.setViewportView(this.codePane);
        this.codePane.addKeyListener(this);
        this.dbgManagerListener = new DbgManagerListener(this);
        DebuggerManager.getDebuggerManager().addDebuggerListener("currentSession", (DebuggerManagerListener)this.dbgManagerListener);
        this.checkDebuggerState();
    }

    public static RequestProcessor getRequestProcessor() {
        return rp;
    }

    public void pasteExpression(String expr) {
        this.codePane.setText(expr);
        this.codeText = expr;
        if (!this.isOpened()) {
            this.open();
        }
        this.requestActive();
    }

    private JButton createDropDownButton() {
        ImageIcon icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/debugger/jpda/resources/drop_down_arrow.png", (boolean)false);
        DropDownButton button = new DropDownButton();
        button.setIcon(icon);
        String tooltipText = NbBundle.getMessage(CodeEvaluator.class, (String)"CTL_Expressions_Dropdown_tooltip");
        button.setToolTipText(tooltipText);
        button.setEnabled(false);
        Dimension size = new Dimension(icon.getIconWidth() + 3, icon.getIconHeight() + 2);
        button.setPreferredSize(size);
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setFocusable(false);
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ("pressed".equals(e.getActionCommand())) {
                    JComponent jc = (JComponent)e.getSource();
                    Point p = new Point(0, 0);
                    SwingUtilities.convertPointToScreen(p, jc);
                    if (!ButtonPopupSwitcher.isShown()) {
                        SwitcherTableItem[] items = CodeEvaluator.this.createSwitcherItems();
                        ButtonPopupSwitcher.selectItem(jc, items, p.x, p.y);
                    }
                    if (jc instanceof AbstractButton) {
                        AbstractButton jb = (AbstractButton)jc;
                        jb.getModel().setPressed(false);
                        jb.getModel().setRollover(false);
                        jb.getModel().setArmed(false);
                        jb.repaint();
                    }
                }
            }

            @Override
            public boolean isEnabled() {
                return !CodeEvaluator.this.editItemsList.isEmpty();
            }
        };
        action.putValue("SmallIcon", icon);
        action.putValue("ShortDescription", tooltipText);
        button.setAction(action);
        return button;
    }

    private void setupContext() {
        if (this.setupContextTask == null) {
            this.setupContextTask = rp.create(new Runnable(){

                @Override
                public void run() {
                    CodeEvaluator.this.setupContextLazily();
                }
            });
        }
        this.setupContextTask.schedule(500);
    }

    private void setupContextLazily() {
        final String text = this.codeText;
        final Document[] documentPtr = new Document[]{null};
        class ContextUpdated
        implements ActionListener,
        Runnable {
            ContextUpdated() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.run();
            }

            @Override
            public void run() {
                if (CodeEvaluator.this.codePane.getDocument() != documentPtr[0]) {
                    CodeEvaluator.this.codePane.getDocument().addDocumentListener(CodeEvaluator.this);
                    if (text != null) {
                        CodeEvaluator.this.codePane.setText(text);
                    }
                }
                documentPtr[0] = CodeEvaluator.this.codePane.getDocument();
            }
        }
        ContextUpdated contextUpdated = new ContextUpdated();
        WatchPanel.setupContext(this.codePane, contextUpdated);
        SwingUtilities.invokeLater(contextUpdated);
    }

    private SwitcherTableItem[] createSwitcherItems() {
        SwitcherTableItem[] items = new SwitcherTableItem[this.editItemsList.size()];
        int x = 0;
        for (String item : this.editItemsList) {
            items[x++] = new SwitcherTableItem(new MenuItemActivatable(item), item);
        }
        return items;
    }

    public void recomputeDropDownItems() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (String str : CodeEvaluator.this.editItemsList) {
                    StringTokenizer tok = new StringTokenizer(str, "\n");
                    String dispName = "";
                    while (dispName.trim().length() == 0 && tok.hasMoreTokens()) {
                        dispName = tok.nextToken();
                    }
                }
                CodeEvaluator.this.dropDownButton.setEnabled(!CodeEvaluator.this.editItemsList.isEmpty());
            }
        });
    }

    public static synchronized CodeEvaluator getInstance() {
        CodeEvaluator instance = (CodeEvaluator)WindowManager.getDefault().findTopComponent(ID);
        if (instance == null) {
            instance = new CodeEvaluator();
        }
        return instance;
    }

    private static CodeEvaluator getDefaultInstance() {
        CodeEvaluator evaluator;
        CodeEvaluator codeEvaluator = evaluator = instanceRef != null ? (CodeEvaluator)instanceRef.get() : null;
        if (evaluator != null) {
            return evaluator;
        }
        final CodeEvaluator[] result = new CodeEvaluator[1];
        if (SwingUtilities.isEventDispatchThread()) {
            result[0] = CodeEvaluator.getInstance();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        result[0] = CodeEvaluator.getInstance();
                    }
                });
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        instanceRef = new WeakReference<CodeEvaluator>(result[0]);
        return result[0];
    }

    public static ArrayList<History.Item> getHistory() {
        CodeEvaluator defaultInstance = CodeEvaluator.getDefaultInstance();
        return defaultInstance != null ? defaultInstance.history.getItems() : new ArrayList<History.Item>();
    }

    public static Variable getResult() {
        CodeEvaluator defaultInstance = CodeEvaluator.getDefaultInstance();
        return defaultInstance != null ? defaultInstance.result : null;
    }

    public static String getExpressionText() {
        CodeEvaluator defaultInstance = CodeEvaluator.getDefaultInstance();
        HistoryRecord rec = defaultInstance != null ? defaultInstance.lastEvaluationRecord : null;
        return rec != null ? rec.expr : "";
    }

    public static void addResultListener(final PropertyChangeListener listener) {
        rp.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CodeEvaluator defaultInstance = CodeEvaluator.getDefaultInstance();
                if (defaultInstance != null) {
                    PropertyChangeSupport propertyChangeSupport = defaultInstance.pcs;
                    synchronized (propertyChangeSupport) {
                        defaultInstance.pcs.addPropertyChangeListener(listener);
                    }
                }
            }
        });
    }

    public static void removeResultListener(final PropertyChangeListener listener) {
        rp.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CodeEvaluator defaultInstance = CodeEvaluator.getDefaultInstance();
                if (defaultInstance != null) {
                    PropertyChangeSupport propertyChangeSupport = defaultInstance.pcs;
                    synchronized (propertyChangeSupport) {
                        defaultInstance.pcs.removePropertyChangeListener(listener);
                    }
                }
            }
        });
    }

    private static void fireResultChange() {
        rp.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CodeEvaluator defaultInstance = CodeEvaluator.getDefaultInstance();
                if (defaultInstance != null) {
                    PropertyChangeSupport propertyChangeSupport = defaultInstance.pcs;
                    synchronized (propertyChangeSupport) {
                        defaultInstance.pcs.firePropertyChange(CodeEvaluator.PROP_RESULT_CHANGED, null, null);
                    }
                }
            }
        });
    }

    private synchronized void checkDebuggerState() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JPDADebugger lastDebugger;
                DebuggerEngine de = DebuggerManager.getDebuggerManager().getCurrentEngine();
                JPDADebugger debugger = null;
                if (de != null) {
                    debugger = (JPDADebugger)de.lookupFirst(null, JPDADebugger.class);
                }
                if (debugger != (lastDebugger = (JPDADebugger)CodeEvaluator.this.debuggerRef.get())) {
                    CodeEvaluator.this.setupContext();
                }
                if (lastDebugger != null && debugger != lastDebugger) {
                    lastDebugger.removePropertyChangeListener("currentCallStackFrame", (PropertyChangeListener)CodeEvaluator.this);
                    lastDebugger.removePropertyChangeListener("state", (PropertyChangeListener)CodeEvaluator.this);
                    CodeEvaluator.this.debuggerRef = new WeakReference<Object>(null);
                    CodeEvaluator.this.displayResult(null);
                }
                if (debugger != null) {
                    CodeEvaluator.this.debuggerRef = new WeakReference<JPDADebugger>(debugger);
                    debugger.addPropertyChangeListener("currentCallStackFrame", (PropertyChangeListener)CodeEvaluator.this);
                    debugger.addPropertyChangeListener("classesFixed", (PropertyChangeListener)CodeEvaluator.this);
                    debugger.addPropertyChangeListener("state", (PropertyChangeListener)CodeEvaluator.this);
                } else {
                    CodeEvaluator.this.history.clear();
                }
                CodeEvaluator.this.computeEvaluationButtonState();
            }
        });
    }

    private void computeEvaluationButtonState() {
        JPDADebugger debugger = this.debuggerRef.get();
        boolean isEnabled = debugger != null && debugger.getCurrentThread() != null && debugger.getState() == 3 && this.codePane.getDocument().getLength() > 0 && this.editorScrollPane.getViewport().getView() == this.codePane;
        this.evaluateButton.setEnabled(isEnabled);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        DebuggerManager.getDebuggerManager().removeDebuggerListener("currentEngine", (DebuggerManagerListener)this.dbgManagerListener);
    }

    private void initComponents() {
        this.evaluateButton = new JButton();
        this.editorScrollPane = new JScrollPane();
        this.separatorPanel = new JPanel();
        this.rightPanel = new JPanel();
        this.evaluateButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/debugger/jpda/resources/evaluate.png")));
        this.evaluateButton.setText(NbBundle.getMessage(CodeEvaluator.class, (String)"CodeEvaluator.evaluateButton.text"));
        this.evaluateButton.setToolTipText(NbBundle.getMessage(CodeEvaluator.class, (String)"HINT_Evaluate_Button"));
        this.evaluateButton.setEnabled(false);
        this.evaluateButton.setPreferredSize(new Dimension(38, 22));
        this.evaluateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CodeEvaluator.this.evaluateButtonActionPerformed(evt);
            }
        });
        this.editorScrollPane.setBorder(null);
        this.separatorPanel.setBackground(UIManager.getDefaults().getColor("Separator.foreground"));
        this.separatorPanel.setMaximumSize(new Dimension(1, Short.MAX_VALUE));
        this.separatorPanel.setMinimumSize(new Dimension(1, 10));
        this.separatorPanel.setPreferredSize(new Dimension(1, 10));
        this.rightPanel.setMinimumSize(new Dimension(0, 0));
        this.rightPanel.setPreferredSize(new Dimension(48, 0));
        GroupLayout rightPanelLayout = new GroupLayout((Container)this.rightPanel);
        this.rightPanel.setLayout((LayoutManager)rightPanelLayout);
        rightPanelLayout.setHorizontalGroup((GroupLayout.Group)rightPanelLayout.createParallelGroup(1).add(0, 48, Short.MAX_VALUE));
        rightPanelLayout.setVerticalGroup((GroupLayout.Group)rightPanelLayout.createParallelGroup(1).add(0, 22, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.editorScrollPane, -1, 450, Short.MAX_VALUE).add((Component)this.separatorPanel, -2, -1, -2).add((Component)this.rightPanel, -2, -1, -2)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.editorScrollPane, -1, 22, Short.MAX_VALUE).add((Component)this.separatorPanel, -1, 22, Short.MAX_VALUE).add((Component)this.rightPanel, -1, 22, Short.MAX_VALUE));
    }

    private void evaluateButtonActionPerformed(ActionEvent evt) {
        this.evaluate();
    }

    public static void openEvaluator() {
        String selectedText = null;
        JEditorPane editor = EditorContextDispatcher.getDefault().getMostRecentEditor();
        if (editor != null) {
            selectedText = editor.getSelectedText();
        }
        CodeEvaluator evaluator = CodeEvaluator.getInstance();
        evaluator.open();
        if (selectedText != null) {
            evaluator.codePane.setText(selectedText);
            evaluator.codeText = selectedText;
        }
        evaluator.codePane.selectAll();
        evaluator.requestActive();
    }

    public boolean requestFocusInWindow() {
        this.codePane.requestFocusInWindow();
        return super.requestFocusInWindow();
    }

    protected String preferredID() {
        return this.getClass().getName();
    }

    public int getPersistenceType() {
        return 0;
    }

    public String getName() {
        return NbBundle.getMessage(CodeEvaluator.class, (String)"CTL_Code_Evaluator_name");
    }

    public String getToolTipText() {
        return NbBundle.getMessage(CodeEvaluator.class, (String)"CTL_Code_Evaluator_tooltip");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("EvaluateCode");
    }

    public String getExpression() {
        return this.codeText;
    }

    public void evaluate() {
        this.evalTask.schedule(10);
    }

    private void displayResult(Variable var) {
        this.result = var;
        if (var == null) {
            CodeEvaluator.fireResultChange();
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (CodeEvaluator.this.preferences.getBoolean("show_evaluator_result", true)) {
                    TopComponent view = WindowManager.getDefault().findTopComponent("localsView");
                    view.open();
                    view.requestActive();
                } else {
                    if (CodeEvaluator.this.resultView == null) {
                        CodeEvaluator.this.resultView = CodeEvaluator.this.getResultViewInstance();
                    }
                    if (CodeEvaluator.this.result != null) {
                        CodeEvaluator.this.resultView.open();
                        CodeEvaluator.this.resultView.requestActive();
                    }
                }
                CodeEvaluator.getInstance().requestActive();
                CodeEvaluator.fireResultChange();
            }
        });
    }

    private void addResultToHistory(final String expr, Variable result) {
        if (this.lastEvaluationRecord != null) {
            this.history.addItem(this.lastEvaluationRecord.expr, this.lastEvaluationRecord.type, this.lastEvaluationRecord.value, this.lastEvaluationRecord.toString);
        }
        if (result != null) {
            String type = result.getType();
            String value = result.getValue();
            String toString = "";
            if (result instanceof ObjectVariable) {
                try {
                    toString = ((ObjectVariable)result).getToStringValue();
                }
                catch (InvalidExpressionException ex) {}
            } else {
                toString = value;
            }
            this.lastEvaluationRecord = new HistoryRecord(expr, type, value, toString);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String expr2 = expr.trim();
                if (CodeEvaluator.this.editItemsSet.contains(expr2)) {
                    CodeEvaluator.this.editItemsList.remove(expr2);
                    CodeEvaluator.this.editItemsList.add(0, expr2);
                } else {
                    CodeEvaluator.this.editItemsList.add(0, expr2);
                    CodeEvaluator.this.editItemsSet.add(expr2);
                    if (CodeEvaluator.this.editItemsList.size() > 20) {
                        String removed = (String)CodeEvaluator.this.editItemsList.remove(CodeEvaluator.this.editItemsList.size() - 1);
                        CodeEvaluator.this.editItemsSet.remove(removed);
                    }
                }
                CodeEvaluator.this.recomputeDropDownItems();
            }
        });
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10 && e.isControlDown()) {
            e.consume();
            if (this.debuggerRef.get() != null) {
                this.evaluate();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateWatch();
        this.codeText = this.codePane.getText();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateWatch();
        this.codeText = this.codePane.getText();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateWatch();
        this.codeText = this.codePane.getText();
    }

    private void updateWatch() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CodeEvaluator.this.computeEvaluationButtonState();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getPropertyName();
        if ("currentCallStackFrame".equals(propertyName) || "classesFixed".equals(propertyName)) {
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    13 var1_1 = this;
                    synchronized (var1_1) {
                        JPDADebugger debugger = (JPDADebugger)CodeEvaluator.this.debuggerRef.get();
                        if (debugger != null) {
                            CodeEvaluator.this.computeEvaluationButtonState();
                            CodeEvaluator.this.setupContext();
                        }
                    }
                }
            });
        } else if ("state".equals(propertyName)) {
            CodeEvaluator codeEvaluator = this;
            synchronized (codeEvaluator) {
                JPDADebugger debugger = this.debuggerRef.get();
                if (debugger != null && debugger.getState() != 3 && this.result != null) {
                    this.history.addItem(this.lastEvaluationRecord.expr, this.lastEvaluationRecord.type, this.lastEvaluationRecord.value, this.lastEvaluationRecord.toString);
                    this.lastEvaluationRecord = null;
                    this.result = null;
                    CodeEvaluator.fireResultChange();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JPDADebugger debugger = (JPDADebugger)CodeEvaluator.this.debuggerRef.get();
                        if (debugger != null && debugger.getState() == 3) {
                            CodeEvaluator.this.setupContext();
                        }
                        CodeEvaluator.this.computeEvaluationButtonState();
                    }
                });
            }
        }
    }

    public static synchronized TopComponent getResultView() {
        return new ResultView();
    }

    private synchronized TopComponent getResultViewInstance() {
        TopComponent instance = WindowManager.getDefault().findTopComponent("resultsView");
        if (instance == null) {
            instance = new ResultView();
        }
        return instance;
    }

    private void initResult(ResultView view) {
        JComponent tree = Models.createView((Models.CompoundModel)Models.EMPTY_MODEL);
        view.add(tree, "Center");
        Dimension tps = tree.getPreferredSize();
        tps.height = tps.width / 2;
        tree.setPreferredSize(tps);
        tree.setName(NbBundle.getMessage(CodeEvaluator.class, (String)"Evaluator.ResultA11YName"));
        tree.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeEvaluator.class, (String)"Evaluator.ResultA11YDescr"));
        JTextField referenceTextField = new JTextField();
        Set<AWTKeyStroke> tfkeys = referenceTextField.getFocusTraversalKeys(0);
        tree.setFocusTraversalKeys(0, tfkeys);
        tfkeys = referenceTextField.getFocusTraversalKeys(1);
        tree.setFocusTraversalKeys(1, tfkeys);
    }

    static {
        rp = new RequestProcessor("Debugger Evaluator", 1);
    }

    private static class HistoryRecord {
        String expr;
        String type;
        String value;
        String toString;

        HistoryRecord(String expr, String type, String value, String toString) {
            this.expr = expr;
            this.type = type;
            this.value = value;
            this.toString = toString;
        }
    }

    private static class DropDownButton
    extends JButton {
        private DropDownButton() {
        }

        @Override
        protected void processMouseEvent(MouseEvent me) {
            super.processMouseEvent(me);
            if (this.isEnabled() && me.getID() == 501) {
                this.getAction().actionPerformed(new ActionEvent(this, 1001, "pressed"));
            }
        }

        protected String getTabActionCommand(ActionEvent e) {
            return null;
        }

        void performAction(ActionEvent e) {
        }
    }

    private class MenuItemActivatable
    implements SwitcherTableItem.Activatable {
        String text;

        MenuItemActivatable(String str) {
            this.text = str;
        }

        @Override
        public void activate() {
            CodeEvaluator.this.codePane.setText(this.text);
            CodeEvaluator.this.codeText = this.text;
        }
    }

    private static class DbgManagerListener
    extends DebuggerManagerAdapter {
        private Reference<CodeEvaluator> codeEvaluatorRef;

        public DbgManagerListener(CodeEvaluator evaluator) {
            this.codeEvaluatorRef = new WeakReference<CodeEvaluator>(evaluator);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            CodeEvaluator evaluator = this.codeEvaluatorRef.get();
            if (evaluator != null) {
                evaluator.checkDebuggerState();
            }
        }
    }

    private class EvaluateTask
    implements Runnable {
        private EvaluateTask() {
        }

        @Override
        public void run() {
            String exp = CodeEvaluator.this.getExpression();
            if (exp == null || "".equals(exp)) {
                return;
            }
            try {
                JPDADebugger debugger = (JPDADebugger)CodeEvaluator.this.debuggerRef.get();
                if (debugger != null) {
                    Variable var = debugger.evaluate(exp);
                    CodeEvaluator.this.addResultToHistory(exp, var);
                    CodeEvaluator.this.displayResult(var);
                }
            }
            catch (InvalidExpressionException ieex) {
                String message = ieex.getLocalizedMessage();
                Throwable t = ieex.getTargetException();
                if (t != null && t instanceof ApplicationException) {
                    StringWriter s = new StringWriter();
                    PrintWriter p = new PrintWriter(s);
                    t.printStackTrace(p);
                    p.close();
                    message = message + " \n" + s.toString();
                }
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CodeEvaluator.this.codePane.requestFocusInWindow();
                    }
                });
            }
        }
    }

    private static class ResultView
    extends TopComponent
    implements HelpCtx.Provider {
        private static final String ID = "evaluator_result";

        ResultView() {
            this.setLayout(new BorderLayout());
        }

        protected String preferredID() {
            return ((Object)((Object)this)).getClass().getName();
        }

        public int getPersistenceType() {
            return 0;
        }

        public String getName() {
            return NbBundle.getMessage(CodeEvaluator.class, (String)"CTL_Evaluator_Result_name");
        }

        public String getToolTipText() {
            return NbBundle.getMessage(CodeEvaluator.class, (String)"CTL_Evaluator_Result_tooltip");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("EvaluationResult");
        }
    }

    public static class History {
        private static final int MAX_ITEMS = 100;
        private ArrayList<Item> historyItems = new ArrayList();

        private void addItem(String expr, String type, String value, String toString) {
            Item item = new Item(expr, type, value, toString);
            this.historyItems.add(0, item);
            if (this.historyItems.size() > 100) {
                this.historyItems.remove(100);
            }
        }

        public ArrayList<Item> getItems() {
            return this.historyItems;
        }

        public void clear() {
            this.historyItems.clear();
        }

        public class Item {
            public String expr;
            public String type;
            public String value;
            public String toString;
            public String tooltip;
            public String exprFormatted;

            Item(String expr, String type, String value, String toString) {
                this.expr = expr;
                this.type = type;
                this.value = value;
                this.toString = toString;
                StringBuffer buf = new StringBuffer();
                buf.append("<html>");
                String text = expr.replaceAll("&", "&amp;");
                text = text.replaceAll("<", "&lt;");
                text = text.replaceAll(">", "&gt;");
                text = text.replaceAll("\n", "<br/>");
                text = text.replaceAll("\r", "");
                buf.append(text);
                buf.append("</html>");
                this.tooltip = buf.toString();
            }

            public String toString() {
                return this.expr;
            }
        }
    }
}

