/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui;

import com.sun.jdi.AbsentInformationException;
import java.awt.IllegalComponentStateException;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.modules.debugger.jpda.ui.SourcePath;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.netbeans.spi.debugger.jpda.SourcePathProvider;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class EditorContextBridge {
    public static final String FIELD = "field";
    public static final String METHOD = "method";
    public static final String CLASS = "class";
    public static final String LINE = "line";
    private static EditorContext context;

    public static EditorContext getContext() {
        if (context == null) {
            List l = DebuggerManager.getDebuggerManager().lookup(null, EditorContext.class);
            context = (EditorContext)l.get(0);
            int k = l.size();
            for (int i = 1; i < k; ++i) {
                context = new CompoundContextProvider((EditorContext)l.get(i), context);
            }
        }
        return context;
    }

    public static String getMostRecentMethodSignature() {
        String ms = EditorContextBridge.getReflectionMethodValue("getMostRecentMethodSignature");
        if (ms == null) {
            ms = EditorContextBridge.getCurrentMethodSignature();
        }
        return ms;
    }

    public static String getCurrentMethodSignature() {
        String ms = EditorContextBridge.getReflectionMethodValue("getCurrentMethodSignature");
        if (ms == null) {
            ms = "";
        }
        return ms;
    }

    public static String getFileName(LineBreakpoint b) {
        try {
            return new File(new URL(b.getURL()).getFile()).getName();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static String getDefaultType() {
        String id = EditorContextBridge.getContext().getSelectedIdentifier();
        try {
            if (id != null) {
                if (id.equals(EditorContextBridge.getContext().getCurrentMethodName())) {
                    return METHOD;
                }
                String s = EditorContextBridge.getContext().getCurrentClassName();
                int i = s.lastIndexOf(46);
                if (i >= 0) {
                    s = s.substring(i + 1);
                }
                if (id.equals(s)) {
                    return CLASS;
                }
                if (s.length() > 0) {
                    return FIELD;
                }
            } else {
                String s = EditorContextBridge.getMostRecentFieldName();
                if (s != null && s.length() > 0) {
                    return FIELD;
                }
                s = EditorContextBridge.getMostRecentMethodName();
                if (s != null && s.length() > 0) {
                    return METHOD;
                }
                if (s != null && s.length() < 1 && (s = EditorContextBridge.getMostRecentClassName()).length() > 0) {
                    return CLASS;
                }
                FileObject fo = EditorContextDispatcher.getDefault().getMostRecentFile();
                if (fo != null && "text/x-java".equals(fo.getMIMEType())) {
                    return LINE;
                }
            }
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            // empty catch block
        }
        return null;
    }

    public static String getMostRecentFieldName() {
        String field = EditorContextBridge.getReflectionMethodValue("getMostRecentFieldName");
        if (field == null) {
            field = EditorContextBridge.getContext().getCurrentFieldName();
        }
        return field;
    }

    public static String getMostRecentMethodName() {
        String field = EditorContextBridge.getReflectionMethodValue("getMostRecentMethodName");
        if (field == null) {
            field = EditorContextBridge.getContext().getCurrentMethodName();
        }
        return field;
    }

    public static String getMostRecentClassName() {
        String field = EditorContextBridge.getReflectionMethodValue("getMostRecentClassName");
        if (field == null) {
            field = EditorContextBridge.getContext().getCurrentClassName();
        }
        return field;
    }

    private static String getReflectionMethodValue(String methodName) {
        try {
            return (String)EditorContextBridge.getContext().getClass().getMethod(methodName, new Class[0]).invoke((Object)EditorContextBridge.getContext(), new Object[0]);
        }
        catch (InvocationTargetException itex) {
            Throwable tex = itex.getTargetException();
            if (tex instanceof RuntimeException) {
                throw (RuntimeException)tex;
            }
            ErrorManager.getDefault().notify(tex);
            return null;
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    private static String[] getClassURLs(String className) {
        SourcePathProvider spp = SourcePath.getDefaultContext();
        try {
            return (String[])spp.getClass().getMethod("getAllURLs", String.class, Boolean.TYPE).invoke((Object)spp, className, Boolean.TRUE);
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
            return new String[0];
        }
    }

    public static String getRelativePath(JPDAThread thread, String stratumn) {
        try {
            return EditorContextBridge.convertSlash(thread.getSourcePath(stratumn));
        }
        catch (AbsentInformationException e) {
            return EditorContextBridge.getRelativePath(thread.getClassName());
        }
    }

    public static String getRelativePath(CallStackFrame csf, String stratumn) {
        try {
            return EditorContextBridge.convertSlash(csf.getSourcePath(stratumn));
        }
        catch (AbsentInformationException e) {
            return EditorContextBridge.getRelativePath(csf.getClassName());
        }
    }

    public static String getRelativePath(String className) {
        int i = className.indexOf(36);
        if (i > 0) {
            className = className.substring(0, i);
        }
        String sourceName = className.replace('.', '/') + ".java";
        return sourceName;
    }

    private static String convertSlash(String original) {
        return original.replace(File.separatorChar, '/');
    }

    public static String getCurrentClassDeclaration() {
        return EditorContextBridge.getReflectionMethodValue("getCurrentClassDeclaration");
    }

    private static class CompoundAnnotation {
        Object annotation1;
        Object annotation2;

        private CompoundAnnotation() {
        }
    }

    private static class CompoundContextProvider
    extends EditorContext {
        private EditorContext cp1;
        private EditorContext cp2;

        CompoundContextProvider(EditorContext cp1, EditorContext cp2) {
            this.cp1 = cp1;
            this.cp2 = cp2;
        }

        public void createTimeStamp(Object timeStamp) {
            this.cp1.createTimeStamp(timeStamp);
            this.cp2.createTimeStamp(timeStamp);
        }

        public void disposeTimeStamp(Object timeStamp) {
            this.cp1.disposeTimeStamp(timeStamp);
            this.cp2.disposeTimeStamp(timeStamp);
        }

        public void updateTimeStamp(Object timeStamp, String url) {
            this.cp1.updateTimeStamp(timeStamp, url);
            this.cp2.updateTimeStamp(timeStamp, url);
        }

        public String getCurrentClassName() {
            String s = this.cp1.getCurrentClassName();
            if (s.trim().length() < 1) {
                return this.cp2.getCurrentClassName();
            }
            return s;
        }

        public String getMostRecentClassName() {
            return this.getReflectionMethodValue("getMostRecentClassName");
        }

        public String getCurrentURL() {
            String s = this.cp1.getCurrentURL();
            if (s.trim().length() < 1) {
                return this.cp2.getCurrentURL();
            }
            return s;
        }

        public String getCurrentFieldName() {
            String s = this.cp1.getCurrentFieldName();
            if (s == null || s.trim().length() < 1) {
                return this.cp2.getCurrentFieldName();
            }
            return s;
        }

        public String getMostRecentFieldName() {
            return this.getReflectionMethodValue("getMostRecentFieldName");
        }

        public int getCurrentLineNumber() {
            int i = this.cp1.getCurrentLineNumber();
            if (i < 1) {
                return this.cp2.getCurrentLineNumber();
            }
            return i;
        }

        public String getCurrentMethodName() {
            String s = this.cp1.getCurrentMethodName();
            if (s == null || s.trim().length() < 1) {
                return this.cp2.getCurrentMethodName();
            }
            return s;
        }

        public String getMostRecentMethodName() {
            return this.getReflectionMethodValue("getMostRecentMethodName");
        }

        public String getCurrentMethodSignature() {
            return this.getReflectionMethodValue("getCurrentMethodSignature");
        }

        public String getMostRecentMethodSignature() {
            return this.getReflectionMethodValue("getMostRecentMethodSignature");
        }

        public String getCurrentClassDeclaration() {
            return this.getReflectionMethodValue("getCurrentClassDeclaration");
        }

        private String getReflectionMethodValue(String methodName) {
            String s = null;
            try {
                s = (String)this.cp1.getClass().getMethod(methodName, new Class[0]).invoke((Object)this.cp1, new Object[0]);
            }
            catch (InvocationTargetException itex) {
                Throwable tex = itex.getTargetException();
                if (tex instanceof RuntimeException) {
                    throw (RuntimeException)tex;
                }
                ErrorManager.getDefault().notify(tex);
                return null;
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (s == null || s.trim().length() < 1) {
                try {
                    s = (String)this.cp2.getClass().getMethod(methodName, new Class[0]).invoke((Object)this.cp2, new Object[0]);
                }
                catch (InvocationTargetException itex) {
                    Throwable tex = itex.getTargetException();
                    if (tex instanceof RuntimeException) {
                        throw (RuntimeException)tex;
                    }
                    ErrorManager.getDefault().notify(tex);
                    return null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return s;
        }

        public String getSelectedIdentifier() {
            String s = this.cp1.getSelectedIdentifier();
            if (s == null || s.trim().length() < 1) {
                return this.cp2.getSelectedIdentifier();
            }
            return s;
        }

        public String getSelectedMethodName() {
            String s = this.cp1.getSelectedMethodName();
            if (s == null || s.trim().length() < 1) {
                return this.cp2.getSelectedMethodName();
            }
            return s;
        }

        public void removeAnnotation(Object value) {
            if (value instanceof List) {
                for (CompoundAnnotation ca : (List)value) {
                    if (ca.annotation1 != null) {
                        this.cp1.removeAnnotation(ca.annotation1);
                    }
                    if (ca.annotation2 == null) continue;
                    this.cp2.removeAnnotation(ca.annotation2);
                }
                return;
            }
            CompoundAnnotation ca = (CompoundAnnotation)value;
            if (ca.annotation1 != null) {
                this.cp1.removeAnnotation(ca.annotation1);
            }
            if (ca.annotation2 != null) {
                this.cp2.removeAnnotation(ca.annotation2);
            }
        }

        public Object annotate(String sourceName, int lineNumber, String annotationType, Object timeStamp) {
            CompoundAnnotation ca = new CompoundAnnotation();
            ca.annotation1 = this.cp1.annotate(sourceName, lineNumber, annotationType, timeStamp);
            ca.annotation2 = this.cp2.annotate(sourceName, lineNumber, annotationType, timeStamp);
            if (ca.annotation1 != null || ca.annotation2 != null) {
                return ca;
            }
            return null;
        }

        public Object annotate(String url, int lineNumber, String annotationType, Object timeStamp, JPDAThread thread) {
            CompoundAnnotation ca = new CompoundAnnotation();
            ca.annotation1 = this.cp1.annotate(url, lineNumber, annotationType, timeStamp, thread);
            ca.annotation2 = this.cp2.annotate(url, lineNumber, annotationType, timeStamp, thread);
            if (ca.annotation1 != null || ca.annotation2 != null) {
                return ca;
            }
            return null;
        }

        public Object annotate(String url, int startPosition, int endPosition, String annotationType, Object timeStamp) {
            CompoundAnnotation ca = new CompoundAnnotation();
            ca.annotation1 = this.cp1.annotate(url, startPosition, endPosition, annotationType, timeStamp);
            ca.annotation2 = this.cp2.annotate(url, startPosition, endPosition, annotationType, timeStamp);
            if (ca.annotation1 != null || ca.annotation2 != null) {
                return ca;
            }
            return null;
        }

        public int getLineNumber(Object annotation, Object timeStamp) {
            CompoundAnnotation ca = new CompoundAnnotation();
            int ln = ca.annotation1 != null ? this.cp1.getLineNumber(ca.annotation1, timeStamp) : -1;
            if (ln >= 0) {
                return ln;
            }
            if (ca.annotation2 != null) {
                return this.cp2.getLineNumber(ca.annotation2, timeStamp);
            }
            return -1;
        }

        public boolean showSource(String sourceName, int lineNumber, Object timeStamp) {
            return this.cp1.showSource(sourceName, lineNumber, timeStamp) | this.cp2.showSource(sourceName, lineNumber, timeStamp);
        }

        public int getFieldLineNumber(String url, String className, String fieldName) {
            int ln = this.cp1.getFieldLineNumber(url, className, fieldName);
            if (ln != -1) {
                return ln;
            }
            return this.cp2.getFieldLineNumber(url, className, fieldName);
        }

        public String getClassName(String url, int lineNumber) {
            String className = this.cp1.getClassName(url, lineNumber);
            if (className != null) {
                return className;
            }
            return this.cp2.getClassName(url, lineNumber);
        }

        public String[] getImports(String url) {
            String[] r1 = this.cp1.getImports(url);
            String[] r2 = this.cp2.getImports(url);
            String[] r = new String[r1.length + r2.length];
            System.arraycopy(r1, 0, r, 0, r1.length);
            System.arraycopy(r2, 0, r, r1.length, r2.length);
            return r;
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.cp1.addPropertyChangeListener(l);
            this.cp2.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.cp1.removePropertyChangeListener(l);
            this.cp2.removePropertyChangeListener(l);
        }

        public void addPropertyChangeListener(String propertyName, PropertyChangeListener l) {
            this.cp1.addPropertyChangeListener(propertyName, l);
            this.cp2.addPropertyChangeListener(propertyName, l);
        }

        public void removePropertyChangeListener(String propertyName, PropertyChangeListener l) {
            this.cp1.removePropertyChangeListener(propertyName, l);
            this.cp2.removePropertyChangeListener(propertyName, l);
        }
    }
}

