/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.breakpoints;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.ThreadBreakpoint;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.ActionsPanel;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.ConditionsPanel;
import org.netbeans.spi.debugger.ui.Controller;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ThreadBreakpointPanel
extends JPanel
implements Controller,
HelpCtx.Provider {
    private static final String HELP_ID = "debug.add.breakpoint.java.thread";
    private ConditionsPanel conditionsPanel;
    private ActionsPanel actionsPanel;
    private ThreadBreakpoint breakpoint;
    private boolean createBreakpoint = false;
    private JPanel cPanel;
    private JComboBox cbBreakpointType;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel pActions;
    private JPanel pSettings;

    private static ThreadBreakpoint creteBreakpoint() {
        ThreadBreakpoint mb = ThreadBreakpoint.create();
        mb.setPrintText("{? threadStarted} {" + NbBundle.getBundle(ThreadBreakpointPanel.class).getString("CTL_Thread_Breakpoint_started_Print_Text") + "}{" + NbBundle.getBundle(ThreadBreakpointPanel.class).getString("CTL_Thread_Breakpoint_died_Print_Text") + "}");
        return mb;
    }

    public ThreadBreakpointPanel() {
        this(ThreadBreakpointPanel.creteBreakpoint());
        this.createBreakpoint = true;
    }

    public ThreadBreakpointPanel(ThreadBreakpoint b) {
        this.breakpoint = b;
        this.initComponents();
        this.cbBreakpointType.addItem(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("LBL_Thread_Breakpoint_Type_Start"));
        this.cbBreakpointType.addItem(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("LBL_Thread_Breakpoint_Type_Death"));
        this.cbBreakpointType.addItem(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("LBL_Thread_Breakpoint_Type_Start_or_Death"));
        switch (b.getBreakpointType()) {
            case 1: {
                this.cbBreakpointType.setSelectedIndex(0);
                break;
            }
            case 2: {
                this.cbBreakpointType.setSelectedIndex(1);
                break;
            }
            case 3: {
                this.cbBreakpointType.setSelectedIndex(2);
            }
        }
        this.conditionsPanel = new ConditionsPanel(HELP_ID);
        this.conditionsPanel.setupConditionPaneContext();
        this.conditionsPanel.showClassFilter(false);
        this.conditionsPanel.showCondition(false);
        this.conditionsPanel.setHitCountFilteringStyle(b.getHitCountFilteringStyle());
        this.conditionsPanel.setHitCount(b.getHitCountFilter());
        this.cPanel.add((Component)this.conditionsPanel, "Center");
        this.actionsPanel = new ActionsPanel((JPDABreakpoint)b);
        this.pActions.add((Component)this.actionsPanel, "Center");
        this.putClientProperty("HelpID_AddBreakpointPanel", HELP_ID);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerBreakpointThreadJPDA");
    }

    private void initComponents() {
        this.pSettings = new JPanel();
        this.jLabel4 = new JLabel();
        this.cbBreakpointType = new JComboBox();
        this.cPanel = new JPanel();
        this.pActions = new JPanel();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle");
        this.pSettings.setBorder(BorderFactory.createTitledBorder(bundle.getString("L_Thread_Breakpoint_BorderTitle")));
        this.pSettings.setLayout(new GridBagLayout());
        this.jLabel4.setLabelFor(this.cbBreakpointType);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)bundle.getString("L_Thread_Breakpoint_Type"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel4.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_L_Thread_Breakpoint_Type"));
        this.cbBreakpointType.setToolTipText(bundle.getString("TTT_CB_Thread_Breakpoint_Type"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.cbBreakpointType, gridBagConstraints);
        this.cbBreakpointType.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_CB_Thread_Breakpoint_Type"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pSettings, gridBagConstraints);
        this.cPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.cPanel, gridBagConstraints);
        this.pActions.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pActions, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    public boolean ok() {
        String msg = this.valiadateMsg();
        if (msg == null) {
            msg = this.conditionsPanel.valiadateMsg();
        }
        if (msg != null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg));
            return false;
        }
        this.actionsPanel.ok();
        switch (this.cbBreakpointType.getSelectedIndex()) {
            case 0: {
                this.breakpoint.setBreakpointType(1);
                break;
            }
            case 1: {
                this.breakpoint.setBreakpointType(2);
                break;
            }
            case 2: {
                this.breakpoint.setBreakpointType(3);
            }
        }
        this.breakpoint.setHitCountFilter(this.conditionsPanel.getHitCount(), this.conditionsPanel.getHitCountFilteringStyle());
        if (this.createBreakpoint) {
            DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)this.breakpoint);
        }
        return true;
    }

    public boolean cancel() {
        return true;
    }

    private String valiadateMsg() {
        return null;
    }
}

