/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.Action;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.ui.CodeEvaluator;
import org.netbeans.modules.debugger.jpda.ui.models.CachedChildrenTreeModel;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;

public class EvaluatorTreeModel
extends CachedChildrenTreeModel
implements NodeActionsProviderFilter {
    public static final String HISTORY_NODE = "org/netbeans/modules/debugger/jpda/resources/history_node_16.png";
    public static final String HISTORY_ITEM = "org/netbeans/modules/debugger/jpda/resources/eval_history_item.png";
    private final Action PASTE_TO_EVALUATOR = Models.createAction((String)NbBundle.getBundle(EvaluatorTreeModel.class).getString("CTL_PasteExprFromHistoryToEvaluator"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object node) {
            return true;
        }

        public void perform(Object[] nodes) {
            CodeEvaluator.getInstance().pasteExpression(((ItemNode)nodes[0]).item.expr);
        }
    }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    private Collection<ModelListener> listeners = new HashSet<ModelListener>();
    EvaluatorListener evalListener = new EvaluatorListener();

    public EvaluatorTreeModel() {
        CodeEvaluator.addResultListener(this.evalListener);
    }

    public Object getRoot() {
        return "Root";
    }

    public boolean isLeaf(Object node) throws UnknownTypeException {
        if ("Root".equals(node)) {
            return false;
        }
        if (node instanceof SpecialNode) {
            return ((SpecialNode)node).isLeaf();
        }
        throw new UnknownTypeException((Object)node.toString());
    }

    @Override
    protected Object[] computeChildren(Object node) throws UnknownTypeException {
        if (node instanceof SpecialNode) {
            return ((SpecialNode)node).getChildren(0, 0);
        }
        if (node == "Root") {
            Variable result = CodeEvaluator.getResult();
            ArrayList<CodeEvaluator.History.Item> items = CodeEvaluator.getHistory();
            int count = 0;
            if (result != null) {
                ++count;
            }
            if (items.size() > 0) {
                ++count;
            }
            Object[] children = new Object[count];
            int index = 0;
            if (result != null) {
                children[index++] = result;
            }
            if (items.size() > 0) {
                children[index] = new HistoryNode();
            }
            return children;
        }
        throw new UnknownTypeException((Object)node.toString());
    }

    public int getChildrenCount(Object node) throws UnknownTypeException {
        if ("Root".equals(node)) {
            Variable result = CodeEvaluator.getResult();
            ArrayList<CodeEvaluator.History.Item> items = CodeEvaluator.getHistory();
            int count = 0;
            if (result != null) {
                ++count;
            }
            if (items.size() > 0) {
                ++count;
            }
            return count;
        }
        if (node instanceof SpecialNode) {
            return ((SpecialNode)node).getChildrenCount();
        }
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(ModelListener l) {
        Collection<ModelListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(ModelListener l) {
        Collection<ModelListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireNodeChanged(Object node) {
        ModelListener[] ls;
        try {
            this.recomputeChildren();
        }
        catch (UnknownTypeException ex) {
            return;
        }
        Collection<ModelListener> collection = this.listeners;
        synchronized (collection) {
            ls = this.listeners.toArray(new ModelListener[0]);
        }
        ModelEvent.NodeChanged ev = new ModelEvent.NodeChanged((Object)this, node);
        for (int i = 0; i < ls.length; ++i) {
            ls[i].modelChanged((ModelEvent)ev);
        }
    }

    public void performDefaultAction(NodeActionsProvider original, Object node) throws UnknownTypeException {
        if (node instanceof ItemNode) {
            CodeEvaluator.getInstance().pasteExpression(((ItemNode)node).item.expr);
        } else {
            original.performDefaultAction(node);
        }
    }

    public Action[] getActions(NodeActionsProvider original, Object node) throws UnknownTypeException {
        if (node instanceof ItemNode) {
            return new Action[]{this.PASTE_TO_EVALUATOR};
        }
        return original.getActions(node);
    }

    private class EvaluatorListener
    implements PropertyChangeListener {
        private EvaluatorListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            EvaluatorTreeModel.this.fireNodeChanged("Root");
        }
    }

    static class ItemNode
    extends SpecialNode {
        CodeEvaluator.History.Item item;

        protected ItemNode(CodeEvaluator.History.Item item) {
            this.item = item;
        }

        @Override
        Object[] getChildren(int from, int to) {
            return new Object[0];
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ItemNode)) {
                return false;
            }
            return this.item.equals(((ItemNode)o).item);
        }

        public int hashCode() {
            int hash = 5;
            hash = 31 * hash + (this.item != null ? this.item.hashCode() : 0);
            return hash;
        }

        @Override
        String getDisplayName() {
            return this.item.expr;
        }

        @Override
        String getIconBase() {
            return EvaluatorTreeModel.HISTORY_ITEM;
        }

        @Override
        boolean isLeaf() {
            return true;
        }

        @Override
        int getChildrenCount() {
            return 0;
        }

        @Override
        String getShortDescription() {
            return this.item.tooltip;
        }

        @Override
        String getValueAt(String columnID) {
            if ("LocalsToString".equals(columnID)) {
                return this.item.toString;
            }
            if ("LocalsType".equals(columnID)) {
                return this.item.type;
            }
            if ("LocalsValue".equals(columnID)) {
                return this.item.value;
            }
            return "";
        }
    }

    static class HistoryNode
    extends SpecialNode {
        HistoryNode() {
        }

        @Override
        Object[] getChildren(int from, int to) {
            ArrayList<CodeEvaluator.History.Item> items = CodeEvaluator.getHistory();
            Object[] vals = new ItemNode[items.size()];
            for (int x = 0; x < items.size(); ++x) {
                CodeEvaluator.History.Item item = items.get(x);
                vals[x] = new ItemNode(item);
            }
            return vals;
        }

        public boolean equals(Object o) {
            return o instanceof HistoryNode;
        }

        public int hashCode() {
            int hash = 7;
            return hash;
        }

        @Override
        String getDisplayName() {
            return NbBundle.getBundle(EvaluatorTreeModel.class).getString("MSG_EvaluatorHistoryFilterNode");
        }

        @Override
        String getIconBase() {
            return EvaluatorTreeModel.HISTORY_NODE;
        }

        @Override
        boolean isLeaf() {
            return false;
        }

        @Override
        int getChildrenCount() {
            return CodeEvaluator.getHistory().size();
        }

        @Override
        String getShortDescription() {
            return NbBundle.getBundle(EvaluatorTreeModel.class).getString("CTL_EvaluatorHistoryNode");
        }

        @Override
        String getValueAt(String columnID) {
            return "";
        }
    }

    static abstract class SpecialNode {
        SpecialNode() {
        }

        abstract Object[] getChildren(int var1, int var2);

        abstract int getChildrenCount();

        abstract String getDisplayName();

        abstract String getValueAt(String var1);

        abstract String getShortDescription();

        abstract String getIconBase();

        abstract boolean isLeaf();
    }
}

