/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import com.sun.jdi.AbsentInformationException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.JPDAThreadGroup;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.modules.debugger.jpda.ui.models.BoldVariablesTableModelFilter;
import org.netbeans.modules.debugger.jpda.ui.models.CallStackNodeModel;
import org.netbeans.modules.debugger.jpda.ui.models.MonitorModel;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;

public class ThreadsNodeModel
implements NodeModel {
    public static final String CURRENT_THREAD = "org/netbeans/modules/debugger/resources/threadsView/CurrentThread";
    public static final String RUNNING_THREAD = "org/netbeans/modules/debugger/resources/threadsView/RunningThread";
    public static final String SUSPENDED_THREAD = "org/netbeans/modules/debugger/resources/threadsView/SuspendedThread";
    public static final String THREAD_GROUP = "org/netbeans/modules/debugger/resources/threadsView/ThreadGroup";
    public static final String CURRENT_THREAD_GROUP = "org/netbeans/modules/debugger/resources/threadsView/CurrentThreadGroup";
    private JPDADebugger debugger;
    private Session session;
    private Vector listeners = new Vector();
    private Set<Object> currentNodes = new HashSet<Object>();

    public ThreadsNodeModel(ContextProvider lookupProvider) {
        this.debugger = (JPDADebugger)lookupProvider.lookupFirst(null, JPDADebugger.class);
        this.session = (Session)lookupProvider.lookupFirst(null, Session.class);
        new Listener(this, this.debugger, this.currentNodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDisplayName(Object o) throws UnknownTypeException {
        if (o == "Root") {
            return NbBundle.getBundle(ThreadsNodeModel.class).getString("CTL_ThreadsModel_Column_Name_Name");
        }
        if (o instanceof JPDAThread) {
            if (this.debugger.getCurrentThread() == o) {
                Set<Object> set = this.currentNodes;
                synchronized (set) {
                    this.currentNodes.add(o);
                }
                return BoldVariablesTableModelFilter.toHTML(((JPDAThread)o).getName(), true, false, null);
            }
            Set<Object> set = this.currentNodes;
            synchronized (set) {
                this.currentNodes.remove(o);
            }
            return ((JPDAThread)o).getName();
        }
        if (o instanceof JPDAThreadGroup) {
            if (this.isCurrent((JPDAThreadGroup)o)) {
                Set<Object> set = this.currentNodes;
                synchronized (set) {
                    this.currentNodes.add(o);
                }
                return BoldVariablesTableModelFilter.toHTML(((JPDAThreadGroup)o).getName(), true, false, null);
            }
            Set<Object> set = this.currentNodes;
            synchronized (set) {
                this.currentNodes.remove(o);
            }
            return ((JPDAThreadGroup)o).getName();
        }
        throw new UnknownTypeException(o);
    }

    public String getShortDescription(Object o) throws UnknownTypeException {
        if (o == "Root") {
            return NbBundle.getBundle(ThreadsNodeModel.class).getString("CTL_ThreadsModel_Column_Name_Desc");
        }
        if (o instanceof JPDAThread) {
            JPDAThread t = (JPDAThread)o;
            int i = t.getState();
            String s = "";
            switch (i) {
                case -1: {
                    s = NbBundle.getBundle(ThreadsNodeModel.class).getString("CTL_ThreadsModel_State_Unknown");
                    break;
                }
                case 3: {
                    ObjectVariable ov = t.getContendedMonitor();
                    if (ov == null) {
                        s = NbBundle.getBundle(ThreadsNodeModel.class).getString("CTL_ThreadsModel_State_Monitor");
                        break;
                    }
                    try {
                        s = MessageFormat.format(NbBundle.getBundle(ThreadsNodeModel.class).getString("CTL_ThreadsModel_State_ConcreteMonitor"), ov.getToStringValue());
                    }
                    catch (InvalidExpressionException ex) {
                        s = ex.getLocalizedMessage();
                    }
                    break;
                }
                case 5: {
                    s = NbBundle.getBundle(ThreadsNodeModel.class).getString("CTL_ThreadsModel_State_NotStarted");
                    break;
                }
                case 1: {
                    s = NbBundle.getBundle(ThreadsNodeModel.class).getString("CTL_ThreadsModel_State_Running");
                    break;
                }
                case 2: {
                    s = NbBundle.getBundle(ThreadsNodeModel.class).getString("CTL_ThreadsModel_State_Sleeping");
                    break;
                }
                case 4: {
                    ObjectVariable ov = t.getContendedMonitor();
                    if (ov == null) {
                        s = NbBundle.getBundle(ThreadsNodeModel.class).getString("CTL_ThreadsModel_State_Waiting");
                        break;
                    }
                    try {
                        s = MessageFormat.format(NbBundle.getBundle(ThreadsNodeModel.class).getString("CTL_ThreadsModel_State_WaitingOn"), ov.getToStringValue());
                    }
                    catch (InvalidExpressionException ex) {
                        s = ex.getLocalizedMessage();
                    }
                    break;
                }
                case 0: {
                    s = NbBundle.getBundle(ThreadsNodeModel.class).getString("CTL_ThreadsModel_State_Zombie");
                }
            }
            if (t.isSuspended() && t.getStackDepth() > 0) {
                try {
                    CallStackFrame sf = t.getCallStack(0, 1)[0];
                    s = s + " " + CallStackNodeModel.getCSFName(this.session, sf, true);
                }
                catch (AbsentInformationException e) {
                    // empty catch block
                }
            }
            return s;
        }
        if (o instanceof JPDAThreadGroup) {
            return ((JPDAThreadGroup)o).getName();
        }
        throw new UnknownTypeException(o);
    }

    public String getIconBase(Object o) throws UnknownTypeException {
        if (o instanceof String) {
            return THREAD_GROUP;
        }
        if (o instanceof JPDAThread) {
            if (o == this.debugger.getCurrentThread()) {
                return CURRENT_THREAD;
            }
            return ((JPDAThread)o).isSuspended() ? SUSPENDED_THREAD : RUNNING_THREAD;
        }
        if (o instanceof JPDAThreadGroup) {
            if (this.isCurrent((JPDAThreadGroup)o)) {
                return CURRENT_THREAD_GROUP;
            }
            return THREAD_GROUP;
        }
        throw new UnknownTypeException(o);
    }

    public void addModelListener(ModelListener l) {
        this.listeners.add(l);
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
    }

    private void fireTreeChanged() {
        Vector v = (Vector)this.listeners.clone();
        int k = v.size();
        for (int i = 0; i < k; ++i) {
            ((ModelListener)v.get(i)).modelChanged(null);
        }
    }

    private void fireNodeChanged(Object node) {
        Vector v = (Vector)this.listeners.clone();
        int k = v.size();
        ModelEvent.NodeChanged event = new ModelEvent.NodeChanged((Object)this, node, 7);
        for (int i = 0; i < k; ++i) {
            ((ModelListener)v.get(i)).modelChanged((ModelEvent)event);
        }
    }

    private boolean isCurrent(JPDAThreadGroup tg) {
        JPDAThread t = this.debugger.getCurrentThread();
        if (t == null) {
            return false;
        }
        for (JPDAThreadGroup ctg = t.getParentThreadGroup(); ctg != null; ctg = ctg.getParentThreadGroup()) {
            if (ctg != tg) continue;
            return true;
        }
        return false;
    }

    private static class Listener
    implements PropertyChangeListener {
        private WeakReference ref;
        private JPDADebugger debugger;
        Set<Object> currentNodes;

        private Listener(ThreadsNodeModel rm, JPDADebugger debugger, Set<Object> currentNodes) {
            this.ref = new WeakReference<ThreadsNodeModel>(rm);
            this.debugger = debugger;
            this.currentNodes = currentNodes;
            debugger.addPropertyChangeListener("currentThread", (PropertyChangeListener)this);
        }

        private ThreadsNodeModel getModel() {
            ThreadsNodeModel rm = (ThreadsNodeModel)this.ref.get();
            if (rm == null) {
                this.debugger.removePropertyChangeListener("currentThread", (PropertyChangeListener)this);
            }
            return rm;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent e) {
            HashSet<Object> nodes;
            ThreadsNodeModel rm = this.getModel();
            if (rm == null) {
                return;
            }
            Set<Object> set = this.currentNodes;
            synchronized (set) {
                nodes = new HashSet<Object>();
                for (Object obj : this.currentNodes) {
                    nodes.add(obj);
                    if (!(obj instanceof JPDAThread)) continue;
                    nodes.add(new MonitorModel.ThreadWithBordel((JPDAThread)obj));
                }
            }
            JPDAThread t = this.debugger.getCurrentThread();
            if (t != null) {
                nodes.add(t);
                nodes.add(new MonitorModel.ThreadWithBordel(t));
                for (JPDAThreadGroup tg = t.getParentThreadGroup(); tg != null; tg = tg.getParentThreadGroup()) {
                    nodes.add(tg);
                }
            }
            for (Object node : nodes) {
                rm.fireNodeChanged(node);
            }
        }
    }
}

