/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.awt.Color;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import javax.security.auth.Refreshable;
import javax.swing.JToolTip;
import org.netbeans.api.debugger.jpda.Field;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAWatch;
import org.netbeans.api.debugger.jpda.LocalVariable;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Super;
import org.netbeans.api.debugger.jpda.This;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.ui.models.BoldVariablesTableModelFilter;
import org.netbeans.modules.debugger.jpda.ui.models.WatchesNodeModelFilter;
import org.netbeans.modules.debugger.jpda.ui.views.VariablesViewButtons;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.netbeans.spi.debugger.ui.Constants;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.omg.CORBA.portable.ApplicationException;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class VariablesTableModel
implements TableModel,
Constants {
    private JPDADebugger debugger;

    public VariablesTableModel(ContextProvider contextProvider) {
        this.debugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
    }

    public Object getValueAt(Object row, String columnID) throws UnknownTypeException {
        if ("LocalsToString".equals(columnID) || "WatchToString".equals(columnID)) {
            if (row instanceof Super) {
                return "";
            }
            if (row instanceof ObjectVariable) {
                try {
                    return ((ObjectVariable)row).getToStringValue();
                }
                catch (InvalidExpressionException ex) {
                    return VariablesTableModel.getMessage(ex);
                }
            }
            if (row instanceof Variable) {
                return ((Variable)row).getValue();
            }
            if (row instanceof EditorContext.Operation || row == "lastOperations" || row instanceof String && ((String)row).startsWith("operationArguments ")) {
                return "";
            }
        } else if ("LocalsType".equals(columnID) || "WatchType".equals(columnID)) {
            if (row instanceof Variable) {
                return VariablesTableModel.getShort(((Variable)row).getType());
            }
            if (row instanceof JToolTip && (row = ((JToolTip)row).getClientProperty("getShortDescription")) instanceof Variable) {
                if (row instanceof Refreshable && !((Refreshable)row).isCurrent()) {
                    return "";
                }
                return ((Variable)row).getType();
            }
        } else if ("LocalsValue".equals(columnID) || "WatchValue".equals(columnID)) {
            if (VariablesViewButtons.isShowValuesAsString()) {
                return this.getValueAt(row, "LocalsToString");
            }
            if (row instanceof JPDAWatch) {
                JPDAWatch w = (JPDAWatch)row;
                String e = w.getExceptionDescription();
                if (e != null) {
                    return BoldVariablesTableModelFilter.toHTML(">" + e + "<", false, false, Color.RED);
                }
                return w.getValue();
            }
            if (row instanceof Variable) {
                return ((Variable)row).getValue();
            }
        }
        if (row instanceof JPDAClassType) {
            return "";
        }
        if (row.toString().startsWith("SubArray")) {
            return "";
        }
        if (row instanceof EditorContext.Operation || row == "lastOperations" || row instanceof String && ((String)row).startsWith("operationArguments ")) {
            return "";
        }
        if (row == "noDebugInfoWarning") {
            return "";
        }
        if (row == "No current thread") {
            return "";
        }
        throw new UnknownTypeException(row);
    }

    public boolean isReadOnly(Object row, String columnID) throws UnknownTypeException {
        if (row instanceof Variable) {
            if ("LocalsToString".equals(columnID) || "WatchToString".equals(columnID) || "LocalsType".equals(columnID) || "WatchType".equals(columnID)) {
                return true;
            }
            if ("LocalsValue".equals(columnID) || "WatchValue".equals(columnID)) {
                String declaredType;
                if (row instanceof This) {
                    return true;
                }
                if (row instanceof JPDAWatch && row instanceof Refreshable) {
                    if (!((Refreshable)row).isCurrent()) {
                        return true;
                    }
                    try {
                        Method getEvaluatedWatchMethod = row.getClass().getDeclaredMethod("getEvaluatedWatch", new Class[0]);
                        getEvaluatedWatchMethod.setAccessible(true);
                        row = (JPDAWatch)getEvaluatedWatchMethod.invoke(row, new Object[0]);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                if (row instanceof ObjectVariable && !"java.lang.String".equals(declaredType = row instanceof LocalVariable ? ((LocalVariable)row).getDeclaredType() : (row instanceof Field ? ((Field)row).getDeclaredType() : ((ObjectVariable)row).getType()))) {
                    return true;
                }
                if (row instanceof LocalVariable || row instanceof Field || row instanceof JPDAWatch) {
                    if (WatchesNodeModelFilter.isEmptyWatch(row)) {
                        return true;
                    }
                    return !this.debugger.canBeModified();
                }
                return true;
            }
        }
        if (row instanceof JPDAClassType) {
            return true;
        }
        if (row.toString().startsWith("SubArray")) {
            return true;
        }
        if (row instanceof EditorContext.Operation) {
            return true;
        }
        if (row == "noDebugInfoWarning") {
            return true;
        }
        if (row == "No current thread") {
            return true;
        }
        throw new UnknownTypeException(row);
    }

    public void setValueAt(Object row, String columnID, Object value) throws UnknownTypeException {
        if (row instanceof LocalVariable && "LocalsValue".equals(columnID)) {
            try {
                ((LocalVariable)row).setValue((String)value);
            }
            catch (InvalidExpressionException e) {
                NotifyDescriptor.Message descriptor = new NotifyDescriptor.Message((Object)e.getLocalizedMessage(), 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
            }
            return;
        }
        if (row instanceof Field && ("LocalsValue".equals(columnID) || "WatchValue".equals(columnID))) {
            try {
                ((Field)row).setValue((String)value);
            }
            catch (InvalidExpressionException e) {
                NotifyDescriptor.Message descriptor = new NotifyDescriptor.Message((Object)e.getLocalizedMessage(), 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
            }
            return;
        }
        if (row instanceof JPDAWatch && ("LocalsValue".equals(columnID) || "WatchValue".equals(columnID))) {
            try {
                ((JPDAWatch)row).setValue((String)value);
            }
            catch (InvalidExpressionException e) {
                NotifyDescriptor.Message descriptor = new NotifyDescriptor.Message((Object)e.getLocalizedMessage(), 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
            }
            return;
        }
        throw new UnknownTypeException(row);
    }

    public void addModelListener(ModelListener l) {
    }

    public void removeModelListener(ModelListener l) {
    }

    static String getShort(String c) {
        int i = c.lastIndexOf(46);
        if (i < 0) {
            return c;
        }
        return c.substring(i + 1);
    }

    static String getMessage(InvalidExpressionException e) {
        Throwable t;
        String m = e.getLocalizedMessage();
        if (m == null) {
            m = e.getMessage();
        }
        if (m == null) {
            m = NbBundle.getMessage(VariablesTableModel.class, (String)"MSG_NA");
        }
        if ((t = e.getTargetException()) != null && t instanceof ApplicationException) {
            StringWriter s = new StringWriter();
            PrintWriter p = new PrintWriter(s);
            t.printStackTrace(p);
            p.close();
            m = m + " \n" + s.toString();
        }
        return BoldVariablesTableModelFilter.toHTML(">" + m + "<", false, false, Color.RED);
    }
}

