/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.views;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.modules.debugger.jpda.ui.debugging.DebuggingView;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.AsynchronousModelFilter;
import org.netbeans.spi.viewmodel.CheckNodeModel;
import org.netbeans.spi.viewmodel.CheckNodeModelFilter;
import org.netbeans.spi.viewmodel.ColumnModel;
import org.netbeans.spi.viewmodel.DnDNodeModel;
import org.netbeans.spi.viewmodel.DnDNodeModelFilter;
import org.netbeans.spi.viewmodel.ExtendedNodeModel;
import org.netbeans.spi.viewmodel.ExtendedNodeModelFilter;
import org.netbeans.spi.viewmodel.Model;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.NodeModelFilter;
import org.netbeans.spi.viewmodel.ReorderableTreeModel;
import org.netbeans.spi.viewmodel.ReorderableTreeModelFilter;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TableModelFilter;
import org.netbeans.spi.viewmodel.TreeExpansionModel;
import org.netbeans.spi.viewmodel.TreeExpansionModelFilter;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.TreeModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.RequestProcessor;

public class ViewModelListener
extends DebuggerManagerAdapter {
    private static final Class[] TREE_MODELS = new Class[]{TreeModel.class, ReorderableTreeModel.class};
    private static final Class[] TREE_MODEL_FILTERS = new Class[]{TreeModelFilter.class, ReorderableTreeModelFilter.class};
    private static final Class[] NODE_MODELS = new Class[]{NodeModel.class, CheckNodeModel.class, DnDNodeModel.class, ExtendedNodeModel.class};
    private static final Class[] NODE_MODEL_FILTERS = new Class[]{NodeModelFilter.class, CheckNodeModelFilter.class, DnDNodeModelFilter.class, ExtendedNodeModelFilter.class};
    private static final RequestProcessor RP = new RequestProcessor(ViewModelListener.class.getName(), 1);
    private static boolean verbose = System.getProperty("netbeans.debugger.models") != null;
    private String viewType;
    private JComponent view;
    private boolean isUp;

    public ViewModelListener(String viewType, JComponent view) {
        this.viewType = viewType;
        this.view = view;
        this.setUp();
    }

    public void setUp() {
        DebuggerManager.getDebuggerManager().addDebuggerListener("currentEngine", (DebuggerManagerListener)this);
        this.updateModel();
    }

    public void destroy() {
        DebuggerManager.getDebuggerManager().removeDebuggerListener("currentEngine", (DebuggerManagerListener)this);
        if (this.view instanceof DebuggingView) {
            ((DebuggingView)((Object)this.view)).setRootContext(null, null);
        } else {
            Models.setModelsToView((JComponent)this.view, (Models.CompoundModel)Models.EMPTY_MODEL);
        }
        this.isUp = false;
    }

    public void propertyChange(PropertyChangeEvent e) {
        this.updateModel();
    }

    private static void getMultiModels(ContextProvider cp, String viewPath, List[] models, Class[] classTypes) {
        for (int i = 0; i < classTypes.length; ++i) {
            models[i] = cp.lookup(viewPath, classTypes[i]);
        }
    }

    private synchronized void updateModel() {
        this.isUp = true;
        RP.post(new Runnable(){

            @Override
            public void run() {
                ViewModelListener.this.updateModelLazily();
            }
        });
    }

    private synchronized void updateModelLazily() {
        if (!this.isUp) {
            return;
        }
        DebuggerManager dm = DebuggerManager.getDebuggerManager();
        DebuggerEngine e = dm.getCurrentEngine();
        List[] treeModels = new List[TREE_MODELS.length];
        List[] treeModelFilters = new List[TREE_MODEL_FILTERS.length];
        List[] nodeModels = new List[NODE_MODELS.length];
        List[] nodeModelFilters = new List[NODE_MODEL_FILTERS.length];
        DebuggerManager cp = e != null ? DebuggerManager.join((ContextProvider)e, (ContextProvider)dm) : dm;
        ViewModelListener.getMultiModels((ContextProvider)cp, this.viewType, treeModels, TREE_MODELS);
        ViewModelListener.getMultiModels((ContextProvider)cp, this.viewType, treeModelFilters, TREE_MODEL_FILTERS);
        List treeExpansionModels = cp.lookup(this.viewType, TreeExpansionModel.class);
        List treeExpansionModelFilters = cp.lookup(this.viewType, TreeExpansionModelFilter.class);
        ViewModelListener.getMultiModels((ContextProvider)cp, this.viewType, nodeModels, NODE_MODELS);
        ViewModelListener.getMultiModels((ContextProvider)cp, this.viewType, nodeModelFilters, NODE_MODEL_FILTERS);
        List tableModels = cp.lookup(this.viewType, TableModel.class);
        List tableModelFilters = cp.lookup(this.viewType, TableModelFilter.class);
        List nodeActionsProviders = cp.lookup(this.viewType, NodeActionsProvider.class);
        List nodeActionsProviderFilters = cp.lookup(this.viewType, NodeActionsProviderFilter.class);
        List columnModels = cp.lookup(this.viewType, ColumnModel.class);
        List mm = cp.lookup(this.viewType, Model.class);
        List asynchModelFilters = cp.lookup(this.viewType, AsynchronousModelFilter.class);
        ArrayList<List> models = new ArrayList<List>(11);
        models.add(ViewModelListener.joinLists(treeModels));
        models.add(ViewModelListener.joinLists(treeModelFilters));
        models.add(treeExpansionModels);
        models.add(ViewModelListener.joinLists(nodeModels));
        models.add(ViewModelListener.joinLists(nodeModelFilters));
        models.add(tableModels);
        models.add(tableModelFilters);
        models.add(nodeActionsProviders);
        models.add(nodeActionsProviderFilters);
        models.add(columnModels);
        models.add(mm);
        models.add(treeExpansionModelFilters);
        models.add(asynchModelFilters);
        if (this.view instanceof DebuggingView) {
            ((DebuggingView)((Object)this.view)).setRootContext(Models.createCompoundModel(models), e);
        } else {
            Models.setModelsToView((JComponent)this.view, (Models.CompoundModel)Models.createCompoundModel(models));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List joinLists(List[] modelLists) {
        ArrayList models = new ArrayList();
        List[] arr$ = modelLists;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            List l;
            List list = l = arr$[i$];
            synchronized (list) {
                for (Object o : l) {
                    if (models.contains(o)) continue;
                    models.add(o);
                }
                continue;
            }
        }
        return models;
    }

    private static class EmptyModel
    implements NodeModel {
        private EmptyModel() {
        }

        public String getDisplayName(Object node) throws UnknownTypeException {
            if (node == "Root") {
                return "Name";
            }
            throw new UnknownTypeException(node);
        }

        public String getIconBase(Object node) throws UnknownTypeException {
            if (node == "Root") {
                return "org/netbeans/modules/debugger/resources/DebuggerTab";
            }
            throw new UnknownTypeException(node);
        }

        public String getShortDescription(Object node) throws UnknownTypeException {
            throw new UnknownTypeException(node);
        }

        public void addModelListener(ModelListener l) {
        }

        public void removeModelListener(ModelListener l) {
        }
    }
}

