/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.hints.pom;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.text.Document;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.hints.pom.ParentVersionErrorCustomizer;
import org.netbeans.modules.maven.hints.pom.spi.Configuration;
import org.netbeans.modules.maven.hints.pom.spi.POMErrorFixProvider;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryQueries;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Parent;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.text.Line;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ParentVersionError
implements POMErrorFixProvider {
    private Configuration configuration = new Configuration("ParentVersionError", NbBundle.getMessage(ParentVersionError.class, (String)"TIT_ParentVersionError"), NbBundle.getMessage(ParentVersionError.class, (String)"DESC_ParentVersionError"), true, Configuration.HintSeverity.WARNING);
    static final String PROP_SOURCES = "sources";
    static final String PROP_SNAPSHOT = "snapshot";

    @Override
    public List<ErrorDescription> getErrorsForDocument(POMModel model, Project prj) {
        assert (model != null);
        ArrayList<ErrorDescription> toRet = new ArrayList<ErrorDescription>();
        if (prj == null) {
            return null;
        }
        Parent par = model.getProject().getPomParent();
        if (par == null) {
            return toRet;
        }
        boolean useSources = this.getConfiguration().getPreferences().getBoolean(PROP_SOURCES, true);
        boolean useSnapshot = this.getConfiguration().getPreferences().getBoolean(PROP_SNAPSHOT, false);
        String declaredVersion = par.getVersion();
        String relPath = par.getRelativePath();
        if (relPath == null) {
            relPath = ".." + File.separator;
        }
        if (relPath.endsWith("pom.xml")) {
            relPath = relPath.substring(0, relPath.length() - "pom.xml".length());
        }
        File resolvedDir = FileUtilities.resolveFilePath((File)FileUtil.toFile((FileObject)prj.getProjectDirectory()), (String)relPath);
        String currentVersion = null;
        boolean usedSources = false;
        if (useSources && resolvedDir.exists()) {
            String parGr = par.getGroupId();
            String parArt = par.getArtifactId();
            if (parArt != null && parGr != null) {
                try {
                    MavenProject mav;
                    NbMavenProject nbprj;
                    Project parentPrj = ProjectManager.getDefault().findProject(FileUtil.toFileObject((File)resolvedDir));
                    if (parentPrj != null && (nbprj = (NbMavenProject)parentPrj.getLookup().lookup(NbMavenProject.class)) != null && parGr.equals((mav = nbprj.getMavenProject()).getGroupId()) && parArt.equals(mav.getArtifactId())) {
                        currentVersion = mav.getVersion();
                        usedSources = true;
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (IllegalArgumentException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        if (!(useSources && currentVersion != null || declaredVersion == null)) {
            DefaultArtifactVersion currentAV = new DefaultArtifactVersion(declaredVersion);
            List loadedRepos = RepositoryQueries.getLoadedContexts();
            if (!loadedRepos.isEmpty()) {
                List infos = RepositoryQueries.getVersions((String)par.getGroupId(), (String)par.getArtifactId(), (RepositoryInfo[])loadedRepos.toArray(new RepositoryInfo[0]));
                for (NBVersionInfo info : infos) {
                    DefaultArtifactVersion av;
                    if (!useSnapshot && info.getVersion().contains("SNAPSHOT") || currentAV.compareTo((Object)(av = new DefaultArtifactVersion(info.getVersion()))) >= 0) continue;
                    currentAV = av;
                }
            }
            currentVersion = currentAV.toString();
        }
        if (currentVersion != null && !currentVersion.equals(declaredVersion)) {
            int position = par.findChildElementPosition(model.getPOMQNames().VERSION.getQName());
            Line line = NbEditorUtilities.getLine((Document)model.getBaseDocument(), (int)position, (boolean)false);
            String message = usedSources ? NbBundle.getMessage(ParentVersionError.class, (String)"TXT_ParentVersionError", (Object)currentVersion) : NbBundle.getMessage(ParentVersionError.class, (String)"TXT_ParentVersionError2", (Object)currentVersion);
            toRet.add(ErrorDescriptionFactory.createErrorDescription((Severity)this.configuration.getSeverity(this.configuration.getPreferences()).toEditorSeverity(), (String)message, Collections.singletonList(new SynchronizeFix(par, currentVersion, usedSources)), (Document)model.getBaseDocument(), (int)(line.getLineNumber() + 1)));
        }
        return toRet;
    }

    @Override
    public JComponent getCustomizer(Preferences preferences) {
        return new ParentVersionErrorCustomizer(preferences);
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    private static class SynchronizeFix
    implements Fix {
        private Parent parent;
        private String version;
        private String message;

        SynchronizeFix(Parent par, String version, boolean usedSources) {
            this.parent = par;
            this.version = version;
            this.message = usedSources ? NbBundle.getMessage(ParentVersionError.class, (String)"TEXT_ParentVersionFix", (Object)version) : NbBundle.getMessage(ParentVersionError.class, (String)"TEXT_ParentVersionFix2", (Object)version);
        }

        public String getText() {
            return this.message;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ChangeInfo implement() throws Exception {
            ChangeInfo info = new ChangeInfo();
            POMModel mdl = this.parent.getModel();
            if (!mdl.getState().equals((Object)Model.State.VALID)) {
                return info;
            }
            mdl.startTransaction();
            try {
                this.parent.setVersion(this.version);
            }
            finally {
                mdl.endTransaction();
            }
            return info;
        }
    }
}

