/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.project.hints;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class OptionalEE7APIsHint
extends AbstractHint {
    private static final Set<Tree.Kind> TREE_KINDS = EnumSet.of(Tree.Kind.MEMBER_SELECT, Tree.Kind.IDENTIFIER);
    private static final List<String> optionalPackages = Arrays.asList("javax.enterprise.deploy.model.", "javax.enterprise.deploy.model.exceptions.", "javax.enterprise.deploy.shared.", "javax.enterprise.deploy.shared.factories.", "javax.enterprise.deploy.spi.", "javax.enterprise.deploy.spi.exceptions.", "javax.enterprise.deploy.spi.factories.", "javax.enterprise.deploy.status.", "javax.xml.registry.", "javax.xml.registry.infomodel.", "javax.xml.rpc.", "javax.xml.rpc.encoding.", "javax.xml.rpc.handler.", "javax.xml.rpc.handler.soap.", "javax.xml.rpc.holders.", "javax.xml.rpc.server.", "javax.xml.rpc.soap.");

    public OptionalEE7APIsHint() {
        super(true, true, AbstractHint.HintSeverity.WARNING, new String[0]);
    }

    public String getDescription() {
        return NbBundle.getMessage(OptionalEE7APIsHint.class, (String)"OptionalEE7APIsHint_Description");
    }

    public Set<Tree.Kind> getTreeKinds() {
        return TREE_KINDS;
    }

    public List<ErrorDescription> run(CompilationInfo info, TreePath treePath) {
        Element el = info.getTrees().getElement(treePath);
        if (el == null) {
            return null;
        }
        String name = ((Object)el.asType()).toString();
        if (!(name.startsWith("javax.xml.rpc") || name.startsWith("javax.xml.registry") || name.startsWith("javax.enterprise.deploy"))) {
            return null;
        }
        boolean optional = false;
        for (String opt : optionalPackages) {
            if (!name.startsWith(opt)) continue;
            optional = true;
            break;
        }
        if (!optional) {
            return null;
        }
        Tree t = treePath.getLeaf();
        ArrayList fixes = new ArrayList();
        return Collections.singletonList(ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)this.getDisplayName(), fixes, (FileObject)info.getFileObject(), (int)((int)info.getTrees().getSourcePositions().getStartPosition(info.getCompilationUnit(), t)), (int)((int)info.getTrees().getSourcePositions().getEndPosition(info.getCompilationUnit(), t))));
    }

    public String getId() {
        return "OptionalEE7APIsHint";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(OptionalEE7APIsHint.class, (String)"OptionalEE7APIsHint_DisplayName");
    }

    public void cancel() {
    }
}

